/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.os.CancellationSignal;
import android.os._Original_Build;
import android.text.TextUtils;
import android.util.Log;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import libcore.util.EmptyArray;

public class SQLiteQueryBuilder {
    private static final String TAG = "SQLiteQueryBuilder";
    private static final Pattern sLimitPattern = Pattern.compile("\\s*\\d+\\s*(,\\s*\\d+\\s*)?");
    private Map<String, String> mProjectionMap = null;
    private String mTables = "";
    private StringBuilder mWhereClause = null;
    private boolean mDistinct = false;
    private SQLiteDatabase.CursorFactory mFactory = null;
    private boolean mStrict;

    public void setDistinct(boolean distinct) {
        this.mDistinct = distinct;
    }

    public String getTables() {
        return this.mTables;
    }

    public void setTables(String inTables) {
        this.mTables = inTables;
    }

    public void appendWhere(CharSequence inWhere) {
        if (this.mWhereClause == null) {
            this.mWhereClause = new StringBuilder(inWhere.length() + 16);
        }
        this.mWhereClause.append(inWhere);
    }

    public void appendWhereEscapeString(String inWhere) {
        if (this.mWhereClause == null) {
            this.mWhereClause = new StringBuilder(inWhere.length() + 16);
        }
        DatabaseUtils.appendEscapedSQLString(this.mWhereClause, inWhere);
    }

    public void setProjectionMap(Map<String, String> columnMap) {
        this.mProjectionMap = columnMap;
    }

    public void setCursorFactory(SQLiteDatabase.CursorFactory factory) {
        this.mFactory = factory;
    }

    public void setStrict(boolean flag) {
        this.mStrict = flag;
    }

    public static String buildQueryString(boolean distinct, String tables, String[] columns, String where, String groupBy, String having, String orderBy, String limit) {
        if (TextUtils.isEmpty(groupBy) && !TextUtils.isEmpty(having)) {
            throw new IllegalArgumentException("HAVING clauses are only permitted when using a groupBy clause");
        }
        if (!TextUtils.isEmpty(limit) && !sLimitPattern.matcher(limit).matches()) {
            throw new IllegalArgumentException("invalid LIMIT clauses:" + limit);
        }
        StringBuilder query = new StringBuilder(120);
        query.append("SELECT ");
        if (distinct) {
            query.append("DISTINCT ");
        }
        if (columns != null && columns.length != 0) {
            SQLiteQueryBuilder.appendColumns(query, columns);
        } else {
            query.append("* ");
        }
        query.append("FROM ");
        query.append(tables);
        SQLiteQueryBuilder.appendClause(query, " WHERE ", where);
        SQLiteQueryBuilder.appendClause(query, " GROUP BY ", groupBy);
        SQLiteQueryBuilder.appendClause(query, " HAVING ", having);
        SQLiteQueryBuilder.appendClause(query, " ORDER BY ", orderBy);
        SQLiteQueryBuilder.appendClause(query, " LIMIT ", limit);
        return query.toString();
    }

    private static void appendClause(StringBuilder s, String name, String clause) {
        if (!TextUtils.isEmpty(clause)) {
            s.append(name);
            s.append(clause);
        }
    }

    public static void appendColumns(StringBuilder s, String[] columns) {
        int n = columns.length;
        for (int i = 0; i < n; ++i) {
            String column = columns[i];
            if (column == null) continue;
            if (i > 0) {
                s.append(", ");
            }
            s.append(column);
        }
        s.append(' ');
    }

    public Cursor query(SQLiteDatabase db, String[] projectionIn, String selection, String[] selectionArgs, String groupBy, String having, String sortOrder) {
        return this.query(db, projectionIn, selection, selectionArgs, groupBy, having, sortOrder, null, null);
    }

    public Cursor query(SQLiteDatabase db, String[] projectionIn, String selection, String[] selectionArgs, String groupBy, String having, String sortOrder, String limit) {
        return this.query(db, projectionIn, selection, selectionArgs, groupBy, having, sortOrder, limit, null);
    }

    public Cursor query(SQLiteDatabase db, String[] projectionIn, String selection, String[] selectionArgs, String groupBy, String having, String sortOrder, String limit, CancellationSignal cancellationSignal) {
        String sql;
        if (this.mTables == null) {
            return null;
        }
        String unwrappedSql = this.buildQuery(projectionIn, selection, groupBy, having, sortOrder, limit);
        if (this.mStrict && selection != null && selection.length() > 0) {
            String wrappedSql;
            db.validateSql(unwrappedSql, cancellationSignal);
            sql = wrappedSql = this.buildQuery(projectionIn, this.wrap(selection), groupBy, having, sortOrder, limit);
        } else {
            sql = unwrappedSql;
        }
        Object[] sqlArgs = selectionArgs;
        if (Log.isLoggable(TAG, 3)) {
            if (_Original_Build.IS_DEBUGGABLE) {
                Log.d(TAG, sql + " with args " + Arrays.toString(sqlArgs));
            } else {
                Log.d(TAG, sql);
            }
        }
        return db.rawQueryWithFactory(this.mFactory, sql, (String[])sqlArgs, SQLiteDatabase.findEditTable(this.mTables), cancellationSignal);
    }

    public int update(SQLiteDatabase db, ContentValues values, String selection, String[] selectionArgs) {
        String sql;
        Objects.requireNonNull(this.mTables, "No tables defined");
        Objects.requireNonNull(db, "No database defined");
        Objects.requireNonNull(values, "No values defined");
        String unwrappedSql = this.buildUpdate(values, selection);
        if (this.mStrict) {
            String wrappedSql;
            db.validateSql(unwrappedSql, null);
            sql = wrappedSql = this.buildUpdate(values, this.wrap(selection));
        } else {
            sql = unwrappedSql;
        }
        if (selectionArgs == null) {
            selectionArgs = EmptyArray.STRING;
        }
        String[] rawKeys = values.keySet().toArray(EmptyArray.STRING);
        int valuesLength = rawKeys.length;
        Object[] sqlArgs = new Object[valuesLength + selectionArgs.length];
        for (int i = 0; i < sqlArgs.length; ++i) {
            sqlArgs[i] = i < valuesLength ? values.get(rawKeys[i]) : selectionArgs[i - valuesLength];
        }
        if (Log.isLoggable(TAG, 3)) {
            if (_Original_Build.IS_DEBUGGABLE) {
                Log.d(TAG, sql + " with args " + Arrays.toString(sqlArgs));
            } else {
                Log.d(TAG, sql);
            }
        }
        return db.executeSql(sql, sqlArgs);
    }

    public int delete(SQLiteDatabase db, String selection, String[] selectionArgs) {
        String sql;
        Objects.requireNonNull(this.mTables, "No tables defined");
        Objects.requireNonNull(db, "No database defined");
        String unwrappedSql = this.buildDelete(selection);
        if (this.mStrict) {
            String wrappedSql;
            db.validateSql(unwrappedSql, null);
            sql = wrappedSql = this.buildDelete(this.wrap(selection));
        } else {
            sql = unwrappedSql;
        }
        Object[] sqlArgs = selectionArgs;
        if (Log.isLoggable(TAG, 3)) {
            if (_Original_Build.IS_DEBUGGABLE) {
                Log.d(TAG, sql + " with args " + Arrays.toString(sqlArgs));
            } else {
                Log.d(TAG, sql);
            }
        }
        return db.executeSql(sql, sqlArgs);
    }

    public String buildQuery(String[] projectionIn, String selection, String groupBy, String having, String sortOrder, String limit) {
        String[] projection = this.computeProjection(projectionIn);
        String where = this.computeWhere(selection);
        return SQLiteQueryBuilder.buildQueryString(this.mDistinct, this.mTables, projection, where, groupBy, having, sortOrder, limit);
    }

    @Deprecated
    public String buildQuery(String[] projectionIn, String selection, String[] selectionArgs, String groupBy, String having, String sortOrder, String limit) {
        return this.buildQuery(projectionIn, selection, groupBy, having, sortOrder, limit);
    }

    public String buildUpdate(ContentValues values, String selection) {
        if (values == null || values.size() == 0) {
            throw new IllegalArgumentException("Empty values");
        }
        StringBuilder sql = new StringBuilder(120);
        sql.append("UPDATE ");
        sql.append(this.mTables);
        sql.append(" SET ");
        String[] rawKeys = values.keySet().toArray(EmptyArray.STRING);
        for (int i = 0; i < rawKeys.length; ++i) {
            if (i > 0) {
                sql.append(',');
            }
            sql.append(rawKeys[i]);
            sql.append("=?");
        }
        String where = this.computeWhere(selection);
        SQLiteQueryBuilder.appendClause(sql, " WHERE ", where);
        return sql.toString();
    }

    public String buildDelete(String selection) {
        StringBuilder sql = new StringBuilder(120);
        sql.append("DELETE FROM ");
        sql.append(this.mTables);
        String where = this.computeWhere(selection);
        SQLiteQueryBuilder.appendClause(sql, " WHERE ", where);
        return sql.toString();
    }

    public String buildUnionSubQuery(String typeDiscriminatorColumn, String[] unionColumns, Set<String> columnsPresentInTable, int computedColumnsOffset, String typeDiscriminatorValue, String selection, String groupBy, String having) {
        int unionColumnsCount = unionColumns.length;
        String[] projectionIn = new String[unionColumnsCount];
        for (int i = 0; i < unionColumnsCount; ++i) {
            String unionColumn = unionColumns[i];
            projectionIn[i] = unionColumn.equals(typeDiscriminatorColumn) ? "'" + typeDiscriminatorValue + "' AS " + typeDiscriminatorColumn : (i <= computedColumnsOffset || columnsPresentInTable.contains(unionColumn) ? unionColumn : "NULL AS " + unionColumn);
        }
        return this.buildQuery(projectionIn, selection, groupBy, having, null, null);
    }

    @Deprecated
    public String buildUnionSubQuery(String typeDiscriminatorColumn, String[] unionColumns, Set<String> columnsPresentInTable, int computedColumnsOffset, String typeDiscriminatorValue, String selection, String[] selectionArgs, String groupBy, String having) {
        return this.buildUnionSubQuery(typeDiscriminatorColumn, unionColumns, columnsPresentInTable, computedColumnsOffset, typeDiscriminatorValue, selection, groupBy, having);
    }

    public String buildUnionQuery(String[] subQueries, String sortOrder, String limit) {
        StringBuilder query = new StringBuilder(128);
        int subQueryCount = subQueries.length;
        String unionOperator = this.mDistinct ? " UNION " : " UNION ALL ";
        for (int i = 0; i < subQueryCount; ++i) {
            if (i > 0) {
                query.append(unionOperator);
            }
            query.append(subQueries[i]);
        }
        SQLiteQueryBuilder.appendClause(query, " ORDER BY ", sortOrder);
        SQLiteQueryBuilder.appendClause(query, " LIMIT ", limit);
        return query.toString();
    }

    private String[] computeProjection(String[] projectionIn) {
        if (projectionIn != null && projectionIn.length > 0) {
            if (this.mProjectionMap != null) {
                String[] projection = new String[projectionIn.length];
                int length = projectionIn.length;
                for (int i = 0; i < length; ++i) {
                    String userColumn = projectionIn[i];
                    String column = this.mProjectionMap.get(userColumn);
                    if (column != null) {
                        projection[i] = column;
                        continue;
                    }
                    if (!this.mStrict && (userColumn.contains(" AS ") || userColumn.contains(" as "))) {
                        projection[i] = userColumn;
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid column " + projectionIn[i]);
                }
                return projection;
            }
            return projectionIn;
        }
        if (this.mProjectionMap != null) {
            Set<Map.Entry<String, String>> entrySet = this.mProjectionMap.entrySet();
            String[] projection = new String[entrySet.size()];
            Iterator<Map.Entry<String, String>> entryIter = entrySet.iterator();
            int i = 0;
            while (entryIter.hasNext()) {
                Map.Entry<String, String> entry = entryIter.next();
                if (entry.getKey().equals("_count")) continue;
                projection[i++] = entry.getValue();
            }
            return projection;
        }
        return null;
    }

    private String computeWhere(String selection) {
        boolean hasExternal;
        boolean hasInternal = !TextUtils.isEmpty(this.mWhereClause);
        boolean bl = hasExternal = !TextUtils.isEmpty(selection);
        if (hasInternal || hasExternal) {
            StringBuilder where = new StringBuilder();
            if (hasInternal) {
                where.append('(').append((CharSequence)this.mWhereClause).append(')');
            }
            if (hasInternal && hasExternal) {
                where.append(" AND ");
            }
            if (hasExternal) {
                where.append('(').append(selection).append(')');
            }
            return where.toString();
        }
        return null;
    }

    private String wrap(String arg) {
        if (TextUtils.isEmpty(arg)) {
            return arg;
        }
        return "(" + arg + ")";
    }
}

