/*
 * Decompiled with CFR 0.152.
 */
package android.app.servertransaction;

import android.app.ActivityThread;
import android.app.servertransaction.ActivityLifecycleItem;
import android.app.servertransaction.ClientTransaction;
import android.app.servertransaction.ClientTransactionItem;
import android.app.servertransaction.PauseActivityItem;
import android.app.servertransaction.ResumeActivityItem;
import android.app.servertransaction.StopActivityItem;
import android.util.IntArray;
import com.android.internal.annotations.VisibleForTesting;
import java.util.List;

public class TransactionExecutorHelper {
    private static final int DESTRUCTION_PENALTY = 10;
    private static final int[] ON_RESUME_PRE_EXCUTION_STATES = new int[]{2, 4};
    private IntArray mLifecycleSequence = new IntArray(6);

    @VisibleForTesting
    public IntArray getLifecyclePath(int start, int finish, boolean excludeLastState) {
        if (start == -1 || finish == -1) {
            throw new IllegalArgumentException("Can't resolve lifecycle path for undefined state");
        }
        if (start == 7 || finish == 7) {
            throw new IllegalArgumentException("Can't start or finish in intermittent RESTART state");
        }
        if (finish == 0 && start != finish) {
            throw new IllegalArgumentException("Can only start in pre-onCreate state");
        }
        this.mLifecycleSequence.clear();
        if (finish >= start) {
            for (int i = start + 1; i <= finish; ++i) {
                this.mLifecycleSequence.add(i);
            }
        } else if (start == 4 && finish == 3) {
            this.mLifecycleSequence.add(3);
        } else if (start <= 5 && finish >= 2) {
            int i;
            for (i = start + 1; i <= 5; ++i) {
                this.mLifecycleSequence.add(i);
            }
            this.mLifecycleSequence.add(7);
            for (i = 2; i <= finish; ++i) {
                this.mLifecycleSequence.add(i);
            }
        } else {
            int i;
            for (i = start + 1; i <= 6; ++i) {
                this.mLifecycleSequence.add(i);
            }
            for (i = 1; i <= finish; ++i) {
                this.mLifecycleSequence.add(i);
            }
        }
        if (excludeLastState && this.mLifecycleSequence.size() != 0) {
            this.mLifecycleSequence.remove(this.mLifecycleSequence.size() - 1);
        }
        return this.mLifecycleSequence;
    }

    @VisibleForTesting
    public int getClosestPreExecutionState(ActivityThread.ActivityClientRecord r, int postExecutionState) {
        switch (postExecutionState) {
            case -1: {
                return -1;
            }
            case 3: {
                return this.getClosestOfStates(r, ON_RESUME_PRE_EXCUTION_STATES);
            }
        }
        throw new UnsupportedOperationException("Pre-execution states for state: " + postExecutionState + " is not supported.");
    }

    @VisibleForTesting
    public int getClosestOfStates(ActivityThread.ActivityClientRecord r, int[] finalStates) {
        if (finalStates == null || finalStates.length == 0) {
            return -1;
        }
        int currentState = r.getLifecycleState();
        int closestState = -1;
        int shortestPath = Integer.MAX_VALUE;
        for (int i = 0; i < finalStates.length; ++i) {
            this.getLifecyclePath(currentState, finalStates[i], false);
            int pathLength = this.mLifecycleSequence.size();
            if (TransactionExecutorHelper.pathInvolvesDestruction(this.mLifecycleSequence)) {
                pathLength += 10;
            }
            if (shortestPath <= pathLength) continue;
            shortestPath = pathLength;
            closestState = finalStates[i];
        }
        return closestState;
    }

    public static ActivityLifecycleItem getLifecycleRequestForCurrentState(ActivityThread.ActivityClientRecord r) {
        ActivityLifecycleItem lifecycleItem;
        int prevState = r.getLifecycleState();
        switch (prevState) {
            case 4: {
                lifecycleItem = PauseActivityItem.obtain();
                break;
            }
            case 5: {
                lifecycleItem = StopActivityItem.obtain(r.isVisibleFromServer(), 0);
                break;
            }
            default: {
                lifecycleItem = ResumeActivityItem.obtain(false);
            }
        }
        return lifecycleItem;
    }

    private static boolean pathInvolvesDestruction(IntArray lifecycleSequence) {
        int size = lifecycleSequence.size();
        for (int i = 0; i < size; ++i) {
            if (lifecycleSequence.get(i) != 6) continue;
            return true;
        }
        return false;
    }

    static int lastCallbackRequestingState(ClientTransaction transaction) {
        List<ClientTransactionItem> callbacks = transaction.getCallbacks();
        if (callbacks == null || callbacks.size() == 0) {
            return -1;
        }
        int lastRequestedState = -1;
        int lastRequestingCallback = -1;
        for (int i = callbacks.size() - 1; i >= 0; --i) {
            ClientTransactionItem callback = callbacks.get(i);
            int postExecutionState = callback.getPostExecutionState();
            if (postExecutionState == -1) continue;
            if (lastRequestedState != -1 && lastRequestedState != postExecutionState) break;
            lastRequestedState = postExecutionState;
            lastRequestingCallback = i;
        }
        return lastRequestingCallback;
    }
}

