/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.SdkUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ManifestResourceDetector
extends ResourceXmlDetector {
    public static final Issue ISSUE = Issue.create((String)"ManifestResource", (String)"Manifest Resource References", (String)"Elements in the manifest can reference resources, but those resources cannot vary across configurations (except as a special case, by version, and except for a few specific package attributes such as the application title and icon).", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.FATAL, (Implementation)new Implementation(ManifestResourceDetector.class, Scope.MANIFEST_AND_RESOURCE_SCOPE, new EnumSet[]{Scope.MANIFEST_SCOPE}));
    private Map<String, Multimap<ResourceType, Location>> mManifestLocations;

    public void visitDocument(XmlContext context, Document document) {
        if (SdkUtils.endsWithIgnoreCase((String)context.file.getPath(), (String)"AndroidManifest.xml")) {
            this.checkManifest(context, document);
        } else if (this.mManifestLocations != null) {
            this.checkResourceFile(context, document);
        }
    }

    private void checkManifest(XmlContext context, Document document) {
        LintClient client = context.getClient();
        Project project = context.getProject();
        ResourceRepository repository = null;
        if (client.supportsProjectResources()) {
            repository = client.getResourceRepository(project, true, false);
        }
        if (repository == null && !context.getScope().contains(Scope.RESOURCE_FILE)) {
            return;
        }
        Element root = document.getDocumentElement();
        if (root != null) {
            this.visit(context, root, repository);
        }
    }

    private void visit(XmlContext context, Element element, ResourceRepository repository) {
        if ("meta-data".equals(element.getTagName())) {
            return;
        }
        NamedNodeMap attributes = element.getAttributes();
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            Attr attribute;
            Node node = attributes.item(i);
            String value = node.getNodeValue();
            if (!value.startsWith("@") || ManifestResourceDetector.isAllowedToVary(attribute = (Attr)node)) continue;
            this.checkReference(context, attribute, value, repository);
        }
        NodeList children = element.getChildNodes();
        int n2 = children.getLength();
        for (int i = 0; i < n2; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            this.visit(context, (Element)child, repository);
        }
    }

    private static boolean isAllowedToVary(Attr attribute) {
        String name = attribute.getLocalName();
        if ("label".equals(name) || "icon".equals(name) || "theme".equals(name) || "description".equals(name) || "logo".equals(name) || "banner".equals(name) || "sharedUserLabel".equals(name) || "roundIcon".equals(name)) {
            return "http://schemas.android.com/apk/res/android".equals(attribute.getNamespaceURI());
        }
        return false;
    }

    private void checkReference(XmlContext context, Attr attribute, String value, ResourceRepository repository) {
        ResourceUrl url = ResourceUrl.parse((String)value);
        if (url != null && !url.isFramework()) {
            if (repository != null) {
                List items = repository.getResources(ResourceNamespace.TODO(), url.type, url.name);
                if (items.size() > 1) {
                    ArrayList list = Lists.newArrayListWithExpectedSize((int)5);
                    for (ResourceItem item : items) {
                        String qualifiers = item.getConfiguration().getQualifierString();
                        if (qualifiers.isEmpty()) continue;
                        int qualifierCount = 1;
                        int n = qualifiers.length();
                        for (int i = 0; i < n; ++i) {
                            if (qualifiers.charAt(i) != '-') continue;
                            ++qualifierCount;
                        }
                        FolderConfiguration configuration = item.getConfiguration();
                        if (configuration == null) continue;
                        DensityQualifier densityQualifier = configuration.getDensityQualifier();
                        VersionQualifier versionQualifier = configuration.getVersionQualifier();
                        if (qualifierCount == 1 && (versionQualifier != null && versionQualifier.isValid() || densityQualifier != null && densityQualifier.isValid()) || qualifierCount == 2 && densityQualifier != null && densityQualifier.isValid() && versionQualifier != null && versionQualifier.isValid()) continue;
                        list.add(qualifiers);
                    }
                    if (!list.isEmpty()) {
                        Collections.sort(list);
                        String message2 = ManifestResourceDetector.getErrorMessage(Joiner.on((String)", ").join((Iterable)list));
                        context.report(ISSUE, (Node)attribute, context.getValueLocation(attribute), message2);
                    }
                }
            } else if (!context.getDriver().isSuppressed(context, ISSUE, (Node)attribute)) {
                ArrayListMultimap typeMap;
                if (this.mManifestLocations == null) {
                    this.mManifestLocations = Maps.newHashMap();
                }
                if ((typeMap = this.mManifestLocations.get(url.name)) == null) {
                    typeMap = ArrayListMultimap.create();
                    this.mManifestLocations.put(url.name, (Multimap<ResourceType, Location>)typeMap);
                }
                typeMap.put((Object)url.type, (Object)context.getValueLocation(attribute));
            }
        }
    }

    private void checkResourceFile(XmlContext context, Document document) {
        block7: {
            String name;
            ResourceFolderType folderType;
            String qualifiers;
            block6: {
                File parentFile = context.file.getParentFile();
                if (parentFile == null) {
                    return;
                }
                String parentName = parentFile.getName();
                int index = parentName.indexOf(45);
                if (index == -1) {
                    return;
                }
                qualifiers = parentName.substring(index + 1);
                if (VersionQualifier.getQualifier((String)qualifiers) != null) {
                    return;
                }
                folderType = context.getResourceFolderType();
                if (folderType != ResourceFolderType.VALUES) break block6;
                Element root = document.getDocumentElement();
                if (root == null) break block7;
                NodeList children = root.getChildNodes();
                int n = children.getLength();
                for (int i = 0; i < n; ++i) {
                    ResourceType type;
                    Element item;
                    String name2;
                    Node child = children.item(i);
                    if (child.getNodeType() != 1 || (name2 = (item = (Element)child).getAttribute("name")) == null || !this.mManifestLocations.containsKey(name2) || (type = ResourceType.fromXmlTag((Node)item)) == null) continue;
                    this.reportIfFound(context, qualifiers, name2, type, item);
                }
                break block7;
            }
            if (folderType != null && this.mManifestLocations.containsKey(name = Lint.getBaseName((String)context.file.getName()))) {
                List types = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)folderType);
                for (ResourceType type : types) {
                    this.reportIfFound(context, qualifiers, name, type, document.getDocumentElement());
                }
            }
        }
    }

    private void reportIfFound(XmlContext context, String qualifiers, String name, ResourceType type, Node secondary) {
        Collection locations;
        Multimap<ResourceType, Location> typeMap = this.mManifestLocations.get(name);
        if (typeMap != null && (locations = typeMap.get((Object)type)) != null) {
            for (Location location : locations) {
                String message2 = ManifestResourceDetector.getErrorMessage(qualifiers);
                if (secondary != null) {
                    Location secondaryLocation = context.getLocation(secondary);
                    secondaryLocation.setSecondary(location.getSecondary());
                    secondaryLocation.setMessage("This value will not be used");
                    location.setSecondary(secondaryLocation);
                }
                context.report(ISSUE, location, message2);
            }
        }
    }

    private static String getErrorMessage(String qualifiers) {
        return "Resources referenced from the manifest cannot vary by configuration (except for version qualifiers, e.g. `-v21`). Found variation in " + qualifiers;
    }
}

