/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xsltDebugger;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.intellij.plugins.xsltDebugger.VMPausedException;
import org.intellij.plugins.xsltDebugger.rt.engine.Watchable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class EDTGuard
implements InvocationHandler {
    private static final long MAX_TIMEOUT = 10000L;
    private final Map<Object, Object> myInstanceCache = ContainerUtil.newIdentityTroveMap();
    private final Object myTarget;
    private final Pair<LinkedBlockingQueue<Call>, LinkedBlockingQueue<Call.Result>> myQueue;
    private final AtomicBoolean myPausedRef;

    private EDTGuard(Object target, Pair<LinkedBlockingQueue<Call>, LinkedBlockingQueue<Call.Result>> queue, AtomicBoolean ref) {
        this.myTarget = target;
        this.myQueue = queue;
        this.myPausedRef = ref;
    }

    @Override
    @Nullable
    public Object invoke(Object proxy, @NotNull Method method, Object[] args) throws Throwable {
        if (method == null) {
            EDTGuard.$$$reportNull$$$0(0);
        }
        if (SwingUtilities.isEventDispatchThread()) {
            return this.invokeAsync(method, args);
        }
        return this.invoke(method, args);
    }

    @Nullable
    private Object invokeAsync(Method method, Object[] args) throws Throwable {
        Call.Result result;
        Call call = new Call(method, args);
        if (!((LinkedBlockingQueue)this.myQueue.first).offer(call)) {
            throw new VMPausedException();
        }
        long start = System.currentTimeMillis();
        do {
            result = (Call.Result)((LinkedBlockingQueue)this.myQueue.second).poll(200L, TimeUnit.MILLISECONDS);
            if (!this.myPausedRef.get() && (result != null || System.currentTimeMillis() - start <= 10000L)) continue;
            throw new VMPausedException();
        } while (result == null || !result.isFromCall(call));
        return result.getValue();
    }

    @Nullable
    private Object invoke(@NotNull Method method, Object[] args) throws Throwable {
        if (method == null) {
            EDTGuard.$$$reportNull$$$0(1);
        }
        try {
            return this.convert(method.invoke(this.myTarget, args));
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Object convert(@Nullable Object o) {
        if (o != null && !(o instanceof Serializable)) {
            Map<Object, Object> map = this.myInstanceCache;
            synchronized (map) {
                Object instance = this.myInstanceCache.get(o);
                if (instance == null) {
                    ClassLoader loader = o.getClass().getClassLoader();
                    Class<?>[] interfaces = o.getClass().getInterfaces();
                    EDTGuard guard = new EDTGuard(o, this.myQueue, this.myPausedRef);
                    instance = Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)guard);
                    this.myInstanceCache.put(o, instance);
                }
                return instance;
            }
        }
        if (o instanceof List) {
            List list = (List)o;
            for (int i = 0; i < list.size(); ++i) {
                Object e = list.remove(i);
                list.add(i, this.convert(e));
            }
        } else if (o instanceof Set) {
            Set set = (Set)o;
            ArrayList<Object> s2 = new ArrayList<Object>();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object o2;
                Object o1 = iterator.next();
                if (o1 == (o2 = this.convert(o1))) continue;
                iterator.remove();
                s2.add(o2);
            }
            set.addAll(s2);
        }
        return o;
    }

    @NotNull
    public static <T, O extends Watchable> T create(final @NotNull O target, ProcessHandler process) {
        if (target == null) {
            EDTGuard.$$$reportNull$$$0(2);
        }
        final Pair queue = Pair.create(new LinkedBlockingQueue(10), new LinkedBlockingQueue());
        final Thread thread = new Thread("Async Invocation Thread for " + process){

            @Override
            public void run() {
                try {
                    while (!Thread.currentThread().isInterrupted()) {
                        Call call = (Call)((LinkedBlockingQueue)queue.first).take();
                        if (call == null) continue;
                        ((LinkedBlockingQueue)queue.second).offer(call.invoke());
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        thread.start();
        final AtomicBoolean ref = new AtomicBoolean();
        final Disposable d = new Disposable(){
            boolean disposed;

            public void dispose() {
                if (!this.disposed) {
                    this.disposed = true;
                    ref.set(true);
                    thread.interrupt();
                }
            }
        };
        process.addProcessListener((ProcessListener)new ProcessAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                Disposable disposable = d;
                synchronized (disposable) {
                    Disposer.dispose((Disposable)d);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                if (event == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (!willBeDestroyed) {
                    Disposable disposable = d;
                    synchronized (disposable) {
                        Disposer.dispose((Disposable)d);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "org/intellij/plugins/xsltDebugger/EDTGuard$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processWillTerminate";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        final Alarm alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, d);
        final Alarm alarm2 = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)alarm);
        final Runnable watchdog = () -> ref.set(true);
        Runnable ping = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Disposable disposable = d;
                synchronized (disposable) {
                    if (alarm.isDisposed()) {
                        return;
                    }
                    alarm2.addRequest(watchdog, 200);
                    try {
                        ref.set(!target.ping());
                    }
                    catch (Exception e) {
                        ref.set(true);
                    }
                    finally {
                        alarm2.cancelRequest(watchdog);
                        alarm.addRequest((Runnable)this, 500);
                    }
                }
            }
        };
        alarm.addRequest(ping, 500);
        EDTGuard guard = new EDTGuard(target, (Pair<LinkedBlockingQueue<Call>, LinkedBlockingQueue<Call.Result>>)queue, ref);
        ClassLoader classLoader = target.getClass().getClassLoader();
        Class<?>[] interfaces = target.getClass().getInterfaces();
        Object object = Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)guard);
        if (object == null) {
            EDTGuard.$$$reportNull$$$0(3);
        }
        return (T)object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/xsltDebugger/EDTGuard";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/xsltDebugger/EDTGuard";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    class Call {
        private final Method myMethod;
        private final Object[] myArguments;

        Call(Method method, Object[] arguments) {
            this.myMethod = method;
            this.myArguments = arguments;
        }

        @NotNull
        public Result invoke() {
            Result result;
            block3: {
                try {
                    result = new Result(EDTGuard.this.invoke(this.myMethod, this.myArguments));
                    if (result != null) break block3;
                }
                catch (Throwable e) {
                    Result result2 = new Result(e);
                    if (result2 == null) {
                        Call.$$$reportNull$$$0(1);
                    }
                    return result2;
                }
                Call.$$$reportNull$$$0(0);
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/xsltDebugger/EDTGuard$Call", "invoke"));
        }

        class Result {
            private final Object myObject;
            private final Throwable myThrowable;

            Result(Object o) {
                this.myObject = o;
                this.myThrowable = null;
            }

            Result(Throwable o) {
                this.myObject = null;
                this.myThrowable = o;
            }

            public boolean isFromCall(Call call) {
                return call == Call.this;
            }

            @Nullable
            public Object getValue() throws Throwable {
                if (this.myThrowable != null) {
                    throw this.myThrowable;
                }
                return this.myObject;
            }
        }
    }
}

