/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model;

import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.gradle.tooling.internal.adapter.TargetTypeProvider;
import org.gradle.tooling.model.BuildIdentifier;
import org.gradle.tooling.model.BuildModel;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.Model;
import org.gradle.tooling.model.ProjectModel;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.gradle.BasicGradleProject;
import org.gradle.tooling.model.gradle.GradleBuild;
import org.gradle.tooling.model.idea.BasicIdeaProject;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ModelsHolder;
import org.jetbrains.plugins.gradle.model.ProjectImportModelProvider;
import org.jetbrains.plugins.gradle.tooling.serialization.ToolingSerializer;

public class ProjectImportAction
implements BuildAction<AllModels>,
Serializable {
    private final Set<ProjectImportModelProvider> myProjectsLoadedModelProviders = new LinkedHashSet<ProjectImportModelProvider>();
    private final Set<ProjectImportModelProvider> myBuildFinishedModelProviders = new LinkedHashSet<ProjectImportModelProvider>();
    private final Set<Class> myTargetTypes = new LinkedHashSet<Class>();
    private final boolean myIsPreviewMode;
    private final boolean myIsCompositeBuildsSupported;
    private final boolean myUseCustomSerialization;
    private boolean myUseProjectsLoadedPhase;
    private AllModels myAllModels = null;

    public ProjectImportAction(boolean isPreviewMode) {
        this(isPreviewMode, false, false);
    }

    public ProjectImportAction(boolean isPreviewMode, boolean isCompositeBuildsSupported, boolean useCustomSerialization) {
        this.myIsPreviewMode = isPreviewMode;
        this.myIsCompositeBuildsSupported = isCompositeBuildsSupported;
        this.myUseCustomSerialization = useCustomSerialization;
    }

    public void addProjectImportModelProvider(@NotNull ProjectImportModelProvider provider) {
        if (provider == null) {
            ProjectImportAction.$$$reportNull$$$0(0);
        }
        this.addProjectImportModelProvider(provider, false);
    }

    public void addProjectImportModelProvider(@NotNull ProjectImportModelProvider provider, boolean isProjectLoadedProvider) {
        if (provider == null) {
            ProjectImportAction.$$$reportNull$$$0(1);
        }
        if (isProjectLoadedProvider) {
            this.myProjectsLoadedModelProviders.add(provider);
        } else {
            this.myBuildFinishedModelProviders.add(provider);
        }
    }

    public void addTargetTypes(@NotNull Set<Class> targetTypes) {
        if (targetTypes == null) {
            ProjectImportAction.$$$reportNull$$$0(2);
        }
        this.myTargetTypes.addAll(targetTypes);
    }

    public void prepareForPhasedExecuter() {
        this.myUseProjectsLoadedPhase = true;
    }

    public void prepareForNonPhasedExecuter() {
        this.myUseProjectsLoadedPhase = false;
    }

    @Nullable
    public AllModels execute(BuildController controller) {
        boolean isProjectsLoadedAction;
        this.configureAdditionalTypes(controller);
        boolean bl = isProjectsLoadedAction = this.myAllModels == null && this.myUseProjectsLoadedPhase;
        if (isProjectsLoadedAction || !this.myUseProjectsLoadedPhase) {
            long startTime = System.currentTimeMillis();
            GradleBuild gradleBuild = controller.getBuildModel();
            AllModels allModels = new AllModels((BuildModel)gradleBuild);
            allModels.logPerformance("Get model GradleBuild", System.currentTimeMillis() - startTime);
            long startTimeBuildEnv = System.currentTimeMillis();
            BuildEnvironment buildEnvironment = (BuildEnvironment)controller.findModel(BuildEnvironment.class);
            allModels.setBuildEnvironment(buildEnvironment);
            allModels.logPerformance("Get model BuildEnvironment", System.currentTimeMillis() - startTimeBuildEnv);
            this.myAllModels = allModels;
        }
        if (!isProjectsLoadedAction) {
            IdeaProject ideaProject;
            long startTimeIdeaProject = System.currentTimeMillis();
            IdeaProject ideaProject2 = ideaProject = this.myIsPreviewMode ? (IdeaProject)controller.getModel(BasicIdeaProject.class) : (IdeaProject)controller.getModel(IdeaProject.class);
            assert (ideaProject != null && !ideaProject.getModules().isEmpty());
            this.myAllModels.logPerformance("Get model IdeaProject" + (this.myIsPreviewMode ? " (preview mode)" : ""), System.currentTimeMillis() - startTimeIdeaProject);
            this.myAllModels.setIdeaProject(ideaProject);
        }
        GradleBuild gradleBuild = (GradleBuild)this.myAllModels.getRootModel();
        ToolingSerializerAdapter serializerHolder = new ToolingSerializerAdapter();
        for (BasicGradleProject gradleProject : gradleBuild.getProjects()) {
            this.addProjectModels(serializerHolder, controller, this.myAllModels, gradleProject, isProjectsLoadedAction);
        }
        this.addBuildModels(controller, this.myAllModels, gradleBuild, isProjectsLoadedAction);
        if (this.myIsCompositeBuildsSupported) {
            for (GradleBuild includedBuild : gradleBuild.getIncludedBuilds()) {
                if (!isProjectsLoadedAction) {
                    IdeaProject ideaIncludedProject = this.myIsPreviewMode ? (IdeaProject)controller.findModel((Model)includedBuild, BasicIdeaProject.class) : (IdeaProject)controller.findModel((Model)includedBuild, IdeaProject.class);
                    this.myAllModels.getIncludedBuilds().add(ideaIncludedProject);
                }
                for (BasicGradleProject project : includedBuild.getProjects()) {
                    this.addProjectModels(serializerHolder, controller, this.myAllModels, project, isProjectsLoadedAction);
                }
                this.addBuildModels(controller, this.myAllModels, includedBuild, isProjectsLoadedAction);
            }
        }
        return isProjectsLoadedAction && this.myAllModels.hasModels() ? null : this.myAllModels;
    }

    private void configureAdditionalTypes(BuildController controller) {
        try {
            Field adapterField;
            try {
                adapterField = controller.getClass().getDeclaredField("adapter");
            }
            catch (NoSuchFieldException e) {
                Field delegate = controller.getClass().getDeclaredField("delegate");
                delegate.setAccessible(true);
                Object wrappedController = delegate.get(controller);
                adapterField = wrappedController.getClass().getDeclaredField("adapter");
                controller = (BuildController)wrappedController;
            }
            adapterField.setAccessible(true);
            ProtocolToModelAdapter adapter = (ProtocolToModelAdapter)adapterField.get(controller);
            Field typeProviderField = adapter.getClass().getDeclaredField("targetTypeProvider");
            typeProviderField.setAccessible(true);
            TargetTypeProvider typeProvider = (TargetTypeProvider)typeProviderField.get(adapter);
            Field targetTypesField = typeProvider.getClass().getDeclaredField("configuredTargetTypes");
            targetTypesField.setAccessible(true);
            Map targetTypes = (Map)targetTypesField.get(typeProvider);
            for (Class targetType : this.myTargetTypes) {
                targetTypes.put(targetType.getCanonicalName(), targetType);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addProjectModels(final @NotNull ToolingSerializerAdapter serializerAdapter, @NotNull BuildController controller, final @NotNull AllModels allModels, final @NotNull BasicGradleProject project, boolean isProjectsLoadedAction) {
        block7: {
            if (serializerAdapter == null) {
                ProjectImportAction.$$$reportNull$$$0(3);
            }
            if (controller == null) {
                ProjectImportAction.$$$reportNull$$$0(4);
            }
            if (allModels == null) {
                ProjectImportAction.$$$reportNull$$$0(5);
            }
            if (project == null) {
                ProjectImportAction.$$$reportNull$$$0(6);
            }
            try {
                Set<ProjectImportModelProvider> modelProviders = this.getModelProviders(isProjectsLoadedAction);
                for (ProjectImportModelProvider extension : modelProviders) {
                    final HashSet<String> obtainedModels = new HashSet<String>();
                    long startTime = System.currentTimeMillis();
                    ProjectImportModelProvider.ProjectModelConsumer modelConsumer = new ProjectImportModelProvider.ProjectModelConsumer(){

                        @Override
                        public void consume(@NotNull Object object, @NotNull Class clazz) {
                            if (object == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (clazz == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            if (ProjectImportAction.this.myUseCustomSerialization) {
                                object = serializerAdapter.serialize(object);
                            }
                            allModels.addModel(object, clazz, project);
                            obtainedModels.add(clazz.getName());
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "object";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "clazz";
                                    break;
                                }
                            }
                            objectArray[1] = "org/jetbrains/plugins/gradle/model/ProjectImportAction$1";
                            objectArray[2] = "consume";
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    };
                    extension.populateProjectModels(controller, (Model)project, modelConsumer);
                    allModels.logPerformance("Ran extension " + extension.getClass().getName() + " for project " + project.getProjectIdentifier().getProjectPath() + " obtained " + obtainedModels.size() + " model(s): " + ProjectImportAction.joinClassNamesToString(obtainedModels), System.currentTimeMillis() - startTime);
                }
            }
            catch (Exception e) {
                if (this.myIsPreviewMode) break block7;
                throw new ExternalSystemException((Throwable)e);
            }
        }
    }

    private void addBuildModels(@NotNull BuildController controller, final @NotNull AllModels allModels, @NotNull GradleBuild buildModel, boolean isProjectsLoadedAction) {
        block6: {
            if (controller == null) {
                ProjectImportAction.$$$reportNull$$$0(7);
            }
            if (allModels == null) {
                ProjectImportAction.$$$reportNull$$$0(8);
            }
            if (buildModel == null) {
                ProjectImportAction.$$$reportNull$$$0(9);
            }
            try {
                Set<ProjectImportModelProvider> modelProviders = this.getModelProviders(isProjectsLoadedAction);
                for (ProjectImportModelProvider extension : modelProviders) {
                    final HashSet<String> obtainedModels = new HashSet<String>();
                    long startTime = System.currentTimeMillis();
                    ProjectImportModelProvider.BuildModelConsumer modelConsumer = new ProjectImportModelProvider.BuildModelConsumer(){

                        @Override
                        public void consume(@NotNull BuildModel buildModel, @NotNull Object object, @NotNull Class clazz) {
                            if (buildModel == null) {
                                2.$$$reportNull$$$0(0);
                            }
                            if (object == null) {
                                2.$$$reportNull$$$0(1);
                            }
                            if (clazz == null) {
                                2.$$$reportNull$$$0(2);
                            }
                            allModels.addModel(object, clazz, buildModel);
                            obtainedModels.add(clazz.getName());
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "buildModel";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "object";
                                    break;
                                }
                                case 2: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "clazz";
                                    break;
                                }
                            }
                            objectArray[1] = "org/jetbrains/plugins/gradle/model/ProjectImportAction$2";
                            objectArray[2] = "consume";
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    };
                    extension.populateBuildModels(controller, buildModel, modelConsumer);
                    allModels.logPerformance("Ran extension " + extension.getClass().getName() + " for build " + buildModel.getBuildIdentifier().getRootDir().getPath() + " obtained " + obtainedModels.size() + " model(s): " + ProjectImportAction.joinClassNamesToString(obtainedModels), System.currentTimeMillis() - startTime);
                }
            }
            catch (Exception e) {
                if (this.myIsPreviewMode) break block6;
                throw new ExternalSystemException((Throwable)e);
            }
        }
    }

    private Set<ProjectImportModelProvider> getModelProviders(boolean isProjectsLoadedAction) {
        LinkedHashSet<ProjectImportModelProvider> modelProviders = new LinkedHashSet<ProjectImportModelProvider>();
        if (!this.myUseProjectsLoadedPhase) {
            modelProviders.addAll(this.myProjectsLoadedModelProviders);
            modelProviders.addAll(this.myBuildFinishedModelProviders);
        } else {
            modelProviders = isProjectsLoadedAction ? this.myProjectsLoadedModelProviders : this.myBuildFinishedModelProviders;
        }
        return modelProviders;
    }

    @NotNull
    private static String joinClassNamesToString(@NotNull Set<String> names) {
        if (names == null) {
            ProjectImportAction.$$$reportNull$$$0(10);
        }
        StringBuilder sb = new StringBuilder();
        Iterator<String> it = names.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        String string = sb.toString();
        if (string == null) {
            ProjectImportAction.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetTypes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializerAdapter";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allModels";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildModel";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/model/ProjectImportAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/model/ProjectImportAction";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "joinClassNamesToString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addProjectImportModelProvider";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addTargetTypes";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addProjectModels";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addBuildModels";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "joinClassNamesToString";
                break;
            }
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ToolingSerializerAdapter {
        private ClassLoader myModelBuildersClassLoader;
        private Object mySerializer;
        private Method mySerializerWriteMethod;

        private ToolingSerializerAdapter() {
        }

        private Object prepare(Object object) throws IOException {
            try {
                object = new ProtocolToModelAdapter().unpack(object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                ClassLoader objectClassLoader = object.getClass().getClassLoader();
                if (this.myModelBuildersClassLoader == null) {
                    Class<?> toolingSerializerClass = objectClassLoader.loadClass(ToolingSerializer.class.getName());
                    this.mySerializer = toolingSerializerClass.newInstance();
                    this.mySerializerWriteMethod = toolingSerializerClass.getMethod("write", Object.class, Class.class);
                    this.myModelBuildersClassLoader = objectClassLoader;
                } else if (objectClassLoader != this.myModelBuildersClassLoader) {
                    return null;
                }
            }
            catch (ClassNotFoundException e) {
                return null;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            return object;
        }

        private Object serialize(Object object) {
            try {
                Object preparedObject = this.prepare(object);
                if (preparedObject != null) {
                    return this.mySerializerWriteMethod.invoke(this.mySerializer, preparedObject, preparedObject.getClass());
                }
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
            return object;
        }
    }

    public static class AllModels
    extends ModelsHolder<BuildModel, ProjectModel> {
        private final List<IdeaProject> includedBuilds;
        private final Map<String, Long> performanceTrace;
        private IdeaProject myIdeaProject;

        public AllModels(@NotNull BuildModel rootProjectModel) {
            if (rootProjectModel == null) {
                AllModels.$$$reportNull$$$0(0);
            }
            super(rootProjectModel);
            this.includedBuilds = new ArrayList<IdeaProject>();
            this.performanceTrace = new LinkedHashMap<String, Long>();
        }

        public AllModels(@NotNull IdeaProject ideaProject) {
            if (ideaProject == null) {
                AllModels.$$$reportNull$$$0(1);
            }
            super(new IdeaProjectBuildModelAdapter(ideaProject));
            this.includedBuilds = new ArrayList<IdeaProject>();
            this.performanceTrace = new LinkedHashMap<String, Long>();
            this.setIdeaProject(ideaProject);
        }

        @NotNull
        public IdeaProject getIdeaProject() {
            IdeaProject ideaProject = this.myIdeaProject;
            if (ideaProject == null) {
                AllModels.$$$reportNull$$$0(2);
            }
            return ideaProject;
        }

        private void setIdeaProject(@NotNull IdeaProject ideaProject) {
            if (ideaProject == null) {
                AllModels.$$$reportNull$$$0(3);
            }
            this.myIdeaProject = ideaProject;
        }

        public List<IdeaProject> getIncludedBuilds() {
            return this.includedBuilds;
        }

        @Nullable
        public BuildEnvironment getBuildEnvironment() {
            return this.getModel(BuildEnvironment.class);
        }

        public void setBuildEnvironment(@Nullable BuildEnvironment buildEnvironment) {
            if (buildEnvironment != null) {
                this.addModel(buildEnvironment, BuildEnvironment.class);
            }
        }

        public void logPerformance(@NotNull String description, long millis) {
            if (description == null) {
                AllModels.$$$reportNull$$$0(4);
            }
            this.performanceTrace.put(description, millis);
        }

        public Map<String, Long> getPerformanceTrace() {
            return this.performanceTrace;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootProjectModel";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ideaProject";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/gradle/model/ProjectImportAction$AllModels";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "description";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/gradle/model/ProjectImportAction$AllModels";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIdeaProject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setIdeaProject";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "logPerformance";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class IdeaProjectBuildModelAdapter
        implements BuildModel {
            private final BuildIdentifier myBuildIdentifier;

            private IdeaProjectBuildModelAdapter(@NotNull IdeaProject ideaProject) {
                if (ideaProject == null) {
                    IdeaProjectBuildModelAdapter.$$$reportNull$$$0(0);
                }
                DomainObjectSet ideaModules = ideaProject.getChildren();
                assert (!ideaModules.isEmpty());
                IdeaModule ideaModule = (IdeaModule)ideaModules.getAt(0);
                this.myBuildIdentifier = ideaModule.getGradleProject().getProjectIdentifier().getBuildIdentifier();
            }

            public BuildIdentifier getBuildIdentifier() {
                return this.myBuildIdentifier;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideaProject", "org/jetbrains/plugins/gradle/model/ProjectImportAction$AllModels$IdeaProjectBuildModelAdapter", "<init>"));
            }
        }
    }
}

