/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.tooling.model.BuildIdentifier;
import org.gradle.tooling.model.BuildModel;
import org.gradle.tooling.model.ProjectIdentifier;
import org.gradle.tooling.model.ProjectModel;
import org.gradle.tooling.model.idea.IdeaModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.tooling.serialization.ToolingSerializer;

public abstract class ModelsHolder<B extends BuildModel, P extends ProjectModel>
implements Serializable {
    @NotNull
    private final B myRootModel;
    @NotNull
    private final Map<String, Object> myModelsById;
    @Nullable
    private ToolingSerializer mySerializer;

    public ModelsHolder(@NotNull B rootModel) {
        if (rootModel == null) {
            ModelsHolder.$$$reportNull$$$0(0);
        }
        this.myModelsById = new LinkedHashMap<String, Object>();
        this.myRootModel = rootModel;
    }

    public void initToolingSerializer() {
        this.mySerializer = new ToolingSerializer();
    }

    @NotNull
    public B getRootModel() {
        B b = this.myRootModel;
        if (b == null) {
            ModelsHolder.$$$reportNull$$$0(1);
        }
        return b;
    }

    @Nullable
    public <T> T getModel(@NotNull Class<T> modelClazz) {
        if (modelClazz == null) {
            ModelsHolder.$$$reportNull$$$0(2);
        }
        return this.getModel((P)this.getRootModel(), modelClazz);
    }

    @Nullable
    public <T> T getModel(@NotNull B build, @NotNull Class<T> modelClazz) {
        if (build == null) {
            ModelsHolder.$$$reportNull$$$0(3);
        }
        if (modelClazz == null) {
            ModelsHolder.$$$reportNull$$$0(4);
        }
        String key = ModelsHolder.extractMapKey(modelClazz, build.getBuildIdentifier());
        return this.getModel(modelClazz, key);
    }

    @Nullable
    public <T> T getModel(@NotNull P project, @NotNull Class<T> modelClazz) {
        if (project == null) {
            ModelsHolder.$$$reportNull$$$0(5);
        }
        if (modelClazz == null) {
            ModelsHolder.$$$reportNull$$$0(6);
        }
        ProjectIdentifier projectIdentifier = this.getProjectIdentifier(project);
        String key = ModelsHolder.extractMapKey(modelClazz, projectIdentifier);
        return this.getModel(modelClazz, key);
    }

    @Nullable
    private <T> T getModel(@NotNull Class<T> modelClazz, @NotNull String key) {
        Object model;
        if (modelClazz == null) {
            ModelsHolder.$$$reportNull$$$0(7);
        }
        if (key == null) {
            ModelsHolder.$$$reportNull$$$0(8);
        }
        if ((model = this.myModelsById.get(key)) == null) {
            return null;
        }
        if (modelClazz.isInstance(model)) {
            return (T)model;
        }
        this.deserializeAllDataOfTheType(modelClazz);
        return (T)this.myModelsById.get(key);
    }

    private <T> void deserializeAllDataOfTheType(@NotNull Class<T> modelClazz) {
        if (modelClazz == null) {
            ModelsHolder.$$$reportNull$$$0(9);
        }
        String keyPrefix = ModelsHolder.getModelKeyPrefix(modelClazz);
        Iterator<Map.Entry<String, Object>> iterator = this.myModelsById.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            String key = entry.getKey();
            if (!key.startsWith(keyPrefix)) continue;
            if (this.mySerializer == null || !(entry.getValue() instanceof byte[])) {
                iterator.remove();
                continue;
            }
            try {
                T deserializedData = this.mySerializer.read((byte[])entry.getValue(), modelClazz);
                if (modelClazz.isInstance(deserializedData)) {
                    this.myModelsById.put(key, deserializedData);
                    continue;
                }
                iterator.remove();
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
                iterator.remove();
            }
        }
    }

    public boolean hasModulesWithModel(@NotNull Class modelClazz) {
        if (modelClazz == null) {
            ModelsHolder.$$$reportNull$$$0(10);
        }
        String keyPrefix = ModelsHolder.getModelKeyPrefix(modelClazz);
        for (String key : this.myModelsById.keySet()) {
            if (!key.startsWith(keyPrefix)) continue;
            return true;
        }
        return false;
    }

    public void addModel(@NotNull Object model, @NotNull Class modelClazz) {
        if (model == null) {
            ModelsHolder.$$$reportNull$$$0(11);
        }
        if (modelClazz == null) {
            ModelsHolder.$$$reportNull$$$0(12);
        }
        this.addModel(model, modelClazz, this.getRootModel());
    }

    public void addModel(@NotNull Object model, @NotNull Class modelClazz, @NotNull P project) {
        if (model == null) {
            ModelsHolder.$$$reportNull$$$0(13);
        }
        if (modelClazz == null) {
            ModelsHolder.$$$reportNull$$$0(14);
        }
        if (project == null) {
            ModelsHolder.$$$reportNull$$$0(15);
        }
        ProjectIdentifier projectIdentifier = this.getProjectIdentifier(project);
        this.myModelsById.put(ModelsHolder.extractMapKey(modelClazz, projectIdentifier), model);
    }

    public void addModel(@NotNull Object model, @NotNull Class modelClazz, @NotNull B build) {
        if (model == null) {
            ModelsHolder.$$$reportNull$$$0(16);
        }
        if (modelClazz == null) {
            ModelsHolder.$$$reportNull$$$0(17);
        }
        if (build == null) {
            ModelsHolder.$$$reportNull$$$0(18);
        }
        this.myModelsById.put(ModelsHolder.extractMapKey(modelClazz, build.getBuildIdentifier()), model);
    }

    @NotNull
    private static String getModelKeyPrefix(@NotNull Class modelClazz) {
        if (modelClazz == null) {
            ModelsHolder.$$$reportNull$$$0(19);
        }
        String string = modelClazz.getSimpleName() + modelClazz.getName().hashCode();
        if (string == null) {
            ModelsHolder.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    private static String extractMapKey(@NotNull Class modelClazz, @NotNull ProjectIdentifier projectIdentifier) {
        if (modelClazz == null) {
            ModelsHolder.$$$reportNull$$$0(21);
        }
        if (projectIdentifier == null) {
            ModelsHolder.$$$reportNull$$$0(22);
        }
        String prefix = ModelsHolder.getModelKeyPrefix(modelClazz);
        BuildIdentifier buildIdentifier = projectIdentifier.getBuildIdentifier();
        String string = prefix + '/' + buildIdentifier.getRootDir().getPath().hashCode() + projectIdentifier.getProjectPath();
        if (string == null) {
            ModelsHolder.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    private static String extractMapKey(@NotNull Class modelClazz, @NotNull BuildIdentifier buildIdentifier) {
        if (modelClazz == null) {
            ModelsHolder.$$$reportNull$$$0(24);
        }
        if (buildIdentifier == null) {
            ModelsHolder.$$$reportNull$$$0(25);
        }
        String prefix = ModelsHolder.getModelKeyPrefix(modelClazz);
        String string = prefix + '/' + buildIdentifier.getRootDir().getPath().hashCode() + ":";
        if (string == null) {
            ModelsHolder.$$$reportNull$$$0(26);
        }
        return string;
    }

    private ProjectIdentifier getProjectIdentifier(@NotNull P project) {
        if (project == null) {
            ModelsHolder.$$$reportNull$$$0(27);
        }
        ProjectIdentifier projectIdentifier = project instanceof IdeaModule ? ((IdeaModule)project).getGradleProject().getProjectIdentifier() : project.getProjectIdentifier();
        return projectIdentifier;
    }

    public String toString() {
        return "Models{rootModel=" + this.myRootModel + ", myModelsById=" + this.myModelsById + '}';
    }

    boolean hasModels() {
        return !this.myModelsById.isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 20: 
            case 23: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 20: 
            case 23: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 1: 
            case 20: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/model/ModelsHolder";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelClazz";
                break;
            }
            case 3: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "build";
                break;
            }
            case 5: 
            case 15: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 11: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectIdentifier";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildIdentifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/model/ModelsHolder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootModel";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelKeyPrefix";
                break;
            }
            case 23: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "extractMapKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 20: 
            case 23: 
            case 26: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getModel";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "deserializeAllDataOfTheType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasModulesWithModel";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addModel";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getModelKeyPrefix";
                break;
            }
            case 21: 
            case 22: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "extractMapKey";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getProjectIdentifier";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 20: 
            case 23: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

