/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.transformations.impl;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrTraitField;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrTraitMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.GrClassImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;
import org.jetbrains.plugins.groovy.transformations.AstTransformationSupport;
import org.jetbrains.plugins.groovy.transformations.TransformationContext;

public class TraitTransformationSupport
implements AstTransformationSupport {
    @Override
    public void applyTransformation(@NotNull TransformationContext context) {
        GrTypeDefinition codeClass;
        if (context == null) {
            TraitTransformationSupport.$$$reportNull$$$0(0);
        }
        if ((codeClass = context.getCodeClass()).isInterface() && !codeClass.isTrait()) {
            return;
        }
        if (codeClass.isTrait() && codeClass.getQualifiedName() != null) {
            for (GrField field : codeClass.getCodeFields()) {
                context.addField(new GrTraitField(field, codeClass, PsiSubstitutor.EMPTY));
            }
        }
        TraitTransformationSupport.process(context, (PairConsumer<? super PsiClass, ? super PsiSubstitutor>)((PairConsumer)(trait, substitutor) -> {
            block5: {
                block4: {
                    if (!(trait instanceof GrTypeDefinition)) break block4;
                    for (PsiMethod psiMethod : trait.getMethods()) {
                        if (psiMethod.getModifierList().hasExplicitModifier("abstract") || psiMethod.getModifierList().hasExplicitModifier("private")) continue;
                        context.addMethods(TraitTransformationSupport.getExpandingMethods(codeClass, psiMethod, substitutor));
                    }
                    for (GrField grField : ((GrTypeDefinition)trait).getCodeFields()) {
                        context.addField(new GrTraitField(grField, codeClass, (PsiSubstitutor)substitutor));
                    }
                    break block5;
                }
                if (!(trait instanceof ClsClassImpl)) break block5;
                for (PsiMethod method : GrTraitUtil.getCompiledTraitConcreteMethods((ClsClassImpl)trait)) {
                    context.addMethods(TraitTransformationSupport.getExpandingMethods(codeClass, method, substitutor));
                }
                for (GrField field : GrTraitUtil.getCompiledTraitFields((ClsClassImpl)trait)) {
                    context.addField(new GrTraitField(field, codeClass, (PsiSubstitutor)substitutor));
                }
            }
        }));
    }

    private static void process(@NotNull TransformationContext context, @NotNull PairConsumer<? super PsiClass, ? super PsiSubstitutor> consumer) {
        if (context == null) {
            TraitTransformationSupport.$$$reportNull$$$0(1);
        }
        if (consumer == null) {
            TraitTransformationSupport.$$$reportNull$$$0(2);
        }
        ArrayDeque<Pair> stack = new ArrayDeque<Pair>();
        for (PsiClassType superType : context.getSuperTypes()) {
            PsiClassType.ClassResolveResult result2 = superType.resolveGenerics();
            PsiClass superClass = result2.getElement();
            if (superClass == null) continue;
            stack.push(Pair.create((Object)superClass, (Object)result2.getSubstitutor()));
        }
        HashSet<PsiClass> visited = new HashSet<PsiClass>();
        while (!stack.isEmpty()) {
            Pair current = (Pair)stack.pop();
            PsiClass currentClass = (PsiClass)current.first;
            PsiSubstitutor currentSubstitutor = (PsiSubstitutor)current.second;
            if (!visited.add(currentClass)) continue;
            if (GrTraitUtil.isTrait(currentClass)) {
                consumer.consume((Object)currentClass, (Object)currentSubstitutor);
            }
            for (PsiClass superClass : currentClass.getSupers()) {
                PsiSubstitutor superSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)currentClass, (PsiSubstitutor)currentSubstitutor);
                stack.push(Pair.create((Object)superClass, (Object)superSubstitutor));
            }
        }
    }

    @NotNull
    private static List<PsiMethod> getExpandingMethods(@NotNull PsiClass containingClass, @NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor) {
        if (containingClass == null) {
            TraitTransformationSupport.$$$reportNull$$$0(3);
        }
        if (method == null) {
            TraitTransformationSupport.$$$reportNull$$$0(4);
        }
        if (substitutor == null) {
            TraitTransformationSupport.$$$reportNull$$$0(5);
        }
        List result2 = ContainerUtil.newSmartList();
        for (PsiMethod psiMethod : GrClassImplUtil.expandReflectedMethods(method)) {
            result2.add(new GrTraitMethod(containingClass, psiMethod, substitutor));
        }
        List list = result2;
        if (list == null) {
            TraitTransformationSupport.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/transformations/impl/TraitTransformationSupport";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/transformations/impl/TraitTransformationSupport";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpandingMethods";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyTransformation";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getExpandingMethods";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

