/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduceParameterObject;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ParameterInfo;
import com.intellij.refactoring.introduceParameterObject.IntroduceParameterObjectClassDescriptor;
import com.intellij.refactoring.introduceParameterObject.IntroduceParameterObjectDelegate;
import com.intellij.refactoring.introduceparameterobject.JavaIntroduceParameterObjectDelegate;
import com.intellij.refactoring.util.CanonicalTypes;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrChangeInfoImpl;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrMethodDescriptor;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrParameterInfo;
import org.jetbrains.plugins.groovy.refactoring.introduceParameterObject.GrReplaceParameterReferenceWithCall;
import org.jetbrains.plugins.groovy.refactoring.introduceParameterObject.GroovyIntroduceObjectClassDescriptor;

public class GroovyIntroduceParameterObjectDelegate
extends IntroduceParameterObjectDelegate<GrMethod, GrParameterInfo, GroovyIntroduceObjectClassDescriptor> {
    public boolean isEnabledOn(PsiElement element) {
        return false;
    }

    public RefactoringActionHandler getHandler(PsiElement element) {
        return null;
    }

    public List<GrParameterInfo> getAllMethodParameters(GrMethod sourceMethod) {
        return new GrMethodDescriptor(sourceMethod).getParameters();
    }

    public GrParameterInfo createMergedParameterInfo(final GroovyIntroduceObjectClassDescriptor descriptor2, GrMethod method, final List<? extends GrParameterInfo> oldMethodParameters) {
        GroovyPsiElementFactory elementFactory = GroovyPsiElementFactory.getInstance(method.getProject());
        PsiClassType classType = elementFactory.createTypeByFQClassName(StringUtil.getQualifiedName((String)descriptor2.getPackageName(), (String)descriptor2.getClassName()));
        return new GrParameterInfo(descriptor2.getClassName(), null, null, (PsiType)classType, -1, false){

            @Nullable
            public PsiElement getActualValue(PsiElement callExpression, Object substitutor) {
                IntroduceParameterObjectDelegate delegate = IntroduceParameterObjectDelegate.findDelegate((PsiElement)callExpression);
                return delegate != null ? delegate.createNewParameterInitializerAtCallSite(callExpression, (IntroduceParameterObjectClassDescriptor)descriptor2, oldMethodParameters, substitutor) : null;
            }
        };
    }

    public PsiElement createNewParameterInitializerAtCallSite(PsiElement callExpression, IntroduceParameterObjectClassDescriptor descriptor2, List<? extends ParameterInfo> oldMethodParameters, Object substitutor) {
        if (callExpression instanceof GrCallExpression) {
            GrArgumentList list = ((GrCallExpression)callExpression).getArgumentList();
            if (list == null) {
                return null;
            }
            PsiElement[] args = list.getExpressionArguments();
            String qualifiedName = StringUtil.getQualifiedName((String)descriptor2.getPackageName(), (String)descriptor2.getClassName());
            String newExpression = "new " + qualifiedName + '(' + JavaIntroduceParameterObjectDelegate.getMergedArgs((IntroduceParameterObjectClassDescriptor)descriptor2, oldMethodParameters, (PsiElement[])args) + ')';
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(callExpression.getProject());
            return factory.createExpressionFromText(newExpression, callExpression);
        }
        return null;
    }

    public ChangeInfo createChangeSignatureInfo(GrMethod method, List<GrParameterInfo> newParameterInfos, boolean delegate) {
        PsiType returnType2 = method.getReturnType();
        return new GrChangeInfoImpl(method, VisibilityUtil.getVisibilityModifier((PsiModifierList)method.getModifierList()), returnType2 != null ? CanonicalTypes.createTypeWrapper((PsiType)returnType2) : null, method.getName(), newParameterInfos, null, delegate);
    }

    public <M1 extends PsiNamedElement, P1 extends ParameterInfo> ReadWriteAccessDetector.Access collectInternalUsages(Collection<? super FixableUsageInfo> usages, GrMethod overridingMethod, IntroduceParameterObjectClassDescriptor<M1, P1> classDescriptor, P1 parameterInfo, String mergedParamName) {
        int oldIndex = parameterInfo.getOldIndex();
        GrParameter parameter = overridingMethod.getParameterList().getParameters()[oldIndex];
        ReadWriteAccessDetector.Access[] accessors = new ReadWriteAccessDetector.Access[1];
        String setter = classDescriptor.getSetterName(parameterInfo, (PsiElement)overridingMethod);
        String getter = classDescriptor.getGetterName(parameterInfo, (PsiElement)overridingMethod);
        ReferencesSearch.search((PsiElement)parameter, (SearchScope)new LocalSearchScope((PsiElement)overridingMethod)).forEach(reference -> {
            PsiElement element = reference.getElement();
            if (element instanceof GrReferenceExpression) {
                accessors[0] = ReadWriteAccessDetector.Access.Read;
                usages.add(new GrReplaceParameterReferenceWithCall(element, getter, mergedParamName));
            }
            return true;
        });
        return accessors[0];
    }

    public void collectUsagesToGenerateMissedFieldAccessors(Collection<? super FixableUsageInfo> usages, GrMethod method, GroovyIntroduceObjectClassDescriptor descriptor2, ReadWriteAccessDetector.Access[] accessors) {
        throw new UnsupportedOperationException();
    }

    public void collectAdditionalFixes(Collection<? super FixableUsageInfo> usages, GrMethod method, GroovyIntroduceObjectClassDescriptor descriptor2) {
        throw new UnsupportedOperationException();
    }

    public void collectConflicts(MultiMap<PsiElement, String> conflicts, UsageInfo[] infos, GrMethod method, GroovyIntroduceObjectClassDescriptor classDescriptor) {
        throw new UnsupportedOperationException();
    }
}

