/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduce.parameter;

import com.intellij.ide.util.SuperMethodWarningUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.PairFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrParameterListOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.refactoring.GrRefactoringError;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.extract.GroovyExtractChooser;
import org.jetbrains.plugins.groovy.refactoring.extract.InitialInfo;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceContext;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceHandlerBase;
import org.jetbrains.plugins.groovy.refactoring.introduce.IntroduceOccurrencesChooser;
import org.jetbrains.plugins.groovy.refactoring.introduce.StringPartInfo;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.GrInplaceParameterIntroducer;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.GrIntroduceParameterDialog;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.GroovyIntroduceParameterUtil;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.IntroduceParameterInfo;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.IntroduceParameterInfoImpl;
import org.jetbrains.plugins.groovy.refactoring.introduce.variable.GrIntroduceVariableHandler;
import org.jetbrains.plugins.groovy.refactoring.ui.MethodOrClosureScopeChooser;

public class GrIntroduceParameterHandler
implements RefactoringActionHandler,
MethodOrClosureScopeChooser.JBPopupOwner {
    static final String REFACTORING_NAME = RefactoringBundle.message((String)"introduce.parameter.title");
    private JBPopup myEnclosingMethodsPopup;

    public void invoke(final @NotNull Project project, final Editor editor, final PsiFile file, @Nullable DataContext dataContext) {
        if (project == null) {
            GrIntroduceParameterHandler.$$$reportNull$$$0(0);
        }
        if (editor == null || file == null) {
            return;
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        if (!selectionModel.hasSelection()) {
            int offset = editor.getCaretModel().getOffset();
            List<GrExpression> expressions = GrIntroduceHandlerBase.collectExpressions(file, editor, offset, false);
            if (expressions.isEmpty()) {
                GrIntroduceHandlerBase.updateSelectionForVariable(editor, file, selectionModel, offset);
            } else if (expressions.size() == 1 || ApplicationManager.getApplication().isUnitTestMode()) {
                TextRange textRange = expressions.get(0).getTextRange();
                selectionModel.setSelection(textRange.getStartOffset(), textRange.getEndOffset());
            } else {
                IntroduceTargetChooser.showChooser((Editor)editor, expressions, (Pass)new Pass<GrExpression>(){

                    public void pass(GrExpression selectedValue) {
                        GrIntroduceParameterHandler.this.invoke(project, editor, file, selectedValue.getTextRange().getStartOffset(), selectedValue.getTextRange().getEndOffset());
                    }
                }, grExpression -> grExpression.getText());
                return;
            }
        }
        this.invoke(project, editor, file, selectionModel.getSelectionStart(), selectionModel.getSelectionEnd());
    }

    private void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, int startOffset, int endOffset) {
        if (project == null) {
            GrIntroduceParameterHandler.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            GrIntroduceParameterHandler.$$$reportNull$$$0(2);
        }
        if (file == null) {
            GrIntroduceParameterHandler.$$$reportNull$$$0(3);
        }
        try {
            InitialInfo initialInfo = GroovyExtractChooser.invoke(project, editor, file, startOffset, endOffset, false);
            this.chooseScopeAndRun(initialInfo, editor);
        }
        catch (GrRefactoringError e) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw e;
            }
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)e.getMessage(), (String)RefactoringBundle.message((String)"introduce.parameter.title"), (String)"refactoring.introduceParameter.groovy");
        }
    }

    private void chooseScopeAndRun(@NotNull InitialInfo initialInfo, @NotNull Editor editor) {
        List<GrParameterListOwner> scopes;
        if (initialInfo == null) {
            GrIntroduceParameterHandler.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            GrIntroduceParameterHandler.$$$reportNull$$$0(5);
        }
        if ((scopes = GrIntroduceParameterHandler.findScopes(initialInfo)).isEmpty()) {
            throw new GrRefactoringError(GroovyRefactoringBundle.message("there.is.no.method.or.closure", new Object[0]));
        }
        if (scopes.size() == 1 || ApplicationManager.getApplication().isUnitTestMode()) {
            GrVariable toSearchFor;
            GrParameterListOwner owner2 = scopes.get(0);
            if (owner2 instanceof GrMethod) {
                toSearchFor = SuperMethodWarningUtil.checkSuperMethod((PsiMethod)((PsiMethod)owner2), (String)RefactoringBundle.message((String)"to.refactor"));
                if (toSearchFor == null) {
                    return;
                }
            } else {
                toSearchFor = MethodOrClosureScopeChooser.findVariableToUse(owner2);
            }
            this.showDialogOrStartInplace(new IntroduceParameterInfoImpl(initialInfo, owner2, toSearchFor), editor);
        } else {
            this.myEnclosingMethodsPopup = MethodOrClosureScopeChooser.create(scopes, editor, this, (PairFunction<? super GrParameterListOwner, ? super PsiElement, Object>)((PairFunction)(owner, element) -> {
                this.showDialogOrStartInplace(new IntroduceParameterInfoImpl(initialInfo, (GrParameterListOwner)owner, (PsiElement)element), editor);
                return null;
            }));
            this.myEnclosingMethodsPopup.showInBestPositionFor(editor);
        }
    }

    @NotNull
    private static List<GrParameterListOwner> findScopes(@NotNull InitialInfo initialInfo) {
        GrParameterListOwner parent2;
        if (initialInfo == null) {
            GrIntroduceParameterHandler.$$$reportNull$$$0(6);
        }
        PsiElement place = initialInfo.getContext();
        ArrayList<GrParameterListOwner> scopes = new ArrayList<GrParameterListOwner>();
        while ((parent2 = (GrParameterListOwner)PsiTreeUtil.getParentOfType((PsiElement)place, GrParameterListOwner.class)) != null) {
            scopes.add(parent2);
            place = parent2;
        }
        ArrayList<GrParameterListOwner> arrayList = scopes;
        if (arrayList == null) {
            GrIntroduceParameterHandler.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Override
    public JBPopup get() {
        return this.myEnclosingMethodsPopup;
    }

    protected void showDialogOrStartInplace(final @NotNull IntroduceParameterInfo info, @NotNull Editor editor) {
        if (info == null) {
            GrIntroduceParameterHandler.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            GrIntroduceParameterHandler.$$$reportNull$$$0(9);
        }
        if (GrIntroduceParameterHandler.isInplace(info, editor)) {
            final GrIntroduceContext context = GrIntroduceParameterHandler.createContext(info, editor);
            Map<OccurrencesChooser.ReplaceChoice, List<Object>> occurrencesMap = GrIntroduceHandlerBase.fillChoice(context);
            new IntroduceOccurrencesChooser(editor).showChooser((Pass)new Pass<OccurrencesChooser.ReplaceChoice>(){

                public void pass(OccurrencesChooser.ReplaceChoice choice) {
                    GrIntroduceParameterHandler.startInplace(info, context, choice);
                }
            }, occurrencesMap);
        } else {
            this.showDialog(info);
        }
    }

    protected void showDialog(IntroduceParameterInfo info) {
        new GrIntroduceParameterDialog(info).show();
    }

    private static void startInplace(@NotNull IntroduceParameterInfo info, @NotNull GrIntroduceContext context, OccurrencesChooser.ReplaceChoice replaceChoice) {
        if (info == null) {
            GrIntroduceParameterHandler.$$$reportNull$$$0(10);
        }
        if (context == null) {
            GrIntroduceParameterHandler.$$$reportNull$$$0(11);
        }
        new GrInplaceParameterIntroducer(info, context, replaceChoice).startInplaceIntroduceTemplate();
    }

    private static boolean isInplace(@NotNull IntroduceParameterInfo info, @NotNull Editor editor) {
        if (info == null) {
            GrIntroduceParameterHandler.$$$reportNull$$$0(12);
        }
        if (editor == null) {
            GrIntroduceParameterHandler.$$$reportNull$$$0(13);
        }
        return GroovyIntroduceParameterUtil.findExpr(info) != null && info.getToReplaceIn() instanceof GrMethod && info.getToSearchFor() instanceof PsiMethod && GrIntroduceHandlerBase.isInplace(editor, info.getContext());
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            GrIntroduceParameterHandler.$$$reportNull$$$0(14);
        }
        if (elements == null) {
            GrIntroduceParameterHandler.$$$reportNull$$$0(15);
        }
    }

    private static GrIntroduceContext createContext(@NotNull IntroduceParameterInfo info, @NotNull Editor editor) {
        if (info == null) {
            GrIntroduceParameterHandler.$$$reportNull$$$0(16);
        }
        if (editor == null) {
            GrIntroduceParameterHandler.$$$reportNull$$$0(17);
        }
        GrExpression expr = GroovyIntroduceParameterUtil.findExpr(info);
        GrVariable var = GroovyIntroduceParameterUtil.findVar(info);
        StringPartInfo stringPart = info.getStringPartInfo();
        return new GrIntroduceVariableHandler().getContext(info.getProject(), editor, expr, var, stringPart, info.getToReplaceIn());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialInfo";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/refactoring/introduce/parameter/GrIntroduceParameterHandler";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/introduce/parameter/GrIntroduceParameterHandler";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findScopes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "chooseScopeAndRun";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findScopes";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "showDialogOrStartInplace";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "startInplace";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isInplace";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

