/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.convertToJava;

import com.intellij.codeInsight.generation.OverrideImplementExploreUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrEnumConstantInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrReflectedMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyConstantExpressionEvaluator;
import org.jetbrains.plugins.groovy.lang.resolve.ast.DelegatedMethod;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ClassItemGenerator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ClassNameProvider;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.GenerationUtil;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.GroovyToJavaGenerator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ModifierListGenerator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.TypeWriter;

public class StubGenerator
implements ClassItemGenerator {
    public static final String[] STUB_MODIFIERS = new String[]{"public", "protected", "private", "packageLocal", "static", "abstract", "final", "native"};
    private static final String[] STUB_FIELD_MODIFIERS = new String[]{"public", "protected", "private", "packageLocal", "static", "final"};
    private final ClassNameProvider classNameProvider;
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.refactoring.convertToJava.StubGenerator");

    public StubGenerator(ClassNameProvider classNameProvider) {
        this.classNameProvider = classNameProvider;
    }

    @Override
    public void writeEnumConstant(StringBuilder text, GrEnumConstant enumConstant) {
        GrEnumConstantInitializer initializer;
        text.append(enumConstant.getName());
        PsiMethod constructor = enumConstant.resolveMethod();
        if (constructor != null) {
            text.append('(');
            this.writeStubConstructorInvocation(text, constructor, PsiSubstitutor.EMPTY, enumConstant);
            text.append(')');
        }
        if ((initializer = enumConstant.getInitializingClass()) != null) {
            text.append("{\n");
            for (PsiMethod method : initializer.getMethods()) {
                this.writeMethod(text, method);
            }
            text.append('}');
        }
    }

    private void writeStubConstructorInvocation(StringBuilder text, PsiMethod constructor, PsiSubstitutor substitutor, PsiElement invocation) {
        PsiParameter[] superParams = constructor.getParameterList().getParameters();
        for (int j = 0; j < superParams.length; ++j) {
            if (j > 0) {
                text.append(", ");
            }
            text.append('(');
            PsiType type2 = superParams[j].getType();
            TypeWriter.writeType(text, substitutor.substitute(type2), invocation, this.classNameProvider);
            text.append(')').append(GroovyToJavaGenerator.getDefaultValueText(type2.getCanonicalText()));
        }
    }

    @Override
    public void writeConstructor(StringBuilder text, PsiMethod constructor, boolean isEnum) {
        LOG.assertTrue(constructor.isConstructor());
        if (!isEnum) {
            text.append("public ");
        }
        text.append(constructor.getName());
        GenerationUtil.writeParameterList(text, constructor.getParameterList().getParameters(), this.classNameProvider, null);
        Set<String> throwsTypes = this.collectThrowsTypes(constructor, (Set<PsiMethod>)new THashSet());
        if (!throwsTypes.isEmpty()) {
            text.append("throws ").append(StringUtil.join(throwsTypes, (String)", ")).append(' ');
        }
        text.append("{\n");
        if (constructor instanceof GrReflectedMethod) {
            constructor = ((GrReflectedMethod)constructor).getBaseMethod();
        }
        if (constructor instanceof GrMethod) {
            GrConstructorInvocation invocation = PsiImplUtil.getChainingConstructorInvocation((GrMethod)constructor);
            if (invocation != null) {
                GroovyResolveResult resolveResult2 = StubGenerator.resolveChainingConstructor((GrMethod)constructor);
                if (resolveResult2 != null) {
                    text.append(invocation.isSuperCall() ? "super(" : "this(");
                    this.writeStubConstructorInvocation(text, (PsiMethod)resolveResult2.getElement(), resolveResult2.getSubstitutor(), invocation);
                    text.append(");");
                }
            } else if (constructor instanceof LightElement) {
                this.writeStubConstructorInvocation(constructor, text);
            }
        }
        text.append("\n}\n");
    }

    private void writeStubConstructorInvocation(PsiMethod constructor, StringBuilder text) {
        PsiClass containingClass = constructor.getContainingClass();
        if (containingClass == null) {
            return;
        }
        PsiClass superClass = containingClass.getSuperClass();
        if (superClass == null) {
            return;
        }
        PsiMethod[] constructors = superClass.getConstructors();
        if (constructors.length == 0) {
            return;
        }
        for (PsiMethod method : constructors) {
            if (!method.getParameterList().isEmpty() || !PsiUtil.isAccessible((PsiMember)method, (PsiElement)containingClass, (PsiClass)containingClass)) continue;
            return;
        }
        for (PsiMethod method : constructors) {
            if (!PsiUtil.isAccessible((PsiMember)method, (PsiElement)containingClass, (PsiClass)containingClass)) continue;
            text.append("super(");
            this.writeStubConstructorInvocation(text, method, TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)containingClass, (PsiSubstitutor)PsiSubstitutor.EMPTY), (PsiElement)constructor);
            text.append(");");
            return;
        }
    }

    private Set<String> collectThrowsTypes(PsiMethod constructor, Set<PsiMethod> visited) {
        GroovyResolveResult resolveResult2;
        LOG.assertTrue(constructor.isConstructor());
        GroovyResolveResult groovyResolveResult = resolveResult2 = constructor instanceof GrMethod ? StubGenerator.resolveChainingConstructor((GrMethod)constructor) : null;
        if (resolveResult2 == null) {
            return Collections.emptySet();
        }
        PsiSubstitutor substitutor = resolveResult2.getSubstitutor();
        PsiMethod chainedConstructor = (PsiMethod)resolveResult2.getElement();
        assert (chainedConstructor != null);
        if (!visited.add(chainedConstructor)) {
            return Collections.emptySet();
        }
        THashSet result2 = ContainerUtil.newTroveSet((Object[])ArrayUtilRt.EMPTY_STRING_ARRAY);
        for (PsiClassType type2 : chainedConstructor.getThrowsList().getReferencedTypes()) {
            StringBuilder builder = new StringBuilder();
            TypeWriter.writeType(builder, substitutor.substitute((PsiType)type2), (PsiElement)constructor, this.classNameProvider);
            result2.add(builder.toString());
        }
        if (chainedConstructor instanceof GrMethod) {
            LOG.assertTrue(chainedConstructor.isConstructor());
            result2.addAll(this.collectThrowsTypes(chainedConstructor, visited));
        }
        return result2;
    }

    @Override
    public void writeMethod(StringBuilder text, PsiMethod method) {
        PsiType retType;
        if (method == null) {
            return;
        }
        String name = method.getName();
        if (!PsiNameHelper.getInstance((Project)method.getProject()).isIdentifier(name)) {
            return;
        }
        boolean isAbstract = method.hasModifierProperty("abstract");
        PsiModifierList modifierList = method.getModifierList();
        ModifierListGenerator.writeModifiers(text, modifierList, STUB_MODIFIERS, false);
        if (method.hasTypeParameters()) {
            GenerationUtil.writeTypeParameters(text, (PsiTypeParameterListOwner)method, this.classNameProvider);
            text.append(' ');
        }
        if ((retType = method.getReturnType()) == null) {
            retType = TypesUtil.getJavaLangObject((PsiElement)method);
        }
        if (!method.hasModifierProperty("static")) {
            List superSignatures = method.findSuperMethodSignaturesIncludingStatic(true);
            for (MethodSignatureBackedByPsiMethod superSignature : superSignatures) {
                PsiType superType = superSignature.getSubstitutor().substitute(superSignature.getMethod().getReturnType());
                if (superType == null || superType.isAssignableFrom(retType) || PsiUtil.resolveClassInType((PsiType)superType) instanceof PsiTypeParameter) continue;
                retType = superType;
            }
        }
        TypeWriter.writeType(text, retType, (PsiElement)method, this.classNameProvider);
        text.append(' ');
        text.append(name);
        GenerationUtil.writeParameterList(text, method.getParameterList().getParameters(), this.classNameProvider, null);
        this.writeThrowsList(text, method);
        if (!isAbstract && !method.hasModifierProperty("native")) {
            text.append("{\nreturn ");
            text.append(GroovyToJavaGenerator.getDefaultValueText(retType.getCanonicalText()));
            text.append(";\n}");
        } else {
            text.append(';');
        }
        text.append('\n');
    }

    private void writeThrowsList(StringBuilder text, PsiMethod method) {
        PsiReferenceList throwsList = method.getThrowsList();
        PsiClassType[] exceptions = throwsList.getReferencedTypes();
        GenerationUtil.writeThrowsList(text, throwsList, exceptions, this.classNameProvider);
    }

    @Nullable
    private static GroovyResolveResult resolveChainingConstructor(GrMethod constructor) {
        LOG.assertTrue(constructor.isConstructor());
        GrConstructorInvocation constructorInvocation = PsiImplUtil.getChainingConstructorInvocation(constructor);
        if (constructorInvocation == null) {
            return null;
        }
        GroovyResolveResult resolveResult2 = constructorInvocation.advancedResolve();
        if (resolveResult2.getElement() != null) {
            return resolveResult2;
        }
        GroovyResolveResult[] results = constructorInvocation.multiResolve(false);
        if (results.length > 0) {
            int i = 0;
            while (results.length > i + 1) {
                PsiMethod candidate = (PsiMethod)results[i].getElement();
                PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)constructor.getProject()).getResolveHelper();
                if (candidate != null && candidate != constructor && resolveHelper.isAccessible((PsiMember)candidate, (PsiElement)constructorInvocation, null)) break;
                ++i;
            }
            return results[i];
        }
        return null;
    }

    @Override
    public Collection<PsiMethod> collectMethods(PsiClass typeDefinition) {
        boolean isClass;
        ArrayList<PsiMethod> methods = new ArrayList<PsiMethod>();
        for (PsiMethod method : typeDefinition.getMethods()) {
            if (method instanceof DelegatedMethod) {
                PsiMethod prototype = ((DelegatedMethod)method).getPrototype();
                PsiClass aClass = prototype.getContainingClass();
                if (prototype.hasModifierProperty("final") && aClass != null && typeDefinition.isInheritor(aClass, true)) continue;
            }
            methods.add(method);
        }
        boolean bl = isClass = !typeDefinition.isInterface() && !typeDefinition.isAnnotationType() && !typeDefinition.isEnum() && !(typeDefinition instanceof GroovyScriptClass);
        if (isClass) {
            Collection toOverride = OverrideImplementExploreUtil.getMethodSignaturesToOverride((PsiClass)typeDefinition);
            for (MethodSignature signature : toOverride) {
                String qname;
                PsiMethod method;
                PsiClass baseClass;
                if (!(signature instanceof MethodSignatureBackedByPsiMethod) || (baseClass = (method = ((MethodSignatureBackedByPsiMethod)signature).getMethod()).getContainingClass()) == null || !"groovy.lang.GroovyObject".equals(qname = baseClass.getQualifiedName()) && !"groovy.lang.GroovyObjectSupport".equals(qname) && (!method.hasModifierProperty("abstract") || !typeDefinition.isInheritor(baseClass, true)) || method.isConstructor()) continue;
                methods.add((PsiMethod)StubGenerator.mirrorMethod(typeDefinition, method, baseClass, signature.getSubstitutor()));
            }
            Collection toImplement = OverrideImplementExploreUtil.getMethodSignaturesToImplement((PsiClass)typeDefinition);
            for (MethodSignature signature : toImplement) {
                PsiMethod resolved;
                PsiClass baseClass;
                if (!(signature instanceof MethodSignatureBackedByPsiMethod) || (baseClass = (resolved = ((MethodSignatureBackedByPsiMethod)signature).getMethod()).getContainingClass()) == null || !"groovy.lang.GroovyObject".equals(baseClass.getQualifiedName())) continue;
                methods.add((PsiMethod)StubGenerator.mirrorMethod(typeDefinition, resolved, baseClass, signature.getSubstitutor()));
            }
        }
        return methods;
    }

    @Override
    public boolean generateAnnotations() {
        return false;
    }

    @Override
    public void writePostponed(StringBuilder text, PsiClass psiClass) {
    }

    private static LightMethodBuilder mirrorMethod(PsiClass typeDefinition, PsiMethod method, PsiClass baseClass, PsiSubstitutor substitutor) {
        LightMethodBuilder builder = new LightMethodBuilder(method.getManager(), method.getName());
        substitutor = substitutor.putAll(TypeConversionUtil.getSuperClassSubstitutor((PsiClass)baseClass, (PsiClass)typeDefinition, (PsiSubstitutor)PsiSubstitutor.EMPTY));
        for (PsiParameter psiParameter : method.getParameterList().getParameters()) {
            builder.addParameter(StringUtil.notNullize((String)psiParameter.getName()), substitutor.substitute(psiParameter.getType()));
        }
        builder.setMethodReturnType(substitutor.substitute(method.getReturnType()));
        for (String string : STUB_MODIFIERS) {
            if (!method.hasModifierProperty(string)) continue;
            builder.addModifier(string);
        }
        return builder;
    }

    @Override
    public void writeVariableDeclarations(StringBuilder text, GrVariableDeclaration variableDeclaration) {
        GrTypeElement typeElement = variableDeclaration.getTypeElementGroovy();
        GrModifierList modifierList = variableDeclaration.getModifierList();
        PsiNameHelper nameHelper = PsiNameHelper.getInstance((Project)variableDeclaration.getProject());
        for (GrVariable variable : variableDeclaration.getVariables()) {
            String name = variable.getName();
            if (!nameHelper.isIdentifier(name)) continue;
            ModifierListGenerator.writeModifiers(text, modifierList, STUB_FIELD_MODIFIERS, false);
            PsiType declaredType = typeElement == null ? PsiType.getJavaLangObject((PsiManager)variable.getManager(), (GlobalSearchScope)variable.getResolveScope()) : typeElement.getType();
            TypeWriter.writeType(text, declaredType, variableDeclaration, this.classNameProvider);
            text.append(' ').append(name).append(" = ").append(StubGenerator.getVariableInitializer(variable, declaredType));
            text.append(";\n");
        }
    }

    private static String getVariableInitializer(GrVariable variable, PsiType declaredType) {
        if (declaredType instanceof PsiPrimitiveType) {
            Object eval = GroovyConstantExpressionEvaluator.evaluate(variable.getInitializerGroovy());
            if (eval instanceof Float || PsiType.FLOAT.equals((Object)TypesUtil.unboxPrimitiveTypeWrapper(variable.getType())) && eval instanceof Number) {
                return eval.toString() + "f";
            }
            if (eval instanceof Character) {
                StringBuilder buffer = new StringBuilder();
                buffer.append('\'');
                StringUtil.escapeStringCharacters((int)1, (String)Character.toString(((Character)eval).charValue()), (StringBuilder)buffer);
                buffer.append('\'');
                return buffer.toString();
            }
            if (eval instanceof Number || eval instanceof Boolean) {
                return eval.toString();
            }
        }
        return GroovyToJavaGenerator.getDefaultValueText(declaredType.getCanonicalText());
    }

    @Override
    public void writeImplementsList(StringBuilder text, PsiClass typeDefinition) {
        LinkedHashSet implementsTypes = new LinkedHashSet();
        Collections.addAll(implementsTypes, typeDefinition.getImplementsListTypes());
        if (implementsTypes.isEmpty()) {
            return;
        }
        text.append(typeDefinition.isInterface() ? "extends " : "implements ");
        for (PsiClassType implementsType : implementsTypes) {
            TypeWriter.writeType(text, (PsiType)implementsType, (PsiElement)typeDefinition, this.classNameProvider);
            text.append(", ");
        }
        if (!implementsTypes.isEmpty()) {
            text.delete(text.length() - 2, text.length());
        }
        text.append(' ');
    }

    @Override
    public void writeExtendsList(StringBuilder text, PsiClass typeDefinition) {
        PsiClassType[] extendsClassesTypes = typeDefinition.getExtendsListTypes();
        if (extendsClassesTypes.length > 0) {
            text.append("extends ");
            TypeWriter.writeType(text, (PsiType)extendsClassesTypes[0], (PsiElement)typeDefinition, this.classNameProvider);
            text.append(' ');
        }
    }
}

