/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc;

import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;

public class MvcPathMacros {
    public MvcPathMacros() {
        Set macroNames = PathMacros.getInstance().getUserMacroNames();
        for (String framework : (String[])ContainerUtil.ar((Object[])new String[]{"grails", "griffon"})) {
            String name = "USER_HOME_" + StringUtil.toUpperCase((String)framework);
            if (macroNames.contains(name)) continue;
            PathMacros.getInstance().addLegacyMacro(name, StringUtil.trimEnd((String)MvcPathMacros.getSdkWorkDirParent(framework), (String)"/"));
        }
    }

    public static String getSdkWorkDirParent(String framework) {
        String grailsWorkDir = System.getProperty(framework + ".work.dir");
        if (StringUtil.isNotEmpty((String)grailsWorkDir)) {
            if (!(grailsWorkDir = FileUtil.toSystemIndependentName((String)grailsWorkDir)).endsWith("/")) {
                grailsWorkDir = grailsWorkDir + "/";
            }
            return grailsWorkDir;
        }
        return StringUtil.trimEnd((String)FileUtil.toSystemIndependentName((String)SystemProperties.getUserHome()), (String)"/") + "/." + framework + "/";
    }
}

