/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.typing;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.CollectionUtil;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.typing.GrCallTypeCalculator;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0018\u00010\tj\u0004\u0018\u0001`\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/groovy/lang/typing/DgmCallTypeCalculator;", "Lorg/jetbrains/plugins/groovy/lang/typing/GrCallTypeCalculator;", "()V", "getType", "Lcom/intellij/psi/PsiType;", "receiver", "method", "Lcom/intellij/psi/PsiMethod;", "arguments", "", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Argument;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Arguments;", "context", "Lcom/intellij/psi/PsiElement;", "Companion", "intellij.groovy.psi"})
public final class DgmCallTypeCalculator
implements GrCallTypeCalculator {
    private static final Set<String> interestingNames;
    public static final Companion Companion;

    @Override
    @Nullable
    public PsiType getType(@Nullable PsiType receiver, @NotNull PsiMethod method, @Nullable List<? extends Argument> arguments2, @NotNull PsiElement context) {
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (arguments2 == null || arguments2.isEmpty()) {
            return null;
        }
        PsiClass psiClass = method.getContainingClass();
        if (Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getQualifiedName() : null), (Object)"org.codehaus.groovy.runtime.DefaultGroovyMethods") ^ true) {
            return null;
        }
        String string = method.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"method.name");
        String methodName = string;
        if (Intrinsics.areEqual((Object)methodName, (Object)"find")) {
            PsiType psiType = ((Argument)CollectionsKt.first(arguments2)).getType();
            if (!(psiType instanceof PsiArrayType)) {
                psiType = null;
            }
            PsiArrayType psiArrayType = (PsiArrayType)psiType;
            return psiArrayType != null ? psiArrayType.getComponentType() : null;
        }
        if (!interestingNames.contains(methodName) || !DgmCallTypeCalculator.Companion.isSimilarCollectionReturner(method)) {
            return null;
        }
        PsiType receiverType = ((Argument)CollectionsKt.first(arguments2)).getType();
        PsiType itemType = DgmCallTypeCalculator.Companion.getItemType(receiverType);
        if (Intrinsics.areEqual((Object)"flatten", (Object)methodName) && itemType != null) {
            while (true) {
                if (DgmCallTypeCalculator.Companion.getItemType(itemType) != null) continue;
                break;
            }
        }
        return (PsiType)CollectionUtil.createSimilarCollection(receiverType, context.getProject(), itemType);
    }

    static {
        Companion = new Companion(null);
        interestingNames = SetsKt.setOf((Object[])new String[]{"unique", "findAll", "grep", "collectMany", "split", "plus", "intersect", "leftShift"});
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/groovy/lang/typing/DgmCallTypeCalculator$Companion;", "", "()V", "interestingNames", "", "", "getItemType", "Lcom/intellij/psi/PsiType;", "type", "isSimilarCollectionReturner", "", "method", "Lcom/intellij/psi/PsiMethod;", "intellij.groovy.psi"})
    public static final class Companion {
        private final boolean isSimilarCollectionReturner(PsiMethod method) {
            PsiParameterList psiParameterList = method.getParameterList();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"method.parameterList");
            Object[] objectArray = psiParameterList.getParameters();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"method.parameterList.parameters");
            PsiParameter psiParameter = (PsiParameter)ArraysKt.firstOrNull((Object[])objectArray);
            if (psiParameter == null) {
                return false;
            }
            PsiParameter receiverParameter = psiParameter;
            PsiType psiType = receiverParameter.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiType, (String)"receiverParameter.type");
            PsiType receiverParameterType = psiType;
            if (!(receiverParameterType instanceof PsiArrayType) && !InheritanceUtil.isInheritor((PsiType)receiverParameterType, (String)"java.util.Collection")) {
                return false;
            }
            PsiType psiType2 = method.getReturnType();
            if (!(psiType2 instanceof PsiClassType)) {
                psiType2 = null;
            }
            PsiClassType psiClassType = (PsiClassType)psiType2;
            if (psiClassType == null) {
                return false;
            }
            PsiClassType returnType2 = psiClassType;
            PsiClass psiClass = returnType2.resolve();
            return Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getQualifiedName() : null), (Object)"java.util.Collection");
        }

        private final PsiType getItemType(PsiType type2) {
            PsiArrayType psiArrayType;
            PsiType psiType = type2;
            if (!(psiType instanceof PsiArrayType)) {
                psiType = null;
            }
            if ((psiArrayType = (PsiArrayType)psiType) == null || (psiArrayType = psiArrayType.getComponentType()) == null) {
                psiArrayType = PsiUtil.extractIterableTypeParameter((PsiType)type2, (boolean)true);
            }
            return psiArrayType;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

