/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors.inference;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.GrFunctionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyReference;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrClassInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrThrowStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrOperatorExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSafeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTuple;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTupleAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClassTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.MethodResolveResult;
import org.jetbrains.plugins.groovy.lang.resolve.api.ExpressionArgument;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.ExpressionConstraint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.GrConstraintFormula;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.GroovyInferenceSession;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.GroovyInferenceSessionBuilderKt;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.OperatorExpressionConstraint;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0012\u0010\t\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\bH\u0002\u001a\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u001a\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0002\u001a\u000e\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0002\u001a\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\"\u001e\u0010\u0000\u001a\u0012\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000*$\b\u0000\u0010\u0015\"\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001\u00a8\u0006\u0016"}, d2={"ignoreFunctionalExpressions", "Lkotlin/Function1;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/inference/ExpressionPredicate;", "buildTopLevelSession", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/inference/GroovyInferenceSession;", "place", "Lcom/intellij/psi/PsiElement;", "canBeExitPoint", "element", "collectExitPoints", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrStatement;", "findExpression", "getExpectedType", "Lcom/intellij/psi/PsiType;", "expression", "getMostTopLevelExpression", "start", "isExitPoint", "ExpressionPredicate", "intellij.groovy.psi"})
public final class GroovyInferenceSessionBuilderKt {
    private static final Function1<GrExpression, Boolean> ignoreFunctionalExpressions = ignoreFunctionalExpressions.1.INSTANCE;

    @NotNull
    public static final GroovyInferenceSession buildTopLevelSession(@NotNull PsiElement place) {
        GrConstraintFormula grConstraintFormula;
        Intrinsics.checkParameterIsNotNull((Object)place, (String)"place");
        Intrinsics.checkExpressionValueIsNotNull((Object)PsiTypeParameter.EMPTY_ARRAY, (String)"PsiTypeParameter.EMPTY_ARRAY");
        PsiSubstitutor psiSubstitutor = PsiSubstitutor.EMPTY;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiSubstitutor, (String)"PsiSubstitutor.EMPTY");
        GroovyInferenceSession session = new GroovyInferenceSession(PsiTypeParameter.EMPTY_ARRAY, psiSubstitutor, place, false, null, 16, null);
        GrExpression grExpression = GroovyInferenceSessionBuilderKt.findExpression(place);
        if (grExpression == null) {
            return session;
        }
        GrExpression expression = grExpression;
        if (expression instanceof GrBinaryExpression || expression instanceof GrAssignmentExpression && ((GrAssignmentExpression)expression).isOperatorAssignment()) {
            grConstraintFormula = new OperatorExpressionConstraint((GrOperatorExpression)expression);
        } else {
            GrExpression mostTopLevelExpression = GroovyInferenceSessionBuilderKt.getMostTopLevelExpression(expression);
            PsiType left = GroovyInferenceSessionBuilderKt.getExpectedType(mostTopLevelExpression);
            grConstraintFormula = new ExpressionConstraint(left, mostTopLevelExpression);
        }
        GrConstraintFormula startConstraint = grConstraintFormula;
        session.addConstraint(startConstraint);
        return session;
    }

    private static final GrExpression findExpression(PsiElement place) {
        GrExpression grExpression;
        PsiElement parent2 = place.getParent();
        if (parent2 instanceof GrAssignmentExpression && ((GrAssignmentExpression)parent2).getLValue() == place) {
            grExpression = (GrExpression)parent2;
        } else if (parent2 instanceof GrMethodCall) {
            grExpression = (GrExpression)parent2;
        } else if (parent2 instanceof GrNewExpression) {
            grExpression = (GrExpression)parent2;
        } else if (parent2 instanceof GrClassTypeElement) {
            PsiElement psiElement = ((GrClassTypeElement)parent2).getParent();
            if (!(psiElement instanceof GrSafeCastExpression)) {
                psiElement = null;
            }
            grExpression = (GrSafeCastExpression)psiElement;
        } else {
            grExpression = place instanceof GrExpression ? (GrExpression)place : null;
        }
        return grExpression;
    }

    @NotNull
    public static final GrExpression getMostTopLevelExpression(@NotNull GrExpression start) {
        Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
        GrExpression current = start;
        while (true) {
            PsiElement grandParent;
            PsiElement parent2;
            if ((parent2 = current.getParent()) instanceof GrArgumentList) {
                grandParent = ((GrArgumentList)parent2).getParent();
                if (!(grandParent instanceof GrCallExpression) || !(((GrCallExpression)grandParent).advancedResolve() instanceof MethodResolveResult)) {
                    return current;
                }
            } else {
                return current;
            }
            current = (GrCallExpression)grandParent;
        }
    }

    @Nullable
    public static final PsiType getExpectedType(@NotNull GrExpression expression) {
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        PsiElement parent2 = expression.getParent();
        GrMethod parentMethod = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)parent2, GrMethod.class, (boolean)false, (Class[])new Class[]{GrFunctionalExpression.class});
        if (parent2 instanceof GrReturnStatement && parentMethod != null) {
            return parentMethod.getReturnType();
        }
        if (GroovyInferenceSessionBuilderKt.isExitPoint(expression) && parentMethod != null) {
            PsiType returnType2 = parentMethod.getReturnType();
            if (TypeConversionUtil.isVoidType((PsiType)returnType2)) {
                return null;
            }
            return returnType2;
        }
        if (parent2 instanceof GrAssignmentExpression && Intrinsics.areEqual((Object)expression, (Object)((GrAssignmentExpression)parent2).getRValue())) {
            PsiElement lValue = PsiUtil.skipParentheses(((GrAssignmentExpression)parent2).getLValue(), false);
            return lValue instanceof GrExpression && !(lValue instanceof GrIndexProperty) ? ((GrExpression)lValue).getNominalType() : null;
        }
        if (parent2 instanceof GrVariable) {
            return ((GrVariable)parent2).getDeclaredType();
        }
        if (parent2 instanceof GrListOrMap) {
            PsiElement pParent = ((GrListOrMap)parent2).getParent();
            if (pParent instanceof GrVariableDeclaration && ((GrVariableDeclaration)pParent).isTuple()) {
                Object[] objectArray = ((GrListOrMap)parent2).getInitializers();
                Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"parent.initializers");
                int index = ArraysKt.indexOf((Object[])objectArray, (Object)expression);
                Object[] objectArray2 = ((GrVariableDeclaration)pParent).getVariables();
                Intrinsics.checkExpressionValueIsNotNull((Object)objectArray2, (String)"pParent.variables");
                GrVariable grVariable = (GrVariable)ArraysKt.getOrNull((Object[])objectArray2, (int)index);
                return grVariable != null ? grVariable.getDeclaredType() : null;
            }
            if (pParent instanceof GrTupleAssignmentExpression) {
                PsiElement psiElement;
                Object[] objectArray = ((GrListOrMap)parent2).getInitializers();
                Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"parent.initializers");
                int index = ArraysKt.indexOf((Object[])objectArray, (Object)expression);
                GrTuple grTuple = ((GrTupleAssignmentExpression)pParent).getLValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)grTuple, (String)"pParent.lValue");
                Object[] objectArray3 = grTuple.getExpressions();
                Intrinsics.checkExpressionValueIsNotNull((Object)objectArray3, (String)"pParent.lValue.expressions");
                Object[] expressions = objectArray3;
                GrReferenceExpression lValue = (GrReferenceExpression)ArraysKt.getOrNull((Object[])expressions, (int)index);
                GroovyReference groovyReference = lValue;
                if (!((groovyReference != null && (groovyReference = groovyReference.getStaticReference()) != null ? groovyReference.resolve() : (psiElement = null)) instanceof GrVariable)) {
                    psiElement = null;
                }
                GrVariable grVariable = (GrVariable)psiElement;
                return grVariable != null ? grVariable.getDeclaredType() : null;
            }
        } else if (parent2 instanceof GrArgumentList) {
            PsiElement psiElement = ((GrArgumentList)parent2).getParent();
            if (!(psiElement instanceof GrCallExpression)) {
                psiElement = null;
            }
            GrCallExpression grCallExpression = (GrCallExpression)psiElement;
            if (grCallExpression == null) {
                return null;
            }
            GrCallExpression call = grCallExpression;
            GroovyResolveResult groovyResolveResult = call.advancedResolve();
            if (!(groovyResolveResult instanceof GroovyMethodResult)) {
                groovyResolveResult = null;
            }
            GroovyMethodResult groovyMethodResult = (GroovyMethodResult)groovyResolveResult;
            if (groovyMethodResult == null) {
                return null;
            }
            GroovyMethodResult result2 = groovyMethodResult;
            Object object = result2.getCandidate();
            if (object == null || (object = object.getArgumentMapping()) == null) {
                return null;
            }
            Object mapping2 = object;
            return result2.getSubstitutor().substitute(mapping2.expectedType(new ExpressionArgument(expression)));
        }
        return null;
    }

    private static final boolean isExitPoint(GrExpression place) {
        return GroovyInferenceSessionBuilderKt.collectExitPoints(place).contains(place);
    }

    private static final List<GrStatement> collectExitPoints(GrExpression place) {
        List<GrStatement> list;
        if (GroovyInferenceSessionBuilderKt.canBeExitPoint(place)) {
            GrControlFlowOwner flowOwner = ControlFlowUtils.findControlFlowOwner(place);
            List<GrStatement> list2 = ControlFlowUtils.collectReturns(flowOwner);
            list = list2;
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"ControlFlowUtils.collectReturns(flowOwner)");
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final boolean canBeExitPoint(PsiElement element) {
        for (PsiElement place = element; place != null; place = place.getParent()) {
            if (place instanceof GrMethod || place instanceof GrFunctionalExpression || place instanceof GrClassInitializer) {
                return true;
            }
            if (!(place instanceof GrThrowStatement) && !(place instanceof GrTypeDefinitionBody) && !(place instanceof GroovyFile)) continue;
            return false;
        }
        return false;
    }

    public static final /* synthetic */ Function1 access$getIgnoreFunctionalExpressions$p() {
        return ignoreFunctionalExpressions;
    }
}

