/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.impl;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.api.Applicability;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyOverloadResolver;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0002\u001a0\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u0005j\u0004\u0018\u0001`\u0010\u001a\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u001a\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005*\b\u0012\u0004\u0012\u00020\u00060\u0005\u001a&\u0010\u0013\u001a\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0004\u0012\u00020\u00150\u0014j\u0002`\u0016*\b\u0012\u0004\u0012\u00020\u00060\u0005\"\u001c\u0010\u0000\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000*.\u0010\u0017\"\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0004\u0012\u00020\u00150\u00142\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0004\u0012\u00020\u00150\u0014\u00a8\u0006\u0018"}, d2={"overloadResolverEp", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/GroovyOverloadResolver;", "kotlin.jvm.PlatformType", "chooseOverloads", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyMethodResult;", "candidates", "compare", "", "left", "right", "filterByArgumentsCount", "results", "arguments", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Argument;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Arguments;", "filterBySignature", "correctStaticScope", "findApplicable", "Lkotlin/Pair;", "", "Lorg/jetbrains/plugins/groovy/lang/resolve/impl/ApplicabilitiesResult;", "ApplicabilitiesResult", "intellij.groovy.psi"})
public final class OverloadsKt {
    private static final ExtensionPointName<GroovyOverloadResolver> overloadResolverEp;

    @NotNull
    public static final Pair<List<GroovyMethodResult>, Boolean> findApplicable(@NotNull List<? extends GroovyMethodResult> $this$findApplicable) {
        Intrinsics.checkParameterIsNotNull($this$findApplicable, (String)"$this$findApplicable");
        if ($this$findApplicable.isEmpty()) {
            return new Pair((Object)CollectionsKt.emptyList(), (Object)true);
        }
        SmartList results = new SmartList();
        boolean canSelectOverload = true;
        for (GroovyMethodResult groovyMethodResult : $this$findApplicable) {
            Applicability applicability;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)groovyMethodResult.getApplicability()), (String)"result.applicability");
            if (applicability == Applicability.inapplicable) continue;
            if (applicability == Applicability.canBeApplicable) {
                canSelectOverload = false;
            }
            Collection collection = (Collection)results;
            boolean bl = false;
            collection.add(groovyMethodResult);
        }
        return new Pair((Object)results, (Object)canSelectOverload);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<GroovyMethodResult> correctStaticScope(@NotNull List<? extends GroovyMethodResult> $this$correctStaticScope) {
        void var2_2;
        void $this$filterTo$iv;
        Intrinsics.checkParameterIsNotNull($this$correctStaticScope, (String)"$this$correctStaticScope");
        if ($this$correctStaticScope.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable iterable = $this$correctStaticScope;
        Collection destination$iv = (Collection)new SmartList();
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            GroovyMethodResult it = (GroovyMethodResult)element$iv;
            boolean bl = false;
            if (!it.isStaticsOK()) continue;
            destination$iv.add(element$iv);
        }
        return (List)var2_2;
    }

    @NotNull
    public static final List<GroovyMethodResult> chooseOverloads(@NotNull List<? extends GroovyMethodResult> candidates) {
        Intrinsics.checkParameterIsNotNull(candidates, (String)"candidates");
        if (candidates.size() <= 1) {
            return candidates;
        }
        SmartList results = new SmartList();
        GroovyMethodResult minResult = null;
        for (GroovyMethodResult candidate : candidates) {
            boolean bl;
            if (minResult == null) {
                minResult = candidate;
                Collection collection = (Collection)results;
                boolean bl2 = false;
                collection.add(candidate);
                continue;
            }
            int comparisonResult = OverloadsKt.compare(minResult, candidate);
            if (comparisonResult > 0) {
                minResult = candidate;
                results.clear();
                Collection collection = (Collection)results;
                bl = false;
                collection.add(candidate);
                continue;
            }
            if (comparisonResult != 0) continue;
            Collection collection = (Collection)results;
            bl = false;
            collection.add(candidate);
        }
        return (List)results;
    }

    private static final int compare(GroovyMethodResult left, GroovyMethodResult right) {
        for (GroovyOverloadResolver resolver : (GroovyOverloadResolver[])overloadResolverEp.getExtensions()) {
            int result2 = resolver.compare(left, right);
            if (result2 == 0) continue;
            return result2;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<GroovyMethodResult> filterByArgumentsCount(@NotNull List<? extends GroovyMethodResult> results, @Nullable List<? extends Argument> arguments2) {
        void $this$filterTo$iv;
        Intrinsics.checkParameterIsNotNull(results, (String)"results");
        List<? extends Argument> list = arguments2;
        if (list == null) {
            return results;
        }
        int argumentsCount = list.size();
        Iterable iterable = results;
        Collection destination$iv = (Collection)new SmartList();
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            GroovyMethodResult it = (GroovyMethodResult)element$iv;
            boolean bl = false;
            PsiMethod psiMethod = it.getElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod, (String)"it.element");
            PsiParameterList psiParameterList = psiMethod.getParameterList();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"it.element.parameterList");
            if (!(psiParameterList.getParametersCount() == argumentsCount)) continue;
            destination$iv.add(element$iv);
        }
        SmartList filtered = (SmartList)destination$iv;
        return filtered.isEmpty() ? results : (List)filtered;
    }

    @NotNull
    public static final List<GroovyMethodResult> filterBySignature(@NotNull List<? extends GroovyMethodResult> results) {
        Intrinsics.checkParameterIsNotNull(results, (String)"results");
        if (results.size() < 2) {
            return results;
        }
        Object[] objectArray = ResolveUtil.filterSameSignatureCandidates((Collection<? extends GroovyResolveResult>)results);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"filterSameSignatureCandidates(results)");
        List list = ArraysKt.toList((Object[])objectArray);
        if (list == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult>");
        }
        return list;
    }

    static {
        ExtensionPointName extensionPointName = ExtensionPointName.create((String)"org.intellij.groovy.overloadResolver");
        Intrinsics.checkExpressionValueIsNotNull((Object)extensionPointName, (String)"ExtensionPointName.creat\u2026groovy.overloadResolver\")");
        overloadResolverEp = extensionPointName;
    }
}

