/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.delegatesTo;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GrFunctionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.DelegatesToInfo;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.GrDelegatesToProvider;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0012\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000b\u001a\u00020\f\u001a\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\f\"\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"DELEGATES_TO_KEY", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/plugins/groovy/lang/resolve/delegatesTo/DelegatesToInfo;", "DELEGATES_TO_STRATEGY_KEY", "", "DELEGATES_TO_TYPE_KEY", "", "defaultDelegatesToInfo", "getDefaultDelegatesToInfo", "()Lorg/jetbrains/plugins/groovy/lang/resolve/delegatesTo/DelegatesToInfo;", "doGetDelegatesToInfo", "expression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GrFunctionalExpression;", "getContainingCall", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrCall;", "getDelegatesToInfo", "closure", "intellij.groovy.psi"})
public final class GrDelegatesToUtilKt {
    @JvmField
    @NotNull
    public static final Key<DelegatesToInfo> DELEGATES_TO_KEY;
    @JvmField
    @NotNull
    public static final Key<String> DELEGATES_TO_TYPE_KEY;
    @JvmField
    @NotNull
    public static final Key<Integer> DELEGATES_TO_STRATEGY_KEY;
    @NotNull
    private static final DelegatesToInfo defaultDelegatesToInfo;

    @NotNull
    public static final DelegatesToInfo getDefaultDelegatesToInfo() {
        return defaultDelegatesToInfo;
    }

    @Nullable
    public static final DelegatesToInfo getDelegatesToInfo(@NotNull GrFunctionalExpression closure) {
        Intrinsics.checkParameterIsNotNull((Object)closure, (String)"closure");
        return (DelegatesToInfo)CachedValuesManager.getCachedValue((PsiElement)closure, (CachedValueProvider)new CachedValueProvider<T>(closure){
            final /* synthetic */ GrFunctionalExpression $closure;

            @NotNull
            public final CachedValueProvider.Result<DelegatesToInfo> compute() {
                return CachedValueProvider.Result.create((Object)GrDelegatesToUtilKt.access$doGetDelegatesToInfo(this.$closure), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
            {
                this.$closure = grFunctionalExpression;
            }
        });
    }

    private static final DelegatesToInfo doGetDelegatesToInfo(GrFunctionalExpression expression) {
        ExtensionPointName<GrDelegatesToProvider> extensionPointName = GrDelegatesToProvider.EP_NAME;
        Intrinsics.checkExpressionValueIsNotNull(extensionPointName, (String)"GrDelegatesToProvider.EP_NAME");
        for (GrDelegatesToProvider ext : (GrDelegatesToProvider[])extensionPointName.getExtensions()) {
            DelegatesToInfo info = ext.getDelegatesToInfo(expression);
            if (info == null) continue;
            return info;
        }
        return null;
    }

    @Nullable
    public static final GrCall getContainingCall(@NotNull GrFunctionalExpression expression) {
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        PsiElement parent2 = expression.getParent();
        if (parent2 instanceof GrCall) {
            GrFunctionalExpression[] grFunctionalExpressionArray = ((GrCall)parent2).getClosureArguments();
            if (ArrayUtil.contains((Object)expression, (Object[])Arrays.copyOf(grFunctionalExpressionArray, grFunctionalExpressionArray.length))) {
                return (GrCall)parent2;
            }
        }
        if (parent2 instanceof GrArgumentList) {
            PsiElement grandParent = ((GrArgumentList)parent2).getParent();
            PsiElement psiElement = grandParent;
            if (!(psiElement instanceof GrCall)) {
                psiElement = null;
            }
            return (GrCall)psiElement;
        }
        return null;
    }

    static {
        Key key = Key.create((String)"groovy.closure.delegatesTo");
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"Key.create(\"groovy.closure.delegatesTo\")");
        DELEGATES_TO_KEY = key;
        Key key2 = Key.create((String)"groovy.closure.delegatesTo.type");
        Intrinsics.checkExpressionValueIsNotNull((Object)key2, (String)"Key.create<String>(\"groo\u2026losure.delegatesTo.type\")");
        DELEGATES_TO_TYPE_KEY = key2;
        Key key3 = Key.create((String)"groovy.closure.delegatesTo.strategy");
        Intrinsics.checkExpressionValueIsNotNull((Object)key3, (String)"Key.create<Int>(\"groovy.\u2026re.delegatesTo.strategy\")");
        DELEGATES_TO_STRATEGY_KEY = key3;
        defaultDelegatesToInfo = new DelegatesToInfo(null, 2);
    }

    public static final /* synthetic */ DelegatesToInfo access$doGetDelegatesToInfo(GrFunctionalExpression expression) {
        return GrDelegatesToUtilKt.doGetDelegatesToInfo(expression);
    }
}

