/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.delegatesTo;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GrFunctionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrAnnotationUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.ClosureAsAnonymousParameterEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.FromStringHintProcessor;
import org.jetbrains.plugins.groovy.lang.psi.util.GdkMethodUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.api.ArgumentMapping;
import org.jetbrains.plugins.groovy.lang.resolve.api.ExpressionArgument;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyMethodCandidate;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.DelegatesToInfo;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.GrDelegatesToProvider;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.GrDelegatesToUtilKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\"\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\"\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0015\u001a\u00020 H\u0002J$\u0010!\u001a\u0004\u0018\u00010\u000e2\b\u0010\"\u001a\u0004\u0018\u00010\u000e2\u0006\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u0004H\u0002\u00a8\u0006%"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/delegatesTo/DefaultDelegatesToProvider;", "Lorg/jetbrains/plugins/groovy/lang/resolve/delegatesTo/GrDelegatesToProvider;", "()V", "findTargetParameter", "Lcom/intellij/psi/PsiParameter;", "list", "Lcom/intellij/psi/PsiParameterList;", "target", "", "getDelegatesToInfo", "Lorg/jetbrains/plugins/groovy/lang/resolve/delegatesTo/DelegatesToInfo;", "expression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GrFunctionalExpression;", "getFromTarget", "Lcom/intellij/psi/PsiType;", "parameterList", "delegatesTo", "Lcom/intellij/psi/PsiAnnotation;", "mapping", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/ArgumentMapping;", "getFromType", "call", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrCall;", "result", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "getFromValue", "getStrategyValue", "", "strategy", "Lcom/intellij/psi/PsiAnnotationMemberValue;", "inferCallQualifier", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrMethodCall;", "inferGenericArgType", "targetType", "genericIndex", "param", "intellij.groovy.psi"})
public final class DefaultDelegatesToProvider
implements GrDelegatesToProvider {
    @Override
    @Nullable
    public DelegatesToInfo getDelegatesToInfo(@NotNull GrFunctionalExpression expression) {
        PsiType psiType;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        GrCall grCall = GrDelegatesToUtilKt.getContainingCall(expression);
        if (grCall == null) {
            return null;
        }
        GrCall call = grCall;
        GroovyResolveResult groovyResolveResult = call.advancedResolve();
        Intrinsics.checkExpressionValueIsNotNull((Object)groovyResolveResult, (String)"call.advancedResolve()");
        GroovyResolveResult result2 = groovyResolveResult;
        PsiElement psiElement = result2.getElement();
        if (!(psiElement instanceof PsiMethod)) {
            psiElement = null;
        }
        PsiMethod psiMethod = (PsiMethod)psiElement;
        if (psiMethod == null) {
            return null;
        }
        PsiMethod method = psiMethod;
        if (GdkMethodUtil.isWithOrIdentity((PsiElement)method)) {
            GrCall grCall2 = call;
            if (grCall2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall");
            }
            GrExpression grExpression = this.inferCallQualifier((GrMethodCall)grCall2);
            if (grExpression == null) {
                return null;
            }
            GrExpression qualifier = grExpression;
            return new DelegatesToInfo(qualifier.getType(), 1);
        }
        GroovyResolveResult groovyResolveResult2 = result2;
        if (!(groovyResolveResult2 instanceof GroovyMethodResult)) {
            groovyResolveResult2 = null;
        }
        if ((object = (GroovyMethodResult)groovyResolveResult2) == null || (object = object.getCandidate()) == null || (object = object.getArgumentMapping()) == null) {
            return null;
        }
        Object argumentMapping2 = object;
        PsiParameter psiParameter = argumentMapping2.targetParameter(new ExpressionArgument(expression));
        if (psiParameter == null) {
            return null;
        }
        PsiParameter parameter = psiParameter;
        DelegatesToInfo delegatesToInfo = (DelegatesToInfo)parameter.getUserData(GrDelegatesToUtilKt.DELEGATES_TO_KEY);
        if (delegatesToInfo != null) {
            DelegatesToInfo delegatesToInfo2 = delegatesToInfo;
            boolean bl = false;
            boolean bl2 = false;
            DelegatesToInfo it = delegatesToInfo2;
            boolean bl3 = false;
            return it;
        }
        String delegateFqnData = (String)parameter.getUserData(GrDelegatesToUtilKt.DELEGATES_TO_TYPE_KEY);
        Integer strategyData = (Integer)parameter.getUserData(GrDelegatesToUtilKt.DELEGATES_TO_STRATEGY_KEY);
        if (delegateFqnData != null) {
            Integer n = strategyData;
            return new DelegatesToInfo((PsiType)TypesUtil.createType(delegateFqnData, expression), n != null ? n : 0);
        }
        PsiModifierList psiModifierList = parameter.getModifierList();
        if (psiModifierList == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiModifierList, (String)"parameter.modifierList ?: return null");
        PsiModifierList modifierList = psiModifierList;
        PsiAnnotation psiAnnotation = modifierList.findAnnotation("groovy.lang.DelegatesTo");
        if (psiAnnotation == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiAnnotation, (String)"modifierList.findAnnotat\u2026EGATES_TO) ?: return null");
        PsiAnnotation delegatesTo = psiAnnotation;
        int strategyValue = this.getStrategyValue(delegatesTo.findAttributeValue("strategy"));
        if (strategyValue == 2 || strategyValue == 4) {
            psiType = null;
        } else {
            PsiType psiType2 = this.getFromValue(delegatesTo);
            if (psiType2 == null) {
                PsiParameterList psiParameterList = method.getParameterList();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"method.parameterList");
                psiType2 = psiType = this.getFromTarget(psiParameterList, delegatesTo, (ArgumentMapping)argumentMapping2);
            }
            if (psiType2 == null) {
                psiType = this.getFromType(call, result2, delegatesTo);
            }
        }
        PsiType delegateType = psiType;
        return new DelegatesToInfo(delegateType, strategyValue);
    }

    private final PsiType getFromValue(PsiAnnotation delegatesTo) {
        PsiAnnotationMemberValue value = delegatesTo.findDeclaredAttributeValue("value");
        if (value instanceof GrReferenceExpression) {
            return ResolveUtil.unwrapClassType(((GrReferenceExpression)value).getType());
        }
        if (value instanceof PsiClassObjectAccessExpression) {
            return ResolveUtil.unwrapClassType(((PsiClassObjectAccessExpression)value).getType());
        }
        if (value == null || value instanceof PsiLiteralExpression && ((PsiLiteralExpression)value).getType() == PsiType.NULL || value instanceof GrLiteral && ((GrLiteral)value).getType() == PsiType.NULL) {
            return null;
        }
        if (value instanceof PsiExpression) {
            return ((PsiExpression)value).getType();
        }
        return null;
    }

    private final PsiType getFromTarget(PsiParameterList parameterList, PsiAnnotation delegatesTo, ArgumentMapping mapping2) {
        Argument argument;
        Object v2;
        PsiParameter parameter;
        block4: {
            String string = GrAnnotationUtil.inferStringAttribute(delegatesTo, "target");
            if (string == null) {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"GrAnnotationUtil.inferSt\u2026 \"target\") ?: return null");
            String target = string;
            PsiParameter psiParameter = this.findTargetParameter(parameterList, target);
            if (psiParameter == null) {
                return null;
            }
            parameter = psiParameter;
            Iterable $this$firstOrNull$iv = mapping2.getArguments();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Argument it = (Argument)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)mapping2.targetParameter(it), (Object)parameter)) continue;
                v2 = element$iv;
                break block4;
            }
            v2 = null;
        }
        if ((argument = (Argument)v2) == null || (argument = argument.getType()) == null) {
            return null;
        }
        Argument type2 = argument;
        Integer index = GrAnnotationUtil.inferIntegerAttribute(delegatesTo, "genericTypeIndex");
        return index != null ? this.inferGenericArgType((PsiType)type2, index, parameter) : type2;
    }

    private final PsiType inferGenericArgType(PsiType targetType, int genericIndex, PsiParameter param) {
        if (!(targetType instanceof PsiClassType)) {
            return null;
        }
        PsiClassType.ClassResolveResult classResolveResult = ((PsiClassType)targetType).resolveGenerics();
        Intrinsics.checkExpressionValueIsNotNull((Object)classResolveResult, (String)"targetType.resolveGenerics()");
        PsiClassType.ClassResolveResult result2 = classResolveResult;
        PsiClass psiClass = result2.getElement();
        if (psiClass == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"result.element ?: return null");
        PsiClass psiClass2 = psiClass;
        PsiSubstitutor psiSubstitutor = result2.getSubstitutor();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiSubstitutor, (String)"result.substitutor");
        PsiSubstitutor substitutor = psiSubstitutor;
        PsiType psiType = param.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiType, (String)"param.type");
        PsiType baseType = psiType;
        PsiClass baseClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)baseType);
        if (baseClass != null && InheritanceUtil.isInheritorOrSelf((PsiClass)psiClass2, (PsiClass)baseClass, (boolean)true)) {
            PsiTypeParameter[] psiTypeParameterArray = baseClass.getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiTypeParameterArray, (String)"baseClass.typeParameters");
            PsiTypeParameter[] typeParameters = psiTypeParameterArray;
            if (genericIndex < typeParameters.length) {
                PsiSubstitutor psiSubstitutor2 = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)baseClass, (PsiClass)psiClass2, (PsiSubstitutor)substitutor);
                Intrinsics.checkExpressionValueIsNotNull((Object)psiSubstitutor2, (String)"TypeConversionUtil.getSu\u2026s, psiClass, substitutor)");
                PsiSubstitutor superClassSubstitutor = psiSubstitutor2;
                return superClassSubstitutor.substitute(typeParameters[genericIndex]);
            }
        }
        return null;
    }

    private final PsiType getFromType(GrCall call, GroovyResolveResult result2, PsiAnnotation delegatesTo) {
        Object object;
        PsiType type2;
        block8: {
            block6: {
                block7: {
                    PsiElement psiElement = result2.getElement();
                    if (!(psiElement instanceof PsiMethod)) {
                        psiElement = null;
                    }
                    PsiMethod psiMethod = (PsiMethod)psiElement;
                    if (psiMethod == null) {
                        return null;
                    }
                    PsiMethod element = psiMethod;
                    String string = GrAnnotationUtil.inferStringAttribute(delegatesTo, "type");
                    if (string == null) {
                        return null;
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"GrAnnotationUtil.inferSt\u2026o, \"type\") ?: return null");
                    String typeValue = string;
                    if (StringsKt.isBlank((CharSequence)typeValue)) {
                        return null;
                    }
                    PsiElement psiElement2 = FromStringHintProcessor.createContext(element);
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"FromStringHintProcessor.createContext(element)");
                    PsiElement context = psiElement2;
                    PsiType psiType = JavaPsiFacade.getElementFactory((Project)context.getProject()).createTypeFromText(typeValue, context);
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiType, (String)"JavaPsiFacade.getElement\u2026mText(typeValue, context)");
                    type2 = psiType;
                    if (!(result2 instanceof GroovyMethodResult)) break block6;
                    object = ((GroovyMethodResult)result2).getCandidate();
                    if (object == null) break block7;
                    Object object2 = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object candidate = object2;
                    boolean bl3 = false;
                    Object object3 = candidate;
                    Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"candidate");
                    object = ClosureAsAnonymousParameterEnhancer.Companion.substitutorIgnoringClosures(call, (GroovyMethodCandidate)object3, (GroovyMethodResult)result2);
                    if (object != null) break block8;
                }
                PsiSubstitutor psiSubstitutor = ((GroovyMethodResult)result2).getPartialSubstitutor();
                object = psiSubstitutor;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiSubstitutor, (String)"result.partialSubstitutor");
                break block8;
            }
            PsiSubstitutor psiSubstitutor = result2.getSubstitutor();
            object = psiSubstitutor;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiSubstitutor, (String)"result.substitutor");
        }
        Object substitutor = object;
        return substitutor.substitute(type2);
    }

    private final PsiParameter findTargetParameter(PsiParameterList list, String target) {
        PsiParameter[] parameters;
        PsiParameter[] psiParameterArray = list.getParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterArray, (String)"list.parameters");
        PsiParameter[] psiParameterArray2 = parameters = psiParameterArray;
        int n = psiParameterArray2.length;
        for (int i = 0; i < n; ++i) {
            String value;
            PsiAnnotation targetAnnotation;
            PsiModifierList modifierList;
            PsiParameter parameter;
            PsiParameter psiParameter = parameter = psiParameterArray2[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)psiParameter, (String)"parameter");
            if (psiParameter.getModifierList() == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)modifierList, (String)"parameter.modifierList ?: continue");
            if (modifierList.findAnnotation("groovy.lang.DelegatesTo.Target") == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)targetAnnotation, (String)"modifierList.findAnnotat\u2026ES_TO_TARGET) ?: continue");
            if (GrAnnotationUtil.inferStringAttribute(targetAnnotation, "value") == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)value, (String)"GrAnnotationUtil.inferSt\u2026ion, \"value\") ?: continue");
            if (!Intrinsics.areEqual((Object)value, (Object)target)) continue;
            return parameter;
        }
        return null;
    }

    private final GrExpression inferCallQualifier(GrMethodCall call) {
        GrExpression grExpression = call.getInvokedExpression();
        Intrinsics.checkExpressionValueIsNotNull((Object)grExpression, (String)"call.invokedExpression");
        GrExpression expression = grExpression;
        return !(expression instanceof GrReferenceExpression) ? null : (GrExpression)((GrReferenceExpression)expression).getQualifier();
    }

    /*
     * Enabled aggressive block sorting
     */
    private final int getStrategyValue(PsiAnnotationMemberValue strategy) {
        String text;
        if (strategy == null) {
            return 0;
        }
        String string = text = strategy.getText();
        if (string != null) {
            switch (string) {
                case "0": {
                    return 0;
                }
                case "1": {
                    return 1;
                }
                case "2": {
                    return 2;
                }
                case "3": {
                    return 3;
                }
                case "4": {
                    return 4;
                }
            }
        }
        String string2 = text;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"text");
        if (StringsKt.endsWith$default((String)string2, (String)"OWNER_FIRST", (boolean)false, (int)2, null)) {
            return 0;
        }
        if (StringsKt.endsWith$default((String)text, (String)"DELEGATE_FIRST", (boolean)false, (int)2, null)) {
            return 1;
        }
        if (StringsKt.endsWith$default((String)text, (String)"OWNER_ONLY", (boolean)false, (int)2, null)) {
            return 2;
        }
        if (StringsKt.endsWith$default((String)text, (String)"DELEGATE_ONLY", (boolean)false, (int)2, null)) {
            return 3;
        }
        if (!StringsKt.endsWith$default((String)text, (String)"TO_SELF", (boolean)false, (int)2, null)) return 0;
        return 4;
    }
}

