/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.util;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.light.JavaIdentifier;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.extensions.GroovyApplicabilityProvider;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyLexer;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GrNamedElement;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.EmptyGroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrSpreadArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrAssertStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrThrowStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForInClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrTraditionalForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrInstanceOfExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSafeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTuple;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrPropertySelection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrBuilderMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrNamedArgumentsOwner;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClosureType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrMapType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrBindingVariable;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.ClosureParameterEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.util.ErrorUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStaticChecker;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyCommonClassNames;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyConstantExpressionEvaluator;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.api.Applicability;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyMethodCallReference;
import org.jetbrains.plugins.groovy.lang.resolve.processors.MethodResolverProcessor;

public class PsiUtil {
    public static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil");
    public static final Key<JavaIdentifier> NAME_IDENTIFIER = new Key("Java Identifier");
    public static final Set<String> OPERATOR_METHOD_NAMES = ContainerUtil.newHashSet((Object[])new String[]{"plus", "minus", "multiply", "power", "div", "mod", "or", "and", "xor", "next", "previous", "getAt", "putAt", "leftShift", "rightShift", "isCase", "bitwiseNegate", "negative", "positive", "call"});
    private static final String[] visibilityModifiers = new String[]{"private", "protected", "public"};

    private PsiUtil() {
    }

    @Nullable
    public static String getMethodName(GrMethodCall methodCall) {
        GrExpression invokedExpression = methodCall.getInvokedExpression();
        if (!(invokedExpression instanceof GrReferenceExpression)) {
            return null;
        }
        return ((GrReferenceExpression)invokedExpression).getReferenceName();
    }

    @Nullable
    public static String getUnqualifiedMethodName(GrMethodCall methodCall) {
        GrExpression invokedExpression = methodCall.getInvokedExpression();
        if (!(invokedExpression instanceof GrReferenceExpression)) {
            return null;
        }
        if (((GrReferenceExpression)invokedExpression).isQualified()) {
            return null;
        }
        return ((GrReferenceExpression)invokedExpression).getReferenceName();
    }

    public static boolean isLValue(GroovyPsiElement element) {
        if (element instanceof GrExpression) {
            PsiElement parent2 = PsiTreeUtil.skipParentsOfType((PsiElement)element, (Class[])new Class[]{GrParenthesizedExpression.class});
            if (parent2 instanceof GrTuple) {
                return true;
            }
            return parent2 instanceof GrAssignmentExpression && PsiTreeUtil.isAncestor((PsiElement)((GrAssignmentExpression)parent2).getLValue(), (PsiElement)element, (boolean)false);
        }
        return false;
    }

    public static boolean isApplicable(@Nullable PsiType[] argumentTypes, @NotNull PsiMethod method, PsiSubstitutor substitutor, PsiElement place, boolean eraseParameterTypes) {
        if (method == null) {
            PsiUtil.$$$reportNull$$$0(0);
        }
        return PsiUtil.isApplicableConcrete(argumentTypes, method, substitutor, place, eraseParameterTypes) != Applicability.inapplicable;
    }

    public static Applicability isApplicableConcrete(@Nullable PsiType[] argumentTypes, @NotNull PsiMethod method, PsiSubstitutor substitutor, PsiElement place, boolean eraseParameterTypes) {
        PsiParameter[] parameters;
        if (method == null) {
            PsiUtil.$$$reportNull$$$0(1);
        }
        if (argumentTypes == null) {
            return Applicability.canBeApplicable;
        }
        GrSignature signature = GrClosureSignatureUtil.createSignature(method, substitutor, eraseParameterTypes, place);
        Applicability result2 = GroovyApplicabilityProvider.checkProviders(argumentTypes, method);
        if (result2 != null) {
            return result2;
        }
        result2 = GrClosureSignatureUtil.isSignatureApplicableConcrete(Collections.singletonList(signature), argumentTypes, place);
        if (result2 != Applicability.inapplicable && (eraseParameterTypes || GenericsUtil.isTypeArgumentsApplicable((PsiTypeParameter[])method.getTypeParameters(), (PsiSubstitutor)substitutor, (PsiElement)place))) {
            return result2;
        }
        if (method instanceof GrBuilderMethod && !((GrBuilderMethod)method).hasObligatoryNamedArguments() && (parameters = method.getParameterList().getParameters()).length > 0 && parameters[0].getType() instanceof GrMapType && (argumentTypes.length == 0 || !(argumentTypes[0] instanceof GrMapType))) {
            return GrClosureSignatureUtil.isSignatureApplicableConcrete(Collections.singletonList(GrClosureSignatureUtil.removeParam(signature, 0)), argumentTypes, place);
        }
        return Applicability.inapplicable;
    }

    public static boolean isApplicable(@Nullable PsiType[] argumentTypes, @NotNull GrClosureType type2, @NotNull GroovyPsiElement context) {
        if (type2 == null) {
            PsiUtil.$$$reportNull$$$0(2);
        }
        if (context == null) {
            PsiUtil.$$$reportNull$$$0(3);
        }
        return PsiUtil.isApplicableConcrete(argumentTypes, type2, context) != Applicability.inapplicable;
    }

    public static Applicability isApplicableConcrete(@Nullable PsiType[] argumentTypes, @NotNull GrClosureType type2, @NotNull GroovyPsiElement context) {
        if (type2 == null) {
            PsiUtil.$$$reportNull$$$0(4);
        }
        if (context == null) {
            PsiUtil.$$$reportNull$$$0(5);
        }
        if (argumentTypes == null) {
            return Applicability.canBeApplicable;
        }
        List<GrSignature> signature = type2.getSignatures();
        return GrClosureSignatureUtil.isSignatureApplicableConcrete(signature, argumentTypes, context);
    }

    @Nullable
    public static GrArgumentList getArgumentsList(@Nullable PsiElement methodRef) {
        if (methodRef == null) {
            return null;
        }
        if (methodRef instanceof GrEnumConstant) {
            return ((GrEnumConstant)methodRef).getArgumentList();
        }
        PsiElement parent2 = methodRef.getParent();
        if (parent2 instanceof GrCall) {
            return ((GrCall)parent2).getArgumentList();
        }
        if (parent2 instanceof GrAnonymousClassDefinition) {
            return ((GrAnonymousClassDefinition)parent2).getArgumentListGroovy();
        }
        return null;
    }

    @Nullable
    public static PsiType[] getArgumentTypes(@Nullable PsiElement place, boolean nullAsBottom) {
        return PsiUtil.getArgumentTypes(place, nullAsBottom, null);
    }

    @Nullable
    public static PsiType[] getArgumentTypes(@Nullable PsiElement place, boolean nullAsBottom, @Nullable GrExpression stopAt) {
        PsiElement parent2;
        Object object = place instanceof GrEnumConstant ? place : (parent2 = place != null ? place.getParent() : null);
        if (parent2 instanceof GrIndexProperty) {
            GrIndexProperty index = (GrIndexProperty)parent2;
            GrArgumentList list = index.getArgumentList();
            Object[] argTypes = PsiUtil.getArgumentTypes(list.getNamedArguments(), list.getExpressionArguments(), GrClosableBlock.EMPTY_ARRAY, nullAsBottom, stopAt);
            if (PsiUtil.isLValue(index) && argTypes != null) {
                PsiType rawInitializer = TypeInferenceHelper.getInitializerTypeFor(index);
                PsiType initializer = PsiUtil.notNullizeType(rawInitializer, nullAsBottom, index);
                return (PsiType[])ArrayUtil.append((Object[])argTypes, (Object)initializer);
            }
            return argTypes;
        }
        if (parent2 instanceof GrCall) {
            GrCall call = (GrCall)parent2;
            GrNamedArgument[] namedArgs = call.getNamedArguments();
            GrExpression[] expressions = call.getExpressionArguments();
            GrClosableBlock[] closures = call.getClosureArguments();
            return PsiUtil.getArgumentTypes(namedArgs, expressions, closures, nullAsBottom, stopAt);
        }
        if (parent2 instanceof GrAnonymousClassDefinition) {
            GrArgumentList argList = ((GrAnonymousClassDefinition)parent2).getArgumentListGroovy();
            if (argList == null) {
                return PsiUtil.getArgumentTypes(GrNamedArgument.EMPTY_ARRAY, GrExpression.EMPTY_ARRAY, GrClosableBlock.EMPTY_ARRAY, nullAsBottom, stopAt);
            }
            return PsiUtil.getArgumentTypes(argList.getNamedArguments(), argList.getExpressionArguments(), GrClosableBlock.EMPTY_ARRAY, nullAsBottom, stopAt);
        }
        if (parent2 instanceof GrBinaryExpression) {
            GrExpression right = ((GrBinaryExpression)parent2).getRightOperand();
            PsiType type2 = right != null ? right.getType() : null;
            return new PsiType[]{PsiUtil.notNullizeType(type2, nullAsBottom, parent2)};
        }
        if (parent2 instanceof GrAssignmentExpression) {
            PsiType type3 = ((GrAssignmentExpression)parent2).getType();
            return new PsiType[]{PsiUtil.notNullizeType(type3, nullAsBottom, parent2)};
        }
        return null;
    }

    @Contract(value="_, false, _ -> !null; !null, _, _ -> !null; null, true, _ -> null")
    private static PsiType notNullizeType(PsiType type2, boolean acceptNull, PsiElement context) {
        return type2 != null || acceptNull ? type2 : TypesUtil.getJavaLangObject(context);
    }

    @Nullable
    public static PsiType[] getArgumentTypes(GrArgumentList argList) {
        return PsiUtil.getArgumentTypes(argList, false, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static PsiType[] getArgumentTypes(@NotNull GrNamedArgument[] namedArgs, @NotNull GrExpression[] expressions, @NotNull GrClosableBlock[] closures, boolean nullAsBottom, @Nullable GrExpression stopAt) {
        if (namedArgs == null) {
            PsiUtil.$$$reportNull$$$0(6);
        }
        if (expressions == null) {
            PsiUtil.$$$reportNull$$$0(7);
        }
        if (closures == null) {
            PsiUtil.$$$reportNull$$$0(8);
        }
        ArrayList<Object> result2 = new ArrayList<Object>();
        if (namedArgs.length > 0) {
            GrNamedArgument context = namedArgs[0];
            result2.add((Object)GrMapType.createFromNamedArgs(context, namedArgs));
        }
        for (GrExpression grExpression : expressions) {
            PsiType type2 = grExpression.getType();
            if (grExpression instanceof GrSpreadArgument) {
                if (!(type2 instanceof GrTupleType)) return null;
                result2.addAll(((GrTupleType)type2).getComponentTypes());
            } else if (type2 == null) {
                result2.add(nullAsBottom ? null : TypesUtil.getJavaLangObject(grExpression));
            } else {
                if (stopAt == grExpression) {
                    type2 = TypeConversionUtil.erasure((PsiType)type2);
                }
                result2.add(type2);
            }
            if (stopAt != grExpression) continue;
            return result2.toArray(PsiType.createArray((int)result2.size()));
        }
        for (GrExpression grExpression : closures) {
            PsiType closureType = grExpression.getType();
            if (closureType != null) {
                if (stopAt == grExpression) {
                    closureType = TypeConversionUtil.erasure((PsiType)closureType);
                }
                result2.add(PsiUtil.notNullizeType(closureType, nullAsBottom, grExpression));
            }
            if (stopAt == grExpression) return result2.toArray(PsiType.createArray((int)result2.size()));
        }
        return result2.toArray(PsiType.createArray((int)result2.size()));
    }

    @Nullable
    public static PsiClass getJavaLangClass(PsiElement resolved, GlobalSearchScope scope) {
        return JavaPsiFacade.getInstance((Project)resolved.getProject()).findClass("java.lang.Class", scope);
    }

    public static boolean isValidReferenceName(@NotNull String text) {
        if (text == null) {
            PsiUtil.$$$reportNull$$$0(9);
        }
        GroovyLexer lexer = new GroovyLexer();
        lexer.start(text);
        return TokenSets.REFERENCE_NAMES_WITHOUT_NUMBERS.contains(lexer.getTokenType()) && lexer.getTokenEnd() == text.length();
    }

    public static boolean isAccessible(@NotNull PsiElement place, @NotNull PsiMember member) {
        if (place == null) {
            PsiUtil.$$$reportNull$$$0(10);
        }
        if (member == null) {
            PsiUtil.$$$reportNull$$$0(11);
        }
        if (member instanceof LightElement) {
            return true;
        }
        if (place instanceof GrReferenceExpression && ((GrReferenceExpression)place).getQualifierExpression() == null && member.getContainingClass() instanceof GroovyScriptClass) {
            return true;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)place, GrDocComment.class) != null) {
            return true;
        }
        return com.intellij.psi.util.PsiUtil.isAccessible((PsiMember)member, (PsiElement)place, null);
    }

    public static void reformatCode(PsiElement element) {
        TextRange textRange = element.getTextRange();
        PsiFile file = element.getContainingFile();
        FileViewProvider viewProvider = file.getViewProvider();
        if (viewProvider instanceof MultiplePsiFilesPerDocumentFileViewProvider) {
            MultiplePsiFilesPerDocumentFileViewProvider multiProvider = (MultiplePsiFilesPerDocumentFileViewProvider)viewProvider;
            file = multiProvider.getPsi(multiProvider.getBaseLanguage());
            LOG.assertTrue(file != null, (Object)(element + " " + multiProvider.getBaseLanguage()));
        }
        try {
            CodeStyleManager.getInstance((Project)element.getProject()).reformatText(file, textRange.getStartOffset(), textRange.getEndOffset());
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public static Iterable<PsiClass> iterateSupers(final @NotNull PsiClass psiClass, final boolean includeSelf) {
        if (psiClass == null) {
            PsiUtil.$$$reportNull$$$0(12);
        }
        return new Iterable<PsiClass>(){

            @Override
            public Iterator<PsiClass> iterator() {
                return new Iterator<PsiClass>(){
                    final TIntStack indices = new TIntStack();
                    final Stack<PsiClassType[]> superTypesStack = new Stack();
                    final Set<PsiClass> visited = new HashSet<PsiClass>();
                    PsiClass current;
                    boolean nextObtained;
                    {
                        if (includeSelf) {
                            this.current = psiClass;
                            this.nextObtained = true;
                        } else {
                            this.current = null;
                            this.nextObtained = false;
                        }
                        this.pushSuper(psiClass);
                    }

                    @Override
                    public boolean hasNext() {
                        this.nextElement();
                        return this.current != null;
                    }

                    private void nextElement() {
                        if (this.nextObtained) {
                            return;
                        }
                        this.nextObtained = true;
                        while (!this.superTypesStack.empty()) {
                            assert (this.indices.size() > 0);
                            PsiClassType[] superTypes = this.superTypesStack.peek();
                            for (int i = this.indices.pop(); i < superTypes.length; ++i) {
                                PsiClass clazz = superTypes[i].resolve();
                                if (clazz == null || this.visited.contains(clazz)) continue;
                                this.current = clazz;
                                this.visited.add(clazz);
                                this.indices.push(i + 1);
                                this.pushSuper(clazz);
                                return;
                            }
                            this.superTypesStack.pop();
                        }
                        this.current = null;
                    }

                    private void pushSuper(PsiClass clazz) {
                        this.superTypesStack.push(clazz.getSuperTypes());
                        this.indices.push(0);
                    }

                    @Override
                    @NotNull
                    public PsiClass next() {
                        this.nextElement();
                        this.nextObtained = false;
                        if (this.current == null) {
                            throw new NoSuchElementException();
                        }
                        PsiClass psiClass = this.current;
                        if (psiClass == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return psiClass;
                    }

                    @Override
                    public void remove() {
                        throw new IllegalStateException("should not be called");
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/util/PsiUtil$1$1", "next"));
                    }
                };
            }
        };
    }

    @Nullable
    public static PsiClass getContextClass(@Nullable PsiElement context) {
        while (context != null) {
            if (context instanceof PsiClass && !PsiUtil.isInDummyFile(context)) {
                return (PsiClass)context;
            }
            if (context instanceof GroovyFileBase && !PsiUtil.isInDummyFile(context)) {
                return ((GroovyFileBase)context).getScriptClass();
            }
            context = context.getContext();
        }
        return null;
    }

    public static boolean isInDummyFile(@NotNull PsiElement context) {
        PsiFile file;
        if (context == null) {
            PsiUtil.$$$reportNull$$$0(13);
        }
        if ((file = context.getContainingFile()) == null) {
            return false;
        }
        String name = file.getName();
        return name.startsWith("DUMMY__1234567890_DUMMYYYYYY___");
    }

    @Nullable
    public static GroovyPsiElement getFileOrClassContext(PsiElement context) {
        while (context != null) {
            if (context instanceof GrTypeDefinition) {
                return (GroovyPsiElement)context;
            }
            if (context instanceof GroovyFileBase && context.isPhysical()) {
                return (GroovyPsiElement)context;
            }
            context = context.getContext();
        }
        return null;
    }

    public static boolean mightBeLValue(@Nullable GrExpression expr) {
        if (expr instanceof GrParenthesizedExpression) {
            return PsiUtil.mightBeLValue(((GrParenthesizedExpression)expr).getOperand());
        }
        if (expr instanceof GrTuple || expr instanceof GrReferenceExpression || expr instanceof GrIndexProperty || expr instanceof GrPropertySelection) {
            return true;
        }
        return PsiUtil.isThisOrSuperRef(expr) && GroovyConfigUtils.getInstance().isVersionAtLeast(expr, "1.8");
    }

    public static boolean isRawMethodCall(GrMethodCallExpression call) {
        PsiType type2;
        GrExpression expression;
        GroovyResolveResult result2 = call.advancedResolve();
        PsiElement element = result2.getElement();
        if (element == null) {
            return false;
        }
        if (element instanceof PsiMethod) {
            PsiType receiver;
            GroovyMethodCallReference reference;
            expression = call.getInvokedExpression();
            if (expression instanceof GrReferenceExpression && (reference = call.getImplicitCallReference()) != null && (receiver = reference.getReceiver()) instanceof GrClosureType) {
                return PsiUtil.isRawClosureCall(call, result2, (GrClosureType)receiver);
            }
            PsiType returnType2 = PsiUtil.getSmartReturnType((PsiMethod)element);
            if (expression instanceof GrReferenceExpression && result2.isInvokedOnProperty()) {
                if (returnType2 instanceof GrClosureType) {
                    return PsiUtil.isRawClosureCall(call, result2, (GrClosureType)returnType2);
                }
            } else {
                return PsiUtil.isRawType(returnType2, result2.getSubstitutor());
            }
        }
        if (element instanceof PsiVariable && (type2 = (expression = call.getInvokedExpression()).getType()) instanceof GrClosureType) {
            return PsiUtil.isRawClosureCall(call, result2, (GrClosureType)type2);
        }
        return false;
    }

    private static boolean isRawClosureCall(GrMethodCallExpression call, GroovyResolveResult result2, GrClosureType returnType2) {
        GrSignature _signature;
        List<GrSignature> signatures = returnType2.getSignatures();
        if (signatures.size() == 1) {
            _signature = signatures.get(0);
        } else {
            PsiType[] types = PsiUtil.getArgumentTypes(call.getInvokedExpression(), true);
            Trinity<GrSignature, GrClosureSignatureUtil.ArgInfo<PsiType>[], Applicability> resultTrinity = types != null ? GrClosureSignatureUtil.getApplicableSignature(signatures, types, call) : null;
            _signature = (GrSignature)Trinity.getFirst(resultTrinity);
        }
        if (_signature != null) {
            return PsiUtil.isRawType(_signature.getReturnType(), TypesUtil.composeSubstitutors(_signature.getSubstitutor(), result2.getSubstitutor()));
        }
        return false;
    }

    public static boolean isRawFieldAccess(GrReferenceExpression ref) {
        PsiElement element = null;
        GroovyResolveResult[] resolveResults = ref.multiResolve(false);
        if (resolveResults.length == 0) {
            return false;
        }
        GroovyResolveResult resolveResult2 = resolveResults[0];
        if (resolveResult2 != null) {
            element = resolveResult2.getElement();
        }
        if (element instanceof PsiField) {
            return PsiUtil.isRawType(((PsiField)element).getType(), resolveResult2.getSubstitutor());
        }
        if (element instanceof GrAccessorMethod) {
            return PsiUtil.isRawType(((GrAccessorMethod)element).getReturnType(), resolveResult2.getSubstitutor());
        }
        return false;
    }

    private static boolean isRawIndexPropertyAccess(GrIndexProperty expr) {
        GrExpression qualifier = expr.getInvokedExpression();
        PsiType qualifierType = qualifier.getType();
        if (qualifierType instanceof PsiClassType) {
            PsiElement element;
            if (InheritanceUtil.isInheritor((PsiType)qualifierType, (String)"java.util.List")) {
                return com.intellij.psi.util.PsiUtil.extractIterableTypeParameter((PsiType)qualifierType, (boolean)false) == null;
            }
            if (InheritanceUtil.isInheritor((PsiType)qualifierType, (String)"java.util.Map")) {
                return com.intellij.psi.util.PsiUtil.substituteTypeParameter((PsiType)qualifierType, (String)"java.util.Map", (int)1, (boolean)false) == null;
            }
            PsiClassType classType = (PsiClassType)qualifierType;
            PsiClassType.ClassResolveResult resolveResult2 = classType.resolveGenerics();
            GrExpression[] arguments2 = expr.getArgumentList().getExpressionArguments();
            PsiType[] argTypes = PsiType.createArray((int)arguments2.length);
            for (int i = 0; i < arguments2.length; ++i) {
                PsiType argType = arguments2[i].getType();
                if (argType == null) {
                    argType = TypesUtil.getJavaLangObject(expr);
                }
                argTypes[i] = argType;
            }
            MethodResolverProcessor processor = new MethodResolverProcessor("getAt", expr, false, qualifierType, argTypes, PsiType.EMPTY_ARRAY);
            PsiClass qClass = resolveResult2.getElement();
            ResolveState state = ResolveState.initial().put(PsiSubstitutor.KEY, (Object)PsiSubstitutor.EMPTY);
            if (qClass != null) {
                qClass.processDeclarations((PsiScopeProcessor)processor, state, null, (PsiElement)expr);
            }
            ResolveUtil.processNonCodeMembers(qualifierType, processor, qualifier, state);
            GroovyResolveResult[] candidates = processor.getCandidates();
            PsiType type2 = null;
            if (candidates.length == 1 && (element = candidates[0].getElement()) instanceof PsiMethod) {
                type2 = PsiUtil.getSmartReturnType((PsiMethod)element);
            }
            return PsiUtil.isRawType(type2, resolveResult2.getSubstitutor());
        }
        return false;
    }

    public static boolean isRawClassMemberAccess(GrExpression expr) {
        if ((expr = (GrExpression)PsiUtil.skipParentheses(expr, false)) instanceof GrMethodCallExpression) {
            return PsiUtil.isRawMethodCall((GrMethodCallExpression)expr);
        }
        if (expr instanceof GrReferenceExpression) {
            return PsiUtil.isRawFieldAccess((GrReferenceExpression)expr);
        }
        if (expr instanceof GrIndexProperty) {
            return PsiUtil.isRawIndexPropertyAccess((GrIndexProperty)expr);
        }
        return false;
    }

    public static boolean isRawType(@Nullable PsiType type2, @NotNull PsiSubstitutor substitutor) {
        PsiClass returnClass;
        if (substitutor == null) {
            PsiUtil.$$$reportNull$$$0(14);
        }
        if (type2 instanceof PsiClassType && (returnClass = ((PsiClassType)type2).resolve()) instanceof PsiTypeParameter) {
            PsiTypeParameter typeParameter = (PsiTypeParameter)returnClass;
            return substitutor.substitute(typeParameter) == null;
        }
        return false;
    }

    public static boolean isWhiteSpaceOrLineFeed(PsiElement element) {
        if (element == null) {
            return false;
        }
        ASTNode node = element.getNode();
        if (node == null) {
            return false;
        }
        IElementType elementType = node.getElementType();
        return elementType == GroovyTokenTypes.mNLS || elementType == TokenType.WHITE_SPACE;
    }

    public static boolean isNewLine(PsiElement element) {
        return PsiUtil.isWhiteSpaceOrLineFeed(element) && element.getText().contains("\n");
    }

    @Nullable
    public static PsiElement getPrevNonSpace(@NotNull PsiElement elem) {
        if (elem == null) {
            PsiUtil.$$$reportNull$$$0(15);
        }
        PsiElement prevSibling = elem.getPrevSibling();
        while (prevSibling instanceof PsiWhiteSpace) {
            prevSibling = prevSibling.getPrevSibling();
        }
        return prevSibling;
    }

    @Nullable
    public static PsiElement getNextNonSpace(PsiElement elem) {
        PsiElement nextSibling = elem.getNextSibling();
        while (nextSibling instanceof PsiWhiteSpace) {
            nextSibling = nextSibling.getNextSibling();
        }
        return nextSibling;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static PsiIdentifier getJavaNameIdentifier(@NotNull GrNamedElement namedElement) {
        PsiElement element;
        JavaIdentifier identifier;
        if (namedElement == null) {
            PsiUtil.$$$reportNull$$$0(16);
        }
        if ((identifier = (JavaIdentifier)(element = namedElement.getNameIdentifierGroovy()).getUserData(NAME_IDENTIFIER)) == null) {
            PsiElement psiElement = element;
            synchronized (psiElement) {
                identifier = (JavaIdentifier)element.getUserData(NAME_IDENTIFIER);
                if (identifier != null) {
                    JavaIdentifier javaIdentifier = identifier;
                    // MONITOREXIT @DISABLED, blocks:[2, 5, 6] lbl9 : MonitorExitStatement: MONITOREXIT : var3_3
                    if (javaIdentifier == null) {
                        PsiUtil.$$$reportNull$$$0(17);
                    }
                    return javaIdentifier;
                }
                identifier = new JavaIdentifier(element.getManager(), element);
                element.putUserData(NAME_IDENTIFIER, (Object)identifier);
            }
        }
        JavaIdentifier javaIdentifier = identifier;
        if (javaIdentifier == null) {
            PsiUtil.$$$reportNull$$$0(18);
        }
        return javaIdentifier;
    }

    @Nullable
    public static GrStatement findEnclosingStatement(@Nullable PsiElement context) {
        while (context != null) {
            if (PsiUtil.isExpressionStatement(context)) {
                return (GrStatement)context;
            }
            context = PsiTreeUtil.getParentOfType((PsiElement)context, GrStatement.class, (boolean)true);
        }
        return null;
    }

    public static boolean isMethodCall(GrMethodCall call, String methodName) {
        GrExpression expression = call.getInvokedExpression();
        return expression instanceof GrReferenceExpression && methodName.equals(expression.getText().trim());
    }

    public static boolean hasEnclosingInstanceInScope(@NotNull PsiClass clazz, @Nullable PsiElement scope, boolean isSuperClassAccepted) {
        if (clazz == null) {
            PsiUtil.$$$reportNull$$$0(19);
        }
        return PsiUtil.findEnclosingInstanceClassInScope(clazz, scope, isSuperClassAccepted) != null;
    }

    public static PsiClass findEnclosingInstanceClassInScope(@NotNull PsiClass clazz, @Nullable PsiElement scope, boolean isInheritorOfClazzAccepted) {
        PsiElement place;
        if (clazz == null) {
            PsiUtil.$$$reportNull$$$0(20);
        }
        for (place = scope; !(place == null || place == clazz || place instanceof PsiFile && place.isPhysical()); place = place.getContext()) {
            if (place instanceof PsiClass && (isInheritorOfClazzAccepted ? InheritanceUtil.isInheritorOrSelf((PsiClass)((PsiClass)place), (PsiClass)clazz, (boolean)true) : clazz.getManager().areElementsEquivalent(place, (PsiElement)clazz))) {
                return (PsiClass)place;
            }
            if (!(place instanceof PsiModifierListOwner) || !((PsiModifierListOwner)place).hasModifierProperty("static")) continue;
            return null;
        }
        if (clazz instanceof GroovyScriptClass && place == clazz.getContainingFile() || place == clazz) {
            return clazz;
        }
        return null;
    }

    @Nullable
    public static PsiElement skipWhitespacesAndComments(@Nullable PsiElement elem, boolean forward, boolean skipNLs) {
        return PsiUtil.skipSet(elem, forward, TokenSets.WHITE_SPACES_OR_COMMENTS, skipNLs);
    }

    @Nullable
    public static PsiElement skipWhitespacesAndComments(@Nullable PsiElement elem, boolean forward) {
        return PsiUtil.skipSet(elem, forward, TokenSets.WHITE_SPACES_OR_COMMENTS, true);
    }

    @Nullable
    public static PsiElement skipSet(PsiElement elem, boolean forward, TokenSet set, boolean skipNLs) {
        while (elem != null && elem.getNode() != null && set.contains(elem.getNode().getElementType()) && (skipNLs || elem.getText().indexOf(10) == -1)) {
            if (forward) {
                elem = elem.getNextSibling();
                continue;
            }
            elem = elem.getPrevSibling();
        }
        return elem;
    }

    @Nullable
    public static PsiElement skipSet(@NotNull PsiElement element, boolean forward, @NotNull TokenSet set) {
        if (element == null) {
            PsiUtil.$$$reportNull$$$0(21);
        }
        if (set == null) {
            PsiUtil.$$$reportNull$$$0(22);
        }
        while ((element = forward ? element.getNextSibling() : element.getPrevSibling()) != null && element.getNode() != null && set.contains(element.getNode().getElementType())) {
        }
        return element;
    }

    @Nullable
    public static PsiElement skipWhitespaces(@Nullable PsiElement elem, boolean forward) {
        return PsiUtil.skipSet(elem, forward, TokenSets.WHITE_SPACES_SET, true);
    }

    @Nullable
    public static PsiType getSmartReturnType(@NotNull PsiMethod method) {
        if (method == null) {
            PsiUtil.$$$reportNull$$$0(23);
        }
        if (method instanceof GrMethod) {
            return ((GrMethod)method).getInferredReturnType();
        }
        if (method instanceof GrAccessorMethod) {
            return ((GrAccessorMethod)method).getInferredReturnType();
        }
        if (method instanceof GrGdkMethod) {
            return PsiUtil.getSmartReturnType(((GrGdkMethod)method).getStaticMethod());
        }
        return method.getReturnType();
    }

    public static boolean isClosurePropertyGetter(PsiMethod method) {
        PsiType type2;
        PsiModifierList modifiers;
        String methodName = method.getName();
        return methodName.startsWith("get") && GroovyPropertyUtils.isGetterName(methodName) && !(modifiers = method.getModifierList()).hasModifierProperty("static") && !modifiers.hasModifierProperty("private") && !modifiers.hasModifierProperty("protected") && method.getParameterList().isEmpty() && (type2 = PsiUtil.getSmartReturnType(method)) != null && TypesUtil.isClassType(type2, "java.lang.Object", "groovy.lang.Closure");
    }

    public static boolean isMethodUsage(PsiElement element) {
        if (element instanceof GrEnumConstant) {
            return true;
        }
        if (!(element instanceof GrReferenceElement)) {
            return false;
        }
        PsiElement parent2 = element.getParent();
        if (parent2 instanceof GrCall) {
            return true;
        }
        if (parent2 instanceof GrAnonymousClassDefinition) {
            return element.equals(((GrAnonymousClassDefinition)parent2).getBaseClassReferenceGroovy());
        }
        return false;
    }

    @NotNull
    public static GroovyResolveResult[] getConstructorCandidates(@NotNull PsiElement place, @NotNull GroovyResolveResult classCandidate, @Nullable PsiType[] argTypes) {
        PsiElement element;
        if (place == null) {
            PsiUtil.$$$reportNull$$$0(24);
        }
        if (classCandidate == null) {
            PsiUtil.$$$reportNull$$$0(25);
        }
        if (!((element = classCandidate.getElement()) instanceof PsiClass)) {
            if (GroovyResolveResult.EMPTY_ARRAY == null) {
                PsiUtil.$$$reportNull$$$0(26);
            }
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        PsiClass clazz = (PsiClass)element;
        PsiSubstitutor substitutor = classCandidate.getSubstitutor();
        GroovyResolveResult[] groovyResolveResultArray = ResolveUtil.getAllClassConstructors(clazz, substitutor, argTypes, place);
        if (groovyResolveResultArray == null) {
            PsiUtil.$$$reportNull$$$0(27);
        }
        return groovyResolveResultArray;
    }

    public static boolean isAccessedForReading(GrExpression expr) {
        return !PsiUtil.isLValue(expr);
    }

    public static boolean isAccessedForWriting(GrExpression expr) {
        return PsiUtil.isLValue(expr) || PsiUtil.isUsedInIncOrDec(expr);
    }

    public static boolean isUsedInIncOrDec(GrExpression expr) {
        PsiElement parent2 = PsiTreeUtil.skipParentsOfType((PsiElement)expr, (Class[])new Class[]{GrParenthesizedExpression.class});
        return PsiUtil.isPlusPlusOrMinusMinus(parent2);
    }

    @Contract(value="null -> false")
    public static boolean isPlusPlusOrMinusMinus(@Nullable PsiElement parent2) {
        if (parent2 instanceof GrUnaryExpression) {
            IElementType tokenType = ((GrUnaryExpression)parent2).getOperationTokenType();
            return tokenType == GroovyTokenTypes.mINC || tokenType == GroovyTokenTypes.mDEC;
        }
        return false;
    }

    public static void qualifyMemberReference(@NotNull GrReferenceExpression refExpr, @NotNull PsiMember member, String name) {
        if (refExpr == null) {
            PsiUtil.$$$reportNull$$$0(28);
        }
        if (member == null) {
            PsiUtil.$$$reportNull$$$0(29);
        }
        assert (refExpr.getQualifierExpression() == null);
        PsiClass clazz = member.getContainingClass();
        assert (clazz != null);
        if (member.hasModifierProperty("static")) {
            GrReferenceExpression newRefExpr = GroovyPsiElementFactory.getInstance(member.getProject()).createReferenceExpressionFromText(clazz.getQualifiedName() + "." + name);
            refExpr.replace(newRefExpr);
        } else {
            PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)refExpr, PsiClass.class);
            if (member.getManager().areElementsEquivalent((PsiElement)containingClass, (PsiElement)clazz)) {
                GrReferenceExpression newRefExpr = GroovyPsiElementFactory.getInstance(member.getProject()).createReferenceExpressionFromText("this." + name);
                refExpr.replace(newRefExpr);
            } else {
                GrReferenceExpression newRefExpr = GroovyPsiElementFactory.getInstance(member.getProject()).createReferenceExpressionFromText(clazz.getName() + ".this." + name);
                refExpr.replace(newRefExpr);
            }
        }
    }

    public static GroovyResolveResult[] getConstructorCandidates(PsiClassType classType, PsiType[] argTypes, GroovyPsiElement context) {
        PsiClassType.ClassResolveResult resolveResult2 = classType.resolveGenerics();
        PsiClass psiClass = resolveResult2.getElement();
        PsiSubstitutor substitutor = resolveResult2.getSubstitutor();
        if (psiClass == null) {
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        GroovyResolveResult grResult = resolveResult2 instanceof GroovyResolveResult ? (GroovyResolveResult)resolveResult2 : new GroovyResolveResultImpl((PsiElement)psiClass, context, null, substitutor, true, true);
        return PsiUtil.getConstructorCandidates(context, grResult, argTypes);
    }

    @Nullable
    public static PsiElement skipParentheses(@Nullable PsiElement element, boolean up) {
        if (element == null) {
            return null;
        }
        if (up) {
            PsiElement parent2;
            while ((parent2 = element.getParent()) instanceof GrParenthesizedExpression) {
                element = parent2;
            }
        } else {
            while (element instanceof GrParenthesizedExpression) {
                element = ((GrParenthesizedExpression)element).getOperand();
            }
        }
        return element;
    }

    @NotNull
    public static PsiElement skipParenthesesIfSensibly(@NotNull PsiElement element, boolean up) {
        PsiElement res;
        if (element == null) {
            PsiUtil.$$$reportNull$$$0(30);
        }
        PsiElement psiElement = (res = PsiUtil.skipParentheses(element, up)) == null ? element : res;
        if (psiElement == null) {
            PsiUtil.$$$reportNull$$$0(31);
        }
        return psiElement;
    }

    @Nullable
    public static PsiElement getNamedArgumentValue(GrNamedArgument otherNamedArgument, String argumentName) {
        PsiElement parent2 = otherNamedArgument.getParent();
        if (!(parent2 instanceof GrNamedArgumentsOwner)) {
            return null;
        }
        GrNamedArgument namedArgument = ((GrNamedArgumentsOwner)parent2).findNamedArgument(argumentName);
        if (namedArgument == null) {
            return null;
        }
        return namedArgument.getExpression();
    }

    @NotNull
    public static PsiClass getOriginalClass(@NotNull PsiClass aClass) {
        PsiFile file;
        if (aClass == null) {
            PsiUtil.$$$reportNull$$$0(32);
        }
        if ((file = aClass.getContainingFile()) == null) {
            PsiClass psiClass = aClass;
            if (psiClass == null) {
                PsiUtil.$$$reportNull$$$0(33);
            }
            return psiClass;
        }
        PsiFile originalFile = file.getOriginalFile();
        if (originalFile == file) {
            PsiClass psiClass = aClass;
            if (psiClass == null) {
                PsiUtil.$$$reportNull$$$0(34);
            }
            return psiClass;
        }
        if (!(originalFile instanceof PsiClassOwner)) {
            PsiClass psiClass = aClass;
            if (psiClass == null) {
                PsiUtil.$$$reportNull$$$0(35);
            }
            return psiClass;
        }
        String name = aClass.getName();
        if (name == null) {
            PsiClass psiClass = aClass;
            if (psiClass == null) {
                PsiUtil.$$$reportNull$$$0(36);
            }
            return psiClass;
        }
        for (PsiClass originalClass : ((PsiClassOwner)originalFile).getClasses()) {
            if (!name.equals(originalClass.getName())) continue;
            PsiClass psiClass = originalClass;
            if (psiClass == null) {
                PsiUtil.$$$reportNull$$$0(37);
            }
            return psiClass;
        }
        PsiClass psiClass = aClass;
        if (psiClass == null) {
            PsiUtil.$$$reportNull$$$0(38);
        }
        return psiClass;
    }

    public static void escalateVisibility(PsiMember owner, PsiElement place) {
        String modifier;
        int index;
        PsiModifierList modifierList = owner.getModifierList();
        LOG.assertTrue(modifierList != null);
        String visibilityModifier = VisibilityUtil.getVisibilityModifier((PsiModifierList)modifierList);
        for (index = 0; index < visibilityModifiers.length && !(modifier = visibilityModifiers[index]).equals(visibilityModifier); ++index) {
        }
        while (index < visibilityModifiers.length && !PsiUtil.isAccessible(place, owner)) {
            modifier = visibilityModifiers[index];
            com.intellij.psi.util.PsiUtil.setModifierProperty((PsiModifierListOwner)owner, (String)modifier, (boolean)true);
            ++index;
        }
    }

    public static int getArgumentIndex(@NotNull GrCall call, @NotNull PsiElement argument) {
        GrArgumentList argumentList;
        if (call == null) {
            PsiUtil.$$$reportNull$$$0(39);
        }
        if (argument == null) {
            PsiUtil.$$$reportNull$$$0(40);
        }
        if ((argumentList = call.getArgumentList()) == null) {
            return -1;
        }
        GrExpression[] expressionArguments = argumentList.getExpressionArguments();
        for (int i = 0; i < expressionArguments.length; ++i) {
            if (!argument.equals(expressionArguments[i])) continue;
            int res = i;
            if (argumentList.getNamedArguments().length > 0) {
                ++res;
            }
            return res;
        }
        if (argument instanceof GrClosableBlock) {
            GrClosableBlock[] closureArgs = call.getClosureArguments();
            for (int i = 0; i < closureArgs.length; ++i) {
                if (!argument.equals(closureArgs[i])) continue;
                int res = i + expressionArguments.length;
                if (argumentList.getNamedArguments().length > 0) {
                    ++res;
                }
                return res;
            }
        }
        return -1;
    }

    public static GrExpression[] getAllArguments(@NotNull GrCall call) {
        GrArgumentList argumentList;
        if (call == null) {
            PsiUtil.$$$reportNull$$$0(41);
        }
        if ((argumentList = call.getArgumentList()) == null) {
            return GrExpression.EMPTY_ARRAY;
        }
        GrClosableBlock[] closureArguments = call.getClosureArguments();
        GrExpression[] expressionArguments = argumentList.getExpressionArguments();
        GrNamedArgument[] namedArguments = argumentList.getNamedArguments();
        int length = expressionArguments.length + closureArguments.length;
        int k = 0;
        if (namedArguments.length > 0) {
            ++length;
            k = 1;
        }
        GrExpression[] res = new GrExpression[length];
        for (GrExpression grExpression : expressionArguments) {
            res[k++] = grExpression;
        }
        for (GrExpression grExpression : closureArguments) {
            res[k++] = grExpression;
        }
        return res;
    }

    public static GrNamedArgument[] getFirstMapNamedArguments(@NotNull GrCall grCall) {
        GrNamedArgument[] res;
        if (grCall == null) {
            PsiUtil.$$$reportNull$$$0(42);
        }
        if ((res = grCall.getNamedArguments()).length > 0) {
            return res;
        }
        GrExpression[] arguments2 = grCall.getExpressionArguments();
        if (arguments2.length == 0) {
            return GrNamedArgument.EMPTY_ARRAY;
        }
        GrExpression firstArg = arguments2[0];
        if (!(firstArg instanceof GrListOrMap)) {
            return GrNamedArgument.EMPTY_ARRAY;
        }
        return ((GrListOrMap)firstArg).getNamedArguments();
    }

    public static boolean isExpressionStatement(@Nullable PsiElement expr) {
        if (!(expr instanceof GrStatement)) {
            return false;
        }
        PsiElement parent2 = expr.getParent();
        if (parent2 instanceof GrControlFlowOwner || parent2 instanceof GrCaseSection) {
            return true;
        }
        if (parent2 instanceof GrLabeledStatement) {
            return true;
        }
        if (parent2 instanceof GrIfStatement && (expr == ((GrIfStatement)parent2).getThenBranch() || expr == ((GrIfStatement)parent2).getElseBranch())) {
            return true;
        }
        return parent2 instanceof GrWhileStatement && expr == ((GrWhileStatement)parent2).getBody();
    }

    @Nullable
    public static GrMethodCall getMethodCallByNamedParameter(GrNamedArgument namedArgument) {
        GrCall res = PsiUtil.getCallByNamedParameter(namedArgument);
        if (res instanceof GrMethodCall) {
            return (GrMethodCall)res;
        }
        return null;
    }

    @Nullable
    public static GrCall getCallByNamedParameter(GrNamedArgument namedArgument) {
        PsiElement eMethodCall;
        PsiElement parent2 = namedArgument.getParent();
        if (parent2 instanceof GrArgumentList) {
            eMethodCall = parent2.getParent();
        } else {
            if (!(parent2 instanceof GrListOrMap)) {
                return null;
            }
            PsiElement eArgumentList = parent2.getParent();
            if (!(eArgumentList instanceof GrArgumentList)) {
                return null;
            }
            GrArgumentList argumentList = (GrArgumentList)eArgumentList;
            if (argumentList.getNamedArguments().length > 0) {
                return null;
            }
            if (argumentList.getExpressionArgumentIndex((GrListOrMap)parent2) != 0) {
                return null;
            }
            eMethodCall = eArgumentList.getParent();
        }
        if (!(eMethodCall instanceof GrCall)) {
            return null;
        }
        return (GrCall)eMethodCall;
    }

    public static String getAnnoAttributeValue(@NotNull PsiAnnotation annotation, String attributeName, String defaultValue) {
        Object o;
        PsiAnnotationMemberValue value;
        if (annotation == null) {
            PsiUtil.$$$reportNull$$$0(43);
        }
        if ((value = annotation.findAttributeValue(attributeName)) instanceof GrExpression && (o = GroovyConstantExpressionEvaluator.evaluate((GrExpression)value)) instanceof String) {
            return (String)o;
        }
        return defaultValue;
    }

    public static boolean getAnnoAttributeValue(@NotNull PsiAnnotation annotation, String attributeName, boolean defaultValue) {
        Object o;
        PsiAnnotationMemberValue value;
        if (annotation == null) {
            PsiUtil.$$$reportNull$$$0(44);
        }
        if ((value = annotation.findAttributeValue(attributeName)) instanceof GrExpression && (o = GroovyConstantExpressionEvaluator.evaluate((GrExpression)value)) instanceof Boolean) {
            return (Boolean)o;
        }
        return defaultValue;
    }

    public static boolean isExpressionUsed(PsiElement expr) {
        while (expr.getParent() instanceof GrParenthesizedExpression) {
            expr = expr.getParent();
        }
        PsiElement parent2 = expr.getParent();
        if (parent2 instanceof GrBinaryExpression || parent2 instanceof GrUnaryExpression || parent2 instanceof GrConditionalExpression || parent2 instanceof GrAssignmentExpression || parent2 instanceof GrInstanceOfExpression || parent2 instanceof GrSafeCastExpression || parent2 instanceof GrTuple || parent2 instanceof GrArgumentList || parent2 instanceof GrReturnStatement || parent2 instanceof GrAssertStatement || parent2 instanceof GrThrowStatement || parent2 instanceof GrSwitchStatement || parent2 instanceof GrVariable || parent2 instanceof GrWhileStatement) {
            return true;
        }
        if (parent2 instanceof GrReferenceExpression) {
            PsiElement resolved;
            if (ResolveUtil.isClassReference(parent2)) {
                parent2 = parent2.getParent();
            }
            if (parent2 instanceof GrReferenceExpression && (resolved = ((GrReferenceExpression)parent2).resolve()) instanceof PsiMember) {
                PsiClass containingClass = ((PsiMember)resolved).getContainingClass();
                return containingClass != null && "java.lang.Class".equals(containingClass.getQualifiedName());
            }
            return true;
        }
        if (parent2 instanceof GrTraditionalForClause) {
            GrTraditionalForClause forClause = (GrTraditionalForClause)parent2;
            return expr == forClause.getCondition();
        }
        return PsiUtil.isReturnStatement(expr);
    }

    public static boolean isReturnStatement(@NotNull PsiElement statement) {
        GrControlFlowOwner controlFlowOwner;
        if (statement == null) {
            PsiUtil.$$$reportNull$$$0(45);
        }
        if ((controlFlowOwner = ControlFlowUtils.findControlFlowOwner(statement)) instanceof GrOpenBlock) {
            PsiElement controlFlowOwnerParent = controlFlowOwner.getParent();
            if (controlFlowOwnerParent instanceof GrMethod && ((GrMethod)controlFlowOwnerParent).isConstructor()) {
                return false;
            }
            if (controlFlowOwnerParent instanceof PsiMethod && PsiType.VOID.equals((Object)((PsiMethod)controlFlowOwnerParent).getReturnType())) {
                return false;
            }
        }
        return ControlFlowUtils.collectReturns(controlFlowOwner, true).contains(statement);
    }

    @Nullable
    public static PsiClass getContainingNotInnerClass(@Nullable PsiElement element) {
        PsiClass domainClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        if (domainClass == null) {
            return null;
        }
        PsiClass c;
        while ((c = domainClass.getContainingClass()) != null) {
            domainClass = c;
        }
        return domainClass;
    }

    @NotNull
    public static ResolveResult getAccessObjectClass(GrExpression expression) {
        GroovyResolveResult resolveResult2;
        if (PsiUtil.isThisOrSuperRef(expression)) {
            EmptyGroovyResolveResult emptyGroovyResolveResult = EmptyGroovyResolveResult.INSTANCE;
            if (emptyGroovyResolveResult == null) {
                PsiUtil.$$$reportNull$$$0(46);
            }
            return emptyGroovyResolveResult;
        }
        PsiType type2 = expression.getType();
        if (type2 instanceof PsiClassType) {
            PsiClassType.ClassResolveResult classResolveResult = ((PsiClassType)type2).resolveGenerics();
            if (classResolveResult == null) {
                PsiUtil.$$$reportNull$$$0(47);
            }
            return classResolveResult;
        }
        if (type2 == null && expression instanceof GrReferenceExpression && (resolveResult2 = ((GrReferenceExpression)expression).advancedResolve()).getElement() instanceof PsiClass) {
            GroovyResolveResult groovyResolveResult = resolveResult2;
            if (groovyResolveResult == null) {
                PsiUtil.$$$reportNull$$$0(48);
            }
            return groovyResolveResult;
        }
        EmptyGroovyResolveResult emptyGroovyResolveResult = EmptyGroovyResolveResult.INSTANCE;
        if (emptyGroovyResolveResult == null) {
            PsiUtil.$$$reportNull$$$0(49);
        }
        return emptyGroovyResolveResult;
    }

    public static boolean isReferenceWithoutQualifier(@Nullable PsiElement element, @NotNull String name) {
        if (name == null) {
            PsiUtil.$$$reportNull$$$0(50);
        }
        if (!(element instanceof GrReferenceExpression)) {
            return false;
        }
        GrReferenceExpression ref = (GrReferenceExpression)element;
        return !ref.isQualified() && name.equals(ref.getReferenceName());
    }

    public static boolean isProperty(@NotNull GrField field) {
        PsiClass clazz;
        if (field == null) {
            PsiUtil.$$$reportNull$$$0(51);
        }
        if ((clazz = field.getContainingClass()) == null) {
            return false;
        }
        if (clazz.isInterface() && !GrTraitUtil.isTrait(clazz)) {
            return false;
        }
        GrModifierList modifierList = field.getModifierList();
        return modifierList == null || !modifierList.hasExplicitVisibilityModifiers();
    }

    public static boolean isConstructorHasRequiredParameters(@NotNull PsiMethod constructor) {
        PsiParameter[] parameters;
        if (constructor == null) {
            PsiUtil.$$$reportNull$$$0(52);
        }
        LOG.assertTrue(constructor.isConstructor());
        for (PsiParameter parameter : parameters = constructor.getParameterList().getParameters()) {
            if (parameter instanceof GrParameter && ((GrParameter)parameter).isOptional()) continue;
            return true;
        }
        return false;
    }

    public static boolean isInMethodCallContext(PsiElement context) {
        return PsiUtil.getArgumentsList(context) != null;
    }

    @NotNull
    public static List<GrImportStatement> getValidImportStatements(GroovyFile file) {
        ArrayList<GrImportStatement> oldImports = new ArrayList<GrImportStatement>();
        for (GrImportStatement statement : file.getImportStatements()) {
            if (ErrorUtil.containsError(statement)) continue;
            oldImports.add(statement);
        }
        ArrayList<GrImportStatement> arrayList = oldImports;
        if (arrayList == null) {
            PsiUtil.$$$reportNull$$$0(53);
        }
        return arrayList;
    }

    public static boolean isInStaticCompilationContext(@NotNull GrReferenceExpression expression) {
        if (expression == null) {
            PsiUtil.$$$reportNull$$$0(54);
        }
        return PsiUtil.isCompileStatic(expression) || GrStaticChecker.isPropertyAccessInStaticMethod(expression);
    }

    public static boolean isCompileStatic(PsiElement e) {
        PsiMember containingMember2 = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)e, PsiMember.class, (boolean)false, (Class[])new Class[]{GrAnnotation.class});
        return containingMember2 != null && GroovyPsiManager.getInstance(containingMember2.getProject()).isCompileStatic(containingMember2);
    }

    @Nullable
    public static PsiType extractIteratedType(GrForInClause forIn) {
        GrExpression iterated = forIn.getIteratedExpression();
        if (iterated == null) {
            return null;
        }
        return ClosureParameterEnhancer.findTypeForIteration(iterated, (PsiElement)forIn);
    }

    public static boolean isThisReference(@Nullable PsiElement expression) {
        return PsiUtil.isThisOrSuperRef(expression, GroovyTokenTypes.kTHIS, false);
    }

    public static boolean isSuperReference(@Nullable PsiElement expression) {
        return PsiUtil.isThisOrSuperRef(expression, GroovyTokenTypes.kSUPER, true);
    }

    private static boolean isThisOrSuperRef(PsiElement expression, IElementType token, boolean superClassAccepted) {
        if (!(expression instanceof GrReferenceExpression)) {
            return false;
        }
        GrReferenceExpression ref = (GrReferenceExpression)expression;
        PsiElement nameElement = ref.getReferenceNameElement();
        if (nameElement == null) {
            return false;
        }
        IElementType type2 = nameElement.getNode().getElementType();
        if (type2 != token) {
            return false;
        }
        GrExpression qualifier = (GrExpression)ref.getQualifier();
        if (qualifier == null) {
            return true;
        }
        PsiElement resolved = ref.resolve();
        if (resolved instanceof PsiClass) {
            if (PsiUtil.hasEnclosingInstanceInScope((PsiClass)resolved, ref, superClassAccepted)) {
                return true;
            }
            if (superClassAccepted && GrTraitUtil.isTrait((PsiClass)resolved) && PsiUtil.scopeClassImplementsTrait((PsiClass)resolved, ref)) {
                return true;
            }
        }
        return false;
    }

    public static boolean scopeClassImplementsTrait(@NotNull PsiClass trait, @NotNull PsiElement place) {
        GrTypeDefinition scopeClass;
        if (trait == null) {
            PsiUtil.$$$reportNull$$$0(55);
        }
        if (place == null) {
            PsiUtil.$$$reportNull$$$0(56);
        }
        return (scopeClass = (GrTypeDefinition)PsiTreeUtil.getParentOfType((PsiElement)place, GrTypeDefinition.class, (boolean)true)) != null && ContainerUtil.find((Object[])scopeClass.getSuperTypes(), type2 -> place.getManager().areElementsEquivalent((PsiElement)type2.resolve(), (PsiElement)trait)) != null;
    }

    public static boolean isThisOrSuperRef(@Nullable PsiElement qualifier) {
        return qualifier instanceof GrReferenceExpression && (PsiUtil.isThisReference(qualifier) || PsiUtil.isSuperReference(qualifier));
    }

    public static boolean isInstanceThisRef(PsiElement qualifier) {
        if (PsiUtil.isThisReference(qualifier)) {
            GrReferenceExpression ref = (GrReferenceExpression)qualifier;
            PsiElement resolved = ref.resolve();
            if (!(resolved instanceof PsiClass)) {
                return false;
            }
            return PsiUtil.hasEnclosingInstanceInScope((PsiClass)resolved, qualifier, false);
        }
        return false;
    }

    public static boolean isLineFeed(@Nullable PsiElement e) {
        return e != null && PsiImplUtil.isWhiteSpaceOrNls(e) && (e.getText().indexOf(10) >= 0 || e.getText().indexOf(13) >= 0);
    }

    public static boolean isSingleBindingVariant(GroovyResolveResult[] candidates) {
        return candidates.length == 1 && candidates[0].getElement() instanceof GrBindingVariable;
    }

    @Nullable
    public static GrConstructorInvocation getConstructorInvocation(@NotNull GrMethod constructor) {
        if (constructor == null) {
            PsiUtil.$$$reportNull$$$0(57);
        }
        assert (constructor.isConstructor());
        GrOpenBlock body = constructor.getBlock();
        if (body == null) {
            return null;
        }
        GrStatement[] statements = body.getStatements();
        if (statements.length > 0 && statements[0] instanceof GrConstructorInvocation) {
            return (GrConstructorInvocation)statements[0];
        }
        return null;
    }

    public static boolean isDGMMethod(@Nullable PsiElement element) {
        if (!(element instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method = element instanceof GrGdkMethod ? ((GrGdkMethod)element).getStaticMethod() : (PsiMethod)element;
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return false;
        }
        String qname = aClass.getQualifiedName();
        return GroovyCommonClassNames.DEFAULT_INSTANCE_EXTENSIONS.contains(qname) || GroovyCommonClassNames.DEFAULT_STATIC_EXTENSIONS.contains(qname);
    }

    public static boolean isVoidMethodCall(@Nullable GrExpression expression) {
        if (expression instanceof GrMethodCall && PsiType.NULL.equals((Object)expression.getType())) {
            GroovyResolveResult resolveResult2 = ((GrMethodCall)expression).advancedResolve();
            PsiType[] args = PsiUtil.getArgumentTypes(((GrMethodCall)expression).getInvokedExpression(), true);
            return PsiType.VOID.equals((Object)ResolveUtil.extractReturnTypeFromCandidate(resolveResult2, expression, args));
        }
        return false;
    }

    public static boolean isVoidMethod(@NotNull PsiMethod method) {
        GrOpenBlock block;
        if (method == null) {
            PsiUtil.$$$reportNull$$$0(58);
        }
        if (PsiType.VOID.equals((Object)method.getReturnType())) {
            return true;
        }
        return method instanceof GrMethod && ((GrMethod)method).getReturnTypeElementGroovy() == null && (block = ((GrMethod)method).getBlock()) != null && PsiUtil.isBlockReturnVoid(block);
    }

    public static boolean isBlockReturnVoid(@NotNull GrCodeBlock block) {
        if (block == null) {
            PsiUtil.$$$reportNull$$$0(59);
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)block, () -> CachedValueProvider.Result.create((Object)ControlFlowUtils.visitAllExitPoints(block, new ControlFlowUtils.ExitPointVisitor(){

            @Override
            public boolean visitExitPoint(Instruction instruction, @Nullable GrExpression returnValue) {
                return !(returnValue instanceof GrLiteral);
            }
        }), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    public static boolean checkPsiElementsAreEqual(PsiElement l, PsiElement r) {
        PsiElement[] rChildren;
        if (!l.getText().equals(r.getText())) {
            return false;
        }
        if (l.getNode().getElementType() != r.getNode().getElementType()) {
            return false;
        }
        PsiElement[] lChildren = l.getChildren();
        if (lChildren.length != (rChildren = r.getChildren()).length) {
            return false;
        }
        for (int i = 0; i < rChildren.length; ++i) {
            if (PsiUtil.checkPsiElementsAreEqual(lChildren[i], rChildren[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isCall(GrReferenceExpression referenceExpression) {
        return referenceExpression.getParent() instanceof GrCall;
    }

    public static boolean isLocalVariable(@Nullable PsiElement variable) {
        return variable instanceof GrVariable && !(variable instanceof GrField) && !(variable instanceof GrParameter);
    }

    public static boolean isLocalOrParameter(@Nullable PsiElement variable) {
        return variable instanceof GrVariable && !(variable instanceof GrField);
    }

    @Nullable
    public static PsiElement getPreviousNonWhitespaceToken(PsiElement e) {
        PsiElement next = PsiTreeUtil.prevLeaf((PsiElement)e);
        while (next != null && next.getNode().getElementType() == TokenType.WHITE_SPACE) {
            next = PsiTreeUtil.prevLeaf((PsiElement)next);
        }
        return next;
    }

    @Nullable
    public static Object getLabelValue(@Nullable GrArgumentLabel label) {
        Object value;
        if (label == null) {
            return null;
        }
        PsiElement element = label.getNameElement();
        if (element instanceof GrExpression && (value = JavaPsiFacade.getInstance((Project)label.getProject()).getConstantEvaluationHelper().computeConstantExpression(element)) != null) {
            return value;
        }
        IElementType elemType = element.getNode().getElementType();
        if (GroovyTokenTypes.mIDENT == elemType || TokenSets.KEYWORDS.contains(elemType)) {
            return element.getText();
        }
        return GrLiteralImpl.getLiteralValue(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: 
            case 18: 
            case 26: 
            case 27: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 53: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: 
            case 18: 
            case 26: 
            case 27: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 53: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedArgs";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closures";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 10: 
            case 24: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 11: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elem";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
            case 17: 
            case 18: 
            case 26: 
            case 27: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/util/PsiUtil";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 21: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classCandidate";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refExpr";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grCall";
                break;
            }
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 52: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trait";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/util/PsiUtil";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaNameIdentifier";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructorCandidates";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "skipParenthesesIfSensibly";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalClass";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessObjectClass";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidImportStatements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableConcrete";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentTypes";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isValidReferenceName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isAccessible";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "iterateSupers";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isInDummyFile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isRawType";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPrevNonSpace";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getJavaNameIdentifier";
                break;
            }
            case 17: 
            case 18: 
            case 26: 
            case 27: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 53: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "hasEnclosingInstanceInScope";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findEnclosingInstanceClassInScope";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "skipSet";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getSmartReturnType";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getConstructorCandidates";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "qualifyMemberReference";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "skipParenthesesIfSensibly";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalClass";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentIndex";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getAllArguments";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getFirstMapNamedArguments";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getAnnoAttributeValue";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isReturnStatement";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceWithoutQualifier";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "isProperty";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "isConstructorHasRequiredParameters";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "isInStaticCompilationContext";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "scopeClassImplementsTrait";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getConstructorInvocation";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "isVoidMethod";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "isBlockReturnVoid";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: 
            case 18: 
            case 26: 
            case 27: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 53: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

