/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.MethodSignature;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GrFunctionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSafeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.AbstractClosureParameterEnhancer;
import org.jetbrains.plugins.groovy.lang.resolve.api.ArgumentMapping;
import org.jetbrains.plugins.groovy.lang.resolve.api.ExpressionArgument;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyMethodCandidate;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.GroovyInferenceSessionBuilder;
import org.jetbrains.plugins.groovy.lang.sam.SamConversionKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0016\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0014J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/groovy/lang/psi/typeEnhancers/ClosureAsAnonymousParameterEnhancer;", "Lorg/jetbrains/plugins/groovy/lang/psi/typeEnhancers/AbstractClosureParameterEnhancer;", "()V", "expectedType", "Lcom/intellij/psi/PsiType;", "expression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GrFunctionalExpression;", "fromMethodCall", "getClosureParameterType", "index", "", "unwrapBound", "type", "Companion", "intellij.groovy.psi"})
public class ClosureAsAnonymousParameterEnhancer
extends AbstractClosureParameterEnhancer {
    public static final Companion Companion = new Companion(null);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    protected PsiType getClosureParameterType(@NotNull GrFunctionalExpression expression, int index) {
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        PsiType psiType = this.expectedType(expression);
        if (!(psiType instanceof PsiClassType)) {
            psiType = null;
        }
        PsiClassType psiClassType = (PsiClassType)psiType;
        if (psiClassType == null) return null;
        PsiClassType type2 = psiClassType;
        PsiClassType.ClassResolveResult classResolveResult = type2.resolveGenerics();
        Intrinsics.checkExpressionValueIsNotNull((Object)classResolveResult, (String)"type.resolveGenerics()");
        PsiClassType.ClassResolveResult result2 = classResolveResult;
        PsiClass psiClass = result2.getElement();
        if (psiClass == null) return null;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"result.element ?: return null");
        PsiClass clazz = psiClass;
        PsiSubstitutor psiSubstitutor = result2.getSubstitutor();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiSubstitutor, (String)"result.substitutor");
        PsiSubstitutor substitutor = psiSubstitutor;
        MethodSignature methodSignature = SamConversionKt.findSingleAbstractSignature(clazz);
        if (methodSignature == null) return null;
        MethodSignature sam2 = methodSignature;
        Object[] objectArray = sam2.getParameterTypes();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"sam.parameterTypes");
        PsiType psiType2 = (PsiType)ArraysKt.getOrNull((Object[])objectArray, (int)index);
        PsiType psiType3 = psiType2;
        if (psiType2 == null) return null;
        PsiType psiType4 = psiType3;
        boolean bl = false;
        boolean bl2 = false;
        PsiType p1 = psiType4;
        boolean bl3 = false;
        PsiType psiType5 = substitutor.substitute(p1);
        psiType3 = psiType5;
        if (psiType5 == null) return null;
        psiType4 = psiType3;
        ClosureAsAnonymousParameterEnhancer closureAsAnonymousParameterEnhancer = this;
        bl2 = false;
        boolean bl4 = false;
        PsiType p12 = psiType4;
        boolean bl5 = false;
        PsiType psiType6 = closureAsAnonymousParameterEnhancer.unwrapBound(p12);
        return psiType6;
    }

    private final PsiType expectedType(GrFunctionalExpression expression) {
        PsiElement parent2 = expression.getParent();
        if (parent2 instanceof GrSafeCastExpression) {
            GrTypeElement grTypeElement = ((GrSafeCastExpression)parent2).getCastTypeElement();
            return grTypeElement != null ? grTypeElement.getType() : null;
        }
        return this.fromMethodCall(expression);
    }

    private final PsiType fromMethodCall(GrFunctionalExpression expression) {
        GrMethodCall grMethodCall = GrClosureSignatureUtil.findCall(expression);
        if (grMethodCall == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)grMethodCall, (String)"findCall(expression) ?: return null");
        GrMethodCall call = grMethodCall;
        GroovyResolveResult groovyResolveResult = call.advancedResolve();
        if (!(groovyResolveResult instanceof GroovyMethodResult)) {
            groovyResolveResult = null;
        }
        GroovyMethodResult groovyMethodResult = (GroovyMethodResult)groovyResolveResult;
        if (groovyMethodResult == null) {
            return null;
        }
        GroovyMethodResult variant = groovyMethodResult;
        GroovyMethodCandidate groovyMethodCandidate = variant.getCandidate();
        if (groovyMethodCandidate == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)groovyMethodCandidate, (String)"variant.candidate ?: return null");
        GroovyMethodCandidate candidate = groovyMethodCandidate;
        ArgumentMapping argumentMapping2 = candidate.getArgumentMapping();
        if (argumentMapping2 == null) {
            return null;
        }
        ArgumentMapping mapping2 = argumentMapping2;
        PsiType psiType = mapping2.expectedType(new ExpressionArgument(expression));
        if (psiType == null) {
            return null;
        }
        PsiType expectedType = psiType;
        PsiSubstitutor substitutor = Companion.substitutorIgnoringClosures(call, candidate, variant);
        return substitutor.substitute(expectedType);
    }

    private final PsiType unwrapBound(PsiType type2) {
        return type2 instanceof PsiWildcardType && ((PsiWildcardType)type2).isSuper() ? ((PsiWildcardType)type2).getBound() : type2;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/groovy/lang/psi/typeEnhancers/ClosureAsAnonymousParameterEnhancer$Companion;", "", "()V", "substitutorIgnoringClosures", "Lcom/intellij/psi/PsiSubstitutor;", "call", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrCall;", "candidate", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/GroovyMethodCandidate;", "variant", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyMethodResult;", "intellij.groovy.psi"})
    public static final class Companion {
        @NotNull
        public final PsiSubstitutor substitutorIgnoringClosures(@NotNull GrCall call, @NotNull GroovyMethodCandidate candidate, @NotNull GroovyMethodResult variant) {
            Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
            Intrinsics.checkParameterIsNotNull((Object)candidate, (String)"candidate");
            Intrinsics.checkParameterIsNotNull((Object)variant, (String)"variant");
            PsiElement psiElement = call;
            PsiSubstitutor psiSubstitutor = variant.getContextSubstitutor();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiSubstitutor, (String)"variant.contextSubstitutor");
            return new GroovyInferenceSessionBuilder(psiElement, candidate, psiSubstitutor).skipClosureIn(call).resolveMode(false).build().inferSubst();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

