/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.stubs.elements;

import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef.members.GrMethodImpl;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrMethodStub;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrStubUtils;
import org.jetbrains.plugins.groovy.lang.psi.stubs.elements.GrStubElementType;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrAnnotatedMemberIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrMethodNameIndex;

public class GrMethodElementType
extends GrStubElementType<GrMethodStub, GrMethod> {
    public GrMethodElementType(String debugName) {
        super(debugName);
    }

    @NotNull
    public GrMethodStub createStub(@NotNull GrMethod psi, StubElement parentStub) {
        if (psi == null) {
            GrMethodElementType.$$$reportNull$$$0(0);
        }
        Set<String> namedParameters = psi.getNamedParameters().keySet();
        GrMethodStub grMethodStub = new GrMethodStub(parentStub, StringRef.fromString((String)psi.getName()), GrStubUtils.getAnnotationNames(psi), ArrayUtilRt.toStringArray(namedParameters), this, GrStubUtils.getTypeText(psi.getReturnTypeElementGroovy()), GrMethodStub.buildFlags(psi));
        if (grMethodStub == null) {
            GrMethodElementType.$$$reportNull$$$0(1);
        }
        return grMethodStub;
    }

    public void serialize(@NotNull GrMethodStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            GrMethodElementType.$$$reportNull$$$0(2);
        }
        if (dataStream == null) {
            GrMethodElementType.$$$reportNull$$$0(3);
        }
        dataStream.writeName(stub.getName());
        GrStubUtils.writeStringArray(dataStream, stub.getAnnotations());
        GrStubUtils.writeStringArray(dataStream, stub.getNamedParameters());
        GrStubUtils.writeNullableString(dataStream, stub.getTypeText());
        dataStream.writeByte((int)stub.getFlags());
    }

    @NotNull
    public GrMethodStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            GrMethodElementType.$$$reportNull$$$0(4);
        }
        StringRef ref = dataStream.readName();
        String[] annNames = GrStubUtils.readStringArray(dataStream);
        String[] namedParameters = GrStubUtils.readStringArray(dataStream);
        String typeText = GrStubUtils.readNullableString(dataStream);
        byte flags = dataStream.readByte();
        GrMethodStub grMethodStub = new GrMethodStub(parentStub, ref, annNames, namedParameters, this, typeText, flags);
        if (grMethodStub == null) {
            GrMethodElementType.$$$reportNull$$$0(5);
        }
        return grMethodStub;
    }

    @Override
    public void indexStub(@NotNull GrMethodStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            GrMethodElementType.$$$reportNull$$$0(6);
        }
        if (sink == null) {
            GrMethodElementType.$$$reportNull$$$0(7);
        }
        String name = stub.getName();
        sink.occurrence(GrMethodNameIndex.KEY, (Object)name);
        if (GrStubUtils.isGroovyStaticMemberStub(stub)) {
            sink.occurrence(JavaStubIndexKeys.JVM_STATIC_MEMBERS_NAMES, (Object)name);
            sink.occurrence(JavaStubIndexKeys.JVM_STATIC_MEMBERS_TYPES, (Object)GrStubUtils.getShortTypeText(stub.getTypeText()));
        }
        for (String annName : stub.getAnnotations()) {
            if (annName == null) continue;
            sink.occurrence(GrAnnotatedMemberIndex.KEY, (Object)annName);
        }
    }

    public GrMethod createPsi(@NotNull GrMethodStub stub) {
        if (stub == null) {
            GrMethodElementType.$$$reportNull$$$0(8);
        }
        return new GrMethodImpl(stub);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrMethodElementType";
                break;
            }
            case 2: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrMethodElementType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createStub";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createStub";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "indexStub";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createPsi";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

