/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiTypeVisitorEx;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.PsiSubstitutorImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ComparatorUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectIntHashMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.SpreadState;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArrayInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationMemberValue;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClosureType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrImmediateTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrMapType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTraitType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.LazyFqnClassType;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrImmediateClosureSignatureImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ClassUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ConversionResult;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrTypeMapper;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypeConstants;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class TypesUtil
implements TypeConstants {
    public static final PsiPrimitiveType[] PRIMITIVES = new PsiPrimitiveType[]{PsiType.BYTE, PsiType.CHAR, PsiType.DOUBLE, PsiType.FLOAT, PsiType.INT, PsiType.SHORT, PsiType.LONG, PsiType.BOOLEAN, PsiType.VOID};
    private static final Map<IElementType, String> ourPrimitiveTypesToClassNames = new HashMap<IElementType, String>();
    private static final String NULL = "null";
    private static final Map<IElementType, String> ourUnaryOperationsToOperatorNames;
    static final TObjectIntHashMap<String> TYPE_TO_RANK;
    static final TIntObjectHashMap<String> RANK_TO_TYPE;
    private static final List<PsiType> LUB_NUMERIC_TYPES;

    private TypesUtil() {
    }

    public static GroovyResolveResult[] getOverloadedUnaryOperatorCandidates(@NotNull PsiType thisType, IElementType tokenType, @NotNull GroovyPsiElement place, PsiType[] argumentTypes) {
        if (thisType == null) {
            TypesUtil.$$$reportNull$$$0(0);
        }
        if (place == null) {
            TypesUtil.$$$reportNull$$$0(1);
        }
        return ResolveUtil.getMethodCandidates(thisType, ourUnaryOperationsToOperatorNames.get(tokenType), (PsiElement)place, argumentTypes);
    }

    @Deprecated
    public static boolean isAssignable(@Nullable PsiType lType, @Nullable PsiType rType, @NotNull PsiElement context) {
        if (context == null) {
            TypesUtil.$$$reportNull$$$0(2);
        }
        if (lType == null || rType == null) {
            return false;
        }
        return TypesUtil.canAssign(lType, rType, context, GrTypeConverter.ApplicableTo.ASSIGNMENT) == ConversionResult.OK;
    }

    @NotNull
    public static ConversionResult canAssign(@NotNull PsiType targetType, @NotNull PsiType actualType, @NotNull PsiElement context, @NotNull GrTypeConverter.ApplicableTo position) {
        GlobalSearchScope scope;
        if (targetType == null) {
            TypesUtil.$$$reportNull$$$0(3);
        }
        if (actualType == null) {
            TypesUtil.$$$reportNull$$$0(4);
        }
        if (context == null) {
            TypesUtil.$$$reportNull$$$0(5);
        }
        if (position == null) {
            TypesUtil.$$$reportNull$$$0(6);
        }
        if (actualType instanceof PsiIntersectionType) {
            ConversionResult min = ConversionResult.ERROR;
            for (PsiType child : ((PsiIntersectionType)actualType).getConjuncts()) {
                ConversionResult result2 = TypesUtil.canAssign(targetType, child, context, position);
                if (result2.ordinal() < min.ordinal()) {
                    min = result2;
                }
                if (min != ConversionResult.OK) continue;
                ConversionResult conversionResult = ConversionResult.OK;
                if (conversionResult == null) {
                    TypesUtil.$$$reportNull$$$0(7);
                }
                return conversionResult;
            }
            ConversionResult conversionResult = min;
            if (conversionResult == null) {
                TypesUtil.$$$reportNull$$$0(8);
            }
            return conversionResult;
        }
        if (targetType instanceof PsiIntersectionType) {
            ConversionResult max = ConversionResult.OK;
            for (PsiType child : ((PsiIntersectionType)targetType).getConjuncts()) {
                ConversionResult result3 = TypesUtil.canAssign(child, actualType, context, position);
                if (result3.ordinal() > max.ordinal()) {
                    max = result3;
                }
                if (max != ConversionResult.ERROR) continue;
                ConversionResult conversionResult = ConversionResult.ERROR;
                if (conversionResult == null) {
                    TypesUtil.$$$reportNull$$$0(9);
                }
                return conversionResult;
            }
            ConversionResult conversionResult = max;
            if (conversionResult == null) {
                TypesUtil.$$$reportNull$$$0(10);
            }
            return conversionResult;
        }
        ConversionResult result4 = TypesUtil.areTypesConvertible(targetType, actualType, context, position);
        if (result4 != null) {
            ConversionResult conversionResult = result4;
            if (conversionResult == null) {
                TypesUtil.$$$reportNull$$$0(11);
            }
            return conversionResult;
        }
        if (TypesUtil.isAssignableWithoutConversions(targetType, actualType)) {
            ConversionResult conversionResult = ConversionResult.OK;
            if (conversionResult == null) {
                TypesUtil.$$$reportNull$$$0(12);
            }
            return conversionResult;
        }
        PsiManager manager = context.getManager();
        if ((targetType = TypesUtil.boxPrimitiveType(targetType, manager, scope = context.getResolveScope())).isAssignableFrom(actualType = TypesUtil.boxPrimitiveType(actualType, manager, scope))) {
            ConversionResult conversionResult = ConversionResult.OK;
            if (conversionResult == null) {
                TypesUtil.$$$reportNull$$$0(13);
            }
            return conversionResult;
        }
        ConversionResult conversionResult = ConversionResult.ERROR;
        if (conversionResult == null) {
            TypesUtil.$$$reportNull$$$0(14);
        }
        return conversionResult;
    }

    public static boolean isAssignableByMethodCallConversion(@Nullable PsiType targetType, @Nullable PsiType actualType, @NotNull PsiElement context) {
        if (context == null) {
            TypesUtil.$$$reportNull$$$0(15);
        }
        if (targetType == null || actualType == null) {
            return false;
        }
        return TypesUtil.canAssign(targetType, actualType, context, GrTypeConverter.ApplicableTo.METHOD_PARAMETER) == ConversionResult.OK;
    }

    public static boolean isAssignableByParameter(@Nullable PsiType targetType, @Nullable PsiType actualType, @NotNull PsiElement context) {
        if (context == null) {
            TypesUtil.$$$reportNull$$$0(16);
        }
        if (targetType == null || actualType == null) {
            return false;
        }
        return TypesUtil.canAssign(targetType, actualType, context, GrTypeConverter.ApplicableTo.GENERIC_PARAMETER) == ConversionResult.OK;
    }

    @Nullable
    private static ConversionResult areTypesConvertible(@NotNull PsiType targetType, @NotNull PsiType actualType, @NotNull PsiElement context, @NotNull GrTypeConverter.ApplicableTo position) {
        if (targetType == null) {
            TypesUtil.$$$reportNull$$$0(17);
        }
        if (actualType == null) {
            TypesUtil.$$$reportNull$$$0(18);
        }
        if (context == null) {
            TypesUtil.$$$reportNull$$$0(19);
        }
        if (position == null) {
            TypesUtil.$$$reportNull$$$0(20);
        }
        if (!(context instanceof GroovyPsiElement)) {
            return null;
        }
        if (targetType.equals(actualType)) {
            return ConversionResult.OK;
        }
        for (GrTypeConverter converter : (GrTypeConverter[])GrTypeConverter.EP_NAME.getExtensions()) {
            ConversionResult result2;
            if (!converter.isApplicableTo(position) || (result2 = converter.isConvertibleEx(targetType, actualType, (GroovyPsiElement)context, position)) == null) continue;
            return result2;
        }
        return null;
    }

    public static boolean isAssignableWithoutConversions(@Nullable PsiType lType, @Nullable PsiType rType) {
        if (lType == null || rType == null) {
            return false;
        }
        if (rType == PsiType.NULL) {
            return !(lType instanceof PsiPrimitiveType);
        }
        if (rType instanceof GrTraitType) {
            for (PsiType type2 : ((GrTraitType)rType).getConjuncts()) {
                if (!TypesUtil.isAssignableWithoutConversions(lType, type2)) continue;
                return true;
            }
            return false;
        }
        if (TypesUtil.isClassType(rType, "groovy.lang.GString") && lType.equalsToText("java.lang.String")) {
            return true;
        }
        lType = TypesUtil.optionalUnbox(lType);
        rType = TypesUtil.optionalUnbox(rType);
        return TypeConversionUtil.isAssignable((PsiType)lType, (PsiType)rType);
    }

    @NotNull
    public static ConversionResult canCast(@NotNull PsiType targetType, @NotNull PsiType actualType, @NotNull PsiElement context) {
        ConversionResult result2;
        if (targetType == null) {
            TypesUtil.$$$reportNull$$$0(21);
        }
        if (actualType == null) {
            TypesUtil.$$$reportNull$$$0(22);
        }
        if (context == null) {
            TypesUtil.$$$reportNull$$$0(23);
        }
        if ((result2 = TypesUtil.areTypesConvertible(targetType, actualType, context, GrTypeConverter.ApplicableTo.EXPLICIT_CAST)) != null) {
            ConversionResult conversionResult = result2;
            if (conversionResult == null) {
                TypesUtil.$$$reportNull$$$0(24);
            }
            return conversionResult;
        }
        ConversionResult conversionResult = TypeConversionUtil.areTypesConvertible((PsiType)actualType, (PsiType)targetType) ? ConversionResult.OK : ConversionResult.ERROR;
        if (conversionResult == null) {
            TypesUtil.$$$reportNull$$$0(25);
        }
        return conversionResult;
    }

    @NotNull
    public static ConversionResult canAssignWithinMultipleAssignment(@NotNull PsiType targetType, @NotNull PsiType actualType) {
        if (targetType == null) {
            TypesUtil.$$$reportNull$$$0(26);
        }
        if (actualType == null) {
            TypesUtil.$$$reportNull$$$0(27);
        }
        ConversionResult conversionResult = TypesUtil.isAssignableWithoutConversions(targetType, actualType) ? ConversionResult.OK : ConversionResult.ERROR;
        if (conversionResult == null) {
            TypesUtil.$$$reportNull$$$0(28);
        }
        return conversionResult;
    }

    public static boolean isNumericType(@Nullable PsiType type2) {
        if (type2 instanceof PsiClassType) {
            return TYPE_TO_RANK.contains((Object)TypesUtil.getQualifiedName(type2));
        }
        return type2 instanceof PsiPrimitiveType && TypeConversionUtil.isNumericType((PsiType)type2);
    }

    public static boolean isIntegralNumberType(@Nullable PsiType type2) {
        if (type2 instanceof PsiClassType) {
            int rank = TYPE_TO_RANK.get((Object)TypesUtil.getQualifiedName(type2));
            return rank > 0 && rank <= 6;
        }
        return type2 instanceof PsiPrimitiveType && TypeConversionUtil.isIntegralNumberType((PsiType)type2);
    }

    public static PsiType unboxPrimitiveTypeWrapperAndEraseGenerics(PsiType result2) {
        return TypeConversionUtil.erasure((PsiType)TypesUtil.unboxPrimitiveTypeWrapper(result2));
    }

    @NotNull
    public static PsiType optionalUnbox(@NotNull PsiType type2) {
        PsiType unboxed;
        if (type2 == null) {
            TypesUtil.$$$reportNull$$$0(29);
        }
        PsiType psiType = (unboxed = TypesUtil.unboxPrimitiveTypeWrapper(type2)) == null ? type2 : unboxed;
        if (psiType == null) {
            TypesUtil.$$$reportNull$$$0(30);
        }
        return psiType;
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiType unboxPrimitiveTypeWrapper(@Nullable PsiType type2) {
        PsiPrimitiveType unboxed = PsiPrimitiveType.getUnboxedType((PsiType)type2);
        return unboxed == null ? type2 : unboxed;
    }

    public static PsiType boxPrimitiveType(@Nullable PsiType result2, @NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope, boolean boxVoid) {
        PsiPrimitiveType primitive;
        String boxedTypeName;
        if (manager == null) {
            TypesUtil.$$$reportNull$$$0(31);
        }
        if (resolveScope == null) {
            TypesUtil.$$$reportNull$$$0(32);
        }
        if (result2 instanceof PsiPrimitiveType && (boxVoid || !PsiType.VOID.equals((Object)result2)) && (boxedTypeName = (primitive = (PsiPrimitiveType)result2).getBoxedTypeName()) != null) {
            return GroovyPsiManager.getInstance(manager.getProject()).createTypeByFQClassName(boxedTypeName, resolveScope);
        }
        return result2;
    }

    public static PsiType boxPrimitiveType(@Nullable PsiType result2, @NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope) {
        if (manager == null) {
            TypesUtil.$$$reportNull$$$0(33);
        }
        if (resolveScope == null) {
            TypesUtil.$$$reportNull$$$0(34);
        }
        return TypesUtil.boxPrimitiveType(result2, manager, resolveScope, false);
    }

    @NotNull
    public static PsiClassType createType(String fqName, @NotNull PsiElement context) {
        if (context == null) {
            TypesUtil.$$$reportNull$$$0(35);
        }
        PsiClassType psiClassType = TypesUtil.createTypeByFQClassName(fqName, context);
        if (psiClassType == null) {
            TypesUtil.$$$reportNull$$$0(36);
        }
        return psiClassType;
    }

    @NotNull
    public static PsiClassType createType(@NotNull PsiClass clazz) {
        if (clazz == null) {
            TypesUtil.$$$reportNull$$$0(37);
        }
        PsiClassType psiClassType = TypesUtil.createType(clazz, null, new PsiType[0]);
        if (psiClassType == null) {
            TypesUtil.$$$reportNull$$$0(38);
        }
        return psiClassType;
    }

    @NotNull
    public static PsiClassType createType(@NotNull PsiClass clazz, @Nullable PsiElement context, PsiType ... parameters) {
        if (clazz == null) {
            TypesUtil.$$$reportNull$$$0(39);
        }
        PsiClassType psiClassType = JavaPsiFacade.getInstance((Project)(context == null ? clazz : context).getProject()).getElementFactory().createType(clazz, parameters);
        if (psiClassType == null) {
            TypesUtil.$$$reportNull$$$0(40);
        }
        return psiClassType;
    }

    @NotNull
    public static PsiClassType getJavaLangObject(@NotNull PsiElement context) {
        if (context == null) {
            TypesUtil.$$$reportNull$$$0(41);
        }
        PsiClassType psiClassType = LazyFqnClassType.getLazyType("java.lang.Object", context);
        if (psiClassType == null) {
            TypesUtil.$$$reportNull$$$0(42);
        }
        return psiClassType;
    }

    @Nullable
    public static PsiType getLeastUpperBoundNullable(@Nullable PsiType type1, @Nullable PsiType type2, @NotNull PsiManager manager) {
        if (manager == null) {
            TypesUtil.$$$reportNull$$$0(43);
        }
        if (type1 == null) {
            return type2;
        }
        if (type2 == null) {
            return type1;
        }
        return TypesUtil.getLeastUpperBound(type1, type2, manager);
    }

    @Nullable
    public static PsiType getLeastUpperBoundNullable(@NotNull Iterable<? extends PsiType> collection, @NotNull PsiManager manager) {
        if (collection == null) {
            TypesUtil.$$$reportNull$$$0(44);
        }
        if (manager == null) {
            TypesUtil.$$$reportNull$$$0(45);
        }
        Iterator<? extends PsiType> iterator2 = collection.iterator();
        PsiType result2 = null;
        while (iterator2.hasNext()) {
            result2 = TypesUtil.getLeastUpperBoundNullable(result2, iterator2.next(), manager);
        }
        return result2;
    }

    @Nullable
    public static PsiType getLeastUpperBound(@NotNull PsiType type1, @NotNull PsiType type2, @NotNull PsiManager manager) {
        PsiType numericLUB;
        if (type1 == null) {
            TypesUtil.$$$reportNull$$$0(46);
        }
        if (type2 == null) {
            TypesUtil.$$$reportNull$$$0(47);
        }
        if (manager == null) {
            TypesUtil.$$$reportNull$$$0(48);
        }
        if ((numericLUB = TypesUtil.getNumericLUB(type1, type2)) != null) {
            return numericLUB;
        }
        if (type1 instanceof GrTupleType && type2 instanceof GrTupleType) {
            GrTupleType tuple1 = (GrTupleType)type1;
            GrTupleType tuple2 = (GrTupleType)type2;
            List<PsiType> components1 = tuple1.getComponentTypes();
            List<PsiType> components2 = tuple2.getComponentTypes();
            if (components1.isEmpty()) {
                return TypesUtil.genNewListBy(type2, manager);
            }
            if (components2.isEmpty()) {
                return TypesUtil.genNewListBy(type1, manager);
            }
            PsiType[] components3 = PsiType.createArray((int)Math.min(components1.size(), components2.size()));
            for (int i = 0; i < components3.length; ++i) {
                PsiType c1 = components1.get(i);
                PsiType c2 = components2.get(i);
                components3[i] = c1 == null || c2 == null ? null : TypesUtil.getLeastUpperBound(c1, c2, manager);
            }
            return new GrImmediateTupleType(Arrays.asList(components3), JavaPsiFacade.getInstance((Project)manager.getProject()), tuple1.getResolveScope().intersectWith(tuple2.getResolveScope()));
        }
        if (TypesUtil.checkEmptyListAndList(type1, type2)) {
            return TypesUtil.genNewListBy(type2, manager);
        }
        if (TypesUtil.checkEmptyListAndList(type2, type1)) {
            return TypesUtil.genNewListBy(type1, manager);
        }
        if (type1 instanceof GrMapType && type2 instanceof GrMapType) {
            return GrMapType.merge((GrMapType)type1, (GrMapType)type2);
        }
        if (TypesUtil.checkEmptyMapAndMap(type1, type2)) {
            return TypesUtil.genNewMapBy(type2, manager);
        }
        if (TypesUtil.checkEmptyMapAndMap(type2, type1)) {
            return TypesUtil.genNewMapBy(type1, manager);
        }
        if (type1 instanceof GrClosureType && type2 instanceof GrClosureType) {
            GrClosureType clType1 = (GrClosureType)type1;
            GrClosureType clType2 = (GrClosureType)type2;
            List<GrSignature> signatures1 = clType1.getSignatures();
            List<GrSignature> signatures2 = clType2.getSignatures();
            if (signatures1.size() == 1 && signatures2.size() == 1) {
                GrSignature signature;
                GrSignature signature1 = signatures1.get(0);
                GrSignature signature2 = signatures2.get(0);
                if (signature1.getParameterCount() == signature2.getParameterCount() && (signature = GrImmediateClosureSignatureImpl.getLeastUpperBound(signature1, signature2, manager)) != null) {
                    GlobalSearchScope scope = clType1.getResolveScope().intersectWith(clType2.getResolveScope());
                    LanguageLevel languageLevel = (LanguageLevel)ComparatorUtil.max((Comparable)clType1.getLanguageLevel(), (Comparable)clType2.getLanguageLevel());
                    return GrClosureType.create(Collections.singletonList(signature), scope, JavaPsiFacade.getInstance((Project)manager.getProject()), languageLevel, true);
                }
            }
        } else {
            if ("groovy.lang.GString".equals(TypesUtil.getQualifiedName(type1)) && "java.lang.String".equals(TypesUtil.getQualifiedName(type2))) {
                return type2;
            }
            if ("groovy.lang.GString".equals(TypesUtil.getQualifiedName(type2)) && "java.lang.String".equals(TypesUtil.getQualifiedName(type1))) {
                return type1;
            }
        }
        return GenericsUtil.getLeastUpperBound((PsiType)type1, (PsiType)type2, (PsiManager)manager);
    }

    @Nullable
    private static PsiType getNumericLUB(@Nullable PsiType type1, @Nullable PsiType type2) {
        PsiPrimitiveType unboxedType1 = PsiPrimitiveType.getOptionallyUnboxedType((PsiType)type1);
        PsiPrimitiveType unboxedType2 = PsiPrimitiveType.getOptionallyUnboxedType((PsiType)type2);
        if (unboxedType1 != null && unboxedType2 != null) {
            int i1 = LUB_NUMERIC_TYPES.indexOf(unboxedType1);
            int i2 = LUB_NUMERIC_TYPES.indexOf(unboxedType2);
            if (i1 >= 0 && i2 >= 0) {
                return i1 > i2 ? type1 : type2;
            }
        }
        return null;
    }

    private static boolean checkEmptyListAndList(PsiType type1, PsiType type2) {
        List<PsiType> types;
        return type1 instanceof GrTupleType && (types = ((GrTupleType)type1).getComponentTypes()).isEmpty() && InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.List");
    }

    private static PsiType genNewListBy(PsiType genericOwner, @NotNull PsiManager manager) {
        if (manager == null) {
            TypesUtil.$$$reportNull$$$0(49);
        }
        PsiClass list = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.util.List", genericOwner.getResolveScope());
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)manager.getProject());
        if (list == null) {
            return factory.createTypeFromText("java.util.List", null);
        }
        return factory.createType(list, PsiUtil.extractIterableTypeParameter((PsiType)genericOwner, (boolean)false));
    }

    private static boolean checkEmptyMapAndMap(PsiType type1, PsiType type2) {
        return type1 instanceof GrMapType && ((GrMapType)type1).isEmpty() && InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.Map");
    }

    private static PsiType genNewMapBy(PsiType genericOwner, PsiManager manager) {
        PsiClass map2 = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.util.Map", genericOwner.getResolveScope());
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)manager.getProject());
        if (map2 == null) {
            return factory.createTypeFromText("java.util.Map", null);
        }
        PsiType key = PsiUtil.substituteTypeParameter((PsiType)genericOwner, (String)"java.util.Map", (int)0, (boolean)false);
        PsiType value = PsiUtil.substituteTypeParameter((PsiType)genericOwner, (String)"java.util.Map", (int)1, (boolean)false);
        return factory.createType(map2, new PsiType[]{key, value});
    }

    @Nullable
    public static PsiType getPsiType(PsiElement context, IElementType elemType) {
        if (elemType == GroovyTokenTypes.kNULL) {
            return PsiType.NULL;
        }
        String typeName = TypesUtil.getBoxedTypeName(elemType);
        if (typeName != null) {
            return TypesUtil.createTypeByFQClassName(typeName, context);
        }
        return null;
    }

    @Nullable
    public static String getBoxedTypeName(IElementType elemType) {
        return ourPrimitiveTypesToClassNames.get(elemType);
    }

    @NotNull
    public static PsiType getLeastUpperBound(PsiType[] classes2, PsiManager manager) {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)manager.getProject());
        if (classes2.length == 0) {
            PsiClassType psiClassType = factory.createTypeByFQClassName("java.lang.Object");
            if (psiClassType == null) {
                TypesUtil.$$$reportNull$$$0(50);
            }
            return psiClassType;
        }
        PsiType type2 = classes2[0];
        for (int i = 1; i < classes2.length; ++i) {
            PsiType t = TypesUtil.getLeastUpperBound(type2, classes2[i], manager);
            if (t == null) continue;
            type2 = t;
        }
        PsiType psiType = type2;
        if (psiType == null) {
            TypesUtil.$$$reportNull$$$0(51);
        }
        return psiType;
    }

    @Contract(value="null, _ -> false")
    public static boolean isClassType(@Nullable PsiType type2, @NotNull String qName) {
        if (qName == null) {
            TypesUtil.$$$reportNull$$$0(52);
        }
        return qName.equals(TypesUtil.getQualifiedName(type2));
    }

    @Contract(value="null, _ -> false")
    public static boolean isClassType(@Nullable PsiType type2, String ... names) {
        String fqn;
        if (names == null) {
            TypesUtil.$$$reportNull$$$0(53);
        }
        if ((fqn = TypesUtil.getQualifiedName(type2)) == null) {
            return false;
        }
        return ContainerUtil.or((Object[])names, it -> it.equals(fqn));
    }

    public static PsiSubstitutor composeSubstitutors(PsiSubstitutor s1, PsiSubstitutor s2) {
        Map map2 = s1.getSubstitutionMap();
        THashMap result2 = new THashMap(map2.size());
        for (PsiTypeParameter parameter : map2.keySet()) {
            result2.put(parameter, s2.substitute((PsiType)map2.get(parameter)));
        }
        Map map22 = s2.getSubstitutionMap();
        for (PsiTypeParameter parameter : map22.keySet()) {
            if (result2.containsKey(parameter)) continue;
            result2.put(parameter, map22.get(parameter));
        }
        return PsiSubstitutorImpl.createSubstitutor((Map)result2);
    }

    @NotNull
    public static PsiClassType createTypeByFQClassName(@NotNull String fqName, @NotNull PsiElement context) {
        if (fqName == null) {
            TypesUtil.$$$reportNull$$$0(54);
        }
        if (context == null) {
            TypesUtil.$$$reportNull$$$0(55);
        }
        PsiClassType psiClassType = GroovyPsiManager.getInstance(context.getProject()).createTypeByFQClassName(fqName, context.getResolveScope());
        if (psiClassType == null) {
            TypesUtil.$$$reportNull$$$0(56);
        }
        return psiClassType;
    }

    @Nullable
    public static PsiType createJavaLangClassType(@Nullable PsiType type2, @NotNull PsiElement context) {
        if (context == null) {
            TypesUtil.$$$reportNull$$$0(57);
        }
        return TypesUtil.createJavaLangClassType(type2, context.getProject(), context.getResolveScope());
    }

    @Nullable
    public static PsiType createJavaLangClassType(@Nullable PsiType type2, Project project, GlobalSearchScope resolveScope) {
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        PsiClassType result2 = null;
        PsiClass javaLangClass = facade.findClass("java.lang.Class", resolveScope);
        if (javaLangClass != null) {
            PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
            PsiTypeParameter[] typeParameters = javaLangClass.getTypeParameters();
            if (typeParameters.length == 1) {
                substitutor = substitutor.put(typeParameters[0], type2);
            }
            result2 = facade.getElementFactory().createType(javaLangClass, substitutor);
        }
        return result2;
    }

    @NotNull
    public static PsiPrimitiveType getPrimitiveTypeByText(String typeText) {
        for (PsiPrimitiveType primitive : PRIMITIVES) {
            if (PsiType.VOID.equals((Object)primitive)) {
                PsiPrimitiveType psiPrimitiveType = primitive;
                if (psiPrimitiveType == null) {
                    TypesUtil.$$$reportNull$$$0(58);
                }
                return psiPrimitiveType;
            }
            if (!primitive.getCanonicalText().equals(typeText)) continue;
            PsiPrimitiveType psiPrimitiveType = primitive;
            if (psiPrimitiveType == null) {
                TypesUtil.$$$reportNull$$$0(59);
            }
            return psiPrimitiveType;
        }
        assert (false) : "Unknown primitive type";
        if (null == null) {
            TypesUtil.$$$reportNull$$$0(60);
        }
        return null;
    }

    @NotNull
    public static PsiClassType createGenericType(@NotNull String fqn, @NotNull PsiElement context, @Nullable PsiType type2) {
        GlobalSearchScope resolveScope;
        JavaPsiFacade facade;
        PsiClass clazz;
        if (fqn == null) {
            TypesUtil.$$$reportNull$$$0(61);
        }
        if (context == null) {
            TypesUtil.$$$reportNull$$$0(62);
        }
        if ((clazz = (facade = JavaPsiFacade.getInstance((Project)context.getProject())).findClass(fqn, resolveScope = context.getResolveScope())) == null || clazz.getTypeParameters().length != 1) {
            PsiClassType psiClassType = facade.getElementFactory().createTypeByFQClassName(fqn, resolveScope);
            if (psiClassType == null) {
                TypesUtil.$$$reportNull$$$0(63);
            }
            return psiClassType;
        }
        PsiClassType psiClassType = type2 == null ? facade.getElementFactory().createType(clazz) : facade.getElementFactory().createType(clazz, type2);
        if (psiClassType == null) {
            TypesUtil.$$$reportNull$$$0(64);
        }
        return psiClassType;
    }

    @NotNull
    public static PsiClassType createIterableType(@NotNull PsiElement context, @Nullable PsiType type2) {
        if (context == null) {
            TypesUtil.$$$reportNull$$$0(65);
        }
        PsiClassType psiClassType = TypesUtil.createGenericType("java.lang.Iterable", context, type2);
        if (psiClassType == null) {
            TypesUtil.$$$reportNull$$$0(66);
        }
        return psiClassType;
    }

    @NotNull
    public static PsiClassType createListType(@NotNull PsiElement context, @Nullable PsiType type2) {
        if (context == null) {
            TypesUtil.$$$reportNull$$$0(67);
        }
        PsiType boxedType = TypesUtil.boxPrimitiveType(type2, context.getManager(), context.getResolveScope());
        PsiClassType psiClassType = TypesUtil.createGenericType("java.util.List", context, boxedType);
        if (psiClassType == null) {
            TypesUtil.$$$reportNull$$$0(68);
        }
        return psiClassType;
    }

    @NotNull
    public static PsiClassType createListType(@NotNull PsiClass elements) {
        if (elements == null) {
            TypesUtil.$$$reportNull$$$0(69);
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)elements.getProject());
        PsiClassType psiClassType = TypesUtil.createGenericType("java.util.List", (PsiElement)elements, (PsiType)facade.getElementFactory().createType(elements));
        if (psiClassType == null) {
            TypesUtil.$$$reportNull$$$0(70);
        }
        return psiClassType;
    }

    @NotNull
    public static PsiType createSetType(@NotNull PsiElement context, @NotNull PsiType type2) {
        if (context == null) {
            TypesUtil.$$$reportNull$$$0(71);
        }
        if (type2 == null) {
            TypesUtil.$$$reportNull$$$0(72);
        }
        PsiClassType psiClassType = TypesUtil.createGenericType("java.util.Set", context, type2);
        if (psiClassType == null) {
            TypesUtil.$$$reportNull$$$0(73);
        }
        return psiClassType;
    }

    public static boolean isAnnotatedCheckHierarchyWithCache(@NotNull PsiClass aClass, @NotNull String annotationFQN) {
        if (aClass == null) {
            TypesUtil.$$$reportNull$$$0(74);
        }
        if (annotationFQN == null) {
            TypesUtil.$$$reportNull$$$0(75);
        }
        Map<String, PsiClass> classMap = ClassUtil.getSuperClassesWithCache(aClass);
        for (PsiClass psiClass : classMap.values()) {
            PsiModifierList modifierList = psiClass.getModifierList();
            if (modifierList == null || !modifierList.hasAnnotation(annotationFQN)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiType substituteAndNormalizeType(@Nullable PsiType type2, @NotNull PsiSubstitutor substitutor, @Nullable SpreadState state, @NotNull GrExpression expression) {
        if (substitutor == null) {
            TypesUtil.$$$reportNull$$$0(76);
        }
        if (expression == null) {
            TypesUtil.$$$reportNull$$$0(77);
        }
        if (type2 == null) {
            return null;
        }
        if ((type2 = substitutor.substitute(type2)) == null) {
            return null;
        }
        type2 = PsiImplUtil.normalizeWildcardTypeByPosition(type2, expression);
        type2 = SpreadState.apply(type2, state, expression.getProject());
        return type2;
    }

    @Nullable
    public static PsiType getItemType(@Nullable PsiType containerType) {
        if (containerType == null) {
            return null;
        }
        if (containerType instanceof PsiArrayType) {
            return ((PsiArrayType)containerType).getComponentType();
        }
        return PsiUtil.extractIterableTypeParameter((PsiType)containerType, (boolean)false);
    }

    @Nullable
    public static PsiType inferAnnotationMemberValueType(GrAnnotationMemberValue value) {
        if (value instanceof GrExpression) {
            return ((GrExpression)value).getType();
        }
        if (value instanceof GrAnnotation) {
            PsiElement resolved = ((GrAnnotation)value).getClassReference().resolve();
            if (resolved instanceof PsiClass) {
                return JavaPsiFacade.getElementFactory((Project)value.getProject()).createType((PsiClass)resolved, PsiSubstitutor.EMPTY);
            }
            return null;
        }
        if (value instanceof GrAnnotationArrayInitializer) {
            return TypesUtil.getTupleByAnnotationArrayInitializer((GrAnnotationArrayInitializer)value);
        }
        return null;
    }

    public static PsiType getTupleByAnnotationArrayInitializer(final GrAnnotationArrayInitializer value) {
        return new GrTupleType(value.getResolveScope(), JavaPsiFacade.getInstance((Project)value.getProject())){

            @Override
            @NotNull
            protected List<PsiType> inferComponents() {
                Object[] initializers = value.getInitializers();
                List list = ContainerUtil.map((Object[])initializers, TypesUtil::inferAnnotationMemberValueType);
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list;
            }

            public boolean isValid() {
                return value.isValid();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil$1", "inferComponents"));
            }
        };
    }

    public static boolean resolvesTo(PsiType type2, String fqn) {
        if (type2 instanceof PsiClassType) {
            PsiClass resolved = ((PsiClassType)type2).resolve();
            return resolved != null && fqn.equals(resolved.getQualifiedName());
        }
        return false;
    }

    @Nullable
    public static PsiType rawSecondGeneric(PsiType type2, Project project) {
        if (!(type2 instanceof PsiClassType)) {
            return null;
        }
        PsiClassType.ClassResolveResult result2 = ((PsiClassType)type2).resolveGenerics();
        PsiClass element = result2.getElement();
        if (element == null) {
            return null;
        }
        PsiType[] parameters = ((PsiClassType)type2).getParameters();
        boolean changed = false;
        PsiType[] newParameters = new PsiType[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            PsiType parameter = parameters[i];
            if (parameter == null) continue;
            final Ref newParam = new Ref();
            parameter.accept((PsiTypeVisitor)new PsiTypeVisitorEx<Object>(){

                @Nullable
                public Object visitClassType(PsiClassType classType) {
                    newParam.set((Object)classType.rawType());
                    return null;
                }

                @Nullable
                public Object visitCapturedWildcardType(PsiCapturedWildcardType capturedWildcardType) {
                    newParam.set((Object)capturedWildcardType.getWildcard().getBound());
                    return null;
                }

                @Nullable
                public Object visitWildcardType(PsiWildcardType wildcardType) {
                    newParam.set((Object)wildcardType.getBound());
                    return null;
                }
            });
            if (newParam.isNull()) continue;
            changed = true;
            newParameters[i] = (PsiType)newParam.get();
        }
        if (!changed) {
            return null;
        }
        return JavaPsiFacade.getElementFactory((Project)project).createType(element, newParameters);
    }

    @Nullable
    public static PsiType rawWildcard(PsiType type2, final PsiElement context) {
        GrTypeMapper visitor2 = new GrTypeMapper(context){

            public PsiType visitCapturedWildcardType(PsiCapturedWildcardType capturedWildcardType) {
                return TypesUtil.getJavaLangObject(context);
            }

            public PsiType visitWildcardType(PsiWildcardType capturedWildcardType) {
                return TypesUtil.getJavaLangObject(context);
            }
        };
        return (PsiType)type2.accept((PsiTypeVisitor)visitor2);
    }

    public static boolean isPsiClassTypeToClosure(PsiType type2) {
        if (!(type2 instanceof PsiClassType)) {
            return false;
        }
        PsiClass psiClass = ((PsiClassType)type2).resolve();
        if (psiClass == null) {
            return false;
        }
        return "groovy.lang.Closure".equals(psiClass.getQualifiedName());
    }

    @Nullable
    public static String getQualifiedName(@Nullable PsiType type2) {
        if (type2 instanceof PsiClassType) {
            PsiClass resolved = ((PsiClassType)type2).resolve();
            if (resolved instanceof PsiAnonymousClass) {
                return "anonymous " + TypesUtil.getQualifiedName((PsiType)((PsiAnonymousClass)resolved).getBaseClassType());
            }
            if (resolved != null) {
                return resolved.getQualifiedName();
            }
            return PsiNameHelper.getQualifiedClassName((String)type2.getCanonicalText(), (boolean)true);
        }
        return null;
    }

    public static boolean isEnum(PsiType type2) {
        if (type2 instanceof PsiClassType) {
            PsiClass resolved = ((PsiClassType)type2).resolve();
            return resolved != null && resolved.isEnum();
        }
        return false;
    }

    static {
        ourPrimitiveTypesToClassNames.put(GroovyElementTypes.STRING_SQ, "java.lang.String");
        ourPrimitiveTypesToClassNames.put(GroovyElementTypes.STRING_TSQ, "java.lang.String");
        ourPrimitiveTypesToClassNames.put(GroovyElementTypes.STRING_DQ, "java.lang.String");
        ourPrimitiveTypesToClassNames.put(GroovyElementTypes.STRING_TDQ, "java.lang.String");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.mREGEX_LITERAL, "java.lang.String");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.mDOLLAR_SLASH_REGEX_LITERAL, "java.lang.String");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.mNUM_INT, "java.lang.Integer");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.mNUM_LONG, "java.lang.Long");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.mNUM_FLOAT, "java.lang.Float");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.mNUM_DOUBLE, "java.lang.Double");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.mNUM_BIG_INT, "java.math.BigInteger");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.mNUM_BIG_DECIMAL, "java.math.BigDecimal");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.kFALSE, "java.lang.Boolean");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.kTRUE, "java.lang.Boolean");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.kNULL, NULL);
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.kINT, "java.lang.Integer");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.kLONG, "java.lang.Long");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.kFLOAT, "java.lang.Float");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.kDOUBLE, "java.lang.Double");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.kBOOLEAN, "java.lang.Boolean");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.kCHAR, "java.lang.Character");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.kBYTE, "java.lang.Byte");
        ourUnaryOperationsToOperatorNames = new HashMap<IElementType, String>();
        ourUnaryOperationsToOperatorNames.put(GroovyTokenTypes.mLNOT, "asBoolean");
        ourUnaryOperationsToOperatorNames.put(GroovyTokenTypes.mPLUS, "positive");
        ourUnaryOperationsToOperatorNames.put(GroovyTokenTypes.mMINUS, "negative");
        ourUnaryOperationsToOperatorNames.put(GroovyTokenTypes.mDEC, "previous");
        ourUnaryOperationsToOperatorNames.put(GroovyTokenTypes.mINC, "next");
        ourUnaryOperationsToOperatorNames.put(GroovyTokenTypes.mBNOT, "bitwiseNegate");
        TYPE_TO_RANK = new TObjectIntHashMap();
        TYPE_TO_RANK.put((Object)"java.lang.Byte", 1);
        TYPE_TO_RANK.put((Object)"java.lang.Character", 2);
        TYPE_TO_RANK.put((Object)"java.lang.Short", 3);
        TYPE_TO_RANK.put((Object)"java.lang.Integer", 4);
        TYPE_TO_RANK.put((Object)"java.lang.Long", 5);
        TYPE_TO_RANK.put((Object)"java.math.BigInteger", 6);
        TYPE_TO_RANK.put((Object)"java.math.BigDecimal", 7);
        TYPE_TO_RANK.put((Object)"java.lang.Float", 8);
        TYPE_TO_RANK.put((Object)"java.lang.Double", 9);
        TYPE_TO_RANK.put((Object)"java.lang.Number", 10);
        RANK_TO_TYPE = new TIntObjectHashMap();
        TYPE_TO_RANK.forEachEntry((fqn, rank) -> {
            RANK_TO_TYPE.put(rank, fqn);
            return true;
        });
        LUB_NUMERIC_TYPES = ContainerUtil.newArrayList((Object[])new PsiType[]{PsiType.BYTE, PsiType.SHORT, PsiType.INT, PsiType.LONG, PsiType.FLOAT, PsiType.DOUBLE});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 24: 
            case 25: 
            case 28: 
            case 30: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 50: 
            case 51: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 63: 
            case 64: 
            case 66: 
            case 68: 
            case 70: 
            case 73: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 24: 
            case 25: 
            case 28: 
            case 30: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 50: 
            case 51: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 63: 
            case 64: 
            case 66: 
            case 68: 
            case 70: 
            case 73: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 2: 
            case 5: 
            case 15: 
            case 16: 
            case 19: 
            case 23: 
            case 35: 
            case 41: 
            case 55: 
            case 57: 
            case 62: 
            case 65: 
            case 67: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 17: 
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
            case 4: 
            case 18: 
            case 22: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualType";
                break;
            }
            case 6: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 24: 
            case 25: 
            case 28: 
            case 30: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 50: 
            case 51: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 63: 
            case 64: 
            case 66: 
            case 68: 
            case 70: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil";
                break;
            }
            case 29: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 31: 
            case 33: 
            case 43: 
            case 45: 
            case 48: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveScope";
                break;
            }
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type1";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type2";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFQN";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "canAssign";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "canCast";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "canAssignWithinMultipleAssignment";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "optionalUnbox";
                break;
            }
            case 36: 
            case 38: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "createType";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaLangObject";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeastUpperBound";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeByFQClassName";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrimitiveTypeByText";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "createGenericType";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "createIterableType";
                break;
            }
            case 68: 
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "createListType";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "createSetType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOverloadedUnaryOperatorCandidates";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAssignable";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "canAssign";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 24: 
            case 25: 
            case 28: 
            case 30: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 50: 
            case 51: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 63: 
            case 64: 
            case 66: 
            case 68: 
            case 70: 
            case 73: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableByMethodCallConversion";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableByParameter";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "areTypesConvertible";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "canCast";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "canAssignWithinMultipleAssignment";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "optionalUnbox";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "boxPrimitiveType";
                break;
            }
            case 35: 
            case 37: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getJavaLangObject";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getLeastUpperBoundNullable";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getLeastUpperBound";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "genNewListBy";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "isClassType";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "createTypeByFQClassName";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "createJavaLangClassType";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "createGenericType";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "createIterableType";
                break;
            }
            case 67: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "createListType";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "createSetType";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "isAnnotatedCheckHierarchyWithCache";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "substituteAndNormalizeType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 24: 
            case 25: 
            case 28: 
            case 30: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 50: 
            case 51: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 63: 
            case 64: 
            case 66: 
            case 68: 
            case 70: 
            case 73: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

