/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import gnu.trove.THashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.GroovyTokenSets;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyReference;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.SpreadState;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrReassignedLocalVarsChecker;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrReferenceElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyTargetElementEvaluator;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrLValueExpressionReference;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrRValueExpressionReference;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrReferenceTypeEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.util.GdkMethodUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyLValueUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.DependentResolver;
import org.jetbrains.plugins.groovy.lang.resolve.GroovyResolver;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyProperty;
import org.jetbrains.plugins.groovy.lang.resolve.impl.IncompleteKt;
import org.jetbrains.plugins.groovy.lang.resolve.references.GrExplicitMethodCallReference;
import org.jetbrains.plugins.groovy.lang.resolve.references.GrStaticExpressionReference;
import org.jetbrains.plugins.groovy.lang.typing.DefaultMethodCallTypeCalculatorKt;
import org.jetbrains.plugins.groovy.lang.typing.GrTypeCalculator;

public class GrReferenceExpressionImpl
extends GrReferenceElementImpl<GrExpression>
implements GrReferenceExpression {
    private static final Logger LOG = Logger.getInstance(GrReferenceExpressionImpl.class);
    private final GroovyReference myStaticReference;
    private final Lazy<GroovyReference> myCallReference;
    private final Lazy<GroovyReference> myRValueReference;
    private final Lazy<GroovyReference> myLValueReference;
    private static final GroovyResolver<GrReferenceExpressionImpl> RESOLVER = new DependentResolver<GrReferenceExpressionImpl>(){

        @Override
        @Nullable
        public Collection<PsiPolyVariantReference> collectDependencies(@NotNull GrReferenceExpressionImpl expression) {
            GrExpression qualifier;
            if (expression == null) {
                1.$$$reportNull$$$0(0);
            }
            if ((qualifier = expression.getQualifier()) == null) {
                return null;
            }
            SmartList result2 = new SmartList();
            qualifier.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor((List)result2){
                final /* synthetic */ List val$result;
                {
                    this.val$result = list;
                }

                public void visitElement(PsiElement element) {
                    GrExpression operand;
                    if (element instanceof GrReferenceExpression) {
                        super.visitElement(element);
                    } else if (element instanceof GrMethodCall) {
                        super.visitElement((PsiElement)((GrMethodCall)element).getInvokedExpression());
                    } else if (element instanceof GrParenthesizedExpression && (operand = ((GrParenthesizedExpression)element).getOperand()) != null) {
                        super.visitElement((PsiElement)operand);
                    }
                }

                protected void elementFinished(PsiElement element) {
                    if (element instanceof GrReferenceExpression) {
                        this.val$result.add((GrReferenceExpression)element);
                    }
                }
            });
            return result2;
        }

        @Override
        @NotNull
        public Collection<GroovyResolveResult> doResolve(@NotNull GrReferenceExpressionImpl ref, boolean incomplete) {
            if (ref == null) {
                1.$$$reportNull$$$0(1);
            }
            GroovyReference rValueRef = (GroovyReference)ref.myRValueReference.getValue();
            GroovyReference lValueRef = (GroovyReference)ref.myLValueReference.getValue();
            if (rValueRef != null && lValueRef != null) {
                THashMap results = new THashMap();
                for (GroovyResolveResult groovyResolveResult : rValueRef.resolve(false)) {
                    results.putIfAbsent(groovyResolveResult.getElement(), groovyResolveResult);
                }
                for (GroovyResolveResult groovyResolveResult : lValueRef.resolve(false)) {
                    results.putIfAbsent(groovyResolveResult.getElement(), groovyResolveResult);
                }
                SmartList smartList = new SmartList(results.values());
                if (smartList == null) {
                    1.$$$reportNull$$$0(2);
                }
                return smartList;
            }
            if (rValueRef != null) {
                SmartList smartList = new SmartList(rValueRef.resolve(false));
                if (smartList == null) {
                    1.$$$reportNull$$$0(3);
                }
                return smartList;
            }
            if (lValueRef != null) {
                SmartList smartList = new SmartList(lValueRef.resolve(false));
                if (smartList == null) {
                    1.$$$reportNull$$$0(4);
                }
                return smartList;
            }
            LOG.error("Reference expression has no references");
            List<GroovyResolveResult> list = Collections.emptyList();
            if (list == null) {
                1.$$$reportNull$$$0(5);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl$1";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doResolve";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "collectDependencies";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "doResolve";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    private static final GroovyResolver<GrReferenceExpression> INCOMPLETE_RESOLVER = (ref, inc) -> IncompleteKt.resolveIncomplete(ref);

    public GrReferenceExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            GrReferenceExpressionImpl.$$$reportNull$$$0(0);
        }
        super(node);
        this.myStaticReference = new GrStaticExpressionReference(this);
        this.myCallReference = LazyKt.lazy(() -> this.getParent() instanceof GrMethodCall && !this.isImplicitCallReceiver() ? new GrExplicitMethodCallReference(this) : null);
        this.myRValueReference = LazyKt.lazy(() -> GroovyLValueUtil.isRValue(this) ? new GrRValueExpressionReference(this) : null);
        this.myLValueReference = LazyKt.lazy(() -> {
            Argument rValue = GroovyLValueUtil.getRValue(this);
            return rValue == null ? null : new GrLValueExpressionReference(this, rValue);
        });
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        if (visitor2 == null) {
            GrReferenceExpressionImpl.$$$reportNull$$$0(1);
        }
        visitor2.visitReferenceExpression(this);
    }

    @Override
    @Nullable
    public PsiElement getReferenceNameElement() {
        return this.findChildByType(TokenSets.REFERENCE_NAMES);
    }

    @Override
    @Nullable
    public GrExpression getQualifier() {
        return this.getQualifierExpression();
    }

    @Override
    @Nullable
    public String getReferenceName() {
        PsiElement nameElement = this.getReferenceNameElement();
        if (nameElement != null) {
            Object value;
            IElementType nodeType = nameElement.getNode().getElementType();
            if (TokenSets.STRING_LITERAL_SET.contains(nodeType) && (value = GrLiteralImpl.getLiteralValue(nameElement)) instanceof String) {
                return (String)value;
            }
            return nameElement.getText();
        }
        return null;
    }

    @Override
    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        String name;
        if (newElementName == null) {
            GrReferenceExpressionImpl.$$$reportNull$$$0(2);
        }
        if (!PsiUtil.isValidReferenceName(newElementName)) {
            PsiElement old = this.getReferenceNameElement();
            if (old == null) {
                throw new IncorrectOperationException("ref has no name element");
            }
            PsiElement element = GroovyPsiElementFactory.getInstance(this.getProject()).createStringLiteralForReference(newElementName);
            old.replace(element);
            return this;
        }
        if (PsiUtil.isThisOrSuperRef(this)) {
            return this;
        }
        GroovyResolveResult result2 = this.advancedResolve();
        if (result2.isInvokedOnProperty() && (name = GroovyPropertyUtils.getPropertyNameByAccessorName(newElementName)) != null) {
            newElementName = name;
        }
        return super.handleElementRename(newElementName);
    }

    @Override
    @NotNull
    protected GrReferenceElement<GrExpression> createQualifiedRef(@NotNull String qName) {
        if (qName == null) {
            GrReferenceExpressionImpl.$$$reportNull$$$0(3);
        }
        GrReferenceExpression grReferenceExpression = GroovyPsiElementFactory.getInstance(this.getProject()).createReferenceExpressionFromText(qName);
        if (grReferenceExpression == null) {
            GrReferenceExpressionImpl.$$$reportNull$$$0(4);
        }
        return grReferenceExpression;
    }

    @Override
    public boolean isFullyQualified() {
        if (!this.hasMemberPointer() && !ResolveUtil.canResolveToMethod(this) && this.resolve() instanceof PsiPackage) {
            return true;
        }
        GrExpression qualifier = this.getQualifier();
        if (!(qualifier instanceof GrReferenceExpressionImpl)) {
            return false;
        }
        return ((GrReferenceExpressionImpl)qualifier).isFullyQualified();
    }

    public String toString() {
        return "Reference expression";
    }

    @Override
    @Nullable
    public PsiType getNominalType() {
        return this.getNominalType(false);
    }

    @Nullable
    private PsiType getNominalType(boolean rValue) {
        GroovyResolveResult resolveResult2 = PsiImplUtil.extractUniqueResult(this.lrResolve(rValue));
        PsiElement resolved = resolveResult2.getElement();
        for (GrReferenceTypeEnhancer enhancer : (GrReferenceTypeEnhancer[])GrReferenceTypeEnhancer.EP_NAME.getExtensions()) {
            PsiType type2 = enhancer.getReferenceType(this, resolved);
            if (type2 == null) continue;
            return type2;
        }
        PsiType result2 = this.getNominalTypeInner(resolveResult2);
        if (result2 == null) {
            return null;
        }
        result2 = TypesUtil.substituteAndNormalizeType(result2, resolveResult2.getSubstitutor(), resolveResult2.getSpreadState(), this);
        return result2;
    }

    @Nullable
    private PsiType getNominalTypeInner(GroovyResolveResult result2) {
        PsiElement resolved = result2.getElement();
        if (resolved instanceof GroovyProperty) {
            return ((GroovyProperty)resolved).getPropertyType();
        }
        if (resolved == null && !"class".equals(this.getReferenceName())) {
            resolved = this.resolve();
        }
        if (resolved instanceof PsiClass) {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory();
            if (PsiUtil.isInstanceThisRef(this)) {
                PsiClassType categoryType = GdkMethodUtil.getCategoryType((PsiClass)resolved);
                if (categoryType != null) {
                    return categoryType;
                }
                return factory.createType((PsiClass)resolved);
            }
            if (PsiUtil.isSuperReference(this)) {
                PsiClass contextClass = PsiUtil.getContextClass(this);
                if (GrTraitUtil.isTrait(contextClass)) {
                    Object[] extendsTypes = contextClass.getExtendsListTypes();
                    Object[] implementsTypes = contextClass.getImplementsListTypes();
                    Object[] superTypes = (PsiClassType[])ArrayUtil.mergeArrays((Object[])implementsTypes, (Object[])extendsTypes, (ArrayFactory)PsiClassType.ARRAY_FACTORY);
                    if (superTypes.length > 0) {
                        return PsiIntersectionType.createIntersection((PsiType[])((PsiType[])ArrayUtil.reverseArray((Object[])superTypes)));
                    }
                }
                return factory.createType((PsiClass)resolved);
            }
            return TypesUtil.createJavaLangClassType((PsiType)factory.createType((PsiClass)resolved), this);
        }
        if (resolved instanceof GrVariable) {
            return ((GrVariable)resolved).getDeclaredType();
        }
        if (resolved instanceof PsiVariable) {
            return ((PsiVariable)resolved).getType();
        }
        if (resolved instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)resolved;
            if (PropertyUtilBase.isSimplePropertySetter((PsiMethod)method) && !method.getName().equals(this.getReferenceName())) {
                return method.getParameterList().getParameters()[0].getType();
            }
            if (result2 instanceof GroovyMethodResult) {
                return DefaultMethodCallTypeCalculatorKt.getTypeFromCandidate((GroovyMethodResult)result2, this);
            }
            return PsiUtil.getSmartReturnType(method);
        }
        if (resolved == null) {
            PsiType fromClassRef;
            if ("class".equals(this.getReferenceName()) && (fromClassRef = this.getTypeFromClassRef()) != null) {
                return fromClassRef;
            }
            PsiType fromSpreadOperator = GrReferenceExpressionImpl.getTypeFromSpreadOperator(this);
            if (fromSpreadOperator != null) {
                return fromSpreadOperator;
            }
        }
        return null;
    }

    @Nullable
    private static PsiType getTypeFromSpreadOperator(@NotNull GrReferenceExpressionImpl ref) {
        if (ref == null) {
            GrReferenceExpressionImpl.$$$reportNull$$$0(5);
        }
        if (ref.getDotTokenType() == GroovyTokenTypes.mSPREAD_DOT) {
            return TypesUtil.createType("java.util.List", ref);
        }
        return null;
    }

    @Nullable
    private PsiType getTypeFromClassRef() {
        PsiType qualifierType = PsiImplUtil.getQualifierType(this);
        if (qualifierType == null && !PsiUtil.isCompileStatic(this)) {
            return null;
        }
        return TypesUtil.createJavaLangClassType(qualifierType, this);
    }

    @Nullable
    private static PsiType calculateType(@NotNull GrReferenceExpressionImpl refExpr) {
        if (refExpr == null) {
            GrReferenceExpressionImpl.$$$reportNull$$$0(6);
        }
        Collection<? extends GroovyResolveResult> results = refExpr.lrResolve(true);
        GroovyResolveResult result2 = PsiImplUtil.extractUniqueResult(results);
        PsiElement resolved = result2.getElement();
        PsiType typeFromCalculators = GrTypeCalculator.getTypeFromCalculators(refExpr);
        if (typeFromCalculators != null) {
            return typeFromCalculators;
        }
        if (ResolveUtil.isClassReference(refExpr)) {
            GrExpression qualifier = refExpr.getQualifier();
            LOG.assertTrue(qualifier != null);
            return qualifier.getType();
        }
        PsiType nominal = refExpr.getNominalType(true);
        Boolean reassigned = GrReassignedLocalVarsChecker.isReassignedVar(refExpr);
        if (reassigned != null && reassigned.booleanValue()) {
            PsiType reassignedType = GrReassignedLocalVarsChecker.getReassignedVarType(refExpr, true);
            if (reassignedType == null) {
                return nominal;
            }
            if (nominal == null) {
                return reassignedType;
            }
            if (TypeConversionUtil.isAssignable((PsiType)TypeConversionUtil.erasure((PsiType)nominal), (PsiType)reassignedType, (boolean)false)) {
                return reassignedType;
            }
            return nominal;
        }
        PsiType inferred = GrReferenceExpressionImpl.getInferredTypes(refExpr, resolved);
        if (inferred == null) {
            return nominal == null ? GrReferenceExpressionImpl.getDefaultType(refExpr, result2) : nominal;
        }
        if (nominal == null) {
            if (inferred.equals(PsiType.NULL) && PsiUtil.isCompileStatic(refExpr)) {
                return TypesUtil.getJavaLangObject(refExpr);
            }
            return inferred;
        }
        if (!TypeConversionUtil.isAssignable((PsiType)TypeConversionUtil.erasure((PsiType)nominal), (PsiType)inferred, (boolean)false) && (resolved instanceof GrVariable ? ((GrVariable)resolved).getTypeElementGroovy() != null : resolved instanceof PsiVariable)) {
            return nominal;
        }
        return inferred;
    }

    @Nullable
    private static PsiType getInferredTypes(@NotNull GrReferenceExpressionImpl refExpr, @Nullable PsiElement resolved) {
        GrExpression qualifier;
        if (refExpr == null) {
            GrReferenceExpressionImpl.$$$reportNull$$$0(7);
        }
        if ((qualifier = refExpr.getQualifier()) != null || resolved instanceof PsiClass || resolved instanceof PsiPackage || resolved instanceof PsiEnumConstant) {
            return null;
        }
        return TypeInferenceHelper.getCurrentContext().getVariableType(refExpr);
    }

    @Nullable
    private static PsiType getDefaultType(@NotNull GrReferenceExpression refExpr, @NotNull GroovyResolveResult result2) {
        PsiElement resolved;
        if (refExpr == null) {
            GrReferenceExpressionImpl.$$$reportNull$$$0(8);
        }
        if (result2 == null) {
            GrReferenceExpressionImpl.$$$reportNull$$$0(9);
        }
        if ((resolved = result2.getElement()) instanceof GrField) {
            PsiUtilCore.ensureValid((PsiElement)resolved);
            if (PsiUtil.isCompileStatic(refExpr)) {
                return TypesUtil.getJavaLangObject(refExpr);
            }
            return SpreadState.apply(((GrVariable)resolved).getTypeGroovy(), result2.getSpreadState(), refExpr.getProject());
        }
        if (resolved instanceof GrVariable) {
            PsiUtilCore.ensureValid((PsiElement)resolved);
            PsiType typeGroovy = SpreadState.apply(((GrVariable)resolved).getTypeGroovy(), result2.getSpreadState(), refExpr.getProject());
            if (typeGroovy == null && PsiUtil.isCompileStatic(refExpr)) {
                return TypesUtil.getJavaLangObject(refExpr);
            }
            return typeGroovy;
        }
        return null;
    }

    @Override
    @Nullable
    public PsiType getType() {
        return TypeInferenceHelper.getCurrentContext().getExpressionType(this, e -> GrReferenceExpressionImpl.calculateType(e));
    }

    @Override
    public GrExpression replaceWithExpression(@NotNull GrExpression newExpr, boolean removeUnnecessaryParentheses) {
        if (newExpr == null) {
            GrReferenceExpressionImpl.$$$reportNull$$$0(10);
        }
        return PsiImplUtil.replaceExpression(this, newExpr, removeUnnecessaryParentheses);
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getRangeInElement().substring(this.getElement().getText());
        if (string == null) {
            GrReferenceExpressionImpl.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    public boolean hasAt() {
        return false;
    }

    @Override
    public boolean hasMemberPointer() {
        return false;
    }

    @Override
    @NotNull
    public GroovyReference getStaticReference() {
        GroovyReference groovyReference = this.myStaticReference;
        if (groovyReference == null) {
            GrReferenceExpressionImpl.$$$reportNull$$$0(12);
        }
        return groovyReference;
    }

    @Nullable
    private GroovyReference getCallReference() {
        return (GroovyReference)this.myCallReference.getValue();
    }

    @Override
    @Nullable
    public GroovyReference getRValueReference() {
        return (GroovyReference)this.myRValueReference.getValue();
    }

    @Override
    @Nullable
    public GroovyReference getLValueReference() {
        return (GroovyReference)this.myLValueReference.getValue();
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        GroovyResolveResult[] results;
        if (element == null) {
            GrReferenceExpressionImpl.$$$reportNull$$$0(13);
        }
        for (GroovyResolveResult result2 : results = this.multiResolve(false)) {
            PsiMethod[] superMethods;
            PsiElement baseTarget = result2.getElement();
            if (baseTarget == null) continue;
            if (this.getManager().areElementsEquivalent(element, baseTarget)) {
                return true;
            }
            PsiElement target = GroovyTargetElementEvaluator.correctSearchTargets(baseTarget);
            if (target != baseTarget && this.getManager().areElementsEquivalent(element, target)) {
                return true;
            }
            if (!(element instanceof PsiMethod) || !(target instanceof PsiMethod) || !Arrays.asList(superMethods = ((PsiMethod)target).findSuperMethods(false)).contains(element)) continue;
            return true;
        }
        return false;
    }

    public boolean isSoft() {
        return false;
    }

    @Override
    @Nullable
    public GrExpression getQualifierExpression() {
        return GrReferenceExpressionImpl.findExpressionChild(this);
    }

    @Override
    @Nullable
    public PsiElement getDotToken() {
        return this.findChildByType(GroovyTokenSets.REFERENCE_DOTS);
    }

    @Override
    public void replaceDotToken(PsiElement newDot) {
        if (newDot == null) {
            return;
        }
        if (!TokenSets.DOTS.contains(newDot.getNode().getElementType())) {
            return;
        }
        PsiElement oldDot = this.getDotToken();
        if (oldDot == null) {
            return;
        }
        this.getNode().replaceChild(oldDot.getNode(), newDot.getNode());
    }

    @Override
    @Nullable
    public IElementType getDotTokenType() {
        PsiElement dot = this.getDotToken();
        return dot == null ? null : dot.getNode().getElementType();
    }

    public PsiReference getReference() {
        return this;
    }

    @Override
    @NotNull
    public Collection<? extends GroovyResolveResult> resolve(boolean incomplete) {
        PsiElement parent2 = this.getParent();
        if (parent2 instanceof GrConstructorInvocation) {
            Collection<? extends GroovyResolveResult> collection = ((GrConstructorInvocation)parent2).getConstructorReference().resolve(incomplete);
            if (collection == null) {
                GrReferenceExpressionImpl.$$$reportNull$$$0(14);
            }
            return collection;
        }
        Collection<? extends GroovyResolveResult> staticResults = this.getStaticReference().resolve(false);
        if (!staticResults.isEmpty()) {
            Collection<? extends GroovyResolveResult> collection = staticResults;
            if (collection == null) {
                GrReferenceExpressionImpl.$$$reportNull$$$0(15);
            }
            return collection;
        }
        if (incomplete) {
            Collection<GroovyResolveResult> collection = TypeInferenceHelper.getCurrentContext().resolve(this, true, INCOMPLETE_RESOLVER);
            if (collection == null) {
                GrReferenceExpressionImpl.$$$reportNull$$$0(16);
            }
            return collection;
        }
        GroovyReference callReference = this.getCallReference();
        if (callReference != null) {
            Collection<? extends GroovyResolveResult> collection = callReference.resolve(false);
            if (collection == null) {
                GrReferenceExpressionImpl.$$$reportNull$$$0(17);
            }
            return collection;
        }
        Collection<GroovyResolveResult> collection = TypeInferenceHelper.getCurrentContext().resolve(this, false, RESOLVER);
        if (collection == null) {
            GrReferenceExpressionImpl.$$$reportNull$$$0(18);
        }
        return collection;
    }

    @NotNull
    protected Collection<? extends GroovyResolveResult> lrResolve(boolean rValue) {
        Collection<? extends GroovyResolveResult> staticResults = this.getStaticReference().resolve(false);
        if (!staticResults.isEmpty()) {
            Collection<? extends GroovyResolveResult> collection = staticResults;
            if (collection == null) {
                GrReferenceExpressionImpl.$$$reportNull$$$0(19);
            }
            return collection;
        }
        GroovyReference callReference = this.getCallReference();
        if (callReference != null) {
            Collection<? extends GroovyResolveResult> collection = callReference.resolve(false);
            if (collection == null) {
                GrReferenceExpressionImpl.$$$reportNull$$$0(20);
            }
            return collection;
        }
        GroovyReference ref = (GroovyReference)(rValue ? this.myRValueReference : this.myLValueReference).getValue();
        Collection<Object> collection = ref == null ? Collections.emptyList() : ref.resolve(false);
        if (collection == null) {
            GrReferenceExpressionImpl.$$$reportNull$$$0(21);
        }
        return collection;
    }

    @Override
    public GrReferenceExpression bindToElementViaStaticImport(@NotNull PsiMember member) {
        if (member == null) {
            GrReferenceExpressionImpl.$$$reportNull$$$0(22);
        }
        if (this.getQualifier() != null) {
            throw new IncorrectOperationException("Reference has qualifier");
        }
        if (StringUtil.isEmpty((String)this.getReferenceName())) {
            throw new IncorrectOperationException("Reference has empty name");
        }
        PsiClass containingClass = member.getContainingClass();
        if (containingClass == null) {
            throw new IncorrectOperationException("Member has no containing class");
        }
        PsiFile file = this.getContainingFile();
        if (file instanceof GroovyFile) {
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.getProject());
            String text = "import static " + containingClass.getQualifiedName() + "." + member.getName();
            GrImportStatement statement = factory.createImportStatementFromText(text);
            ((GroovyFile)file).addImport(statement);
        }
        return this;
    }

    @Override
    public boolean isImplicitCallReceiver() {
        return this.hasAt() || this.hasMemberPointer() || this.myStaticReference.resolve() instanceof GrVariable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 4: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refExpr";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpr";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createQualifiedRef";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getStaticReference";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "lrResolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createQualifiedRef";
                break;
            }
            case 4: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromSpreadOperator";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "calculateType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getInferredTypes";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "replaceWithExpression";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "bindToElementViaStaticImport";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

