/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.presentation.java.JavaPresentationUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.ui.IconManager;
import com.intellij.util.IncorrectOperationException;
import icons.JetgroovyIcons;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.extensions.NamedArgumentDescriptor;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl.GrDocCommentUtil;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyStubElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrNamedArgumentSearchVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.GrVariableBaseImpl;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrFieldStub;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrVariableEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.util.GrClassImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrFieldImpl
extends GrVariableBaseImpl<GrFieldStub>
implements GrField,
StubBasedPsiElement<GrFieldStub> {
    public GrFieldImpl(@NotNull ASTNode node) {
        if (node == null) {
            GrFieldImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public GrFieldImpl(GrFieldStub stub) {
        this(stub, (IStubElementType)GroovyStubElementTypes.FIELD);
    }

    public GrFieldImpl(GrFieldStub stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        if (visitor2 == null) {
            GrFieldImpl.$$$reportNull$$$0(1);
        }
        visitor2.visitField(this);
    }

    public String toString() {
        return "Field";
    }

    @Override
    public PsiExpression getInitializer() {
        return PsiImplUtil.getOrCreatePisExpression(this.getInitializerGroovy());
    }

    public void setInitializer(@Nullable PsiExpression psiExpression) throws IncorrectOperationException {
        GrExpression oldInitializer = this.getInitializerGroovy();
        if (psiExpression == null) {
            if (oldInitializer != null) {
                oldInitializer.delete();
                PsiElement assign = this.findChildByType(GroovyTokenTypes.mASSIGN);
                if (assign != null) {
                    assign.delete();
                }
            }
            return;
        }
        GrExpression newInitializer = GroovyPsiElementFactory.getInstance(this.getProject()).createExpressionFromText(psiExpression.getText());
        if (oldInitializer != null) {
            oldInitializer.replaceWithExpression(newInitializer, true);
        } else {
            this.getNode().addLeaf(GroovyTokenTypes.mASSIGN, (CharSequence)"=", this.getNode().getLastChildNode());
            this.addAfter(newInitializer, this.getLastChild());
        }
    }

    @Override
    public boolean isDeprecated() {
        GrFieldStub stub = (GrFieldStub)this.getStub();
        if (stub != null) {
            return stub.isDeprecatedByDocTag() || com.intellij.psi.impl.PsiImplUtil.isDeprecatedByAnnotation((PsiModifierListOwner)this);
        }
        return com.intellij.psi.impl.PsiImplUtil.isDeprecatedByDocTag((PsiJavaDocumentedElement)this) || com.intellij.psi.impl.PsiImplUtil.isDeprecatedByAnnotation((PsiModifierListOwner)this);
    }

    @Override
    public PsiType getTypeGroovy() {
        PsiType type2 = (PsiType)TypeInferenceHelper.inTopContext(() -> GroovyPsiManager.getInstance(this.getProject()).getType(this, field -> {
            PsiType type1;
            if (this.getDeclaredType() == null && this.getInitializerGroovy() == null && (type1 = GrVariableEnhancer.getEnhancedType(field)) != null) {
                return type1;
            }
            return null;
        }));
        if (type2 != null) {
            return type2;
        }
        return (PsiType)TypeInferenceHelper.inTopContext(() -> super.getTypeGroovy());
    }

    public PsiClass getContainingClass() {
        PsiElement pparent;
        PsiElement parent2 = this.getParent().getParent();
        if (parent2 instanceof GrTypeDefinitionBody && (pparent = parent2.getParent()) instanceof PsiClass) {
            return (PsiClass)pparent;
        }
        PsiFile file = this.getContainingFile();
        if (file instanceof GroovyFileBase) {
            return ((GroovyFileBase)file).getScriptClass();
        }
        return null;
    }

    @Override
    public boolean isProperty() {
        GrFieldStub stub = (GrFieldStub)this.getStub();
        if (stub != null) {
            return stub.isProperty();
        }
        return PsiUtil.isProperty(this);
    }

    @Override
    @Nullable
    public GrAccessorMethod getSetter() {
        return GrClassImplUtil.findSetter(this);
    }

    @Override
    @NotNull
    public GrAccessorMethod[] getGetters() {
        GrAccessorMethod[] grAccessorMethodArray = GrClassImplUtil.findGetters(this);
        if (grAccessorMethodArray == null) {
            GrFieldImpl.$$$reportNull$$$0(2);
        }
        return grAccessorMethodArray;
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        if (this.isProperty()) {
            GlobalSearchScope globalSearchScope = ResolveScopeManager.getElementUseScope((PsiElement)this);
            if (globalSearchScope == null) {
                GrFieldImpl.$$$reportNull$$$0(3);
            }
            return globalSearchScope;
        }
        SearchScope searchScope = com.intellij.psi.impl.PsiImplUtil.getMemberUseScope((PsiMember)this);
        if (searchScope == null) {
            GrFieldImpl.$$$reportNull$$$0(4);
        }
        return searchScope;
    }

    public ItemPresentation getPresentation() {
        return JavaPresentationUtil.getFieldPresentation((PsiField)this);
    }

    public PsiElement getOriginalElement() {
        PsiClass containingClass = this.getContainingClass();
        if (containingClass == null) {
            return this;
        }
        PsiClass originalClass = (PsiClass)containingClass.getOriginalElement();
        PsiField originalField = originalClass.findFieldByName(this.getName(), false);
        return originalField != null ? originalField : this;
    }

    @Nullable
    protected Icon getElementIcon(@Iconable.IconFlags int flags) {
        boolean isAbstract = this.hasModifierProperty("abstract");
        Icon fieldIcon = this.isProperty() ? (isAbstract ? JetgroovyIcons.Groovy.AbstractProperty : JetgroovyIcons.Groovy.Property) : (isAbstract ? JetgroovyIcons.Groovy.AbstractField : JetgroovyIcons.Groovy.Field);
        return IconManager.getInstance().createLayeredIcon((Iconable)this, fieldIcon, ElementPresentationUtil.getFlags((PsiModifierListOwner)this, (boolean)false));
    }

    @Override
    @NotNull
    public Map<String, NamedArgumentDescriptor> getNamedParameters() {
        GrFieldStub stub = (GrFieldStub)this.getStub();
        if (stub != null) {
            String[] namedParameters = stub.getNamedParameters();
            if (namedParameters.length == 0) {
                Map<String, NamedArgumentDescriptor> map2 = Collections.emptyMap();
                if (map2 == null) {
                    GrFieldImpl.$$$reportNull$$$0(5);
                }
                return map2;
            }
            HashMap<String, NamedArgumentDescriptor> result2 = new HashMap<String, NamedArgumentDescriptor>();
            for (String parameter : namedParameters) {
                result2.put(parameter, GrNamedArgumentSearchVisitor.CODE_NAMED_ARGUMENTS_DESCR);
            }
            HashMap<String, NamedArgumentDescriptor> hashMap = result2;
            if (hashMap == null) {
                GrFieldImpl.$$$reportNull$$$0(6);
            }
            return hashMap;
        }
        Map<String, NamedArgumentDescriptor> map3 = GrNamedArgumentSearchVisitor.find(this);
        if (map3 == null) {
            GrFieldImpl.$$$reportNull$$$0(7);
        }
        return map3;
    }

    @Override
    public GrDocComment getDocComment() {
        return GrDocCommentUtil.findDocComment(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrFieldImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrFieldImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGetters";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamedParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

