/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.signatures;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClosureParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureParameterImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

class GrMethodSignatureImpl
implements GrSignature {
    private final PsiMethod myMethod;
    private final PsiSubstitutor mySubstitutor;
    private final boolean myEraseParameterTypes;
    private final PsiElement myContext;

    GrMethodSignatureImpl(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor, boolean eraseParameterTypes, @NotNull PsiElement context) {
        if (method == null) {
            GrMethodSignatureImpl.$$$reportNull$$$0(0);
        }
        if (substitutor == null) {
            GrMethodSignatureImpl.$$$reportNull$$$0(1);
        }
        if (context == null) {
            GrMethodSignatureImpl.$$$reportNull$$$0(2);
        }
        this.myMethod = method;
        this.mySubstitutor = substitutor;
        this.myEraseParameterTypes = eraseParameterTypes;
        this.myContext = context;
    }

    @Override
    @NotNull
    public PsiSubstitutor getSubstitutor() {
        PsiSubstitutor psiSubstitutor = this.mySubstitutor;
        if (psiSubstitutor == null) {
            GrMethodSignatureImpl.$$$reportNull$$$0(3);
        }
        return psiSubstitutor;
    }

    public PsiMethod getMethod() {
        return this.myMethod;
    }

    @Override
    @NotNull
    public GrClosureParameter[] getParameters() {
        GrClosureParameter[] grClosureParameterArray = (GrClosureParameter[])ContainerUtil.map((Object[])this.myMethod.getParameterList().getParameters(), parameter -> new GrClosureParameterImpl((PsiParameter)parameter, this.mySubstitutor, this.myEraseParameterTypes, this.myContext), (Object[])GrClosureParameter.EMPTY_ARRAY);
        if (grClosureParameterArray == null) {
            GrMethodSignatureImpl.$$$reportNull$$$0(4);
        }
        return grClosureParameterArray;
    }

    @Override
    public int getParameterCount() {
        return this.myMethod.getParameterList().getParametersCount();
    }

    @Override
    public boolean isVarargs() {
        return GrClosureSignatureUtil.isVarArgsImpl(this.getParameters());
    }

    @Override
    public PsiType getReturnType() {
        PsiType type2 = this.getReturnTypeInner();
        return this.myEraseParameterTypes ? TypeConversionUtil.erasure((PsiType)type2) : type2;
    }

    private PsiType getReturnTypeInner() {
        PsiSubstitutor substitutor = this.getSubstitutor();
        if (this.myMethod.isConstructor()) {
            PsiClass clazz = this.myMethod.getContainingClass();
            if (clazz == null) {
                return null;
            }
            return GroovyPsiElementFactory.getInstance(this.myMethod.getProject()).createType(clazz, substitutor);
        }
        return substitutor.substitute(PsiUtil.getSmartReturnType(this.myMethod));
    }

    @Override
    public boolean isCurried() {
        return false;
    }

    @Override
    public boolean isValid() {
        return this.myContext.isValid() && this.myMethod.isValid() && this.getSubstitutor().isValid();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/signatures/GrMethodSignatureImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/signatures/GrMethodSignatureImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

