/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.dataFlow.types;

import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.MixinTypeInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.NegatingGotoInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.VariableDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ArgumentsInstruction;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAType;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DfaInstance;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.InferenceCache;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeDfaState;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.api.ArgumentMapping;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyMethodCandidate;

class TypeDfaInstance
implements DfaInstance<TypeDfaState> {
    private final Instruction[] myFlow;
    private final Set<Instruction> myInteresting;
    private final Set<Instruction> myAcyclicInstructions;
    private final InferenceCache myCache;

    TypeDfaInstance(@NotNull Instruction[] flow, @NotNull Couple<Set<Instruction>> interesting, @NotNull InferenceCache cache2) {
        if (flow == null) {
            TypeDfaInstance.$$$reportNull$$$0(0);
        }
        if (interesting == null) {
            TypeDfaInstance.$$$reportNull$$$0(1);
        }
        if (cache2 == null) {
            TypeDfaInstance.$$$reportNull$$$0(2);
        }
        this.myFlow = flow;
        this.myInteresting = (Set)interesting.first;
        this.myAcyclicInstructions = (Set)interesting.second;
        this.myCache = cache2;
    }

    @Override
    public void fun(@NotNull TypeDfaState state, @NotNull Instruction instruction) {
        if (state == null) {
            TypeDfaInstance.$$$reportNull$$$0(3);
        }
        if (instruction == null) {
            TypeDfaInstance.$$$reportNull$$$0(4);
        }
        if (instruction instanceof ReadWriteVariableInstruction) {
            this.handleVariableWrite(state, (ReadWriteVariableInstruction)instruction);
        } else if (instruction instanceof MixinTypeInstruction) {
            this.handleMixin(state, (MixinTypeInstruction)instruction);
        } else if (instruction instanceof ArgumentsInstruction) {
            this.handleArguments(state, (ArgumentsInstruction)instruction);
        } else if (instruction instanceof NegatingGotoInstruction) {
            TypeDfaInstance.handleNegation(state, (NegatingGotoInstruction)instruction);
        }
    }

    private void handleMixin(@NotNull TypeDfaState state, @NotNull MixinTypeInstruction instruction) {
        VariableDescriptor descriptor2;
        if (state == null) {
            TypeDfaInstance.$$$reportNull$$$0(5);
        }
        if (instruction == null) {
            TypeDfaInstance.$$$reportNull$$$0(6);
        }
        if ((descriptor2 = instruction.getVariableDescriptor()) == null) {
            return;
        }
        this.updateVariableType(state, instruction, descriptor2, (Computable<? extends DFAType>)((Computable)() -> {
            ReadWriteVariableInstruction originalInstr = instruction.getInstructionToMixin(this.myFlow);
            assert (originalInstr != null && !originalInstr.isWrite());
            DFAType original = state.getOrCreateVariableType(descriptor2);
            original.addMixin(instruction.inferMixinType(), instruction.getConditionInstruction());
            return original;
        }));
    }

    private void handleVariableWrite(TypeDfaState state, ReadWriteVariableInstruction instruction) {
        PsiElement element = instruction.getElement();
        if (element != null && instruction.isWrite()) {
            this.updateVariableType(state, instruction, instruction.getDescriptor(), (Computable<? extends DFAType>)((Computable)() -> DFAType.create(TypeInferenceHelper.getInitializerType(element))));
        }
    }

    private void handleArguments(TypeDfaState state, ArgumentsInstruction instruction) {
        for (Map.Entry<VariableDescriptor, Collection<Argument>> entry : instruction.getArguments().entrySet()) {
            VariableDescriptor descriptor2 = entry.getKey();
            Collection<Argument> arguments2 = entry.getValue();
            this.handleArgument(state, instruction, descriptor2, arguments2);
        }
    }

    private void handleArgument(TypeDfaState state, ArgumentsInstruction instruction, VariableDescriptor descriptor2, Collection<Argument> arguments2) {
        this.updateVariableType(state, instruction, descriptor2, (Computable<? extends DFAType>)((Computable)() -> {
            GroovyResolveResult[] results;
            DFAType result2 = state.getOrCreateVariableType(descriptor2);
            for (GroovyResolveResult variant : results = instruction.getElement().multiResolve(false)) {
                ArgumentMapping mapping2;
                GroovyMethodCandidate candidate;
                if (!(variant instanceof GroovyMethodResult) || (candidate = ((GroovyMethodResult)variant).getCandidate()) == null || (mapping2 = candidate.getArgumentMapping()) == null) continue;
                for (Argument argument : arguments2) {
                    PsiType parameterType = mapping2.expectedType(argument);
                    if (parameterType == null) continue;
                    PsiType typeToMixin = variant.getSubstitutor().substitute(parameterType);
                    result2.addMixin(typeToMixin, null);
                }
            }
            return result2;
        }));
    }

    private void updateVariableType(@NotNull TypeDfaState state, @NotNull Instruction instruction, @NotNull VariableDescriptor descriptor2, @NotNull Computable<? extends DFAType> computation) {
        if (state == null) {
            TypeDfaInstance.$$$reportNull$$$0(7);
        }
        if (instruction == null) {
            TypeDfaInstance.$$$reportNull$$$0(8);
        }
        if (descriptor2 == null) {
            TypeDfaInstance.$$$reportNull$$$0(9);
        }
        if (computation == null) {
            TypeDfaInstance.$$$reportNull$$$0(10);
        }
        if (!this.myInteresting.contains(instruction)) {
            state.removeBinding(descriptor2);
            return;
        }
        DFAType type2 = this.myCache.getCachedInferredType(descriptor2, instruction);
        if (type2 == null) {
            type2 = this.myAcyclicInstructions.contains(instruction) ? (DFAType)computation.compute() : TypeInferenceHelper.doInference(state.getBindings(), computation);
        }
        state.putType(descriptor2, type2);
    }

    private static void handleNegation(@NotNull TypeDfaState state, @NotNull NegatingGotoInstruction negation) {
        if (state == null) {
            TypeDfaInstance.$$$reportNull$$$0(11);
        }
        if (negation == null) {
            TypeDfaInstance.$$$reportNull$$$0(12);
        }
        for (Map.Entry<VariableDescriptor, DFAType> entry : state.getVarTypes().entrySet()) {
            entry.setValue(entry.getValue().negate(negation));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flow";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interesting";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computation";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "negation";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/dataFlow/types/TypeDfaInstance";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "fun";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "handleMixin";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "updateVariableType";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "handleNegation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

