/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.dataFlow.types;

import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.util.LazyKt;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kotlin.Lazy;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.MixinTypeInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.VariableDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAEngine;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAType;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.UtilKt;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.DefinitionMap;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeDfaInstance;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeDfaState;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypesSemilattice;
import org.jetbrains.plugins.groovy.util.GraphKt;

class InferenceCache {
    private final GrControlFlowOwner myScope;
    private final Instruction[] myFlow;
    private final Map<PsiElement, List<Instruction>> myFromByElements;
    private final Lazy<TObjectIntHashMap<VariableDescriptor>> myVarIndexes;
    private final Lazy<List<DefinitionMap>> myDefinitionMaps;
    private final AtomicReference<List<TypeDfaState>> myVarTypes;
    private final Set<Instruction> myTooComplexInstructions;

    InferenceCache(@NotNull GrControlFlowOwner scope) {
        if (scope == null) {
            InferenceCache.$$$reportNull$$$0(0);
        }
        this.myTooComplexInstructions = ContainerUtil.newConcurrentSet();
        this.myScope = scope;
        this.myFlow = scope.getControlFlow();
        this.myVarIndexes = LazyKt.lazyPub(() -> UtilKt.getVarIndexes(this.myScope));
        this.myDefinitionMaps = LazyKt.lazyPub(() -> TypeInferenceHelper.getDefUseMaps(this.myFlow, (TObjectIntHashMap<VariableDescriptor>)((TObjectIntHashMap)this.myVarIndexes.getValue())));
        this.myFromByElements = Arrays.stream(this.myFlow).filter(it -> it.getElement() != null).collect(Collectors.groupingBy(Instruction::getElement));
        ArrayList<TypeDfaState> noTypes = new ArrayList<TypeDfaState>();
        for (int i = 0; i < this.myFlow.length; ++i) {
            noTypes.add(new TypeDfaState());
        }
        this.myVarTypes = new AtomicReference(noTypes);
    }

    boolean isTooComplexToAnalyze() {
        return this.myDefinitionMaps.getValue() == null;
    }

    @Nullable
    PsiType getInferredType(@NotNull VariableDescriptor descriptor2, @NotNull Instruction instruction, boolean mixinOnly) {
        DFAType dfaType;
        if (descriptor2 == null) {
            InferenceCache.$$$reportNull$$$0(1);
        }
        if (instruction == null) {
            InferenceCache.$$$reportNull$$$0(2);
        }
        if (this.myTooComplexInstructions.contains(instruction)) {
            return null;
        }
        List definitionMaps = (List)this.myDefinitionMaps.getValue();
        if (definitionMaps == null) {
            return null;
        }
        TypeDfaState cache2 = this.myVarTypes.get().get(instruction.num());
        if (!cache2.containsVariable(descriptor2)) {
            Predicate<Instruction> mixinPredicate = mixinOnly ? e -> e instanceof MixinTypeInstruction : e -> true;
            Couple<Set<Instruction>> interesting = this.collectRequiredInstructions(definitionMaps, instruction, descriptor2, mixinPredicate);
            List<TypeDfaState> dfaResult = this.performTypeDfa(this.myScope, this.myFlow, interesting);
            if (dfaResult == null) {
                this.myTooComplexInstructions.addAll((Collection)interesting.first);
            } else {
                this.cacheDfaResult(dfaResult);
            }
        }
        return (dfaType = this.getCachedInferredType(descriptor2, instruction)) == null ? null : dfaType.getResultType();
    }

    @Nullable
    private List<TypeDfaState> performTypeDfa(@NotNull GrControlFlowOwner owner, @NotNull Instruction[] flow, @NotNull Couple<Set<Instruction>> interesting) {
        if (owner == null) {
            InferenceCache.$$$reportNull$$$0(3);
        }
        if (flow == null) {
            InferenceCache.$$$reportNull$$$0(4);
        }
        if (interesting == null) {
            InferenceCache.$$$reportNull$$$0(5);
        }
        TypeDfaInstance dfaInstance = new TypeDfaInstance(flow, interesting, this);
        TypesSemilattice semilattice = new TypesSemilattice(owner.getManager());
        return new DFAEngine<TypeDfaState>(flow, dfaInstance, semilattice).performDFAWithTimeout();
    }

    @Nullable
    DFAType getCachedInferredType(@NotNull VariableDescriptor descriptor2, @NotNull Instruction instruction) {
        if (descriptor2 == null) {
            InferenceCache.$$$reportNull$$$0(6);
        }
        if (instruction == null) {
            InferenceCache.$$$reportNull$$$0(7);
        }
        return this.myVarTypes.get().get(instruction.num()).getVariableType(descriptor2);
    }

    private Couple<Set<Instruction>> collectRequiredInstructions(@NotNull List<DefinitionMap> definitionMaps, @NotNull Instruction instruction, @NotNull VariableDescriptor descriptor2, @NotNull Predicate<? super Instruction> predicate2) {
        if (definitionMaps == null) {
            InferenceCache.$$$reportNull$$$0(8);
        }
        if (instruction == null) {
            InferenceCache.$$$reportNull$$$0(9);
        }
        if (descriptor2 == null) {
            InferenceCache.$$$reportNull$$$0(10);
        }
        if (predicate2 == null) {
            InferenceCache.$$$reportNull$$$0(11);
        }
        LinkedHashMap<Pair, Set<Pair<Instruction, VariableDescriptor>>> interesting = new LinkedHashMap<Pair, Set<Pair<Instruction, VariableDescriptor>>>();
        LinkedList<Pair> queue = new LinkedList<Pair>();
        queue.add(Pair.create((Object)instruction, (Object)descriptor2));
        while (!queue.isEmpty()) {
            Pair pair = (Pair)queue.removeFirst();
            if (interesting.containsKey(pair)) continue;
            Set<Pair<Instruction, VariableDescriptor>> dependencies = this.findDependencies(definitionMaps, (Instruction)pair.first, (VariableDescriptor)pair.second);
            interesting.put(pair, dependencies);
            dependencies.forEach(queue::addLast);
        }
        Set interestingInstructions = interesting.keySet().stream().map(it -> (Instruction)it.getFirst()).filter(predicate2).collect(Collectors.toSet());
        Set acyclicInstructions = GraphKt.findNodesOutsideCycles(GraphKt.mapGraph(interesting)).stream().map(it -> (Instruction)it.getFirst()).filter(predicate2).collect(Collectors.toSet());
        return Couple.of(interestingInstructions, acyclicInstructions);
    }

    @NotNull
    private Set<Pair<Instruction, VariableDescriptor>> findDependencies(@NotNull List<DefinitionMap> definitionMaps, @NotNull Instruction instruction, @NotNull VariableDescriptor descriptor2) {
        int varIndex;
        DefinitionMap definitionMap;
        int[] definitions;
        if (definitionMaps == null) {
            InferenceCache.$$$reportNull$$$0(12);
        }
        if (instruction == null) {
            InferenceCache.$$$reportNull$$$0(13);
        }
        if (descriptor2 == null) {
            InferenceCache.$$$reportNull$$$0(14);
        }
        if ((definitions = (definitionMap = definitionMaps.get(instruction.num())).getDefinitions(varIndex = ((TObjectIntHashMap)this.myVarIndexes.getValue()).get((Object)descriptor2))) == null) {
            Set<Pair<Instruction, VariableDescriptor>> set = Collections.emptySet();
            if (set == null) {
                InferenceCache.$$$reportNull$$$0(15);
            }
            return set;
        }
        LinkedHashSet<Pair<Instruction, VariableDescriptor>> pairs = new LinkedHashSet<Pair<Instruction, VariableDescriptor>>();
        for (int defIndex : definitions) {
            Instruction write = this.myFlow[defIndex];
            if (write != instruction) {
                pairs.add((Pair<Instruction, VariableDescriptor>)Pair.create((Object)write, (Object)descriptor2));
            }
            for (ReadWriteVariableInstruction dependency : UtilKt.findReadDependencies(write, (Function1<? super PsiElement, ? extends Collection<? extends Instruction>>)((Function1)it -> this.myFromByElements.getOrDefault(it, Collections.emptyList())))) {
                pairs.add((Pair<Instruction, VariableDescriptor>)Pair.create((Object)dependency, (Object)dependency.getDescriptor()));
            }
        }
        LinkedHashSet<Pair<Instruction, VariableDescriptor>> linkedHashSet = pairs;
        if (linkedHashSet == null) {
            InferenceCache.$$$reportNull$$$0(16);
        }
        return linkedHashSet;
    }

    private void cacheDfaResult(@NotNull List<TypeDfaState> dfaResult) {
        if (dfaResult == null) {
            InferenceCache.$$$reportNull$$$0(17);
        }
        this.myVarTypes.accumulateAndGet(dfaResult, InferenceCache::addDfaResult);
    }

    @NotNull
    private static List<TypeDfaState> addDfaResult(@NotNull List<TypeDfaState> oldTypes, @NotNull List<TypeDfaState> dfaResult) {
        if (oldTypes == null) {
            InferenceCache.$$$reportNull$$$0(18);
        }
        if (dfaResult == null) {
            InferenceCache.$$$reportNull$$$0(19);
        }
        ArrayList<TypeDfaState> newTypes = new ArrayList<TypeDfaState>(oldTypes);
        for (int i = 0; i < dfaResult.size(); ++i) {
            newTypes.set(i, ((TypeDfaState)newTypes.get(i)).mergeWith(dfaResult.get(i)));
        }
        ArrayList<TypeDfaState> arrayList = newTypes;
        if (arrayList == null) {
            InferenceCache.$$$reportNull$$$0(20);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 16: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 16: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flow";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interesting";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definitionMaps";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 15: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/dataFlow/types/InferenceCache";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaResult";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/dataFlow/types/InferenceCache";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findDependencies";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "addDfaResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInferredType";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "performTypeDfa";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCachedInferredType";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectRequiredInstructions";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findDependencies";
                break;
            }
            case 15: 
            case 16: 
            case 20: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "cacheDfaResult";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addDfaResult";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: 
            case 16: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

