/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.util.MethodParenthesesHandler;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeStyle.GroovyCodeStyleSettings;
import org.jetbrains.plugins.groovy.lang.completion.ClosureCompleter;
import org.jetbrains.plugins.groovy.lang.completion.GroovyCompletionUtil;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class GroovyInsertHandler
implements InsertHandler<LookupElement> {
    public static final GroovyInsertHandler INSTANCE = new GroovyInsertHandler();

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        if (context == null) {
            GroovyInsertHandler.$$$reportNull$$$0(0);
        }
        if (item == null) {
            GroovyInsertHandler.$$$reportNull$$$0(1);
        }
        Object obj = item.getObject();
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        if (obj instanceof GroovyResolveResult) {
            substitutor = ((GroovyResolveResult)obj).getSubstitutor();
            obj = ((GroovyResolveResult)obj).getElement();
        }
        if (obj instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)obj;
            PsiParameter[] parameters = method.getParameterList().getParameters();
            Editor editor = context.getEditor();
            Document document = editor.getDocument();
            if (context.getCompletionChar() == '\t') {
                GroovyInsertHandler.handleOverwrite(editor.getCaretModel().getOffset(), document);
            }
            CaretModel caretModel = editor.getCaretModel();
            int offset = context.getTailOffset();
            PsiFile file = context.getFile();
            PsiElement elementAt = file.findElementAt(context.getStartOffset());
            assert (elementAt != null);
            PsiElement parent2 = elementAt.getParent();
            if (parent2 instanceof GrReferenceExpression && ((GrReferenceExpression)parent2).getDotTokenType() == GroovyTokenTypes.mMEMBER_POINTER) {
                return;
            }
            CharSequence charsSequence = document.getCharsSequence();
            if (GroovyInsertHandler.isAnnotationNameValuePair(obj, parent2)) {
                int endOffset = offset;
                if (context.getCompletionChar() == '\t') {
                    endOffset = CharArrayUtil.shiftForward((CharSequence)charsSequence, (int)offset, (String)" \t");
                    if (charsSequence.length() > endOffset && charsSequence.charAt(endOffset) == '=') {
                        ++endOffset;
                        endOffset = CharArrayUtil.shiftForward((CharSequence)charsSequence, (int)endOffset, (String)" \t");
                    }
                }
                document.replaceString(offset, endOffset, (CharSequence)" = ");
                caretModel.moveToOffset(offset + 3);
                return;
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)elementAt, GrImportStatement.class) != null) {
                return;
            }
            if (parameters.length == 1 && context.getCompletionChar() != '(' && context.getCompletionChar() != ' ' && TypesUtil.isClassType(parameters[0].getType(), "groovy.lang.Closure")) {
                int afterBrace;
                int nonWs = CharArrayUtil.shiftForward((CharSequence)charsSequence, (int)offset, (String)" \t");
                if (nonWs < document.getTextLength() && charsSequence.charAt(nonWs) == '{') {
                    afterBrace = nonWs + 1;
                } else {
                    if (GroovyInsertHandler.isSpaceBeforeClosure(file)) {
                        document.insertString(offset, (CharSequence)" ");
                        ++offset;
                    }
                    if (ClosureCompleter.runClosureCompletion(context, method, substitutor, document, offset, parent2)) {
                        return;
                    }
                    if (context.getCompletionChar() == '\r') {
                        document.insertString(offset, (CharSequence)"{\n}");
                        afterBrace = offset + 1;
                        context.setTailOffset(afterBrace);
                    } else {
                        document.insertString(offset, (CharSequence)"{}");
                        afterBrace = offset + 1;
                    }
                }
                caretModel.moveToOffset(afterBrace);
                return;
            }
            context.commitDocument();
            if (context.getCompletionChar() == ' ' && MethodParenthesesHandler.hasParams((LookupElement)item, (LookupElement[])context.getElements(), (boolean)true, (PsiMethod)method)) {
                return;
            }
            CommonCodeStyleSettings settings = context.getCodeStyleSettings();
            ParenthesesInsertHandler.getInstance((boolean)MethodParenthesesHandler.hasParams((LookupElement)item, (LookupElement[])context.getElements(), (boolean)true, (PsiMethod)method), (boolean)settings.SPACE_BEFORE_METHOD_CALL_PARENTHESES, (boolean)settings.SPACE_WITHIN_METHOD_CALL_PARENTHESES, (boolean)true, (boolean)true).handleInsert(context, item);
            AutoPopupController.getInstance((Project)context.getProject()).autoPopupParameterInfo(editor, (PsiElement)method);
            return;
        }
        if (obj instanceof PsiClass) {
            PsiClass clazz = (PsiClass)obj;
            Editor editor = context.getEditor();
            Document document = editor.getDocument();
            PsiFile file = PsiDocumentManager.getInstance((Project)clazz.getProject()).getPsiFile(document);
            assert (file != null);
            PsiElement elementAt = file.findElementAt(context.getStartOffset());
            assert (elementAt != null);
            CaretModel caretModel = editor.getCaretModel();
            int offset = context.getStartOffset() + elementAt.getTextLength();
            String text = document.getText();
            PsiElement parent3 = elementAt.getParent();
            if (parent3 instanceof GrCodeReferenceElement && parent3.getParent() instanceof GrNewExpression && (offset == text.length() || !text.substring(offset).trim().startsWith("("))) {
                document.insertString(offset, (CharSequence)"()");
                if (GroovyCompletionUtil.hasConstructorParameters(clazz, parent3)) {
                    caretModel.moveToOffset(offset + 1);
                    return;
                }
                caretModel.moveToOffset(offset + 2);
                return;
            }
        }
        if (context.getCompletionChar() == '=') {
            context.setAddCompletionChar(false);
            TailType.EQ.processTail(context.getEditor(), context.getTailOffset());
            return;
        }
        if (obj instanceof PsiPackage) {
            AutoPopupController.getInstance((Project)context.getProject()).scheduleAutoPopup(context.getEditor());
        }
    }

    private static boolean isSpaceBeforeClosure(PsiFile file) {
        return GroovyCodeStyleSettings.getInstance((PsiFile)file).SPACE_BEFORE_CLOSURE_LBRACE;
    }

    private static boolean isAnnotationNameValuePair(Object obj, PsiElement parent2) {
        PsiClass aClass;
        return (parent2 instanceof GrAnnotationNameValuePair || parent2 != null && parent2.getParent() instanceof GrAnnotationNameValuePair) && obj instanceof PsiMethod && (aClass = ((PsiMethod)obj).getContainingClass()) != null && aClass.isAnnotationType();
    }

    private static void handleOverwrite(int offset, Document document) {
        int i;
        CharSequence sequence = document.getCharsSequence();
        for (i = offset; i < sequence.length() && Character.isJavaIdentifierPart(sequence.charAt(i)); ++i) {
        }
        document.deleteString(offset, i);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "item";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/groovy/lang/completion/GroovyInsertHandler";
        objectArray[2] = "handleInsert";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

