/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.IconManager;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.ProcessingContext;
import com.intellij.util.VisibilityUtil;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.completion.handlers.GroovyMethodOverrideHandler;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.util.GroovyOverrideImplementExploreUtil;

class GrMethodOverrideCompletionProvider
extends CompletionProvider<CompletionParameters> {
    private static final ElementPattern<PsiElement> PLACE = ((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(GrTypeDefinitionBody.class)).with((PatternCondition)new PatternCondition<PsiElement>("Not in extends/implements clause of inner class"){

        public boolean accepts(@NotNull PsiElement element, ProcessingContext context) {
            GrTypeDefinition innerDefinition;
            if (element == null) {
                1.$$$reportNull$$$0(0);
            }
            return (innerDefinition = (GrTypeDefinition)PsiTreeUtil.getPrevSiblingOfType((PsiElement)element, GrTypeDefinition.class)) == null || innerDefinition.getContainingClass() == null || innerDefinition.getBody() != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/lang/completion/GrMethodOverrideCompletionProvider$1", "accepts"));
        }
    })).andNot((ElementPattern)PlatformPatterns.psiComment());

    GrMethodOverrideCompletionProvider() {
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
        PsiElement position;
        GrTypeDefinition currentClass;
        if (parameters == null) {
            GrMethodOverrideCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            GrMethodOverrideCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            GrMethodOverrideCompletionProvider.$$$reportNull$$$0(2);
        }
        if ((currentClass = (GrTypeDefinition)PsiTreeUtil.getParentOfType((PsiElement)(position = parameters.getPosition()), GrTypeDefinition.class)) != null) {
            GrMethodOverrideCompletionProvider.addSuperMethods(currentClass, result2, false);
            GrMethodOverrideCompletionProvider.addSuperMethods(currentClass, result2, true);
        }
    }

    public static void register(CompletionContributor contributor) {
        contributor.extend(CompletionType.BASIC, PLACE, (CompletionProvider)new GrMethodOverrideCompletionProvider());
    }

    private static void addSuperMethods(GrTypeDefinition psiClass, CompletionResultSet completionResultSet, boolean toImplement) {
        Collection<CandidateInfo> candidates = GroovyOverrideImplementExploreUtil.getMethodsToOverrideImplement(psiClass, toImplement);
        for (CandidateInfo candidateInfo : candidates) {
            PsiMethod method = (PsiMethod)candidateInfo.getElement();
            if (method.isConstructor()) continue;
            RowIcon icon = IconManager.getInstance().createRowIcon(2);
            icon.setIcon(method.getIcon(0), 0);
            icon.setIcon(toImplement ? AllIcons.Gutter.ImplementingMethod : AllIcons.Gutter.OverridingMethod, 1);
            PsiSubstitutor substitutor = candidateInfo.getSubstitutor();
            String parameters = PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)substitutor, (int)256, (int)1);
            String visibility = VisibilityUtil.getVisibilityModifier((PsiModifierList)method.getModifierList());
            String modifiers = visibility == "packageLocal" ? "" : visibility + " ";
            PsiType type2 = substitutor.substitute(method.getReturnType());
            String parentClassName = psiClass == null ? "" : psiClass.getName();
            String signature = modifiers + (type2 == null ? "" : type2.getPresentableText() + " ") + method.getName();
            LookupElementBuilder lookupElement = LookupElementBuilder.create((Object)method, (String)signature).appendTailText(parameters, false).appendTailText("{...}", true).withTypeText(parentClassName).withIcon((Icon)icon).withInsertHandler((InsertHandler)new GroovyMethodOverrideHandler(psiClass));
            completionResultSet.addElement((LookupElement)lookupElement);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/groovy/lang/completion/GrMethodOverrideCompletionProvider";
        objectArray[2] = "addCompletions";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

