/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.style.inference;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeMapper;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.GroovyInferenceSession;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a'\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u000e\u001a\u001a\u0010\u000f\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014*\b\u0012\u0004\u0012\u00020\u00050\u0014*\u0016\u0010\u0015\"\b\u0012\u0004\u0012\u00020\u00170\u00162\b\u0012\u0004\u0012\u00020\u00170\u0016\u00a8\u0006\u0018"}, d2={"getInferenceVariable", "Lcom/intellij/psi/impl/source/resolve/graphInference/InferenceVariable;", "session", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/inference/GroovyInferenceSession;", "variableType", "Lcom/intellij/psi/PsiType;", "createProperTypeParameter", "Lcom/intellij/psi/PsiTypeParameter;", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyPsiElementFactory;", "name", "", "superTypes", "", "Lcom/intellij/psi/PsiClassType;", "(Lorg/jetbrains/plugins/groovy/lang/psi/GroovyPsiElementFactory;Ljava/lang/String;[Lcom/intellij/psi/PsiClassType;)Lcom/intellij/psi/PsiTypeParameter;", "ensureWildcards", "factory", "manager", "Lcom/intellij/psi/PsiManager;", "flattenIntersections", "", "InferenceGraphNode", "Lcom/intellij/psi/impl/source/resolve/graphInference/InferenceVariablesOrder$InferenceGraphNode;", "Lorg/jetbrains/plugins/groovy/intentions/style/inference/graph/InferenceUnitNode;", "intellij.groovy"})
public final class MethodParametersInferenceProcessorUtilKt {
    @NotNull
    public static final InferenceVariable getInferenceVariable(@NotNull GroovyInferenceSession session, @NotNull PsiType variableType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)session), (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)variableType, (String)"variableType");
        InferenceVariable inferenceVariable = session.getInferenceVariable(session.substituteWithInferenceVariables(variableType));
        Intrinsics.checkExpressionValueIsNotNull((Object)inferenceVariable, (String)"session.getInferenceVari\u2026eVariables(variableType))");
        return inferenceVariable;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Iterable<PsiType> flattenIntersections(@NotNull Iterable<? extends PsiType> $this$flattenIntersections) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull($this$flattenIntersections, (String)"$this$flattenIntersections");
        Iterable<? extends PsiType> $this$flatMap$iv = $this$flattenIntersections;
        boolean $i$f$flatMap = false;
        Iterable<? extends PsiType> iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Iterable iterable2;
            PsiType it = (PsiType)element$iv$iv;
            boolean bl = false;
            if (it instanceof PsiIntersectionType) {
                Object[] objectArray = ((PsiIntersectionType)it).getConjuncts();
                Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"it.conjuncts");
                iterable2 = ArraysKt.asIterable((Object[])objectArray);
            } else {
                iterable2 = CollectionsKt.listOf((Object)it);
            }
            Iterable list$iv$iv = iterable2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final PsiTypeParameter createProperTypeParameter(@NotNull GroovyPsiElementFactory $this$createProperTypeParameter, @NotNull String name, @NotNull PsiClassType[] superTypes) {
        Intrinsics.checkParameterIsNotNull((Object)$this$createProperTypeParameter, (String)"$this$createProperTypeParameter");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)superTypes, (String)"superTypes");
        StringBuilder builder = new StringBuilder();
        builder.append("public <").append(name);
        if (superTypes.length > 1 || superTypes.length == 1 && !superTypes[0].equalsToText("java.lang.Object")) {
            builder.append(" extends ");
            for (PsiClassType type2 : superTypes) {
                if (type2.equalsToText("java.lang.Object")) continue;
                builder.append(type2.getCanonicalText(true)).append('&');
            }
            builder.delete(builder.length() - 1, builder.length());
        }
        builder.append("> void foo(){}");
        try {
            GrMethod grMethod = $this$createProperTypeParameter.createMethodFromText(builder.toString(), null);
            Intrinsics.checkExpressionValueIsNotNull((Object)grMethod, (String)"createMethodFromText(builder.toString(), null)");
            PsiTypeParameter psiTypeParameter = grMethod.getTypeParameters()[0];
            Intrinsics.checkExpressionValueIsNotNull((Object)psiTypeParameter, (String)"createMethodFromText(bui\u2026, null).typeParameters[0]");
            return psiTypeParameter;
        }
        catch (RuntimeException e) {
            throw (Throwable)new IncorrectOperationException("type parameter text: " + builder);
        }
    }

    @NotNull
    public static final PsiType ensureWildcards(@NotNull PsiType $this$ensureWildcards, @NotNull GroovyPsiElementFactory factory, @NotNull PsiManager manager) {
        Intrinsics.checkParameterIsNotNull((Object)$this$ensureWildcards, (String)"$this$ensureWildcards");
        Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        PsiType enclosing = $this$ensureWildcards;
        Object object = $this$ensureWildcards.accept((PsiTypeVisitor)new PsiTypeMapper(factory, enclosing, manager){
            final /* synthetic */ GroovyPsiElementFactory $factory;
            final /* synthetic */ PsiType $enclosing;
            final /* synthetic */ PsiManager $manager;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public PsiType visitClassType(@Nullable PsiClassType classType) {
                void $this$toTypedArray$iv;
                PsiClass psiClass;
                Object object;
                void $this$mapTo$iv$iv;
                if (classType == null) {
                    return (PsiType)classType;
                }
                PsiType[] psiTypeArray = classType.getParameters();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiTypeArray, (String)"classType.parameters");
                PsiType[] $this$map$iv = psiTypeArray;
                boolean $i$f$map22 = false;
                PsiType[] psiTypeArray2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>($this$map$iv.length);
                boolean $i$f$mapTo = false;
                void var8_9 = $this$mapTo$iv$iv;
                int n = ((void)var8_9).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var12_13 = item$iv$iv = var8_9[i];
                    object = destination$iv$iv;
                    boolean bl = false;
                    psiClass = (PsiType)it.accept((PsiTypeVisitor)this);
                    object.add(psiClass);
                }
                List mappedParameters = (List)destination$iv$iv;
                PsiClass psiClass2 = classType.resolve();
                if (psiClass2 == null) {
                    Intrinsics.throwNpe();
                }
                Collection $i$f$map22 = mappedParameters;
                psiClass = psiClass2;
                object = this.$factory;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                PsiType[] psiTypeArray3 = thisCollection$iv.toArray(new PsiType[0]);
                if (psiTypeArray3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                PsiType[] psiTypeArray4 = psiTypeArray3;
                PsiClassType psiClassType = object.createType(psiClass, Arrays.copyOf(psiTypeArray4, psiTypeArray4.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)psiClassType, (String)"factory.createType(class\u2026arameters.toTypedArray())");
                PsiClassType newType = psiClassType;
                if (Intrinsics.areEqual((Object)classType, (Object)this.$enclosing)) {
                    return (PsiType)newType;
                }
                return (PsiType)PsiWildcardType.createExtends((PsiManager)this.$manager, (PsiType)((PsiType)newType));
            }
            {
                this.$factory = $captured_local_variable$0;
                this.$enclosing = $captured_local_variable$1;
                this.$manager = $captured_local_variable$2;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"accept(object : PsiTypeM\u2026Type)\n      }\n    }\n\n  })");
        return (PsiType)object;
    }
}

