/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.style;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiTypeParameterList;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.intentions.GroovyIntentionsBundle;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.style.AddReturnTypeFix;
import org.jetbrains.plugins.groovy.intentions.style.InferMethodParametersTypesIntention;
import org.jetbrains.plugins.groovy.intentions.style.inference.MethodParametersInferenceProcessor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0014J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0014J\"\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0014\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/groovy/intentions/style/InferMethodParametersTypesIntention;", "Lorg/jetbrains/plugins/groovy/intentions/base/Intention;", "()V", "getElementPredicate", "Lorg/jetbrains/plugins/groovy/intentions/base/PsiElementPredicate;", "getFamilyName", "", "getText", "isStopElement", "", "element", "Lcom/intellij/psi/PsiElement;", "processIntention", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.groovy"})
public final class InferMethodParametersTypesIntention
extends Intention {
    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, @Nullable Editor editor) {
        MethodParametersInferenceProcessor processor;
        GrMethod virtualMethod;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        GrMethod method = (GrMethod)element;
        if (!method.isConstructor()) {
            AddReturnTypeFix.applyFix(project, (GrMethod)element);
        }
        if ((virtualMethod = (processor = new MethodParametersInferenceProcessor(method)).runInferenceProcess()).hasTypeParameters()) {
            if (method.hasTypeParameters()) {
                PsiTypeParameterList psiTypeParameterList = method.getTypeParameterList();
                if (psiTypeParameterList == null) {
                    Intrinsics.throwNpe();
                }
                PsiTypeParameterList psiTypeParameterList2 = virtualMethod.getTypeParameterList();
                if (psiTypeParameterList2 == null) {
                    Intrinsics.throwNpe();
                }
                psiTypeParameterList.replace((PsiElement)psiTypeParameterList2);
            } else {
                PsiTypeParameterList psiTypeParameterList = virtualMethod.getTypeParameterList();
                if (psiTypeParameterList == null) {
                    Intrinsics.throwNpe();
                }
                method.addAfter((PsiElement)psiTypeParameterList, method.getFirstChild());
            }
        } else {
            PsiTypeParameterList psiTypeParameterList = method.getTypeParameterList();
            if (psiTypeParameterList != null) {
                psiTypeParameterList.delete();
            }
        }
        Object[] objectArray = method.getParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"method.parameters");
        Object[] objectArray2 = virtualMethod.getParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray2, (String)"virtualMethod.parameters");
        Iterable $this$forEach$iv = ArraysKt.zip((Object[])objectArray, (Object[])objectArray2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GrParameter inferred;
            Pair $dstr$actual$inferred = (Pair)element$iv;
            boolean bl = false;
            GrParameter actual = (GrParameter)$dstr$actual$inferred.component1();
            GrParameter grParameter = inferred = (GrParameter)$dstr$actual$inferred.component2();
            Intrinsics.checkExpressionValueIsNotNull((Object)grParameter, (String)"inferred");
            actual.setType(grParameter.getType());
        }
        if (method.isConstructor() || method.getReturnTypeElementGroovy() != null && !method.hasTypeParameters()) {
            method.getModifierList().setModifierProperty("def", false);
        }
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return getElementPredicate.1.INSTANCE;
    }

    @Override
    protected boolean isStopElement(@Nullable PsiElement element) {
        return element instanceof GrOpenBlock || element instanceof GrMethod || super.isStopElement(element);
    }

    @Override
    @NotNull
    public String getText() {
        String string = GroovyIntentionsBundle.message("infer.method.parameters.types", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"GroovyIntentionsBundle.m\u2026method.parameters.types\")");
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = GroovyIntentionsBundle.message("infer.method.parameters.types.for.method.declaration", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"GroovyIntentionsBundle.m\u2026.for.method.declaration\")");
        return string;
    }
}

