/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.style;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeStyle.GrReferenceAdjuster;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GrQualifiedReference;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;

public class ImportOnDemandIntention
extends Intention {
    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        if (element == null) {
            ImportOnDemandIntention.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ImportOnDemandIntention.$$$reportNull$$$0(1);
        }
        if (!(element instanceof GrReferenceElement)) {
            return;
        }
        GrReferenceElement ref = (GrReferenceElement)element;
        PsiElement resolved = ref.resolve();
        if (!(resolved instanceof PsiClass)) {
            return;
        }
        String qname = ((PsiClass)resolved).getQualifiedName();
        GrImportStatement importStatement = GroovyPsiElementFactory.getInstance(project).createImportStatementFromText(qname, true, true, null);
        PsiFile containingFile = element.getContainingFile();
        if (!(containingFile instanceof GroovyFile)) {
            return;
        }
        ((GroovyFile)containingFile).addImport(importStatement);
        for (PsiReference reference : ReferencesSearch.search((PsiElement)resolved, (SearchScope)new LocalSearchScope((PsiElement)containingFile))) {
            PsiElement parent2;
            PsiElement refElement = reference.getElement();
            if (refElement == null || !((parent2 = refElement.getParent()) instanceof GrQualifiedReference)) continue;
            GrReferenceAdjuster.shortenReference((GrQualifiedReference)parent2);
        }
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!(element instanceof GrReferenceElement)) {
                    return false;
                }
                GrReferenceElement ref = (GrReferenceElement)element;
                PsiElement parent2 = ref.getParent();
                if (!(parent2 instanceof GrReferenceElement)) {
                    return false;
                }
                PsiElement resolved = ref.resolve();
                if (resolved == null) {
                    return false;
                }
                return resolved instanceof PsiClass;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/style/ImportOnDemandIntention$1", "satisfiedBy"));
            }
        };
        if (psiElementPredicate == null) {
            ImportOnDemandIntention.$$$reportNull$$$0(2);
        }
        return psiElementPredicate;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/intentions/style/ImportOnDemandIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/intentions/style/ImportOnDemandIntention";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

