/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.formatter.blocks;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.openapi.util.TextRange;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.formatter.FormattingContext;
import org.jetbrains.plugins.groovy.formatter.processors.GroovySpacingProcessor;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B3\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0006\u0010\u0014\u001a\u00020\u0001J\b\u0010\u0015\u001a\u00020\u0007H\u0016J\u0006\u0010\u0016\u001a\u00020\u0001J\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001a\u001a\u00020\u0001H\u0016J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0005H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020 H\u0016R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/plugins/groovy/formatter/blocks/SyntheticGroovyBlock;", "Lcom/intellij/formatting/Block;", "subBlocks", "", "wrap", "Lcom/intellij/formatting/Wrap;", "indent", "Lcom/intellij/formatting/Indent;", "childIndent", "context", "Lorg/jetbrains/plugins/groovy/formatter/FormattingContext;", "(Ljava/util/List;Lcom/intellij/formatting/Wrap;Lcom/intellij/formatting/Indent;Lcom/intellij/formatting/Indent;Lorg/jetbrains/plugins/groovy/formatter/FormattingContext;)V", "getContext", "()Lorg/jetbrains/plugins/groovy/formatter/FormattingContext;", "getAlignment", "Lcom/intellij/formatting/Alignment;", "getChildAttributes", "Lcom/intellij/formatting/ChildAttributes;", "newChildIndex", "", "getFirstChild", "getIndent", "getLastChild", "getSpacing", "Lcom/intellij/formatting/Spacing;", "child1", "child2", "getSubBlocks", "getTextRange", "Lcom/intellij/openapi/util/TextRange;", "getWrap", "isIncomplete", "", "isLeaf", "intellij.groovy"})
public class SyntheticGroovyBlock
implements Block {
    private final List<Block> subBlocks;
    private final Wrap wrap;
    private final Indent indent;
    private final Indent childIndent;
    @NotNull
    private final FormattingContext context;

    @NotNull
    public TextRange getTextRange() {
        if (this.subBlocks.isEmpty()) {
            TextRange textRange = TextRange.EMPTY_RANGE;
            Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"TextRange.EMPTY_RANGE");
            return textRange;
        }
        TextRange textRange = ((Block)CollectionsKt.first(this.subBlocks)).getTextRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"subBlocks.first().textRange");
        int n = textRange.getStartOffset();
        TextRange textRange2 = ((Block)CollectionsKt.last(this.subBlocks)).getTextRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange2, (String)"subBlocks.last().textRange");
        return new TextRange(n, textRange2.getEndOffset());
    }

    @NotNull
    public List<Block> getSubBlocks() {
        return this.subBlocks;
    }

    @NotNull
    public Wrap getWrap() {
        return this.wrap;
    }

    @NotNull
    public Indent getIndent() {
        return this.indent;
    }

    @Nullable
    public Alignment getAlignment() {
        return null;
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        Intrinsics.checkParameterIsNotNull((Object)child2, (String)"child2");
        return GroovySpacingProcessor.getSpacing(child1, child2, this.context);
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        return new ChildAttributes(this.childIndent, null);
    }

    public boolean isIncomplete() {
        return ((Block)CollectionsKt.last(this.subBlocks)).isIncomplete();
    }

    public boolean isLeaf() {
        return false;
    }

    @NotNull
    public final Block getFirstChild() {
        return (Block)CollectionsKt.first(this.subBlocks);
    }

    @NotNull
    public final Block getLastChild() {
        return (Block)CollectionsKt.last(this.subBlocks);
    }

    @NotNull
    public final FormattingContext getContext() {
        return this.context;
    }

    public SyntheticGroovyBlock(@NotNull List<? extends Block> subBlocks, @NotNull Wrap wrap, @NotNull Indent indent, @NotNull Indent childIndent, @NotNull FormattingContext context) {
        Intrinsics.checkParameterIsNotNull(subBlocks, (String)"subBlocks");
        Intrinsics.checkParameterIsNotNull((Object)wrap, (String)"wrap");
        Intrinsics.checkParameterIsNotNull((Object)indent, (String)"indent");
        Intrinsics.checkParameterIsNotNull((Object)childIndent, (String)"childIndent");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.subBlocks = subBlocks;
        this.wrap = wrap;
        this.indent = indent;
        this.childIndent = childIndent;
        this.context = context;
        if (this.subBlocks.isEmpty()) {
            throw (Throwable)new IllegalArgumentException("SyntheticGroovyBlock should contain at least one child block");
        }
    }
}

