/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.formatter.blocks;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.formatter.AlignmentProvider;
import org.jetbrains.plugins.groovy.formatter.FormattingContext;
import org.jetbrains.plugins.groovy.formatter.blocks.ClosureBodyBlock;
import org.jetbrains.plugins.groovy.formatter.blocks.GrLabelBlock;
import org.jetbrains.plugins.groovy.formatter.blocks.GroovyBlock;
import org.jetbrains.plugins.groovy.formatter.blocks.GroovyBlockWithRange;
import org.jetbrains.plugins.groovy.formatter.blocks.MethodCallWithoutQualifierBlock;
import org.jetbrains.plugins.groovy.formatter.blocks.SyntheticGroovyBlock;
import org.jetbrains.plugins.groovy.formatter.processors.GroovyIndentProcessor;
import org.jetbrains.plugins.groovy.formatter.processors.GroovyWrappingProcessor;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GrQualifiedReference;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyTokenSets;
import org.jetbrains.plugins.groovy.lang.psi.api.GrArrayInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.GrTryResourceList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrThrowsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrTraditionalForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrElvisExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrExtendsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyBlockGenerator {
    private static final TokenSet NESTED = TokenSet.create((IElementType[])new IElementType[]{org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.REFERENCE_EXPRESSION, org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.PATH_INDEX_PROPERTY, org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.PATH_METHOD_CALL, org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.PATH_PROPERTY_REFERENCE});
    private static final Logger LOG = Logger.getInstance(GroovyBlockGenerator.class);
    private final GroovyBlock myBlock;
    private final ASTNode myNode;
    private final AlignmentProvider myAlignmentProvider;
    private final GroovyWrappingProcessor myWrappingProcessor;
    private final FormattingContext myContext;

    public GroovyBlockGenerator(GroovyBlock block) {
        this.myBlock = block;
        this.myNode = this.myBlock.getNode();
        this.myContext = block.getContext();
        this.myAlignmentProvider = this.myContext.getAlignmentProvider();
        this.myWrappingProcessor = new GroovyWrappingProcessor(this.myBlock);
    }

    static List<ASTNode> getClosureBodyVisibleChildren(ASTNode node) {
        ASTNode last;
        ASTNode first;
        List<ASTNode> children = GroovyBlockGenerator.visibleChildren(node);
        if (!children.isEmpty() && (first = children.get(0)).getElementType() == GroovyTokenTypes.mLCURLY) {
            children.remove(0);
        }
        if (!children.isEmpty() && (last = children.get(children.size() - 1)).getElementType() == GroovyTokenTypes.mRCURLY) {
            children.remove(children.size() - 1);
        }
        return children;
    }

    public List<Block> generateSubBlocks() {
        AlignmentProvider.Aligner aligner;
        String text;
        PsiElement blockPsi = this.myNode.getPsi();
        IElementType elementType = this.myNode.getElementType();
        if (blockPsi instanceof GrBinaryExpression && !(blockPsi.getParent() instanceof GrBinaryExpression)) {
            return this.generateForBinaryExpr();
        }
        if (GroovyTokenSets.STRING_LITERALS.contains(elementType) && this.myBlock.getTextRange().equals((Object)this.myNode.getTextRange()) && (text = this.myNode.getText()).length() > 6 && (text.substring(0, 3).equals("'''") && text.substring(text.length() - 3).equals("'''") || text.substring(0, 3).equals("\"\"\"") & text.substring(text.length() - 3).equals("\"\"\""))) {
            return this.generateForMultiLineString();
        }
        if (elementType == org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.GSTRING || elementType == org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.REGEX || elementType == GroovyTokenTypes.mREGEX_LITERAL || elementType == GroovyTokenTypes.mDOLLAR_SLASH_REGEX_LITERAL) {
            ASTNode[] children;
            FormattingContext context = this.myNode.getPsi() instanceof GrString && ((GrString)this.myNode.getPsi()).isPlainString() ? this.myContext.createContext(true) : this.myContext;
            ArrayList<Block> subBlocks = new ArrayList<Block>();
            for (ASTNode childNode : children = GroovyBlockGenerator.getGroovyChildren(this.myNode)) {
                if (childNode.getTextRange().getLength() <= 0) continue;
                subBlocks.add(new GroovyBlock(childNode, this.getIndent(childNode), Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false), context));
            }
            return subBlocks;
        }
        CommonCodeStyleSettings settings = this.myContext.getSettings();
        if (NESTED.contains(elementType) && blockPsi.getParent() != null && !NESTED.contains(blockPsi.getParent().getNode().getElementType())) {
            ArrayList<Block> subBlocks = new ArrayList<Block>();
            AlignmentProvider.Aligner dotsAligner = settings.ALIGN_MULTILINE_CHAINED_METHODS ? this.myAlignmentProvider.createAligner(false) : null;
            Wrap wrap = this.myWrappingProcessor.getChainedMethodCallWrap();
            this.addNestedChildren(this.myNode.getPsi(), subBlocks, dotsAligner, true, wrap);
            return subBlocks;
        }
        if (blockPsi instanceof GrListOrMap && ((GrListOrMap)blockPsi).isMap() && this.myContext.getGroovySettings().ALIGN_NAMED_ARGS_IN_MAP) {
            GrNamedArgument[] namedArgs;
            AlignmentProvider.Aligner labels = this.myAlignmentProvider.createAligner(false);
            AlignmentProvider.Aligner exprs = this.myAlignmentProvider.createAligner(true);
            for (GrNamedArgument arg : namedArgs = ((GrListOrMap)blockPsi).getNamedArguments()) {
                PsiElement colon;
                GrArgumentLabel label = arg.getLabel();
                if (label != null) {
                    labels.append(label);
                }
                if ((colon = arg.getColon()) == null) {
                    colon = arg.getExpression();
                }
                if (colon == null) continue;
                exprs.append(colon);
            }
        }
        if (blockPsi instanceof GrParameterList) {
            Object rParen;
            PsiElement lParen;
            List<ASTNode> children = GroovyBlockGenerator.visibleChildren(this.myNode);
            if (settings.ALIGN_MULTILINE_METHOD_BRACKETS && (lParen = ((GrParameterList)blockPsi).getLParen()) != null && (rParen = ((GrParameterList)blockPsi).getRParen()) != null) {
                this.myAlignmentProvider.addPair(lParen, (PsiElement)rParen, (Boolean)false);
            }
            if (settings.ALIGN_MULTILINE_PARAMETERS) {
                aligner = this.myAlignmentProvider.createAligner(false);
                for (ASTNode node : children) {
                    IElementType type2;
                    if (GroovyBlockGenerator.isKeyword(node) || (type2 = node.getElementType()) == GroovyElementTypes.T_LPAREN || type2 == GroovyElementTypes.T_RPAREN) continue;
                    aligner.append(node.getPsi());
                }
            }
            return this.getGenericBlocks(children);
        }
        if (GroovyBlockGenerator.isListLikeClause(blockPsi)) {
            List<ASTNode> astNodes = GroovyBlockGenerator.visibleChildren(this.myNode);
            if (this.mustAlign(blockPsi, astNodes)) {
                aligner = this.myAlignmentProvider.createAligner(false);
                for (ASTNode node : astNodes) {
                    if (GroovyBlockGenerator.isKeyword(node)) continue;
                    aligner.append(node.getPsi());
                }
            }
            return this.getGenericBlocks(astNodes);
        }
        if (blockPsi instanceof GrSwitchStatement) {
            ArrayList<Block> subBlocks = new ArrayList<Block>();
            ArrayList<Block> bodyBlocks = new ArrayList<Block>();
            List<ASTNode> astNodes = GroovyBlockGenerator.visibleChildren(this.myNode);
            boolean switchBody = false;
            for (ASTNode childNode : astNodes) {
                if (childNode.getElementType() == GroovyTokenTypes.mLCURLY) {
                    switchBody = true;
                }
                if (switchBody) {
                    bodyBlocks.add(new GroovyBlock(childNode, this.getIndent(childNode), this.getChildWrap(childNode), this.myContext));
                    continue;
                }
                subBlocks.add(new GroovyBlock(childNode, this.getIndent(childNode), this.getChildWrap(childNode), this.myContext));
            }
            if (!bodyBlocks.isEmpty()) {
                subBlocks.add(this.createSwitchBodyBlock(bodyBlocks));
            }
            return subBlocks;
        }
        boolean classLevel = blockPsi instanceof GrTypeDefinitionBody;
        if (blockPsi instanceof GrClosableBlock && ((GrClosableBlock)blockPsi).getArrow() != null && ((GrClosableBlock)blockPsi).getParameters().length > 0 && !GroovyBlockGenerator.getClosureBodyVisibleChildren(this.myNode).isEmpty()) {
            GrClosableBlock closableBlock = (GrClosableBlock)blockPsi;
            ArrayList<Block> blocks = new ArrayList<Block>();
            PsiElement lbrace = closableBlock.getLBrace();
            if (lbrace != null) {
                ASTNode node = lbrace.getNode();
                blocks.add(new GroovyBlock(node, this.getIndent(node), Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false), this.myContext));
            }
            Indent indent = Indent.getNormalIndent();
            ASTNode parameterListNode = closableBlock.getParameterList().getNode();
            ClosureBodyBlock bodyBlock = new ClosureBodyBlock(parameterListNode, indent, Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false), this.myContext);
            blocks.add(bodyBlock);
            PsiElement rbrace = closableBlock.getRBrace();
            if (rbrace != null) {
                ASTNode node = rbrace.getNode();
                blocks.add(new GroovyBlock(node, this.getIndent(node), Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false), this.myContext));
            }
            return blocks;
        }
        if (blockPsi instanceof GrCodeBlock || blockPsi instanceof GroovyFile) {
            return this.generateCodeSubBlocks(GroovyBlockGenerator.visibleChildren(this.myNode));
        }
        if (classLevel) {
            return this.generateSubBlocks(GroovyBlockGenerator.visibleChildren(this.myNode), true);
        }
        if (blockPsi instanceof GrTraditionalForClause) {
            if (settings.ALIGN_MULTILINE_FOR) {
                GrTraditionalForClause clause = (GrTraditionalForClause)blockPsi;
                AlignmentProvider.Aligner parenthesesAligner = this.myAlignmentProvider.createAligner(false);
                parenthesesAligner.append(clause.getInitialization());
                parenthesesAligner.append(clause.getCondition());
                parenthesesAligner.append(clause.getUpdate());
            }
        } else if (blockPsi instanceof GrBinaryExpression) {
            if (settings.ALIGN_MULTILINE_BINARY_OPERATION) {
                GrBinaryExpression binary = (GrBinaryExpression)blockPsi;
                GrExpression left = binary.getLeftOperand();
                GrExpression right = binary.getRightOperand();
                if (right != null) {
                    this.myAlignmentProvider.addPair(left, right, (Boolean)false);
                }
            }
        } else if (blockPsi instanceof GrAssignmentExpression) {
            if (settings.ALIGN_MULTILINE_ASSIGNMENT) {
                GrAssignmentExpression assignment = (GrAssignmentExpression)blockPsi;
                GrExpression lValue = assignment.getLValue();
                GrExpression rValue = assignment.getRValue();
                if (rValue != null) {
                    this.myAlignmentProvider.addPair(lValue, rValue, (Boolean)false);
                }
            }
        } else if (blockPsi instanceof GrConditionalExpression && settings.ALIGN_MULTILINE_TERNARY_OPERATION) {
            GrConditionalExpression conditional = (GrConditionalExpression)blockPsi;
            AlignmentProvider.Aligner exprAligner = this.myAlignmentProvider.createAligner(false);
            exprAligner.append(conditional.getCondition());
            if (!(conditional instanceof GrElvisExpression)) {
                exprAligner.append(conditional.getThenBranch());
            }
            exprAligner.append(conditional.getElseBranch());
            ASTNode question = conditional.getNode().findChildByType(GroovyTokenTypes.mQUESTION);
            ASTNode colon = conditional.getNode().findChildByType(GroovyTokenTypes.mCOLON);
            if (question != null && colon != null) {
                AlignmentProvider.Aligner questionColonAligner = this.myAlignmentProvider.createAligner(false);
                questionColonAligner.append(question.getPsi());
                questionColonAligner.append(colon.getPsi());
            }
        }
        return this.getGenericBlocks(GroovyBlockGenerator.visibleChildren(this.myNode));
    }

    @NotNull
    private List<Block> getGenericBlocks(@NotNull List<ASTNode> astNodes) {
        if (astNodes == null) {
            GroovyBlockGenerator.$$$reportNull$$$0(0);
        }
        List list = ContainerUtil.map(astNodes, it -> new GroovyBlock((ASTNode)it, this.getIndent((ASTNode)it), this.getChildWrap((ASTNode)it), this.myContext));
        if (list == null) {
            GroovyBlockGenerator.$$$reportNull$$$0(1);
        }
        return list;
    }

    private Block createSwitchBodyBlock(List<Block> bodyBlocks) {
        final CommonCodeStyleSettings settings = this.myContext.getSettings();
        return new SyntheticGroovyBlock(bodyBlocks, Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false), GroovyIndentProcessor.getBlockIndent(settings.BRACE_STYLE), GroovyIndentProcessor.getIndentInBlock(settings.BRACE_STYLE), this.myContext){

            @Override
            @NotNull
            public ChildAttributes getChildAttributes(int newChildIndex) {
                PsiElement anchorPsi;
                Block block;
                List<Block> subBlocks = this.getSubBlocks();
                if (newChildIndex > 0 && (block = subBlocks.get(newChildIndex - 1)) instanceof GroovyBlock && (anchorPsi = ((GroovyBlock)block).getNode().getPsi()) instanceof GrCaseSection) {
                    boolean finished = GroovyIndentProcessor.isFinishedCase((GrCaseSection)anchorPsi, Integer.MAX_VALUE);
                    Indent indent = GroovyIndentProcessor.getSwitchCaseIndent(settings);
                    int indentSize = 0;
                    CommonCodeStyleSettings.IndentOptions options = settings.getIndentOptions();
                    if (options != null) {
                        indentSize = options.INDENT_SIZE;
                    }
                    if (!finished) {
                        indent = Indent.getSpaceIndent((int)((indent.getType() == Indent.Type.NORMAL ? indentSize : 0) + indentSize));
                    }
                    ChildAttributes childAttributes = new ChildAttributes(indent, null);
                    if (childAttributes == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return childAttributes;
                }
                ChildAttributes childAttributes = super.getChildAttributes(newChildIndex);
                if (childAttributes == null) {
                    1.$$$reportNull$$$0(1);
                }
                return childAttributes;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/formatter/blocks/GroovyBlockGenerator$1", "getChildAttributes"));
            }
        };
    }

    private Wrap getChildWrap(ASTNode childNode) {
        return this.myWrappingProcessor.getChildWrap(childNode);
    }

    @NotNull
    List<Block> generateCodeSubBlocks(List<ASTNode> children) {
        ArrayList<Block> subBlocks = new ArrayList<Block>();
        List<ASTNode> flattenChildren = GroovyBlockGenerator.flattenChildren(children);
        this.calculateAlignments(flattenChildren, false);
        for (int i = 0; i < flattenChildren.size(); ++i) {
            ASTNode childNode = flattenChildren.get(i);
            if (childNode.getElementType() == org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.LABELED_STATEMENT) {
                int start = i;
                while (++i < flattenChildren.size() && flattenChildren.get(i).getElementType() != org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.LABELED_STATEMENT && flattenChildren.get(i).getElementType() != GroovyTokenTypes.mRCURLY) {
                }
                subBlocks.add(new GrLabelBlock(childNode, flattenChildren.subList(start + 1, i), this.getIndent(childNode), this.getChildWrap(childNode), this.myContext));
                --i;
                continue;
            }
            subBlocks.add(new GroovyBlock(childNode, this.getIndent(childNode), this.getChildWrap(childNode), this.myContext));
        }
        ArrayList<Block> arrayList = subBlocks;
        if (arrayList == null) {
            GroovyBlockGenerator.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    List<Block> generateSubBlocks(List<ASTNode> children, boolean classLevel) {
        ArrayList<Block> subBlocks = new ArrayList<Block>();
        this.calculateAlignments(children, classLevel);
        for (ASTNode childNode : children) {
            subBlocks.add(new GroovyBlock(childNode, this.getIndent(childNode), this.getChildWrap(childNode), this.myContext));
        }
        return subBlocks;
    }

    private static List<ASTNode> flattenChildren(List<ASTNode> children) {
        ArrayList<ASTNode> result2 = new ArrayList<ASTNode>();
        for (ASTNode child : children) {
            GroovyBlockGenerator.processNodeFlattening(result2, child);
        }
        return result2;
    }

    private static void processNodeFlattening(ArrayList<ASTNode> result2, ASTNode child) {
        result2.add(child);
        if (child.getElementType() == org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.LABELED_STATEMENT) {
            for (ASTNode node : GroovyBlockGenerator.visibleChildren(child)) {
                GroovyBlockGenerator.processNodeFlattening(result2, node);
            }
        }
    }

    private Indent getIndent(ASTNode childNode) {
        return new GroovyIndentProcessor().getChildIndent(this.myBlock, childNode);
    }

    private void calculateAlignments(List<ASTNode> children, boolean classLevel) {
        ArrayList<GrStatement> currentGroup = null;
        boolean spock = true;
        for (ASTNode child : children) {
            PsiElement psi = child.getPsi();
            if (psi instanceof GrLabeledStatement) {
                this.alignGroup(currentGroup, spock, classLevel);
                currentGroup = new ArrayList<GrStatement>();
                spock = true;
                continue;
            }
            if (currentGroup != null && spock && GroovyBlockGenerator.isTablePart(psi)) {
                currentGroup.add((GrStatement)psi);
                continue;
            }
            if (psi instanceof GrVariableDeclaration) {
                GrVariable[] variables = ((GrVariableDeclaration)psi).getVariables();
                if (variables.length <= 0) continue;
                if (!classLevel || currentGroup == null || this.fieldGroupEnded(psi) || spock) {
                    this.alignGroup(currentGroup, spock, classLevel);
                    currentGroup = new ArrayList();
                    spock = false;
                }
                currentGroup.add((GrStatement)psi);
                continue;
            }
            if (this.shouldSkip(classLevel, psi)) continue;
            this.alignGroup(currentGroup, spock, classLevel);
            currentGroup = null;
        }
        if (currentGroup != null) {
            this.alignGroup(currentGroup, spock, classLevel);
        }
    }

    private boolean shouldSkip(boolean classLevel, PsiElement psi) {
        PsiElement prev;
        if (!(!(psi instanceof PsiComment) || (prev = psi.getPrevSibling()) == null || classLevel && PsiUtil.isNewLine(prev) && this.fieldGroupEnded(psi))) {
            return true;
        }
        return psi.getParent() instanceof GrLabeledStatement && (psi instanceof GrLiteral && GrStringUtil.isStringLiteral((GrLiteral)psi) || !(psi instanceof GrStatement));
    }

    private void alignGroup(@Nullable List<GrStatement> group, boolean spock, boolean classLevel) {
        if (group == null) {
            return;
        }
        if (spock) {
            this.alignSpockTable(group);
        } else {
            this.alignVariableDeclarations(group, classLevel);
        }
    }

    private void alignVariableDeclarations(List<GrStatement> group, boolean classLevel) {
        AlignmentProvider.Aligner typeElement = this.myAlignmentProvider.createAligner(true);
        AlignmentProvider.Aligner varName = this.myAlignmentProvider.createAligner(true);
        AlignmentProvider.Aligner eq = this.myAlignmentProvider.createAligner(true);
        for (GrStatement statement : group) {
            GrVariable[] variables;
            GrVariableDeclaration varDeclaration = (GrVariableDeclaration)statement;
            for (GrVariable variable : variables = varDeclaration.getVariables()) {
                varName.append(variable.getNameIdentifierGroovy());
            }
            if (!classLevel || !this.myContext.getSettings().ALIGN_GROUP_FIELD_DECLARATIONS) continue;
            typeElement.append(varDeclaration.getTypeElementGroovy());
            ASTNode current_eq = variables[variables.length - 1].getNode().findChildByType(GroovyTokenTypes.mASSIGN);
            if (current_eq == null) continue;
            eq.append(current_eq.getPsi());
        }
    }

    private void alignSpockTable(List<GrStatement> group) {
        int second;
        if (group.size() < 2) {
            return;
        }
        GrStatement inner = group.get(0);
        boolean embedded = inner != null && GroovyBlockGenerator.isTablePart(inner);
        GrStatement first = embedded ? inner : group.get(1);
        List alignments = ContainerUtil.map2List(GroovyBlockGenerator.getSpockTable(first), leaf -> this.myAlignmentProvider.createAligner((PsiElement)leaf, true, Alignment.Anchor.RIGHT));
        for (int i = second = embedded ? 1 : 2; i < group.size(); ++i) {
            List<LeafPsiElement> table = GroovyBlockGenerator.getSpockTable(group.get(i));
            for (int j = 0; j < Math.min(table.size(), alignments.size()); ++j) {
                ((AlignmentProvider.Aligner)alignments.get(j)).append((PsiElement)table.get(j));
            }
        }
    }

    private boolean fieldGroupEnded(PsiElement psi) {
        if (!this.myContext.getSettings().ALIGN_GROUP_FIELD_DECLARATIONS) {
            return true;
        }
        PsiElement prevSibling = psi.getPrevSibling();
        return prevSibling != null && StringUtil.countChars((CharSequence)prevSibling.getText(), (char)'\n') >= this.myContext.getSettings().KEEP_BLANK_LINES_IN_DECLARATIONS;
    }

    private static List<LeafPsiElement> getSpockTable(GrStatement statement) {
        final ArrayList<LeafPsiElement> result2 = new ArrayList<LeafPsiElement>();
        statement.accept(new GroovyElementVisitor(){

            @Override
            public void visitBinaryExpression(@NotNull GrBinaryExpression expression) {
                if (expression == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (GroovyBlockGenerator.isTablePart(expression)) {
                    result2.add((LeafPsiElement)expression.getOperationToken());
                    expression.acceptChildren(this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/formatter/blocks/GroovyBlockGenerator$2", "visitBinaryExpression"));
            }
        });
        result2.sort(Comparator.comparingInt(TreeElement::getStartOffset));
        return result2;
    }

    private static boolean isTablePart(PsiElement psi) {
        return psi instanceof GrBinaryExpression && (GroovyTokenTypes.mBOR == ((GrBinaryExpression)psi).getOperationTokenType() || GroovyTokenTypes.mLOR == ((GrBinaryExpression)psi).getOperationTokenType());
    }

    public static List<ASTNode> visibleChildren(ASTNode node) {
        ArrayList<ASTNode> list = new ArrayList<ASTNode>();
        for (ASTNode astNode : GroovyBlockGenerator.getGroovyChildren(node)) {
            if (!GroovyBlockGenerator.canBeCorrectBlock(astNode)) continue;
            list.add(astNode);
        }
        return list;
    }

    private boolean mustAlign(PsiElement blockPsi, List<ASTNode> children) {
        if (blockPsi instanceof GrArgumentList && this.myContext.getSettings().ALIGN_MULTILINE_PARAMETERS_IN_CALLS) {
            return children.size() != 3 || children.get(0).getElementType() != GroovyTokenTypes.mLPAREN || children.get(1).getElementType() != org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.CLOSABLE_BLOCK && children.get(1).getElementType() != org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.LIST_OR_MAP || children.get(2).getElementType() != GroovyTokenTypes.mRPAREN;
        }
        if (blockPsi instanceof GrAssignmentExpression && ((GrAssignmentExpression)blockPsi).getRValue() instanceof GrAssignmentExpression) {
            return this.myContext.getSettings().ALIGN_MULTILINE_ASSIGNMENT;
        }
        return blockPsi instanceof GrExtendsClause && this.myContext.getSettings().ALIGN_MULTILINE_EXTENDS_LIST || blockPsi instanceof GrThrowsClause && this.myContext.getSettings().ALIGN_MULTILINE_THROWS_LIST || blockPsi instanceof GrListOrMap && this.myContext.getGroovySettings().ALIGN_MULTILINE_LIST_OR_MAP || blockPsi instanceof GrTryResourceList && this.myContext.getSettings().ALIGN_MULTILINE_RESOURCES || blockPsi instanceof GrArrayInitializer && this.myContext.getSettings().ALIGN_MULTILINE_ARRAY_INITIALIZER_EXPRESSION;
    }

    private static boolean isListLikeClause(PsiElement blockPsi) {
        return blockPsi instanceof GrArgumentList || blockPsi instanceof GrAssignmentExpression || blockPsi instanceof GrExtendsClause || blockPsi instanceof GrThrowsClause || blockPsi instanceof GrListOrMap || blockPsi instanceof GrTryResourceList || blockPsi instanceof GrArrayInitializer;
    }

    private static boolean isKeyword(ASTNode node) {
        if (node == null) {
            return false;
        }
        return TokenSets.KEYWORDS.contains(node.getElementType()) || TokenSets.BRACES.contains(node.getElementType()) && !((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withText(")")).withParent(GrArgumentList.class)).afterLeaf(new String[]{","})).accepts((Object)node.getPsi());
    }

    private List<Block> generateForMultiLineString() {
        ArrayList<Block> subBlocks = new ArrayList<Block>();
        int start = this.myNode.getTextRange().getStartOffset();
        int end = this.myNode.getTextRange().getEndOffset();
        subBlocks.add(new GroovyBlockWithRange(this.myNode, Indent.getNoneIndent(), new TextRange(start, start + 3), Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false), this.myContext));
        subBlocks.add(new GroovyBlockWithRange(this.myNode, Indent.getAbsoluteNoneIndent(), new TextRange(start + 3, end - 3), Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false), this.myContext));
        subBlocks.add(new GroovyBlockWithRange(this.myNode, Indent.getAbsoluteNoneIndent(), new TextRange(end - 3, end), Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false), this.myContext));
        return subBlocks;
    }

    private static boolean canBeCorrectBlock(ASTNode node) {
        return !node.getText().trim().isEmpty();
    }

    private static ASTNode[] getGroovyChildren(ASTNode node) {
        PsiElement psi = node.getPsi();
        if (psi instanceof OuterLanguageElement) {
            TextRange range = node.getTextRange();
            ArrayList<ASTNode> childList = new ArrayList<ASTNode>();
            PsiFile groovyFile = psi.getContainingFile().getViewProvider().getPsi((Language)GroovyLanguage.INSTANCE);
            if (groovyFile instanceof GroovyFileBase) {
                GroovyBlockGenerator.addChildNodes((PsiElement)groovyFile, childList, range, psi);
            }
            return childList.toArray(ASTNode.EMPTY_ARRAY);
        }
        return node.getChildren(null);
    }

    private static void addChildNodes(PsiElement elem, ArrayList<ASTNode> childNodes, TextRange range, PsiElement root) {
        ASTNode node = elem.getNode();
        if (range.contains(elem.getTextRange()) && node != null && elem != root && !(elem instanceof PsiFile)) {
            childNodes.add(node);
        } else {
            for (PsiElement child : elem.getChildren()) {
                GroovyBlockGenerator.addChildNodes(child, childNodes, range, root);
            }
        }
    }

    private List<Block> generateForBinaryExpr() {
        ArrayList<Block> subBlocks = new ArrayList<Block>();
        AlignmentProvider.Aligner alignment = this.myContext.getSettings().ALIGN_MULTILINE_BINARY_OPERATION ? this.myAlignmentProvider.createAligner(false) : null;
        GrBinaryExpression binary = (GrBinaryExpression)this.myNode.getPsi();
        LOG.assertTrue(binary != null);
        this.addBinaryChildrenRecursively(binary, subBlocks, Indent.getContinuationWithoutFirstIndent(), alignment);
        return subBlocks;
    }

    private void addBinaryChildrenRecursively(PsiElement elem, List<Block> list, Indent indent, @Nullable AlignmentProvider.Aligner aligner) {
        if (elem == null) {
            return;
        }
        if (elem instanceof GrBinaryExpression) {
            GrBinaryExpression myExpr = (GrBinaryExpression)elem;
            if (myExpr.getLeftOperand() instanceof GrBinaryExpression) {
                this.addBinaryChildrenRecursively(myExpr.getLeftOperand(), list, Indent.getContinuationWithoutFirstIndent(), aligner);
            }
            PsiElement op = ((GrBinaryExpression)elem).getOperationToken();
            for (ASTNode childNode : GroovyBlockGenerator.visibleChildren(elem.getNode())) {
                PsiElement psi = childNode.getPsi();
                if (psi instanceof GrBinaryExpression) continue;
                if (op != psi && aligner != null) {
                    aligner.append(psi);
                }
                list.add(new GroovyBlock(childNode, indent, this.getChildWrap(childNode), this.myContext));
            }
            if (myExpr.getRightOperand() instanceof GrBinaryExpression) {
                this.addBinaryChildrenRecursively(myExpr.getRightOperand(), list, Indent.getContinuationWithoutFirstIndent(), aligner);
            }
        }
    }

    private void addNestedChildren(PsiElement elem, List<Block> list, @Nullable AlignmentProvider.Aligner aligner, boolean topLevel, Wrap wrap) {
        PsiElement nameElement;
        GrExpression invokedExpression;
        List<ASTNode> children = GroovyBlockGenerator.visibleChildren(elem.getNode());
        if (elem instanceof GrMethodCallExpression && (invokedExpression = ((GrMethodCallExpression)elem).getInvokedExpression()) instanceof GrQualifiedReference && (nameElement = ((GrQualifiedReference)((Object)invokedExpression)).getReferenceNameElement()) != null) {
            ASTNode node;
            int i;
            List<ASTNode> grandChildren = GroovyBlockGenerator.visibleChildren(invokedExpression.getNode());
            for (i = 0; i < grandChildren.size() && nameElement != (node = grandChildren.get(i)).getPsi() && !TokenSets.DOTS.contains(node.getElementType()); ++i) {
            }
            if (i > 0) {
                this.processNestedChildrenPrefix(list, aligner, false, grandChildren.subList(0, i), wrap);
            }
            MethodCallWithoutQualifierBlock nameBlock = new MethodCallWithoutQualifierBlock(nameElement, wrap, topLevel, children, elem, this.myContext);
            List<ASTNode> tail = grandChildren.subList(i, grandChildren.size());
            list.add(this.syntheticBlockForCallTail(aligner, nameElement, tail, nameBlock));
            return;
        }
        this.processNestedChildrenPrefix(list, aligner, topLevel, children, wrap);
    }

    @NotNull
    private Block syntheticBlockForCallTail(@Nullable AlignmentProvider.Aligner aligner, @NotNull PsiElement nameElement, @NotNull List<ASTNode> grandChildren, @NotNull Block nameBlock) {
        if (nameElement == null) {
            GroovyBlockGenerator.$$$reportNull$$$0(3);
        }
        if (grandChildren == null) {
            GroovyBlockGenerator.$$$reportNull$$$0(4);
        }
        if (nameBlock == null) {
            GroovyBlockGenerator.$$$reportNull$$$0(5);
        }
        ArrayList<Block> subBlocks = new ArrayList<Block>();
        for (ASTNode node : grandChildren) {
            PsiElement currentElement = node.getPsi();
            if (aligner != null && TokenSets.DOTS.contains(node.getElementType())) {
                aligner.append(currentElement);
            }
            if (currentElement == nameElement) {
                subBlocks.add(nameBlock);
                continue;
            }
            subBlocks.add(new GroovyBlock(node, this.getIndent(node), this.getChildWrap(node), this.myContext));
        }
        Wrap synWrap = Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false);
        Indent indent = Indent.getContinuationWithoutFirstIndent();
        SyntheticGroovyBlock syntheticGroovyBlock = new SyntheticGroovyBlock(subBlocks, synWrap, indent, indent, this.myContext);
        if (syntheticGroovyBlock == null) {
            GroovyBlockGenerator.$$$reportNull$$$0(6);
        }
        return syntheticGroovyBlock;
    }

    private static boolean isAfterMultiLineClosure(ASTNode dot) {
        PsiElement last;
        PsiElement dotPsi = dot.getPsi();
        PsiElement prev = PsiUtil.skipWhitespaces(dotPsi.getPrevSibling(), false);
        if (prev != null && prev instanceof GrMethodCall && (last = prev.getLastChild()) instanceof GrClosableBlock) {
            return last.getText().contains("\n");
        }
        return false;
    }

    private void processNestedChildrenPrefix(List<Block> list, @Nullable AlignmentProvider.Aligner aligner, boolean topLevel, List<ASTNode> children, Wrap wrap) {
        LOG.assertTrue(children.size() > 0);
        ASTNode fst = children.get(0);
        if (NESTED.contains(fst.getElementType())) {
            this.addNestedChildren(fst.getPsi(), list, aligner, false, wrap);
        } else {
            Indent indent = Indent.getContinuationWithoutFirstIndent();
            list.add(new GroovyBlock(fst, indent, this.getChildWrap(fst), this.myContext));
        }
        this.addNestedChildrenSuffix(list, topLevel, children.subList(1, children.size()));
    }

    void addNestedChildrenSuffix(List<Block> list, boolean topLevel, List<ASTNode> children) {
        for (ASTNode childNode : children) {
            if (!GroovyBlockGenerator.canBeCorrectBlock(childNode)) continue;
            IElementType type2 = childNode.getElementType();
            Indent indent = NESTED.contains(type2) || type2 == GroovyTokenTypes.mIDENT || TokenSets.DOTS.contains(type2) && !GroovyBlockGenerator.isAfterMultiLineClosure(childNode) || topLevel ? Indent.getContinuationWithoutFirstIndent() : Indent.getNoneIndent();
            list.add(new GroovyBlock(childNode, indent, this.getChildWrap(childNode), this.myContext));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "astNodes";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/formatter/blocks/GroovyBlockGenerator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grandChildren";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameBlock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/formatter/blocks/GroovyBlockGenerator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenericBlocks";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "generateCodeSubBlocks";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "syntheticBlockForCallTail";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getGenericBlocks";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "syntheticBlockForCallTail";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

