/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.ext.spock;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtilKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u0005H\u0002\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\u0005\u001a\n\u0010\b\u001a\u00020\u0007*\u00020\t\u001a\f\u0010\n\u001a\u00020\u0007*\u00020\u000bH\u0002\u001a\f\u0010\f\u001a\u00020\u0007*\u00020\u0001H\u0002\u001a\f\u0010\f\u001a\u00020\u0007*\u00020\tH\u0002\u001a\f\u0010\r\u001a\u00020\u0007*\u00020\u000bH\u0002\u001a\f\u0010\u000e\u001a\u00020\u0007*\u00020\u000bH\u0002\u00a8\u0006\u000f"}, d2={"findWhereLabeledStatement", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrStatement;", "top", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrLabeledStatement;", "findMaybeTableRow", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrBinaryExpression;", "isOr", "", "isTableColumnSeparator", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "isTableHeader", "Lcom/intellij/psi/PsiElement;", "isTableRow", "isUnderTableHeader", "maybeTableColumnExpression", "intellij.groovy.psi"})
public final class DataTablesKt {
    public static final boolean isTableColumnSeparator(@NotNull GrExpression $this$isTableColumnSeparator) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isTableColumnSeparator, (String)"$this$isTableColumnSeparator");
        if (!($this$isTableColumnSeparator instanceof GrBinaryExpression) || !DataTablesKt.isOr((GrBinaryExpression)$this$isTableColumnSeparator)) {
            return false;
        }
        GrBinaryExpression grBinaryExpression = DataTablesKt.findMaybeTableRow((GrBinaryExpression)$this$isTableColumnSeparator);
        if (grBinaryExpression == null) {
            return false;
        }
        GrBinaryExpression maybeTableRow = grBinaryExpression;
        return DataTablesKt.isUnderTableHeader(maybeTableRow) || DataTablesKt.isTableRow(maybeTableRow);
    }

    private static final GrBinaryExpression findMaybeTableRow(@NotNull GrBinaryExpression $this$findMaybeTableRow) {
        GrBinaryExpression current = $this$findMaybeTableRow;
        while (true) {
            PsiElement parent2;
            if ((parent2 = current.getParent()) == null) {
                return null;
            }
            if (!(parent2 instanceof GrBinaryExpression) || !DataTablesKt.isOr((GrBinaryExpression)parent2)) break;
            current = (GrBinaryExpression)parent2;
        }
        return current;
    }

    private static final boolean isUnderTableHeader(@NotNull PsiElement $this$isUnderTableHeader) {
        PsiElement psiElement = $this$isUnderTableHeader.getParent();
        return psiElement != null ? DataTablesKt.isTableHeader(psiElement) : false;
    }

    private static final boolean isTableHeader(@NotNull PsiElement $this$isTableHeader) {
        return $this$isTableHeader instanceof GrLabeledStatement && Intrinsics.areEqual((Object)((GrLabeledStatement)$this$isTableHeader).getName(), (Object)"where");
    }

    private static final boolean isTableRow(@NotNull GrExpression $this$isTableRow) {
        PsiElement parent2 = $this$isTableRow.getParent();
        if (parent2 instanceof GrLabeledStatement && Intrinsics.areEqual((Object)((GrLabeledStatement)parent2).getName(), (Object)"and")) {
            return DataTablesKt.isTableRow((GrStatement)parent2);
        }
        GrExpression grExpression = $this$isTableRow;
        if (grExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement");
        }
        return DataTablesKt.isTableRow((GrStatement)grExpression);
    }

    private static final boolean isTableRow(@NotNull GrStatement $this$isTableRow) {
        Sequence sequence = SequencesKt.drop((Sequence)PsiTreeUtilKt.siblings((PsiElement)$this$isTableRow, (boolean)false), (int)1);
        TokenSet tokenSet = TokenSets.WHITE_SPACES_OR_COMMENTS;
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet, (String)"WHITE_SPACES_OR_COMMENTS");
        for (PsiElement sibling : PsiTreeUtilKt.skipTokens((Sequence)sequence, (TokenSet)tokenSet)) {
            if (DataTablesKt.maybeTableColumnExpression(sibling)) continue;
            if (!(sibling instanceof GrLabeledStatement)) {
                return false;
            }
            if (Intrinsics.areEqual((Object)((GrLabeledStatement)sibling).getName(), (Object)"and")) {
                GrStatement grStatement = ((GrLabeledStatement)sibling).getStatement();
                if (grStatement != null) {
                    if (DataTablesKt.maybeTableColumnExpression(grStatement)) {
                        continue;
                    }
                }
            }
            return DataTablesKt.findWhereLabeledStatement((GrLabeledStatement)sibling) != null;
        }
        return false;
    }

    @Nullable
    public static final GrStatement findWhereLabeledStatement(@NotNull GrLabeledStatement top) {
        Intrinsics.checkParameterIsNotNull((Object)top, (String)"top");
        GrLabeledStatement current = top;
        while (true) {
            GrStatement labeledStatement = current.getStatement();
            if (Intrinsics.areEqual((Object)"where", (Object)current.getName())) {
                return labeledStatement;
            }
            if (!(labeledStatement instanceof GrLabeledStatement)) break;
            current = (GrLabeledStatement)labeledStatement;
        }
        return null;
    }

    private static final boolean maybeTableColumnExpression(@NotNull PsiElement $this$maybeTableColumnExpression) {
        return $this$maybeTableColumnExpression instanceof GrBinaryExpression && DataTablesKt.isOr((GrBinaryExpression)$this$maybeTableColumnExpression);
    }

    public static final boolean isOr(@NotNull GrBinaryExpression $this$isOr) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isOr, (String)"$this$isOr");
        IElementType iElementType = $this$isOr.getOperationTokenType();
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"operationTokenType");
        IElementType type2 = iElementType;
        return type2 == GroovyElementTypes.T_BOR || type2 == GroovyElementTypes.T_LOR;
    }
}

