/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.console;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.io.BaseOutputReader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.console.BuildAndRestartConsoleAction;
import org.jetbrains.plugins.groovy.console.GroovyConsoleStateService;
import org.jetbrains.plugins.groovy.console.GroovyConsoleUtil;
import org.jetbrains.plugins.groovy.console.GroovyConsoleUtilKt;
import org.jetbrains.plugins.groovy.console.GroovyConsoleView;
import org.jetbrains.plugins.groovy.runner.DefaultGroovyScriptRunner;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunConfiguration;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunner;

public class GroovyConsole {
    public static final Key<GroovyConsole> GROOVY_CONSOLE = Key.create((String)"Groovy console key");
    private static final Logger LOG = Logger.getInstance(GroovyConsole.class);
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final Executor defaultExecutor = DefaultRunExecutor.getRunExecutorInstance();
    private final Project myProject;
    private final RunContentDescriptor myContentDescriptor;
    private final ConsoleView myConsoleView;
    private final ProcessHandler myProcessHandler;

    public GroovyConsole(Project project, RunContentDescriptor descriptor2, ConsoleView view, ProcessHandler handler) {
        this.myProject = project;
        this.myContentDescriptor = descriptor2;
        this.myConsoleView = view;
        this.myProcessHandler = handler;
    }

    private void doExecute(@NotNull String command) {
        if (command == null) {
            GroovyConsole.$$$reportNull$$$0(0);
        }
        for (String line : command.trim().split("\n")) {
            this.myConsoleView.print("> ", ConsoleViewContentType.USER_INPUT);
            this.myConsoleView.print(line, ConsoleViewContentType.USER_INPUT);
            this.myConsoleView.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> GroovyConsole.send(this.myProcessHandler, StringUtil.replace((String)command, (String)"\n", (String)"###\\n")));
    }

    public void execute(@NotNull String command) {
        if (command == null) {
            GroovyConsole.$$$reportNull$$$0(1);
        }
        if (!StringUtil.isEmptyOrSpaces((String)command)) {
            this.doExecute(command);
        }
        ExecutionManager.getInstance((Project)this.myProject).getContentManager().toFrontRunContent(defaultExecutor, this.myContentDescriptor);
    }

    public void stop() {
        this.myProcessHandler.destroyProcess();
    }

    private static void send(@NotNull ProcessHandler processHandler, @NotNull String command) {
        if (processHandler == null) {
            GroovyConsole.$$$reportNull$$$0(2);
        }
        if (command == null) {
            GroovyConsole.$$$reportNull$$$0(3);
        }
        OutputStream outputStream = processHandler.getProcessInput();
        assert (outputStream != null) : "output stream is null";
        Charset charset = processHandler instanceof BaseOSProcessHandler ? ((BaseOSProcessHandler)processHandler).getCharset() : null;
        byte[] bytes = (command + "\n").getBytes(charset != null ? charset : UTF_8);
        try {
            outputStream.write(bytes);
            outputStream.flush();
        }
        catch (IOException ignored) {
            LOG.warn((Throwable)ignored);
        }
    }

    public static void getOrCreateConsole(@NotNull Project project, @NotNull VirtualFile contentFile, @NotNull Consumer<? super GroovyConsole> callback) {
        GroovyConsole existingConsole;
        if (project == null) {
            GroovyConsole.$$$reportNull$$$0(4);
        }
        if (contentFile == null) {
            GroovyConsole.$$$reportNull$$$0(5);
        }
        if (callback == null) {
            GroovyConsole.$$$reportNull$$$0(6);
        }
        if ((existingConsole = (GroovyConsole)contentFile.getUserData(GROOVY_CONSOLE)) != null) {
            return;
        }
        Consumer initializer = module -> {
            GroovyConsole console = GroovyConsole.createConsole(project, contentFile, module);
            if (console != null) {
                callback.consume((Object)console);
            }
        };
        Module module2 = GroovyConsoleStateService.getInstance(project).getSelectedModule(contentFile);
        if (module2 == null || module2.isDisposed()) {
            GroovyConsoleUtil.selectModuleAndRun(project, (Consumer<Module>)initializer);
        } else {
            initializer.consume((Object)module2);
        }
    }

    @Nullable
    public static GroovyConsole createConsole(@NotNull Project project, final @NotNull VirtualFile contentFile, @NotNull Module module) {
        ProcessHandler processHandler;
        if (project == null) {
            GroovyConsole.$$$reportNull$$$0(7);
        }
        if (contentFile == null) {
            GroovyConsole.$$$reportNull$$$0(8);
        }
        if (module == null) {
            GroovyConsole.$$$reportNull$$$0(9);
        }
        if ((processHandler = GroovyConsole.createProcessHandler(module)) == null) {
            return null;
        }
        GroovyConsoleStateService consoleStateService = GroovyConsoleStateService.getInstance(project);
        consoleStateService.setFileModule(contentFile, module);
        String title = consoleStateService.getSelectedModuleTitle(contentFile);
        GroovyConsoleView consoleView = new GroovyConsoleView(project);
        RunContentDescriptor descriptor2 = new RunContentDescriptor((ExecutionConsole)consoleView, processHandler, (JComponent)new JPanel(new BorderLayout()), title);
        final GroovyConsole console = new GroovyConsole(project, descriptor2, (ConsoleView)consoleView, processHandler);
        JComponent consoleViewComponent = consoleView.getComponent();
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add((AnAction)new BuildAndRestartConsoleAction(module, project, defaultExecutor, descriptor2, GroovyConsole.restarter(project, contentFile)));
        actionGroup.addSeparator();
        actionGroup.addAll(consoleView.createConsoleActions());
        actionGroup.add((AnAction)new CloseAction(defaultExecutor, descriptor2, project){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                processHandler.destroyProcess();
                super.actionPerformed(e);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/groovy/console/GroovyConsole$1", "actionPerformed"));
            }
        });
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("GroovyConsole", (ActionGroup)actionGroup, false);
        toolbar.setTargetComponent(consoleViewComponent);
        JComponent ui = descriptor2.getComponent();
        ui.add((Component)consoleViewComponent, "Center");
        ui.add((Component)toolbar.getComponent(), "West");
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (contentFile.getUserData(GROOVY_CONSOLE) == console) {
                    contentFile.putUserData(GROOVY_CONSOLE, null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/groovy/console/GroovyConsole$2", "processTerminated"));
            }
        });
        contentFile.putUserData(GROOVY_CONSOLE, (Object)console);
        consoleView.attachToProcess(processHandler);
        processHandler.startNotify();
        ExecutionManager.getInstance((Project)project).getContentManager().showRunContent(defaultExecutor, descriptor2);
        return console;
    }

    private static ProcessHandler createProcessHandler(Module module) {
        try {
            JavaParameters javaParameters = GroovyConsole.createJavaParameters(module);
            GeneralCommandLine commandLine = javaParameters.toCommandLine();
            return new OSProcessHandler(commandLine){

                public boolean isSilentlyDestroyOnClose() {
                    return true;
                }

                @NotNull
                protected BaseOutputReader.Options readerOptions() {
                    BaseOutputReader.Options options = BaseOutputReader.Options.forMostlySilentProcess();
                    if (options == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return options;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/console/GroovyConsole$3", "readerOptions"));
                }
            };
        }
        catch (ExecutionException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    private static JavaParameters createJavaParameters(@NotNull Module module) throws ExecutionException {
        if (module == null) {
            GroovyConsole.$$$reportNull$$$0(10);
        }
        JavaParameters res = GroovyScriptRunConfiguration.createJavaParametersWithSdk(module);
        DefaultGroovyScriptRunner.configureGenericGroovyRunner(res, module, "groovy.ui.GroovyMain", !GroovyConsoleUtil.hasGroovyAll(module), true, true, false);
        res.getProgramParametersList().addAll(new String[]{"-p", GroovyScriptRunner.getPathInConf("console.groovy")});
        res.setWorkingDirectory(GroovyConsoleUtilKt.getWorkingDirectory(module));
        res.setUseDynamicClasspath(true);
        if (GroovyConsole.useArgsFile(res)) {
            res.setArgFile(true);
        }
        return res;
    }

    private static boolean useArgsFile(@NotNull JavaParameters res) {
        Sdk jdk;
        if (res == null) {
            GroovyConsole.$$$reportNull$$$0(11);
        }
        if ((jdk = res.getJdk()) == null) {
            return false;
        }
        String rootPath = jdk.getHomePath();
        if (rootPath == null) {
            return false;
        }
        return JdkUtil.isModularRuntime((String)rootPath);
    }

    private static Consumer<Module> restarter(Project project, VirtualFile file) {
        return module -> GroovyConsole.createConsole(project, file, module);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "res";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/console/GroovyConsole";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doExecute";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "send";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getOrCreateConsole";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "createConsole";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "createJavaParameters";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "useArgsFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

