/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.validity;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;

public class GroovyUnreachableStatementInspection
extends BaseInspection {
    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "Unreachable statement #loc";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        Visitor visitor2 = new Visitor();
        if (visitor2 == null) {
            GroovyUnreachableStatementInspection.$$$reportNull$$$0(0);
        }
        return visitor2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/validity/GroovyUnreachableStatementInspection", "buildVisitor"));
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitClosure(@NotNull GrClosableBlock closure) {
            if (closure == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitClosure(closure);
            GrStatement[] statements = closure.getStatements();
            for (int i = 0; i < statements.length - 1; ++i) {
                this.checkPair(statements[i], statements[i + 1]);
            }
        }

        @Override
        public void visitOpenBlock(@NotNull GrOpenBlock block) {
            if (block == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            super.visitOpenBlock(block);
            GrStatement[] statements = block.getStatements();
            for (int i = 0; i < statements.length - 1; ++i) {
                this.checkPair(statements[i], statements[i + 1]);
            }
        }

        private void checkPair(GrStatement prev, GrStatement statement) {
            if (!ControlFlowUtils.statementMayCompleteNormally(prev)) {
                this.registerError(statement);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "closure";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "block";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/validity/GroovyUnreachableStatementInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClosure";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitOpenBlock";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

