/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.untypedUnresolvedAccess;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.GroovyQuickFixFactory;
import org.jetbrains.plugins.groovy.codeInspection.untypedUnresolvedAccess.GrUnresolvedAccessChecker;
import org.jetbrains.plugins.groovy.codeInspection.untypedUnresolvedAccess.ReferenceFixesKt;
import org.jetbrains.plugins.groovy.highlighting.HighlightSink;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"checkUnresolvedReference", "", "expression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrReferenceExpression;", "highlightIfGroovyObjectOverridden", "", "highlightIfMissingMethodsDeclared", "highlightSink", "Lorg/jetbrains/plugins/groovy/highlighting/HighlightSink;", "intellij.groovy.psi"})
@JvmName(name="GroovyUnresolvedAccessChecker")
public final class GroovyUnresolvedAccessChecker {
    public static final void checkUnresolvedReference(@NotNull GrReferenceExpression expression, boolean highlightIfGroovyObjectOverridden, boolean highlightIfMissingMethodsDeclared, @NotNull HighlightSink highlightSink) {
        boolean bl;
        Object object;
        Collection collection;
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)highlightSink, (String)"highlightSink");
        PsiElement psiElement = expression.getReferenceNameElement();
        if (psiElement == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"expression.referenceNameElement ?: return");
        PsiElement referenceNameElement = psiElement;
        String string = expression.getReferenceName();
        if (string == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"expression.referenceName ?: return");
        String referenceName = string;
        GroovyResolveResult groovyResolveResult = GrUnresolvedAccessChecker.getBestResolveResult(expression);
        Intrinsics.checkExpressionValueIsNotNull((Object)groovyResolveResult, (String)"GrUnresolvedAccessChecke\u2026ResolveResult(expression)");
        GroovyResolveResult resolveResult2 = groovyResolveResult;
        if (resolveResult2.getElement() != null) {
            if (!GrUnresolvedAccessChecker.isStaticOk(resolveResult2)) {
                highlightSink.registerProblem(referenceNameElement, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, GroovyBundle.message("cannot.reference.non.static", referenceName), new LocalQuickFix[0]);
            }
            return;
        }
        if (ResolveUtil.isKeyOfMap(expression) || ResolveUtil.isClassReference(expression)) {
            return;
        }
        if (!highlightIfGroovyObjectOverridden && GrUnresolvedAccessChecker.areGroovyObjectMethodsOverridden(expression)) {
            return;
        }
        if (!highlightIfMissingMethodsDeclared && GrUnresolvedAccessChecker.areMissingMethodsDeclared(expression)) {
            return;
        }
        ArrayList actions = new ArrayList();
        PsiElement parent2 = expression.getParent();
        if (parent2 instanceof GrMethodCall) {
            collection = actions;
            object = GroovyQuickFixFactory.getInstance().createGroovyStaticImportMethodFix((GrMethodCall)parent2);
            bl = false;
            collection.add(object);
        } else {
            collection = actions;
            object = ReferenceFixesKt.generateCreateClassActions(expression);
            bl = false;
            CollectionsKt.addAll((Collection)collection, (Iterable)object);
            collection = actions;
            object = ReferenceFixesKt.generateAddImportActions(expression);
            bl = false;
            CollectionsKt.addAll((Collection)collection, (Iterable)object);
        }
        collection = actions;
        object = ReferenceFixesKt.generateReferenceExpressionFixes(expression);
        bl = false;
        CollectionsKt.addAll((Collection)collection, (Iterable)object);
        QuickFixActionRegistrar registrar2 = new QuickFixActionRegistrar(actions){
            final /* synthetic */ ArrayList $actions;

            public void register(@NotNull IntentionAction action) {
                Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
                Collection collection = this.$actions;
                boolean bl = false;
                collection.add(action);
            }

            public void register(@NotNull TextRange fixRange, @NotNull IntentionAction action, @Nullable HighlightDisplayKey key) {
                Intrinsics.checkParameterIsNotNull((Object)fixRange, (String)"fixRange");
                Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
                Collection collection = this.$actions;
                boolean bl = false;
                collection.add(action);
            }
            {
                this.$actions = $captured_local_variable$0;
            }
        };
        UnresolvedReferenceQuickFixProvider.registerReferenceFixes((PsiReference)((PsiReference)expression), (QuickFixActionRegistrar)registrar2);
        QuickFixFactory.getInstance().registerOrderEntryFixes(registrar2, (PsiReference)expression);
        highlightSink.registerProblem(referenceNameElement, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, GroovyBundle.message("cannot.resolve", referenceName), actions);
    }
}

