/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.type.highlighting;

import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.assignment.ParameterCastFix;
import org.jetbrains.plugins.groovy.codeInspection.type.highlighting.CallReferenceHighlighter;
import org.jetbrains.plugins.groovy.codeInspection.type.highlighting.HighlightingKt;
import org.jetbrains.plugins.groovy.highlighting.HighlightSink;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.DefaultConstructor;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.api.ExpressionArgument;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyCallReference;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H&J*\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00122\u0010\u0010\u0019\u001a\f\u0012\u0004\u0012\u00020\u00100\u001aj\u0002`\u001bH\u0016J\u0006\u0010\u001c\u001a\u00020\u001dR\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/plugins/groovy/codeInspection/type/highlighting/ConstructorCallHighlighter;", "Lorg/jetbrains/plugins/groovy/codeInspection/type/highlighting/CallReferenceHighlighter;", "reference", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/GroovyCallReference;", "sink", "Lorg/jetbrains/plugins/groovy/highlighting/HighlightSink;", "(Lorg/jetbrains/plugins/groovy/lang/resolve/api/GroovyCallReference;Lorg/jetbrains/plugins/groovy/highlighting/HighlightSink;)V", "ambiguousMethodMessage", "", "getAmbiguousMethodMessage", "()Ljava/lang/String;", "unknownArgsMessage", "getUnknownArgsMessage", "buildFix", "Lorg/jetbrains/plugins/groovy/codeInspection/assignment/ParameterCastFix;", "argument", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Argument;", "expectedType", "Lcom/intellij/psi/PsiType;", "getArgumentList", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/arguments/GrArgumentList;", "getInapplicableMethodMessage", "result", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyMethodResult;", "containingType", "arguments", "", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Arguments;", "highlight", "", "intellij.groovy.psi"})
public abstract class ConstructorCallHighlighter
extends CallReferenceHighlighter {
    @Nullable
    public abstract GrArgumentList getArgumentList();

    @Override
    @NotNull
    public String getUnknownArgsMessage() {
        String string = GroovyBundle.message("cannot.infer.argument.types", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"GroovyBundle.message(\"ca\u2026ot.infer.argument.types\")");
        return string;
    }

    @Override
    @NotNull
    public String getAmbiguousMethodMessage() {
        String string = GroovyBundle.message("method.call.is.ambiguous", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"GroovyBundle.message(\"method.call.is.ambiguous\")");
        return string;
    }

    @Override
    @NotNull
    public String getInapplicableMethodMessage(@NotNull GroovyMethodResult result2, @NotNull PsiType containingType, @NotNull List<? extends Argument> arguments2) {
        Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
        Intrinsics.checkParameterIsNotNull((Object)containingType, (String)"containingType");
        Intrinsics.checkParameterIsNotNull(arguments2, (String)"arguments");
        PsiMethod psiMethod = result2.getElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod, (String)"result.element");
        PsiMethod method = psiMethod;
        String string = method.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"method.name");
        String methodName = string;
        if (method instanceof DefaultConstructor) {
            String string2 = GroovyBundle.message("cannot.apply.default.constructor", methodName);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"GroovyBundle.message(\"ca\u2026constructor\", methodName)");
            return string2;
        }
        String string3 = containingType.getInternalCanonicalText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"containingType.internalCanonicalText");
        String canonicalText = string3;
        String string4 = GroovyBundle.message("cannot.apply.constructor", methodName, canonicalText, HighlightingKt.argumentsString(arguments2));
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"GroovyBundle.message(\"ca\u2026gumentsString(arguments))");
        return string4;
    }

    @Override
    @Nullable
    public ParameterCastFix buildFix(@NotNull Argument argument, @NotNull PsiType expectedType) {
        Intrinsics.checkParameterIsNotNull((Object)argument, (String)"argument");
        Intrinsics.checkParameterIsNotNull((Object)expectedType, (String)"expectedType");
        if (!(argument instanceof ExpressionArgument)) {
            return null;
        }
        List<Argument> list = this.getReference().getArguments();
        if (list == null) {
            return null;
        }
        List<Argument> arguments2 = list;
        GrArgumentList grArgumentList = this.getArgumentList();
        if (grArgumentList == null) {
            return null;
        }
        GrArgumentList list2 = grArgumentList;
        if (!arguments2.contains(argument)) {
            return null;
        }
        int position = list2.getExpressionArgumentIndex(((ExpressionArgument)argument).getExpression());
        return new ParameterCastFix(position, expectedType);
    }

    public final boolean highlight() {
        return this.highlightMethodApplicability();
    }

    public ConstructorCallHighlighter(@NotNull GroovyCallReference reference, @NotNull HighlightSink sink) {
        Intrinsics.checkParameterIsNotNull((Object)reference, (String)"reference");
        Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
        super(reference, sink);
    }
}

