/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.type.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.type.highlighting.CallReferenceHighlighter$WhenMappings;
import org.jetbrains.plugins.groovy.codeInspection.type.highlighting.HighlightingKt;
import org.jetbrains.plugins.groovy.highlighting.HighlightSink;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.resolve.api.Applicability;
import org.jetbrains.plugins.groovy.lang.resolve.api.ApplicabilityData;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.api.ArgumentMapping;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyCallReference;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyMethodCandidate;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.GroovyInferenceSessionBuilder;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H&J!\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002\u00a2\u0006\u0002\u0010\u001cJ\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u001d2\u0006\u0010\u001e\u001a\u00020\u001bH\u0002J\b\u0010\u001f\u001a\u00020 H&J*\u0010!\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u00162\u0010\u0010#\u001a\f\u0012\u0004\u0012\u00020\u00140\u001dj\u0002`$H&J\u0006\u0010%\u001a\u00020&J\u0016\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020\bJ&\u0010*\u001a\u00020&2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0010\u0010#\u001a\f\u0012\u0004\u0012\u00020\u00140\u001dj\u0002`$J\u0006\u0010+\u001a\u00020,J\u0006\u0010-\u001a\u00020&R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\n\u00a8\u0006."}, d2={"Lorg/jetbrains/plugins/groovy/codeInspection/type/highlighting/CallReferenceHighlighter;", "", "reference", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/GroovyCallReference;", "sink", "Lorg/jetbrains/plugins/groovy/highlighting/HighlightSink;", "(Lorg/jetbrains/plugins/groovy/lang/resolve/api/GroovyCallReference;Lorg/jetbrains/plugins/groovy/highlighting/HighlightSink;)V", "ambiguousMethodMessage", "", "getAmbiguousMethodMessage", "()Ljava/lang/String;", "getReference", "()Lorg/jetbrains/plugins/groovy/lang/resolve/api/GroovyCallReference;", "getSink", "()Lorg/jetbrains/plugins/groovy/highlighting/HighlightSink;", "unknownArgsMessage", "getUnknownArgsMessage", "buildFix", "Lcom/intellij/codeInspection/LocalQuickFix;", "argument", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Argument;", "expectedType", "Lcom/intellij/psi/PsiType;", "generateFixes", "", "results", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyMethodResult;", "(Ljava/util/Set;)[Lcom/intellij/codeInspection/LocalQuickFix;", "", "result", "getHighlightElement", "Lcom/intellij/psi/PsiElement;", "getInapplicableMethodMessage", "containingType", "arguments", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Arguments;", "highlightAmbiguousMethod", "", "highlightCannotApplyError", "invokedText", "typesString", "highlightInapplicableMethod", "highlightMethodApplicability", "", "highlightUnknownArgs", "intellij.groovy.psi"})
public abstract class CallReferenceHighlighter {
    @NotNull
    private final GroovyCallReference reference;
    @NotNull
    private final HighlightSink sink;

    @NotNull
    public abstract String getUnknownArgsMessage();

    @NotNull
    public abstract String getAmbiguousMethodMessage();

    @NotNull
    public abstract String getInapplicableMethodMessage(@NotNull GroovyMethodResult var1, @NotNull PsiType var2, @NotNull List<? extends Argument> var3);

    @NotNull
    public abstract PsiElement getHighlightElement();

    @Nullable
    public abstract LocalQuickFix buildFix(@NotNull Argument var1, @NotNull PsiType var2);

    public final void highlightCannotApplyError(@NotNull String invokedText, @NotNull String typesString) {
        Intrinsics.checkParameterIsNotNull((Object)invokedText, (String)"invokedText");
        Intrinsics.checkParameterIsNotNull((Object)typesString, (String)"typesString");
        this.sink.registerError(this.getHighlightElement(), GroovyBundle.message("cannot.apply.method.or.closure", invokedText, typesString), new LocalQuickFix[0]);
    }

    public final void highlightUnknownArgs() {
        this.sink.registerProblem(this.getHighlightElement(), ProblemHighlightType.WEAK_WARNING, this.getUnknownArgsMessage(), new LocalQuickFix[0]);
    }

    public final void highlightAmbiguousMethod() {
        this.sink.registerError(this.getHighlightElement(), this.getAmbiguousMethodMessage(), new LocalQuickFix[0]);
    }

    public final void highlightInapplicableMethod(@NotNull Set<? extends GroovyMethodResult> results, @NotNull List<? extends Argument> arguments2) {
        PsiClass psiClass;
        Intrinsics.checkParameterIsNotNull(results, (String)"results");
        Intrinsics.checkParameterIsNotNull(arguments2, (String)"arguments");
        GroovyMethodResult groovyMethodResult = (GroovyMethodResult)CollectionsKt.firstOrNull((Iterable)results);
        if (groovyMethodResult == null) {
            return;
        }
        GroovyMethodResult result2 = groovyMethodResult;
        PsiMethod psiMethod = result2.getElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod, (String)"result.element");
        PsiMethod method = psiMethod;
        if (method instanceof GrGdkMethod) {
            PsiMethod psiMethod2 = ((GrGdkMethod)method).getStaticMethod();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod2, (String)"method.staticMethod");
            psiClass = psiMethod2.getContainingClass();
        } else {
            psiClass = method.getContainingClass();
        }
        PsiClass containingClass = psiClass;
        String string = method.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"method.name");
        String methodName = string;
        PsiElement highlightElement = this.getHighlightElement();
        String argumentsString2 = HighlightingKt.argumentsString(arguments2);
        if (containingClass == null) {
            this.highlightCannotApplyError(methodName, argumentsString2);
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)method.getProject());
        PsiClassType psiClassType = factory.createType(containingClass, result2.getSubstitutor());
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClassType, (String)"factory.createType(conta\u2026lass, result.substitutor)");
        PsiClassType containingType = psiClassType;
        LocalQuickFix[] fixes = this.generateFixes(results);
        String message = this.getInapplicableMethodMessage(result2, (PsiType)containingType, arguments2);
        this.sink.registerProblem(highlightElement, ProblemHighlightType.GENERIC_ERROR, message, Arrays.copyOf(fixes, fixes.length));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean highlightMethodApplicability() {
        Map $this$fold$iv;
        Object object;
        void $this$associateTo$iv$iv;
        List<Argument> list = this.reference.getArguments();
        if (list == null) {
            CallReferenceHighlighter callReferenceHighlighter = this;
            boolean bl = false;
            boolean bl2 = false;
            CallReferenceHighlighter $this$run = callReferenceHighlighter;
            boolean bl3 = false;
            $this$run.highlightUnknownArgs();
            return true;
        }
        List<Argument> userArguments = list;
        Collection<? extends GroovyResolveResult> collection = this.reference.resolve(false);
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"reference.resolve(false)");
        Iterable $this$associate$iv = CollectionsKt.filterIsInstance((Iterable)collection, GroovyMethodResult.class);
        boolean $i$f$associate22 = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable bl3 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo22 = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Object object2;
            boolean bl4;
            GroovyMethodResult it;
            block13: {
                block12: {
                    object = destination$iv$iv;
                    it = (GroovyMethodResult)element$iv$iv;
                    bl4 = false;
                    object2 = it.getCandidate();
                    if (object2 == null || (object2 = object2.getArgumentMapping()) == null) break block12;
                    PsiSubstitutor psiSubstitutor = it.getSubstitutor();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiSubstitutor, (String)"it.substitutor");
                    if ((object2 = object2.applicability(psiSubstitutor, false)) != null) break block13;
                }
                object2 = Applicability.inapplicable;
            }
            it = TuplesKt.to((Object)it, (Object)object2);
            bl4 = false;
            object.put(it.getFirst(), it.getSecond());
        }
        Map results = destination$iv$iv;
        Iterable $i$f$associate22 = results.entrySet();
        Applicability initial$iv = Applicability.applicable;
        boolean $i$f$fold2 = false;
        Applicability accumulator$iv = initial$iv;
        Iterator $i$f$associateTo22 = $this$fold$iv.iterator();
        while ($i$f$associateTo22.hasNext()) {
            void $dstr$_u24__u24$applicability;
            Object element$iv$iv;
            Object element$iv = $i$f$associateTo22.next();
            element$iv$iv = (Map.Entry)element$iv;
            Applicability status = accumulator$iv;
            boolean bl = false;
            void bl4 = $dstr$_u24__u24$applicability;
            boolean bl5 = false;
            Applicability applicability = (Applicability)((Object)bl4.getValue());
            accumulator$iv = status == Applicability.inapplicable ? Applicability.inapplicable : (applicability == Applicability.inapplicable ? Applicability.inapplicable : applicability);
        }
        Applicability totalApplicability = accumulator$iv;
        switch (CallReferenceHighlighter$WhenMappings.$EnumSwitchMapping$0[totalApplicability.ordinal()]) {
            case 1: {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                $this$fold$iv = results;
                CallReferenceHighlighter callReferenceHighlighter = this;
                boolean $i$f$filter = false;
                void $i$f$fold2 = $this$filter$iv;
                destination$iv$iv = new LinkedHashMap();
                boolean $i$f$filterTo = false;
                Iterator iterator2 = $this$filterTo$iv$iv;
                boolean bl = false;
                object = iterator2.entrySet().iterator();
                while (object.hasNext()) {
                    Map.Entry element$iv$iv;
                    Map.Entry it = element$iv$iv = (Map.Entry)object.next();
                    boolean bl6 = false;
                    if (!((Applicability)((Object)it.getValue()) == Applicability.inapplicable)) continue;
                    destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                Map map2 = destination$iv$iv;
                callReferenceHighlighter.highlightInapplicableMethod(map2.keySet(), userArguments);
                return true;
            }
            case 2: {
                if (results.size() <= 1) break;
                this.highlightUnknownArgs();
                return true;
            }
            case 3: {
                if (results.size() <= 1) break;
                this.highlightAmbiguousMethod();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final LocalQuickFix[] generateFixes(Set<? extends GroovyMethodResult> results) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Iterable iterable = results;
        CallReferenceHighlighter callReferenceHighlighter = this;
        boolean $i$f$flatMap = false;
        void var5_7 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            GroovyMethodResult p1 = (GroovyMethodResult)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = callReferenceHighlighter.generateFixes(p1);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        LocalQuickFix[] localQuickFixArray = thisCollection$iv.toArray(new LocalQuickFix[0]);
        if (localQuickFixArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return localQuickFixArray;
    }

    /*
     * WARNING - void declaration
     */
    private final List<LocalQuickFix> generateFixes(GroovyMethodResult result2) {
        void $this$mapNotNullTo$iv$iv;
        void $this$filterTo$iv$iv;
        Object applicabilities;
        Object object;
        ArgumentMapping mapping2;
        GroovyMethodCandidate candidate;
        block8: {
            block7: {
                GroovyMethodCandidate groovyMethodCandidate = result2.getCandidate();
                if (groovyMethodCandidate == null) {
                    return CollectionsKt.emptyList();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)groovyMethodCandidate, (String)"result.candidate ?: return emptyList()");
                candidate = groovyMethodCandidate;
                ArgumentMapping argumentMapping2 = candidate.getArgumentMapping();
                if (argumentMapping2 == null) {
                    return CollectionsKt.emptyList();
                }
                mapping2 = argumentMapping2;
                object = candidate.getArgumentMapping();
                if (object == null) break block7;
                PsiSubstitutor psiSubstitutor = result2.getSubstitutor();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiSubstitutor, (String)"result.substitutor");
                if ((object = object.highlightingApplicabilities(psiSubstitutor)) != null) break block8;
            }
            return CollectionsKt.emptyList();
        }
        Object $this$filter$iv = applicabilities = object;
        boolean $i$f$filter = false;
        Object object2 = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        void var11_13 = $this$filterTo$iv$iv;
        boolean bl = false;
        Iterator iterator2 = var11_13.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry $dstr$_u24__u24$data = element$iv$iv = iterator2.next();
            boolean bl2 = false;
            Map.Entry entry = $dstr$_u24__u24$data;
            boolean bl3 = false;
            ApplicabilityData data = (ApplicabilityData)entry.getValue();
            if (!(data.getApplicability() == Applicability.inapplicable)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Set notApplicableArguments = destination$iv$iv.keySet();
        PsiMethod psiMethod = result2.getElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod, (String)"result.element");
        PsiElement psiElement = (PsiElement)psiMethod;
        PsiSubstitutor psiSubstitutor = result2.getContextSubstitutor();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiSubstitutor, (String)"result.contextSubstitutor");
        PsiSubstitutor substitutor = new GroovyInferenceSessionBuilder(psiElement, candidate, psiSubstitutor).resolveMode(false).ignoreArguments(notApplicableArguments).build().inferSubst();
        Iterable $this$mapNotNull$iv = notApplicableArguments;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
        while (iterator3.hasNext()) {
            LocalQuickFix localQuickFix;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator3.next();
            boolean bl4 = false;
            Argument argument = (Argument)element$iv$iv;
            boolean bl5 = false;
            PsiType fixType = substitutor.substitute(mapping2.expectedType(argument));
            if ((fixType != null ? this.buildFix(argument, fixType) : null) == null) continue;
            localQuickFix = localQuickFix;
            boolean bl6 = false;
            boolean bl7 = false;
            LocalQuickFix it$iv$iv = localQuickFix;
            boolean bl8 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    @NotNull
    public final GroovyCallReference getReference() {
        return this.reference;
    }

    @NotNull
    public final HighlightSink getSink() {
        return this.sink;
    }

    public CallReferenceHighlighter(@NotNull GroovyCallReference reference, @NotNull HighlightSink sink) {
        Intrinsics.checkParameterIsNotNull((Object)reference, (String)"reference");
        Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
        this.reference = reference;
        this.sink = sink;
    }
}

