/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.type.highlighting;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.assignment.GrCastFix;
import org.jetbrains.plugins.groovy.codeInspection.type.GroovyTypeCheckVisitorHelper;
import org.jetbrains.plugins.groovy.codeInspection.type.highlighting.CallReferenceHighlighter;
import org.jetbrains.plugins.groovy.codeInspection.type.highlighting.HighlightingKt;
import org.jetbrains.plugins.groovy.highlighting.HighlightSink;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyExpressionUtil;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.api.ExpressionArgument;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyCallReference;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J*\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00162\u0010\u0010\u001d\u001a\f\u0012\u0004\u0012\u00020\u00140\u001ej\u0002`\u001fH\u0016J\u0006\u0010 \u001a\u00020!R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\f\u00a8\u0006\""}, d2={"Lorg/jetbrains/plugins/groovy/codeInspection/type/highlighting/BinaryExpressionHighlighter;", "Lorg/jetbrains/plugins/groovy/codeInspection/type/highlighting/CallReferenceHighlighter;", "expression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrBinaryExpression;", "reference", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/GroovyCallReference;", "sink", "Lorg/jetbrains/plugins/groovy/highlighting/HighlightSink;", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrBinaryExpression;Lorg/jetbrains/plugins/groovy/lang/resolve/api/GroovyCallReference;Lorg/jetbrains/plugins/groovy/highlighting/HighlightSink;)V", "ambiguousMethodMessage", "", "getAmbiguousMethodMessage", "()Ljava/lang/String;", "getExpression", "()Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrBinaryExpression;", "unknownArgsMessage", "getUnknownArgsMessage", "buildFix", "Lorg/jetbrains/plugins/groovy/codeInspection/assignment/GrCastFix;", "argument", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Argument;", "expectedType", "Lcom/intellij/psi/PsiType;", "getHighlightElement", "Lcom/intellij/psi/PsiElement;", "getInapplicableMethodMessage", "result", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyMethodResult;", "containingType", "arguments", "", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Arguments;", "highlight", "", "intellij.groovy.psi"})
public final class BinaryExpressionHighlighter
extends CallReferenceHighlighter {
    @NotNull
    private final GrBinaryExpression expression;

    @Override
    @NotNull
    public String getUnknownArgsMessage() {
        String string = GroovyBundle.message("cannot.infer.argument.types", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"GroovyBundle.message(\"ca\u2026ot.infer.argument.types\")");
        return string;
    }

    @Override
    @NotNull
    public String getAmbiguousMethodMessage() {
        String string = GroovyBundle.message("operator.call.is.ambiguous", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"GroovyBundle.message(\"operator.call.is.ambiguous\")");
        return string;
    }

    @Override
    @NotNull
    public String getInapplicableMethodMessage(@NotNull GroovyMethodResult result2, @NotNull PsiType containingType, @NotNull List<? extends Argument> arguments2) {
        Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
        Intrinsics.checkParameterIsNotNull((Object)containingType, (String)"containingType");
        Intrinsics.checkParameterIsNotNull(arguments2, (String)"arguments");
        String string = containingType.getInternalCanonicalText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"containingType.internalCanonicalText");
        String typeText = string;
        String argumentsString2 = HighlightingKt.argumentsString(arguments2);
        Object[] objectArray = new Object[3];
        PsiMethod psiMethod = result2.getElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod, (String)"result.element");
        objectArray[0] = psiMethod.getName();
        objectArray[1] = typeText;
        objectArray[2] = argumentsString2;
        String string2 = GroovyBundle.message("cannot.apply.method1", objectArray);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"GroovyBundle.message(\"ca\u2026ypeText, argumentsString)");
        return string2;
    }

    @Override
    @NotNull
    public PsiElement getHighlightElement() {
        PsiElement psiElement = this.expression.getOperationToken();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"expression.operationToken");
        return psiElement;
    }

    @Override
    @Nullable
    public GrCastFix buildFix(@NotNull Argument argument, @NotNull PsiType expectedType) {
        Intrinsics.checkParameterIsNotNull((Object)argument, (String)"argument");
        Intrinsics.checkParameterIsNotNull((Object)expectedType, (String)"expectedType");
        if (!(argument instanceof ExpressionArgument)) {
            return null;
        }
        List<Argument> list = this.getReference().getArguments();
        if (list == null) {
            return null;
        }
        List<Argument> arguments2 = list;
        if (!arguments2.contains(argument)) {
            return null;
        }
        String name = "Cast operand to " + expectedType.getPresentableText();
        return new GrCastFix(expectedType, ((ExpressionArgument)argument).getExpression(), true, name);
    }

    public final void highlight() {
        if (GroovyExpressionUtil.isFake(this.expression)) {
            return;
        }
        if (GroovyTypeCheckVisitorHelper.hasErrorElements(this.expression)) {
            return;
        }
        GroovyCallReference groovyCallReference = this.expression.getReference();
        if (groovyCallReference == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)groovyCallReference, (String)"expression.reference ?: return");
        GroovyCallReference reference = groovyCallReference;
        GroovyResolveResult groovyResolveResult = reference.advancedResolve();
        Intrinsics.checkExpressionValueIsNotNull((Object)groovyResolveResult, (String)"reference.advancedResolve()");
        GroovyResolveResult resolveResult2 = groovyResolveResult;
        if (GroovyTypeCheckVisitorHelper.isOperatorWithSimpleTypes(this.expression, resolveResult2)) {
            return;
        }
        this.highlightMethodApplicability();
    }

    @NotNull
    public final GrBinaryExpression getExpression() {
        return this.expression;
    }

    public BinaryExpressionHighlighter(@NotNull GrBinaryExpression expression, @NotNull GroovyCallReference reference, @NotNull HighlightSink sink) {
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)reference, (String)"reference");
        Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
        super(reference, sink);
        this.expression = expression;
    }
}

