/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.threading;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSynchronizedStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class GroovyPublicFieldAccessedInSynchronizedContextInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        if ("Non-private field <code>#ref</code> accessed in synchronized context  #loc" == null) {
            GroovyPublicFieldAccessedInSynchronizedContextInspection.$$$reportNull$$$0(0);
        }
        return "Non-private field <code>#ref</code> accessed in synchronized context  #loc";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        PublicFieldAccessedInSynchronizedContextVisitor publicFieldAccessedInSynchronizedContextVisitor = new PublicFieldAccessedInSynchronizedContextVisitor();
        if (publicFieldAccessedInSynchronizedContextVisitor == null) {
            GroovyPublicFieldAccessedInSynchronizedContextInspection.$$$reportNull$$$0(1);
        }
        return publicFieldAccessedInSynchronizedContextVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/groovy/codeInspection/threading/GroovyPublicFieldAccessedInSynchronizedContextInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class PublicFieldAccessedInSynchronizedContextVisitor
    extends BaseInspectionVisitor {
        private PublicFieldAccessedInSynchronizedContextVisitor() {
        }

        @Override
        public void visitReferenceExpression(@NotNull GrReferenceExpression expression) {
            PsiElement element;
            if (expression == null) {
                PublicFieldAccessedInSynchronizedContextVisitor.$$$reportNull$$$0(0);
            }
            if (!((element = expression.resolve()) instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)element;
            if (field.hasModifierProperty("private") || field.hasModifierProperty("final")) {
                return;
            }
            if (!PublicFieldAccessedInSynchronizedContextVisitor.isInSynchronizedContext(expression)) {
                return;
            }
            PsiClass containingClass = field.getContainingClass();
            if (containingClass.hasModifierProperty("private")) {
                return;
            }
            this.registerError(expression);
        }

        private static boolean isInSynchronizedContext(PsiElement element) {
            PsiModifierListOwner modifierListOwner;
            PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{GrMethod.class, GrSynchronizedStatement.class});
            if (context instanceof GrSynchronizedStatement) {
                return true;
            }
            return context != null && (modifierListOwner = (PsiModifierListOwner)context).hasModifierProperty("synchronized");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/codeInspection/threading/GroovyPublicFieldAccessedInSynchronizedContextInspection$PublicFieldAccessedInSynchronizedContextVisitor", "visitReferenceExpression"));
        }
    }
}

