/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.threading;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public class GroovyBusyWaitInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        if ("Call to <code>Thread.#ref()</code> in a loop, probably busy-waiting #loc" == null) {
            GroovyBusyWaitInspection.$$$reportNull$$$0(0);
        }
        return "Call to <code>Thread.#ref()</code> in a loop, probably busy-waiting #loc";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        BusyWaitVisitor busyWaitVisitor = new BusyWaitVisitor();
        if (busyWaitVisitor == null) {
            GroovyBusyWaitInspection.$$$reportNull$$$0(1);
        }
        return busyWaitVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/groovy/codeInspection/threading/GroovyBusyWaitInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class BusyWaitVisitor
    extends BaseInspectionVisitor {
        private BusyWaitVisitor() {
        }

        @Override
        public void visitMethodCallExpression(@NotNull GrMethodCallExpression grMethodCallExpression) {
            if (grMethodCallExpression == null) {
                BusyWaitVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(grMethodCallExpression);
            GrExpression methodExpression = grMethodCallExpression.getInvokedExpression();
            if (!(methodExpression instanceof GrReferenceExpression)) {
                return;
            }
            GrReferenceExpression reference = (GrReferenceExpression)methodExpression;
            String name = reference.getReferenceName();
            if (!"sleep".equals(name)) {
                return;
            }
            PsiMethod method = grMethodCallExpression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null || !"java.lang.Thread".equals(containingClass.getQualifiedName())) {
                return;
            }
            if (!ControlFlowUtils.isInLoop(grMethodCallExpression)) {
                return;
            }
            this.registerMethodCallError(grMethodCallExpression, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grMethodCallExpression", "org/jetbrains/plugins/groovy/codeInspection/threading/GroovyBusyWaitInspection$BusyWaitVisitor", "visitMethodCallExpression"));
        }
    }
}

