/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.secondUnsafeCall;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.annotator.inspections.SecondUnsafeCallQuickFix;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.codeInspection.GroovySuppressableInspectionTool;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public class SecondUnsafeCallInspection
extends GroovySuppressableInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            SecondUnsafeCallInspection.$$$reportNull$$$0(0);
        }
        GroovyPsiElementVisitor groovyPsiElementVisitor = new GroovyPsiElementVisitor(new GroovyElementVisitor(){

            @Override
            public void visitReferenceExpression(@NotNull GrReferenceExpression refExpression) {
                if (refExpression == null) {
                    1.$$$reportNull$$$0(0);
                }
                SecondUnsafeCallInspection.checkForSecondUnsafeCall(refExpression, holder);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refExpression", "org/jetbrains/plugins/groovy/codeInspection/secondUnsafeCall/SecondUnsafeCallInspection$1", "visitReferenceExpression"));
            }
        });
        if (groovyPsiElementVisitor == null) {
            SecondUnsafeCallInspection.$$$reportNull$$$0(1);
        }
        return groovyPsiElementVisitor;
    }

    private static void checkForSecondUnsafeCall(GrExpression expression, ProblemsHolder holder) {
        SecondUnsafeCallInspection.checkForSecondUnsafeCall(expression, holder, null);
    }

    private static void checkForSecondUnsafeCall(GrExpression expression, ProblemsHolder holder, @Nullable PsiElement highlightElement) {
        GrReferenceExpression referenceExpression;
        if (highlightElement == null) {
            highlightElement = expression;
        }
        if (GroovyTokenTypes.mDOT.equals((referenceExpression = (GrReferenceExpression)expression).getDotTokenType())) {
            GrExpression qualifier = referenceExpression.getQualifierExpression();
            if (qualifier instanceof GrMethodCallExpression) {
                GrExpression expression1 = ((GrMethodCallExpression)qualifier).getInvokedExpression();
                if (!(expression1 instanceof GrReferenceExpression)) {
                    return;
                }
                if (GroovyTokenTypes.mOPTIONAL_DOT.equals(((GrReferenceExpression)expression1).getDotTokenType())) {
                    holder.registerProblem(highlightElement, GroovyInspectionBundle.message("call.can.throw.npe", new Object[0]), new LocalQuickFix[]{new SecondUnsafeCallQuickFix()});
                }
            } else if (qualifier instanceof GrReferenceExpression && GroovyTokenTypes.mOPTIONAL_DOT.equals(((GrReferenceExpression)qualifier).getDotTokenType())) {
                holder.registerProblem(highlightElement, GroovyInspectionBundle.message("call.can.throw.npe", new Object[0]), new LocalQuickFix[]{new SecondUnsafeCallQuickFix()});
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/secondUnsafeCall/SecondUnsafeCallInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/secondUnsafeCall/SecondUnsafeCallInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

