/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.metrics;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.metrics.NegationCountVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class GroovyMethodWithMoreThanThreeNegationsInspection
extends BaseInspection {
    @Override
    public String buildErrorString(Object ... args) {
        return "Method '#ref' has too many negations (" + args[0] + " > 3)";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        Visitor visitor2 = new Visitor();
        if (visitor2 == null) {
            GroovyMethodWithMoreThanThreeNegationsInspection.$$$reportNull$$$0(0);
        }
        return visitor2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/metrics/GroovyMethodWithMoreThanThreeNegationsInspection", "buildVisitor"));
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitMethod(@NotNull GrMethod grMethod) {
            if (grMethod == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitMethod(grMethod);
            NegationCountVisitor visitor2 = new NegationCountVisitor();
            GrOpenBlock body = grMethod.getBlock();
            if (body == null) {
                return;
            }
            body.accept(visitor2);
            int numNegations = visitor2.getNegationCount();
            if (numNegations <= 3) {
                return;
            }
            this.registerMethodError(grMethod, numNegations);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grMethod", "org/jetbrains/plugins/groovy/codeInspection/metrics/GroovyMethodWithMoreThanThreeNegationsInspection$Visitor", "visitMethod"));
        }
    }
}

