/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class GroovyReturnFromClosureCanBeImplicitInspection
extends BaseInspection {
    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "#ref statement at end of a closure can be made implicit #loc";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        Visitor visitor2 = new Visitor();
        if (visitor2 == null) {
            GroovyReturnFromClosureCanBeImplicitInspection.$$$reportNull$$$0(0);
        }
        return visitor2;
    }

    @Override
    @Nullable
    protected GroovyFix buildFix(@NotNull PsiElement location) {
        if (location == null) {
            GroovyReturnFromClosureCanBeImplicitInspection.$$$reportNull$$$0(1);
        }
        return new MakeReturnImplicitFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/control/GroovyReturnFromClosureCanBeImplicitInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/control/GroovyReturnFromClosureCanBeImplicitInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitReturnStatement(@NotNull GrReturnStatement returnStatement) {
            if (returnStatement == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitReturnStatement(returnStatement);
            GrExpression returnValue = returnStatement.getReturnValue();
            if (returnValue == null) {
                return;
            }
            GrClosableBlock closure = (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)returnStatement, GrClosableBlock.class);
            if (closure == null) {
                return;
            }
            GrMethod containingMethod = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)returnStatement, GrMethod.class);
            if (containingMethod != null && PsiTreeUtil.isAncestor((PsiElement)closure, (PsiElement)containingMethod, (boolean)true)) {
                return;
            }
            if (!ControlFlowUtils.closureCompletesWithStatement(closure, returnStatement)) {
                return;
            }
            this.registerStatementError(returnStatement, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnStatement", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyReturnFromClosureCanBeImplicitInspection$Visitor", "visitReturnStatement"));
        }
    }

    private static class MakeReturnImplicitFix
    extends GroovyFix {
        private MakeReturnImplicitFix() {
        }

        @NotNull
        public String getFamilyName() {
            if ("Make return implicit" == null) {
                MakeReturnImplicitFix.$$$reportNull$$$0(0);
            }
            return "Make return implicit";
        }

        @Override
        public void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiElement returnKeywordElement;
            GrReturnStatement returnStatement;
            if (project == null) {
                MakeReturnImplicitFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                MakeReturnImplicitFix.$$$reportNull$$$0(2);
            }
            if ((returnStatement = (GrReturnStatement)(returnKeywordElement = descriptor2.getPsiElement()).getParent()) == null) {
                return;
            }
            if (returnStatement.getReturnValue() == null) {
                return;
            }
            MakeReturnImplicitFix.replaceStatement((GrStatement)returnStatement, returnStatement.getReturnValue().getText());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/control/GroovyReturnFromClosureCanBeImplicitInspection$MakeReturnImplicitFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/control/GroovyReturnFromClosureCanBeImplicitInspection$MakeReturnImplicitFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

