/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.utils.EquivalenceChecker;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;

public class GroovyIfStatementWithIdenticalBranchesInspection
extends BaseInspection {
    @Override
    public String buildErrorString(Object ... args) {
        return "'#ref' statement with identical branches #loc";
    }

    @Override
    public GroovyFix buildFix(@NotNull PsiElement location) {
        if (location == null) {
            GroovyIfStatementWithIdenticalBranchesInspection.$$$reportNull$$$0(0);
        }
        return new CollapseIfFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        IfStatementWithIdenticalBranchesVisitor ifStatementWithIdenticalBranchesVisitor = new IfStatementWithIdenticalBranchesVisitor();
        if (ifStatementWithIdenticalBranchesVisitor == null) {
            GroovyIfStatementWithIdenticalBranchesInspection.$$$reportNull$$$0(1);
        }
        return ifStatementWithIdenticalBranchesVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/control/GroovyIfStatementWithIdenticalBranchesInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/control/GroovyIfStatementWithIdenticalBranchesInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildFix";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class IfStatementWithIdenticalBranchesVisitor
    extends BaseInspectionVisitor {
        private IfStatementWithIdenticalBranchesVisitor() {
        }

        @Override
        public void visitIfStatement(@NotNull GrIfStatement statement) {
            if (statement == null) {
                IfStatementWithIdenticalBranchesVisitor.$$$reportNull$$$0(0);
            }
            super.visitIfStatement(statement);
            GrStatement thenBranch = statement.getThenBranch();
            GrStatement elseBranch = statement.getElseBranch();
            if (thenBranch == null || elseBranch == null) {
                return;
            }
            if (EquivalenceChecker.statementsAreEquivalent(thenBranch, elseBranch)) {
                this.registerStatementError(statement, new Object[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyIfStatementWithIdenticalBranchesInspection$IfStatementWithIdenticalBranchesVisitor", "visitIfStatement"));
        }
    }

    private static class CollapseIfFix
    extends GroovyFix {
        private CollapseIfFix() {
        }

        @NotNull
        public String getFamilyName() {
            if ("Collapse 'if' statement'" == null) {
                CollapseIfFix.$$$reportNull$$$0(0);
            }
            return "Collapse 'if' statement'";
        }

        @Override
        public void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) throws IncorrectOperationException {
            if (project == null) {
                CollapseIfFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                CollapseIfFix.$$$reportNull$$$0(2);
            }
            PsiElement identifier = descriptor2.getPsiElement();
            GrIfStatement statement = (GrIfStatement)identifier.getParent();
            assert (statement != null);
            GrStatement thenBranch = statement.getThenBranch();
            CollapseIfFix.replaceStatement((GrStatement)statement, thenBranch);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/control/GroovyIfStatementWithIdenticalBranchesInspection$CollapseIfFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/control/GroovyIfStatementWithIdenticalBranchesInspection$CollapseIfFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

