/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public class GroovyConstantIfStatementInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... args) {
        if ("#ref statement can be simplified #loc" == null) {
            GroovyConstantIfStatementInspection.$$$reportNull$$$0(0);
        }
        return "#ref statement can be simplified #loc";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        ConstantIfStatementVisitor constantIfStatementVisitor = new ConstantIfStatementVisitor();
        if (constantIfStatementVisitor == null) {
            GroovyConstantIfStatementInspection.$$$reportNull$$$0(1);
        }
        return constantIfStatementVisitor;
    }

    @Override
    public GroovyFix buildFix(@NotNull PsiElement location) {
        if (location == null) {
            GroovyConstantIfStatementInspection.$$$reportNull$$$0(2);
        }
        return new ConstantIfStatementFix();
    }

    private static boolean isFalse(GrExpression expression) {
        String text = expression.getText();
        return "false".equals(text);
    }

    private static boolean isTrue(GrExpression expression) {
        String text = expression.getText();
        return "true".equals(text);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/control/GroovyConstantIfStatementInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/control/GroovyConstantIfStatementInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ConstantIfStatementVisitor
    extends BaseInspectionVisitor {
        private ConstantIfStatementVisitor() {
        }

        @Override
        public void visitIfStatement(@NotNull GrIfStatement statement) {
            if (statement == null) {
                ConstantIfStatementVisitor.$$$reportNull$$$0(0);
            }
            super.visitIfStatement(statement);
            GrExpression condition = statement.getCondition();
            if (condition == null) {
                return;
            }
            GrStatement thenBranch = statement.getThenBranch();
            if (thenBranch == null) {
                return;
            }
            if (GroovyConstantIfStatementInspection.isTrue(condition) || GroovyConstantIfStatementInspection.isFalse(condition)) {
                this.registerStatementError(statement, new Object[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyConstantIfStatementInspection$ConstantIfStatementVisitor", "visitIfStatement"));
        }
    }

    private static class ConstantIfStatementFix
    extends GroovyFix {
        private ConstantIfStatementFix() {
        }

        @NotNull
        public String getFamilyName() {
            if ("Simplify" == null) {
                ConstantIfStatementFix.$$$reportNull$$$0(0);
            }
            return "Simplify";
        }

        @Override
        public void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) throws IncorrectOperationException {
            if (project == null) {
                ConstantIfStatementFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                ConstantIfStatementFix.$$$reportNull$$$0(2);
            }
            PsiElement ifKeyword = descriptor2.getPsiElement();
            GrIfStatement ifStatement = (GrIfStatement)ifKeyword.getParent();
            assert (ifStatement != null);
            GrStatement thenBranch = ifStatement.getThenBranch();
            GrStatement elseBranch = ifStatement.getElseBranch();
            GrExpression condition = ifStatement.getCondition();
            if (GroovyConstantIfStatementInspection.isFalse(condition)) {
                if (elseBranch != null) {
                    ConstantIfStatementFix.replaceStatement((GrStatement)ifStatement, (GrStatement)elseBranch.copy());
                } else {
                    ifStatement.delete();
                }
            } else {
                ConstantIfStatementFix.replaceStatement((GrStatement)ifStatement, (GrStatement)thenBranch.copy());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/control/GroovyConstantIfStatementInspection$ConstantIfStatementFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/control/GroovyConstantIfStatementInspection$ConstantIfStatementFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

