/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrElvisExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;

public class GroovyConditionalCanBeElvisInspection
extends BaseInspection {
    @Override
    public String buildErrorString(Object ... args) {
        return "Conditional expression can be elvis #loc";
    }

    @Override
    public GroovyFix buildFix(@NotNull PsiElement location) {
        if (location == null) {
            GroovyConditionalCanBeElvisInspection.$$$reportNull$$$0(0);
        }
        return new GroovyFix(){

            @NotNull
            public String getFamilyName() {
                if ("Convert Conditional to Elvis" == null) {
                    1.$$$reportNull$$$0(0);
                }
                return "Convert Conditional to Elvis";
            }

            @Override
            public void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) throws IncorrectOperationException {
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (descriptor2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                GrConditionalExpression expr = (GrConditionalExpression)descriptor2.getPsiElement();
                GrExpression condition = expr.getCondition();
                GrExpression thenExpression = expr.getThenBranch();
                GrExpression elseExpression = expr.getElseBranch();
                assert (elseExpression != null);
                assert (thenExpression != null);
                String newExpression = GroovyConditionalCanBeElvisInspection.checkForStringIsEmpty(condition, elseExpression) || GroovyConditionalCanBeElvisInspection.checkForListIsEmpty(condition, elseExpression) || GroovyConditionalCanBeElvisInspection.checkForEqualsNotElse(condition, elseExpression) ? elseExpression.getText() + " ?: " + thenExpression.getText() : thenExpression.getText() + " ?: " + elseExpression.getText();
                PsiImplUtil.replaceExpression(newExpression, expr);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/control/GroovyConditionalCanBeElvisInspection$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/control/GroovyConditionalCanBeElvisInspection$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "doFix";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static boolean checkPsiElement(GrConditionalExpression expr) {
        if (expr instanceof GrElvisExpression) {
            return false;
        }
        GrExpression condition = expr.getCondition();
        GrExpression then = expr.getThenBranch();
        GrExpression elseBranch = expr.getElseBranch();
        if (then == null || elseBranch == null) {
            return false;
        }
        return GroovyConditionalCanBeElvisInspection.checkForEqualsThen(condition, then) || GroovyConditionalCanBeElvisInspection.checkForEqualsNotElse(condition, elseBranch) || GroovyConditionalCanBeElvisInspection.checkForNull(condition, then) || GroovyConditionalCanBeElvisInspection.checkForStringIsEmpty(condition, elseBranch) || GroovyConditionalCanBeElvisInspection.checkForStringIsNotEmpty(condition, then) || GroovyConditionalCanBeElvisInspection.checkForListIsEmpty(condition, elseBranch) || GroovyConditionalCanBeElvisInspection.checkForListIsNotEmpty(condition, then);
    }

    private static boolean checkForEqualsNotElse(GrExpression condition, GrExpression elseBranch) {
        if (!(condition instanceof GrUnaryExpression)) {
            return false;
        }
        if (((GrUnaryExpression)condition).getOperationTokenType() != GroovyTokenTypes.mLNOT) {
            return false;
        }
        GrExpression operand = ((GrUnaryExpression)condition).getOperand();
        return operand != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)operand, (PsiElement)elseBranch);
    }

    private static boolean checkForEqualsThen(GrExpression condition, GrExpression then) {
        return PsiEquivalenceUtil.areElementsEquivalent((PsiElement)condition, (PsiElement)then);
    }

    private static boolean checkForListIsNotEmpty(GrExpression condition, GrExpression then) {
        if (!(condition instanceof GrUnaryExpression)) {
            return false;
        }
        if (((GrUnaryExpression)condition).getOperationTokenType() != GroovyTokenTypes.mLNOT) {
            return false;
        }
        return GroovyConditionalCanBeElvisInspection.checkForListIsEmpty(((GrUnaryExpression)condition).getOperand(), then);
    }

    private static boolean checkForListIsEmpty(GrExpression condition, GrExpression elseBranch) {
        if (condition instanceof GrMethodCall) {
            condition = ((GrMethodCall)condition).getInvokedExpression();
        }
        if (!(condition instanceof GrReferenceExpression)) {
            return false;
        }
        GrExpression qualifier = (GrExpression)((GrReferenceExpression)condition).getQualifier();
        if (qualifier == null) {
            return false;
        }
        if (!PsiEquivalenceUtil.areElementsEquivalent((PsiElement)qualifier, (PsiElement)elseBranch)) {
            return false;
        }
        PsiType type2 = qualifier.getType();
        if (type2 == null) {
            return false;
        }
        if (!InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.List")) {
            return false;
        }
        PsiElement resolved = ((GrReferenceExpression)condition).resolve();
        return resolved instanceof PsiMethod && "isEmpty".equals(((PsiMethod)resolved).getName()) && ((PsiMethod)resolved).getParameterList().isEmpty();
    }

    private static boolean checkForStringIsNotEmpty(GrExpression condition, GrExpression then) {
        if (!(condition instanceof GrUnaryExpression)) {
            return false;
        }
        if (((GrUnaryExpression)condition).getOperationTokenType() != GroovyTokenTypes.mLNOT) {
            return false;
        }
        return GroovyConditionalCanBeElvisInspection.checkForStringIsEmpty(((GrUnaryExpression)condition).getOperand(), then);
    }

    private static boolean checkForStringIsEmpty(GrExpression condition, GrExpression elseBranch) {
        if (condition instanceof GrMethodCall) {
            condition = ((GrMethodCall)condition).getInvokedExpression();
        }
        if (!(condition instanceof GrReferenceExpression)) {
            return false;
        }
        GrExpression qualifier = (GrExpression)((GrReferenceExpression)condition).getQualifier();
        if (qualifier == null) {
            return false;
        }
        if (!PsiEquivalenceUtil.areElementsEquivalent((PsiElement)qualifier, (PsiElement)elseBranch)) {
            return false;
        }
        PsiType type2 = qualifier.getType();
        if (type2 == null) {
            return false;
        }
        if (!type2.equalsToText("java.lang.String")) {
            return false;
        }
        PsiElement resolved = ((GrReferenceExpression)condition).resolve();
        return resolved instanceof PsiMethod && "isEmpty".equals(((PsiMethod)resolved).getName()) && ((PsiMethod)resolved).getParameterList().isEmpty();
    }

    private static boolean checkForNull(GrExpression condition, GrExpression then) {
        if (!(condition instanceof GrBinaryExpression)) {
            return false;
        }
        GrBinaryExpression binaryExpression = (GrBinaryExpression)condition;
        if (GroovyTokenTypes.mNOT_EQUAL != binaryExpression.getOperationTokenType()) {
            return false;
        }
        GrExpression left = binaryExpression.getLeftOperand();
        GrExpression right = binaryExpression.getRightOperand();
        if (left instanceof GrLiteral && "null".equals(left.getText()) && right != null) {
            return PsiEquivalenceUtil.areElementsEquivalent((PsiElement)right, (PsiElement)then);
        }
        if (right instanceof GrLiteral && "null".equals(right.getText())) {
            return PsiEquivalenceUtil.areElementsEquivalent((PsiElement)left, (PsiElement)then);
        }
        return false;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        Visitor visitor2 = new Visitor();
        if (visitor2 == null) {
            GroovyConditionalCanBeElvisInspection.$$$reportNull$$$0(1);
        }
        return visitor2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/control/GroovyConditionalCanBeElvisInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/control/GroovyConditionalCanBeElvisInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildFix";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitConditionalExpression(@NotNull GrConditionalExpression expression) {
            if (expression == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitConditionalExpression(expression);
            if (GroovyConditionalCanBeElvisInspection.checkPsiElement(expression)) {
                this.registerError(expression);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyConditionalCanBeElvisInspection$Visitor", "visitConditionalExpression"));
        }
    }
}

