/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.codeInspection.GroovyQuickFixFactory;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyCodeStyleSettingsFacade;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;

public class UnnecessaryQualifiedReferenceInspection
extends BaseInspection {
    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        BaseInspectionVisitor baseInspectionVisitor = new BaseInspectionVisitor(){

            @Override
            public void visitCodeReferenceElement(@NotNull GrCodeReferenceElement refElement) {
                if (refElement == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitCodeReferenceElement(refElement);
                if (UnnecessaryQualifiedReferenceInspection.canBeSimplified(refElement)) {
                    this.registerError(refElement);
                }
            }

            @Override
            public void visitReferenceExpression(@NotNull GrReferenceExpression referenceExpression) {
                if (referenceExpression == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitReferenceExpression(referenceExpression);
                if (UnnecessaryQualifiedReferenceInspection.canBeSimplified(referenceExpression) || UnnecessaryQualifiedReferenceInspection.isQualifiedStaticMethodWithUnnecessaryQualifier(referenceExpression)) {
                    this.registerError(referenceExpression);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "refElement";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "referenceExpression";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/confusing/UnnecessaryQualifiedReferenceInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitCodeReferenceElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReferenceExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (baseInspectionVisitor == null) {
            UnnecessaryQualifiedReferenceInspection.$$$reportNull$$$0(0);
        }
        return baseInspectionVisitor;
    }

    private static boolean isQualifiedStaticMethodWithUnnecessaryQualifier(GrReferenceExpression ref) {
        PsiElement copyResolved;
        if (ref.getQualifier() == null) {
            return false;
        }
        if (ref.hasAt()) {
            return false;
        }
        PsiElement resolved = ref.resolve();
        if (!(resolved instanceof PsiMember)) {
            return false;
        }
        if (!((PsiMember)resolved).hasModifierProperty("static")) {
            return false;
        }
        PsiElement parent2 = ref.getParent();
        if (parent2 instanceof GrMethodCall) {
            GrMethodCall copy = (GrMethodCall)parent2.copy();
            GrReferenceExpression invoked = (GrReferenceExpression)copy.getInvokedExpression();
            assert (invoked != null);
            invoked.setQualifier(null);
            copyResolved = ((GrReferenceExpression)copy.getInvokedExpression()).resolve();
        } else {
            GrReferenceExpression copy = (GrReferenceExpression)ref.copy();
            copy.setQualifier(null);
            copyResolved = copy.resolve();
        }
        return ref.getManager().areElementsEquivalent(copyResolved, resolved);
    }

    @Override
    protected String buildErrorString(Object ... args) {
        return GroovyInspectionBundle.message("unnecessary.qualified.reference", new Object[0]);
    }

    @Override
    protected GroovyFix buildFix(@NotNull PsiElement location) {
        if (location == null) {
            UnnecessaryQualifiedReferenceInspection.$$$reportNull$$$0(1);
        }
        return GroovyQuickFixFactory.getInstance().createReplaceWithImportFix();
    }

    private static boolean canBeSimplified(PsiElement element) {
        GrReferenceElement ref;
        if (PsiTreeUtil.getParentOfType((PsiElement)element, PsiComment.class) != null) {
            return false;
        }
        if (element instanceof GrCodeReferenceElement) {
            if (PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{GrImportStatement.class, GrPackageDefinition.class}) != null) {
                return false;
            }
        } else if (element instanceof GrReferenceExpression) {
            if (!PsiImplUtil.seemsToBeQualifiedClassName((GrReferenceExpression)element)) {
                return false;
            }
        } else {
            return false;
        }
        if ((ref = (GrReferenceElement)element).getQualifier() == null) {
            return false;
        }
        if (!(ref.getContainingFile() instanceof GroovyFileBase)) {
            return false;
        }
        PsiElement resolved = ref.resolve();
        if (!(resolved instanceof PsiClass)) {
            return false;
        }
        String name = ((PsiClass)resolved).getName();
        if (name == null) {
            return false;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(element.getProject());
        GrReferenceExpression shortedRef = factory.createReferenceExpressionFromText(name, element);
        GroovyResolveResult resolveResult2 = shortedRef.advancedResolve();
        if (element.getManager().areElementsEquivalent(resolved, resolveResult2.getElement())) {
            return true;
        }
        PsiClass containingClass = ((PsiClass)resolved).getContainingClass();
        if (containingClass != null && !GroovyCodeStyleSettingsFacade.getInstance(containingClass.getProject()).insertInnerClassImports()) {
            return false;
        }
        return resolveResult2.getElement() == null || !resolveResult2.isAccessible() || !resolveResult2.isStaticsOK();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/confusing/UnnecessaryQualifiedReferenceInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/confusing/UnnecessaryQualifiedReferenceInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

