/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.ComparisonUtils;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.ParenthesesUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyExpressionUtil;

public class GroovyPointlessBooleanInspection
extends BaseInspection {
    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        PointlessBooleanExpressionVisitor pointlessBooleanExpressionVisitor = new PointlessBooleanExpressionVisitor();
        if (pointlessBooleanExpressionVisitor == null) {
            GroovyPointlessBooleanInspection.$$$reportNull$$$0(0);
        }
        return pointlessBooleanExpressionVisitor;
    }

    @Override
    public String buildErrorString(Object ... args) {
        if (args[0] instanceof GrBinaryExpression) {
            return GroovyInspectionBundle.message("pointless.boolean.problem.descriptor", GroovyPointlessBooleanInspection.calculateSimplifiedBinaryExpression((GrBinaryExpression)args[0]));
        }
        return GroovyInspectionBundle.message("pointless.boolean.problem.descriptor", GroovyPointlessBooleanInspection.calculateSimplifiedPrefixExpression((GrUnaryExpression)args[0]));
    }

    @Nullable
    private static String calculateSimplifiedBinaryExpression(GrBinaryExpression expression) {
        IElementType sign = expression.getOperationTokenType();
        GrExpression lhs = expression.getLeftOperand();
        GrExpression rhs = expression.getRightOperand();
        if (rhs == null) {
            return null;
        }
        String rhsText = rhs.getText();
        String lhsText = lhs.getText();
        assert (sign != null);
        if (sign.equals(GroovyTokenTypes.mLAND)) {
            if (GroovyPointlessBooleanInspection.isTrue(lhs)) {
                return rhsText;
            }
            return lhsText;
        }
        if (sign.equals(GroovyTokenTypes.mLOR)) {
            if (GroovyPointlessBooleanInspection.isFalse(lhs)) {
                return rhsText;
            }
            return lhsText;
        }
        if (sign.equals(GroovyTokenTypes.mBXOR) || sign.equals(GroovyTokenTypes.mNOT_EQUAL)) {
            if (GroovyPointlessBooleanInspection.isFalse(lhs)) {
                return rhsText;
            }
            if (GroovyPointlessBooleanInspection.isFalse(rhs)) {
                return lhsText;
            }
            if (GroovyPointlessBooleanInspection.isTrue(lhs)) {
                return GroovyPointlessBooleanInspection.createStringForNegatedExpression(rhs);
            }
            return GroovyPointlessBooleanInspection.createStringForNegatedExpression(lhs);
        }
        if (sign.equals(GroovyTokenTypes.mEQUAL)) {
            if (GroovyPointlessBooleanInspection.isTrue(lhs)) {
                return rhsText;
            }
            if (GroovyPointlessBooleanInspection.isTrue(rhs)) {
                return lhsText;
            }
            if (GroovyPointlessBooleanInspection.isFalse(lhs)) {
                return GroovyPointlessBooleanInspection.createStringForNegatedExpression(rhs);
            }
            return GroovyPointlessBooleanInspection.createStringForNegatedExpression(lhs);
        }
        return "";
    }

    private static String createStringForNegatedExpression(GrExpression exp) {
        if (ComparisonUtils.isComparison(exp)) {
            GrBinaryExpression binaryExpression = (GrBinaryExpression)exp;
            IElementType sign = binaryExpression.getOperationTokenType();
            String negatedComparison = ComparisonUtils.getNegatedComparison(sign);
            GrExpression lhs = binaryExpression.getLeftOperand();
            GrExpression rhs = binaryExpression.getRightOperand();
            if (rhs == null) {
                return lhs.getText() + negatedComparison;
            }
            return lhs.getText() + negatedComparison + rhs.getText();
        }
        String baseText = exp.getText();
        if (ParenthesesUtils.getPrecedence(exp) > ParenthesesUtils.PREFIX_PRECEDENCE) {
            return "!(" + baseText + ')';
        }
        return '!' + baseText;
    }

    @NonNls
    private static String calculateSimplifiedPrefixExpression(GrUnaryExpression expression) {
        GrExpression operand = expression.getOperand();
        if (GroovyPointlessBooleanInspection.isTrue(operand)) {
            return "false";
        }
        return "true";
    }

    @Override
    public GroovyFix buildFix(@NotNull PsiElement location) {
        if (location == null) {
            GroovyPointlessBooleanInspection.$$$reportNull$$$0(1);
        }
        return new BooleanLiteralComparisonFix();
    }

    private static boolean equalityExpressionIsPointless(GrExpression lhs, GrExpression rhs) {
        return (GroovyPointlessBooleanInspection.isTrue(lhs) || GroovyPointlessBooleanInspection.isFalse(lhs)) && GroovyPointlessBooleanInspection.isBoolean(rhs) || (GroovyPointlessBooleanInspection.isTrue(rhs) || GroovyPointlessBooleanInspection.isFalse(rhs)) && GroovyPointlessBooleanInspection.isBoolean(lhs);
    }

    private static boolean isBoolean(GrExpression expression) {
        PsiType type2 = expression.getType();
        PsiType unboxed = TypesUtil.unboxPrimitiveTypeWrapper(type2);
        return unboxed != null && PsiType.BOOLEAN.equals((Object)unboxed);
    }

    private static boolean andExpressionIsPointless(GrExpression lhs, GrExpression rhs) {
        return GroovyPointlessBooleanInspection.isTrue(lhs) || GroovyPointlessBooleanInspection.isTrue(rhs);
    }

    private static boolean orExpressionIsPointless(GrExpression lhs, GrExpression rhs) {
        return GroovyPointlessBooleanInspection.isFalse(lhs) || GroovyPointlessBooleanInspection.isFalse(rhs);
    }

    private static boolean xorExpressionIsPointless(GrExpression lhs, GrExpression rhs) {
        return GroovyPointlessBooleanInspection.isTrue(lhs) || GroovyPointlessBooleanInspection.isTrue(rhs) || GroovyPointlessBooleanInspection.isFalse(lhs) || GroovyPointlessBooleanInspection.isFalse(rhs);
    }

    private static boolean notExpressionIsPointless(GrExpression arg) {
        return GroovyPointlessBooleanInspection.isFalse(arg) || GroovyPointlessBooleanInspection.isTrue(arg);
    }

    private static boolean isTrue(GrExpression expression) {
        if (expression == null) {
            return false;
        }
        if (!(expression instanceof GrLiteral)) {
            return false;
        }
        String text = expression.getText();
        return "true".equals(text);
    }

    private static boolean isFalse(GrExpression expression) {
        if (expression == null) {
            return false;
        }
        if (!(expression instanceof GrLiteral)) {
            return false;
        }
        String text = expression.getText();
        return "false".equals(text);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyPointlessBooleanInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyPointlessBooleanInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PointlessBooleanExpressionVisitor
    extends BaseInspectionVisitor {
        private final Set<IElementType> booleanTokens = new HashSet<IElementType>(5);

        private PointlessBooleanExpressionVisitor() {
            this.booleanTokens.add(GroovyTokenTypes.mLAND);
            this.booleanTokens.add(GroovyTokenTypes.mLOR);
            this.booleanTokens.add(GroovyTokenTypes.mBXOR);
            this.booleanTokens.add(GroovyTokenTypes.mEQUAL);
            this.booleanTokens.add(GroovyTokenTypes.mNOT_EQUAL);
        }

        @Override
        public void visitBinaryExpression(@NotNull GrBinaryExpression expression) {
            if (expression == null) {
                PointlessBooleanExpressionVisitor.$$$reportNull$$$0(0);
            }
            super.visitBinaryExpression(expression);
            if (GroovyExpressionUtil.isFake(expression)) {
                return;
            }
            GrExpression rhs = expression.getRightOperand();
            if (rhs == null) {
                return;
            }
            IElementType sign = expression.getOperationTokenType();
            if (!this.booleanTokens.contains(sign)) {
                return;
            }
            GrExpression lhs = expression.getLeftOperand();
            assert (sign != null);
            boolean isPointless = sign.equals(GroovyTokenTypes.mEQUAL) || sign.equals(GroovyTokenTypes.mNOT_EQUAL) ? GroovyPointlessBooleanInspection.equalityExpressionIsPointless(lhs, rhs) : (sign.equals(GroovyTokenTypes.mLAND) ? GroovyPointlessBooleanInspection.andExpressionIsPointless(lhs, rhs) : (sign.equals(GroovyTokenTypes.mLOR) ? GroovyPointlessBooleanInspection.orExpressionIsPointless(lhs, rhs) : (sign.equals(GroovyTokenTypes.mBXOR) ? GroovyPointlessBooleanInspection.xorExpressionIsPointless(lhs, rhs) : false)));
            if (!isPointless) {
                return;
            }
            this.registerError(expression);
        }

        @Override
        public void visitUnaryExpression(@NotNull GrUnaryExpression expression) {
            if (expression == null) {
                PointlessBooleanExpressionVisitor.$$$reportNull$$$0(1);
            }
            super.visitUnaryExpression(expression);
            IElementType sign = expression.getOperationTokenType();
            if (sign == null) {
                return;
            }
            GrExpression operand = expression.getOperand();
            if (sign.equals(GroovyTokenTypes.mLNOT) && GroovyPointlessBooleanInspection.notExpressionIsPointless(operand)) {
                this.registerError(expression);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyPointlessBooleanInspection$PointlessBooleanExpressionVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitBinaryExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitUnaryExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class BooleanLiteralComparisonFix
    extends GroovyFix {
        private BooleanLiteralComparisonFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = GroovyInspectionBundle.message("pointless.boolean.quickfix", new Object[0]);
            if (string == null) {
                BooleanLiteralComparisonFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiElement element;
            if (project == null) {
                BooleanLiteralComparisonFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                BooleanLiteralComparisonFix.$$$reportNull$$$0(2);
            }
            if ((element = descriptor2.getPsiElement()) instanceof GrBinaryExpression) {
                GrBinaryExpression expression = (GrBinaryExpression)element;
                String replacementString = GroovyPointlessBooleanInspection.calculateSimplifiedBinaryExpression(expression);
                BooleanLiteralComparisonFix.replaceExpression(expression, replacementString);
            } else {
                GrUnaryExpression expression = (GrUnaryExpression)element;
                String replacementString = GroovyPointlessBooleanInspection.calculateSimplifiedPrefixExpression(expression);
                BooleanLiteralComparisonFix.replaceExpression(expression, replacementString);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyPointlessBooleanInspection$BooleanLiteralComparisonFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyPointlessBooleanInspection$BooleanLiteralComparisonFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

