/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;

public class GroovyOctalIntegerInspection
extends BaseInspection {
    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "Octal integer #ref #loc";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        BaseInspectionVisitor baseInspectionVisitor = new BaseInspectionVisitor(){

            @Override
            public void visitLiteralExpression(@NotNull GrLiteral literal) {
                if (literal == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitLiteralExpression(literal);
                String text = literal.getText();
                if (!text.startsWith("0")) {
                    return;
                }
                if (text.replaceAll("0", "").isEmpty()) {
                    return;
                }
                if ("0g".equals(text) || "0G".equals(text)) {
                    return;
                }
                if ("0i".equals(text) || "0I".equals(text)) {
                    return;
                }
                if ("0l".equals(text) || "0L".equals(text)) {
                    return;
                }
                if (text.startsWith("0x") || text.startsWith("0X")) {
                    return;
                }
                if (text.startsWith("0b") || text.startsWith("0B")) {
                    return;
                }
                if (text.endsWith("d") || text.endsWith("D")) {
                    return;
                }
                if (text.endsWith("f") || text.endsWith("F")) {
                    return;
                }
                if (text.contains(".") || text.contains("e") || text.contains("E")) {
                    return;
                }
                this.registerError(literal);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyOctalIntegerInspection$1", "visitLiteralExpression"));
            }
        };
        if (baseInspectionVisitor == null) {
            GroovyOctalIntegerInspection.$$$reportNull$$$0(0);
        }
        return baseInspectionVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyOctalIntegerInspection", "buildVisitor"));
    }
}

